/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.peppermodules.annis.IdManager;
import org.corpus_tools.peppermodules.annis.SRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.Salt2ANNISMapper;
import org.corpus_tools.peppermodules.annis.TupleWriter;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOrderRelation2ANNISMapper
extends SRelation2ANNISMapper {
    private static final Logger log = LoggerFactory.getLogger(SOrderRelation2ANNISMapper.class);
    private boolean appendIndex = false;
    private int segPathCounter = 0;
    private long seg_index = 0L;

    public SOrderRelation2ANNISMapper(IdManager idManager, SDocumentGraph documentGraph, Map<SToken, Long> token2index, TupleWriter nodeTabWriter, TupleWriter nodeAnnoTabWriter, TupleWriter rankTabWriter, TupleWriter relationAnnoTabWriter, TupleWriter componentTabWriter, Salt2ANNISMapper parentMapper) {
        super(idManager, documentGraph, token2index, nodeTabWriter, nodeAnnoTabWriter, rankTabWriter, relationAnnoTabWriter, componentTabWriter, parentMapper);
    }

    @Override
    public void run() {
    }

    @Override
    public void mapSRelations2ANNIS(Collection<? extends SNode> sRelationRoots, SALT_TYPE relationTypeName, Salt2ANNISMapper.TRAVERSION_TYPE traversionType) {
        this.beginTransaction();
        if (sRelationRoots != null && !sRelationRoots.isEmpty()) {
            this.appendIndex = sRelationRoots.size() > 1;
            for (SNode sNode : sRelationRoots) {
                ArrayList<SNode> singleRootList = new ArrayList<SNode>();
                singleRootList.add(sNode);
                this.documentGraph.traverse(singleRootList, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "", (GraphTraverseHandler)this);
                ++this.segPathCounter;
                this.seg_index = 0L;
            }
        }
        this.commitTransaction();
    }

    @Override
    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> sRelation, SNode fromNode, long order) {
        String namespace;
        String segSpan;
        Long segIndex;
        String name;
        block5: {
            block4: {
                name = this.currentTraversionSType;
                if (name == null) {
                    name = "default_seg";
                }
                if (this.appendIndex) {
                    name = name + this.segPathCounter;
                }
                segIndex = this.seg_index;
                ++this.seg_index;
                segSpan = "NULL";
                namespace = null;
                if (!(currNode instanceof SToken)) break block4;
                SDocumentGraph g = ((SToken)currNode).getGraph();
                if (g == null) break block5;
                segSpan = g.getText((SNode)((SToken)currNode));
                break block5;
            }
            Set annos = currNode.getAnnotations();
            if (annos != null) {
                for (SAnnotation a : annos) {
                    if (!name.equals(a.getName())) continue;
                    segSpan = a.getValue_STEXT();
                    namespace = a.getNamespace();
                    break;
                }
            }
        }
        this.idManager.addSegmentInformation(currNode.getId(), segIndex, name, segSpan);
        this.getVirtualTokenStats().addVirtualAnnoName(namespace, name);
    }

    @Override
    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
    }

    @Override
    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
        if (relation == null) {
            return true;
        }
        if (relation instanceof SOrderRelation) {
            if (this.currentTraversionSType == null) {
                return true;
            }
            if (this.currentTraversionSType.equals(relation.getType())) {
                return true;
            }
        }
        return false;
    }
}

