/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.peppermodules.annis.IdManager;
import org.corpus_tools.peppermodules.annis.SRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.Salt2ANNISMapper;
import org.corpus_tools.peppermodules.annis.SegmentationInfo;
import org.corpus_tools.peppermodules.annis.TupleWriter;
import org.corpus_tools.peppermodules.annis.resolver.QName;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;

public class SDominanceRelation2ANNISMapper
extends SRelation2ANNISMapper {
    private SNode lastEnteredNode;

    public SDominanceRelation2ANNISMapper(IdManager idManager, SDocumentGraph documentGraph, Map<SToken, Long> token2index, TupleWriter nodeTabWriter, TupleWriter nodeAnnoTabWriter, TupleWriter rankTabWriter, TupleWriter edgeAnnoTabWriter, TupleWriter componentTabWriter, Salt2ANNISMapper parentMapper) {
        super(idManager, documentGraph, token2index, nodeTabWriter, nodeAnnoTabWriter, rankTabWriter, edgeAnnoTabWriter, componentTabWriter, parentMapper);
    }

    @Override
    public void run() {
        this.beginTransaction();
        HashSet<String> layers = new HashSet<String>();
        if (this.sRelationRoots != null && this.sRelationRoots.size() != 0) {
            for (SNode node : this.sRelationRoots) {
                String componentLayerName = "default_ns";
                SLayer componentLayer = this.getFirstComponentLayer(node);
                if (componentLayer != null) {
                    componentLayerName = componentLayer.getName();
                }
                layers.add(componentLayerName);
                if (this.currentTraversionSType == null) {
                    super.initialiseTraversion("d", componentLayerName, "NULL");
                } else {
                    super.initialiseTraversion("d", componentLayerName, this.currentTraversionSType);
                }
                ArrayList<SNode> singleRootList = new ArrayList<SNode>();
                singleRootList.add(node);
                Preconditions.checkNotNull((Object)this.currentComponentLayer);
                this.documentGraph.traverse(singleRootList, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traversionType.toString(), (GraphTraverseHandler)this);
                this.mapComponent2ANNIS();
            }
        }
        this.commitTransaction();
    }

    @Override
    public void mapSRelations2ANNIS(Collection<? extends SNode> sRelationRoots, SALT_TYPE edgeTypeName, Salt2ANNISMapper.TRAVERSION_TYPE traversionType) {
        this.traversionType = traversionType;
        this.edgeTypeName = edgeTypeName;
        this.sRelationRoots = sRelationRoots;
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation sRelation, SNode fromNode, long order) {
        super.nodeReached(traversalType, traversalId, currNode, (SRelation<SNode, SNode>)sRelation, fromNode, order);
        this.lastEnteredNode = currNode;
        if (sRelation != null) {
            this.getDomStats().addRelationType(this.currentComponentLayer, sRelation.getType());
            this.getDomStats().addRelationAnno(this.currentComponentLayer, sRelation.getAnnotations());
        }
    }

    @Override
    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
        super.nodeLeft(traversalType, traversalId, currNode, relation, fromNode, order);
        if (this.currentTraversionSType == null) {
            if (this.lastEnteredNode == currNode) {
                if (relation != null) {
                    this.getDomStats().addTerminalEdgeType(this.currentComponentLayer, relation.getType());
                }
                if (currNode instanceof SToken) {
                    SegmentationInfo segInfo;
                    if (this.idManager.getVirtualisedSpanId(currNode.getId()) != null && (segInfo = this.idManager.getSegmentInformation(currNode.getId())) != null) {
                        this.getDomStats().getTerminalAnno().add(this.currentComponentLayer, new QName(segInfo.getSegmentationName()));
                    }
                } else {
                    Set annos = currNode.getAnnotations();
                    if (annos != null && !annos.isEmpty()) {
                        SAnnotation anno = (SAnnotation)annos.iterator().next();
                        this.getDomStats().getTerminalAnno().add(this.currentComponentLayer, new QName(anno.getNamespace(), anno.getName()));
                    }
                }
            } else {
                this.getDomStats().addNodeAnno(this.currentComponentLayer, currNode.getAnnotations());
            }
        }
    }

    @Override
    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
        boolean returnVal = false;
        if (relation == null) {
            returnVal = true;
        } else if (relation instanceof SDominanceRelation) {
            if (this.currentTraversionSType == null) {
                returnVal = true;
            } else if (relation.getType() != null && !relation.getType().isEmpty() && relation.getType().equals(this.currentTraversionSType)) {
                returnVal = true;
            }
        }
        return returnVal;
    }
}

