/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.peppermodules.annis.GlobalIdManager;
import org.corpus_tools.peppermodules.annis.ResolverEntry;
import org.corpus_tools.peppermodules.annis.SegmentationInfo;
import org.corpus_tools.peppermodules.annis.VirtualNodeID;
import org.corpus_tools.salt.core.SNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdManager {
    private static final Logger log = LoggerFactory.getLogger(IdManager.class);
    private final GlobalIdManager globalIdManager;
    private final ConcurrentMap<String, Long> textIdMap;
    private final ConcurrentMap<String, List<Long>> tokenVirtualisationMapping;
    private final ConcurrentMap<String, Long> spanVirtualisationMapping;
    private final Lock lockNodeIdMap = new ReentrantLock();
    private final Map<String, Long> nodeIdMap = new HashMap<String, Long>();
    private final Lock lockVirtualNodeIdMap = new ReentrantLock();
    private final Map<String, Long> virtualNodeIdMap = new HashMap<String, Long>();
    private Long textId = 0L;
    private final Lock lockVirtMinTokenID2Index = new ReentrantLock();
    private final Map<Long, Long> virtMinTokenID2Index = new TreeMap<Long, Long>();
    protected ConcurrentMap<String, SegmentationInfo> segmentationInfoTable = null;

    public IdManager(GlobalIdManager globalIdManager) {
        this.globalIdManager = globalIdManager;
        this.textIdMap = new ConcurrentHashMap<String, Long>();
        this.tokenVirtualisationMapping = new ConcurrentHashMap<String, List<Long>>();
        this.spanVirtualisationMapping = new ConcurrentHashMap<String, Long>();
        this.textId = 0L;
        this.segmentationInfoTable = new ConcurrentHashMap<String, SegmentationInfo>();
    }

    public synchronized boolean hasVirtualTokenization() {
        return this.getGlobal().containsVirtualTokens();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long[] getMinimalVirtTokenIndex(Long ... tokenIDs) {
        Long[] returnVal = new Long[tokenIDs.length];
        this.lockVirtMinTokenID2Index.lock();
        try {
            for (int i = 0; i < tokenIDs.length; ++i) {
                returnVal[i] = this.virtMinTokenID2Index.get(tokenIDs[i]);
            }
        }
        finally {
            this.lockVirtMinTokenID2Index.unlock();
        }
        return returnVal;
    }

    public synchronized void addSegmentInformation(String node, Long segIndex, String segName, String segSpan) {
        this.segmentationInfoTable.put(node, new SegmentationInfo(segIndex, segName, segSpan));
    }

    public synchronized SegmentationInfo getSegmentInformation(String node) {
        SegmentationInfo returnVal = (SegmentationInfo)this.segmentationInfoTable.get(node);
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMininmalVirtToken(List<Long> mininalVirtTokenIDs) {
        this.lockVirtMinTokenID2Index.lock();
        try {
            this.virtMinTokenID2Index.clear();
            long i = 0L;
            for (Long l : mininalVirtTokenIDs) {
                this.virtMinTokenID2Index.put(l, i);
                ++i;
            }
        }
        finally {
            this.lockVirtMinTokenID2Index.unlock();
        }
    }

    public synchronized void registerTokenVirtMapping(String tokenId, Long virtualSpanId, List<Long> virtualTokenIds) {
        this.globalIdManager.setContainsVirtualTokens(true);
        this.tokenVirtualisationMapping.putIfAbsent(tokenId, virtualTokenIds);
        this.spanVirtualisationMapping.putIfAbsent(tokenId, virtualSpanId);
    }

    public synchronized List<Long> getVirtualisedTokenId(String tokenId) {
        return (List)this.tokenVirtualisationMapping.get(tokenId);
    }

    public int getNumberOfVirtualToken() {
        int result = 0;
        this.lockVirtMinTokenID2Index.lock();
        try {
            result = this.virtMinTokenID2Index.size();
        }
        finally {
            this.lockVirtMinTokenID2Index.unlock();
        }
        return result;
    }

    public synchronized Long getVirtualisedSpanId(String tokenId) {
        return (Long)this.spanVirtualisationMapping.get(tokenId);
    }

    public ResolverEntry insertResolverEntry(ResolverEntry entry) {
        ResolverEntry old = this.globalIdManager.getResolverEntryByDisplay().putIfAbsent(entry.getDisplay(), entry);
        return old;
    }

    public List<ResolverEntry> getResolverEntries() {
        ArrayList<ResolverEntry> entries = new ArrayList<ResolverEntry>();
        entries.addAll(this.globalIdManager.getResolverEntryByDisplay().values());
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNewCorpusTabId(String sElementId) {
        Long newId = this.globalIdManager.getCorpusTabIdMap().get(sElementId);
        IdManager idManager = this;
        synchronized (idManager) {
            if (newId == null) {
                newId = this.getGlobal().getNewCorpusId();
                this.globalIdManager.getCorpusTabIdMap().put(sElementId, newId);
            }
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualNodeID getVirtualNodeId(String sElementId) {
        boolean isNew = false;
        Long id = null;
        this.lockVirtualNodeIdMap.lock();
        try {
            id = this.virtualNodeIdMap.get(sElementId);
            if (id == null) {
                id = this.getGlobal().getNewNodeId();
                this.virtualNodeIdMap.put(sElementId, id);
                isNew = true;
            }
        }
        finally {
            this.lockVirtualNodeIdMap.unlock();
        }
        return new VirtualNodeID(id, isNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Long, Boolean> getNewNodeId(String sElementId) {
        boolean isNew = false;
        Long id = null;
        this.lockNodeIdMap.lock();
        try {
            id = this.nodeIdMap.get(sElementId);
            if (id == null) {
                id = this.getGlobal().getNewNodeId();
                this.nodeIdMap.put(sElementId, id);
                isNew = true;
            }
        }
        finally {
            this.lockNodeIdMap.unlock();
        }
        return new ImmutablePair((Object)id, (Object)isNew);
    }

    public Long getNodeId(SNode node) {
        if (node == null) {
            return null;
        }
        Long id = null;
        this.lockNodeIdMap.lock();
        try {
            id = this.nodeIdMap.get(node.getId());
        }
        finally {
            this.lockNodeIdMap.unlock();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNewTextId(String sElementId) {
        if (this.getGlobal().containsVirtualTokens()) {
            return 0L;
        }
        Long newId = (Long)this.textIdMap.get(sElementId);
        IdManager idManager = this;
        synchronized (idManager) {
            if (this.getGlobal().containsVirtualTokens()) {
                return 0L;
            }
            if (newId == null) {
                newId = this.textId;
                this.textIdMap.put(sElementId, this.textId);
                IdManager idManager2 = this;
                idManager2.textId = idManager2.textId + 1L;
            }
        }
        return newId;
    }

    public String getUniqueDocumentName(String docName) {
        String oldVal;
        String result = docName;
        int appendix = 1;
        do {
            if ((oldVal = this.globalIdManager.getDocumentNames().putIfAbsent(result, docName)) == null) continue;
            result = docName + "_" + appendix++;
        } while (oldVal != null);
        return result;
    }

    public String getEscapedIdentifier(String orig) {
        return this.globalIdManager.getEscapedIdentifier(orig);
    }

    public GlobalIdManager getGlobal() {
        return this.globalIdManager;
    }
}

