/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.google.common.net.PercentEscaper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.corpus_tools.peppermodules.annis.ResolverEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalIdManager {
    private static final Logger log = LoggerFactory.getLogger(GlobalIdManager.class);
    private final AtomicLong componentId = new AtomicLong(0L);
    private final AtomicLong rankId = new AtomicLong(0L);
    private final AtomicLong corpusId = new AtomicLong(0L);
    private final AtomicLong nodeId = new AtomicLong(0L);
    private final ConcurrentHashMap<String, Long> corpusTabIdMap = new ConcurrentHashMap();
    private final AtomicBoolean containsVirtualTokens = new AtomicBoolean(false);
    private final ConcurrentMap<String, ResolverEntry> resolverEntryByDisplay = new ConcurrentHashMap<String, ResolverEntry>();
    private final AtomicBoolean audioFound = new AtomicBoolean(false);
    private final AtomicBoolean videoFound = new AtomicBoolean(false);
    private final AtomicBoolean pdfFound = new AtomicBoolean(false);
    private final ConcurrentMap<String, String> documentNames = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> stringIDMapping = new ConcurrentHashMap<String, String>();
    private static final PercentEscaper percentEscaper = new PercentEscaper("_-", false);
    private static final Escaper firstCharEscaper = Escapers.builder().addEscape('0', "%30").addEscape('1', "%31").addEscape('2', "%32").addEscape('3', "%33").addEscape('4', "%34").addEscape('5', "%35").addEscape('6', "%36").addEscape('7', "%37").addEscape('8', "%38").addEscape('9', "%39").addEscape('-', "%2D").build();

    public long getNewRankId() {
        return this.rankId.getAndIncrement();
    }

    public Long getNewComponentId() {
        return this.componentId.getAndIncrement();
    }

    public long getNewCorpusId() {
        return this.corpusId.getAndIncrement();
    }

    public long getNewNodeId() {
        return this.nodeId.getAndIncrement();
    }

    public boolean containsVirtualTokens() {
        return this.containsVirtualTokens.get();
    }

    public void setContainsVirtualTokens(boolean val) {
        this.containsVirtualTokens.set(val);
    }

    public ConcurrentHashMap<String, Long> getCorpusTabIdMap() {
        return this.corpusTabIdMap;
    }

    public ConcurrentMap<String, ResolverEntry> getResolverEntryByDisplay() {
        return this.resolverEntryByDisplay;
    }

    public ConcurrentMap<String, String> getDocumentNames() {
        return this.documentNames;
    }

    public void setAudioFound() {
        this.audioFound.set(true);
    }

    public void setVideoFound() {
        this.videoFound.set(true);
    }

    public void setPDFFound() {
        this.pdfFound.set(true);
    }

    public boolean isAudioFound() {
        return this.audioFound.get();
    }

    public boolean isVideoFound() {
        return this.videoFound.get();
    }

    public boolean isPDFFound() {
        return this.pdfFound.get();
    }

    public String getEscapedIdentifier(String orig) {
        String oldEscape;
        if (orig == null) {
            return null;
        }
        String escaped = this.getValidIDString(orig);
        if (!orig.equals(escaped) && (oldEscape = this.stringIDMapping.putIfAbsent(orig, escaped)) == null) {
            log.warn("replaced invalid ANNIS identifier {} with {}", (Object)orig, (Object)escaped);
        }
        return escaped;
    }

    private String getValidIDString(String orig) {
        char firstChar;
        String result = orig;
        if (result != null && !result.isEmpty() && ((firstChar = (result = percentEscaper.escape(result)).charAt(0)) >= '0' && firstChar <= '9' || firstChar == '-')) {
            result = firstCharEscaper.escape(String.valueOf(firstChar)) + result.substring(1);
        }
        return result;
    }
}

