/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.corpus_tools.peppermodules.annis.IdManager;
import org.corpus_tools.peppermodules.annis.SRelation2ANNISMapper;
import org.corpus_tools.peppermodules.annis.Salt2ANNISMapper;
import org.corpus_tools.peppermodules.annis.TupleWriter;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SMedialDS;
import org.corpus_tools.salt.common.SMedialRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.eclipse.emf.common.util.URI;

public class Audio2ANNISMapper
extends SRelation2ANNISMapper {
    private final Set<URI> mappedFiles;
    private final Map<Long, Range<Double>> virtTokenTimes = new TreeMap<Long, Range<Double>>();

    public Audio2ANNISMapper(IdManager idManager, SDocumentGraph documentGraph, Map<SToken, Long> token2Index, TupleWriter nodeTabWriter, TupleWriter nodeAnnoTabWriter, TupleWriter rankTabWriter, TupleWriter edgeAnnoTabWriter, TupleWriter componentTabWriter, Salt2ANNISMapper parentMapper) {
        super(idManager, documentGraph, token2Index, nodeTabWriter, nodeAnnoTabWriter, rankTabWriter, edgeAnnoTabWriter, componentTabWriter, parentMapper);
        this.mappedFiles = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public void mapSRelations2ANNIS(Collection<? extends SNode> sRelationRoots, SALT_TYPE edgeTypeName, Salt2ANNISMapper.TRAVERSION_TYPE traversionType) {
        this.traversionType = traversionType;
        this.edgeTypeName = edgeTypeName;
        this.sRelationRoots = sRelationRoots;
    }

    @Override
    public void run() {
        this.beginTransaction();
        if (this.sRelationRoots != null && this.sRelationRoots.size() != 0) {
            for (SNode node : this.sRelationRoots) {
                super.initialiseTraversion(null, null, null);
                ArrayList<SNode> singleRootList = new ArrayList<SNode>();
                singleRootList.add(node);
                this.documentGraph.traverse(singleRootList, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, this.traversionType.toString(), (GraphTraverseHandler)this);
            }
            this.outputVirtualTokenAnnotations();
        }
        this.commitTransaction();
    }

    @Override
    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
        if (this.traversionType == Salt2ANNISMapper.TRAVERSION_TYPE.DOCUMENT_STRUCTURE_AUDIO) {
            return currNode instanceof SToken && relation == null || relation instanceof SMedialRelation;
        }
        return false;
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation sRelation, SNode fromNode, long order) {
        if (sRelation instanceof SMedialRelation && this.traversionType == Salt2ANNISMapper.TRAVERSION_TYPE.DOCUMENT_STRUCTURE_AUDIO) {
            SMedialRelation dsRel = (SMedialRelation)sRelation;
            Double start = (Double)dsRel.getStart();
            Double end = (Double)dsRel.getEnd();
            String val = start != null && end != null ? "" + start + "-" + end : (start != null ? "" + start : (end != null ? "-" + end : ""));
            SToken tok = (SToken)dsRel.getSource();
            List<Long> virtualToken = this.idManager.getVirtualisedTokenId(tok.getId());
            if (virtualToken == null) {
                tok.createAnnotation("annis", "time", (Object)val);
                this.mapSNode((SNode)dsRel.getSource());
            } else if (!virtualToken.isEmpty()) {
                if (virtualToken.size() == 1) {
                    Range newRange = Range.all();
                    if (start != null && end != null) {
                        newRange = Range.closed((Comparable)start, (Comparable)end);
                    } else if (start != null) {
                        newRange = Range.atLeast((Comparable)start);
                    } else if (end != null) {
                        newRange = Range.atMost((Comparable)end);
                    }
                    this.addVirtualRange(virtualToken.get(0), newRange);
                } else {
                    Long firstTokenID = virtualToken.get(0);
                    Long lastTokenID = virtualToken.get(virtualToken.size() - 1);
                    if (start != null) {
                        this.addVirtualRange(firstTokenID, Range.atLeast((Comparable)start));
                    }
                    if (end != null) {
                        this.addVirtualRange(lastTokenID, Range.atMost((Comparable)end));
                    }
                }
            }
            URI linkedFile = ((SMedialDS)dsRel.getTarget()).getMediaReference();
            if (linkedFile != null && this.mappedFiles.add(linkedFile)) {
                this.copyLinkedFile(linkedFile);
            }
        }
    }

    @Override
    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation relation, SNode fromNode, long order) {
    }

    private void addVirtualRange(Long tokenID, Range newRange) {
        Range<Double> existingRange = this.virtTokenTimes.get(tokenID);
        if (existingRange == null) {
            this.virtTokenTimes.put(tokenID, (Range<Double>)newRange);
        } else {
            this.virtTokenTimes.put(tokenID, (Range<Double>)existingRange.intersection(newRange));
        }
    }

    private void outputVirtualTokenAnnotations() {
        for (Map.Entry<Long, Range<Double>> e : this.virtTokenTimes.entrySet()) {
            Range<Double> r = e.getValue();
            String val = null;
            if (r.hasLowerBound() && r.hasUpperBound()) {
                val = r.lowerEndpoint() + "-" + r.upperEndpoint();
            } else if (r.hasLowerBound()) {
                val = "" + r.lowerEndpoint();
            } else if (r.hasUpperBound()) {
                val = "-" + r.upperEndpoint();
            }
            if (val == null) continue;
            this.mapSNodeAnnotation(e.getKey(), "annis", "time", val);
        }
    }
}

