/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;

public class ANNISExporterProperties
extends PepperModuleProperties {
    public static final String PREFIX_CLOBBER = "clobber.";
    public static final String PROP_VISUALISATION_CLOBBER = "clobber.visualisation";
    public static final String PROP_CORPUS_ANNOTATION_CLOBBER = "clobber.corpus_annotation";
    public static final String PROP_INDIVIDUAL_CORPUS_NAME = "corpusName";
    public static final String PROP_ESCAPE_CHARACTERS = "escapeCharacters";
    public static final String PROP_ESCAPE_CHARACTERS_LIST = "escapeCharactersList";
    public static final String PROP_MERGE_TEXTS_WITH_TIMELINE = "mergeTextsWithTimeline";
    public static final String PROP_EXCLUDE_SINGLE_DOM_TYPE = "excludeSingleDomType";

    public ANNISExporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_VISUALISATION_CLOBBER, Boolean.class, "This property defines whether the resolver_vis_map.tab is allowed to be overwritten if it is existent. By default, the table is overwritten(value:true)", (Object)Boolean.TRUE, false));
        this.addProperty(new PepperModuleProperty(PROP_CORPUS_ANNOTATION_CLOBBER, Boolean.class, "This property defines whether the corpus_annotation.tab is allowed to be overwritten if it is existent. By default, the table is overwritten(value:true)", (Object)Boolean.TRUE, false));
        this.addProperty(new PepperModuleProperty(PROP_INDIVIDUAL_CORPUS_NAME, String.class, "This property defines an individual name for the top-level corpus. By default, the top-level corpus gets a generic name by the salt meta model.", null, false));
        this.addProperty(new PepperModuleProperty(PROP_ESCAPE_CHARACTERS, Boolean.class, "This property defines whether special characters are escaped during export. By default, characters which are incompatible with databases are escaped.", (Object)Boolean.TRUE, false));
        this.addProperty(new PepperModuleProperty(PROP_ESCAPE_CHARACTERS_LIST, String.class, "This property defines a set of special characters with their escape characters.", null, Boolean.FALSE.booleanValue()));
        this.addProperty(new PepperModuleProperty(PROP_MERGE_TEXTS_WITH_TIMELINE, Boolean.class, "If \"true\" and the document has a timeline merge texts of one document to one text and create an artificial tokenization based on the timeline.", (Object)Boolean.TRUE, false));
        this.addProperty(new PepperModuleProperty(PROP_EXCLUDE_SINGLE_DOM_TYPE, Boolean.class, "If there is only a single edge type for dominance relations and this property is set, don't output the named component entries (but the general one with the empty name)", (Object)Boolean.FALSE, false));
    }

    public boolean getEscapeCharacters() {
        return (Boolean)this.getProperty(PROP_ESCAPE_CHARACTERS).getValue();
    }

    public ConcurrentMap<Character, String> getEscapeCharactersSet() {
        ConcurrentHashMap<Character, String> characterEscapeTable = null;
        String escapeString = (String)this.getProperty(PROP_ESCAPE_CHARACTERS_LIST).getValue();
        if (escapeString != null && !escapeString.isEmpty()) {
            characterEscapeTable = new ConcurrentHashMap<Character, String>();
            Pattern pattern = Pattern.compile("(\\()(.*?=.*?)(\\))");
            Matcher matcher = pattern.matcher(escapeString);
            ArrayList<String> listMatches = new ArrayList<String>();
            while (matcher.find()) {
                listMatches.add(matcher.group(2));
            }
            for (String escapePair : listMatches) {
                int key;
                String[] valuePair = escapePair.split("=");
                if (valuePair.length != 2) continue;
                if (valuePair[0].equals("\\t")) {
                    key = 9;
                } else if (valuePair[0].equals("\\n")) {
                    key = 10;
                } else if (valuePair[0].equals("\\r")) {
                    key = 13;
                } else if (valuePair[0].equals("'")) {
                    key = 39;
                } else if (valuePair[0].equals("\"")) {
                    key = 34;
                } else {
                    if (valuePair[0].length() != 1) continue;
                    key = valuePair[0].toCharArray()[0];
                }
                characterEscapeTable.put(Character.valueOf((char)key), valuePair[1]);
            }
        }
        return characterEscapeTable;
    }

    public boolean getClobberResolverVisMap() {
        return (Boolean)this.getProperty(PROP_VISUALISATION_CLOBBER).getValue();
    }

    public boolean getClobberCorpusAnnotations() {
        return (Boolean)this.getProperty(PROP_CORPUS_ANNOTATION_CLOBBER).getValue();
    }

    public String getIndividualCorpusName() {
        return (String)this.getProperty(PROP_INDIVIDUAL_CORPUS_NAME).getValue();
    }

    public boolean getMergeTextsWithTimeline() {
        return (Boolean)this.getProperty(PROP_MERGE_TEXTS_WITH_TIMELINE).getValue();
    }

    public boolean getExcludeSingleDomType() {
        return (Boolean)this.getProperty(PROP_EXCLUDE_SINGLE_DOM_TYPE).getValue();
    }
}

