/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.annis;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import org.corpus_tools.pepper.impl.PepperExporterImpl;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.peppermodules.annis.ANNIS;
import org.corpus_tools.peppermodules.annis.ANNISExporterProperties;
import org.corpus_tools.peppermodules.annis.GlobalIdManager;
import org.corpus_tools.peppermodules.annis.IdManager;
import org.corpus_tools.peppermodules.annis.ResolverEntry;
import org.corpus_tools.peppermodules.annis.Salt2ANNISMapper;
import org.corpus_tools.peppermodules.annis.TupleWriter;
import org.corpus_tools.peppermodules.annis.resolver.DomStatistics;
import org.corpus_tools.peppermodules.annis.resolver.PointingStatistics;
import org.corpus_tools.peppermodules.annis.resolver.QName;
import org.corpus_tools.peppermodules.annis.resolver.SpanStatistics;
import org.corpus_tools.peppermodules.annis.resolver.VirtualTokenStatistics;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="ANNISExporterComponent", factory="PepperExporterComponentFactory")
public class ANNISExporter
extends PepperExporterImpl
implements PepperExporter,
ANNIS {
    private static final Logger log = LoggerFactory.getLogger(ANNISExporter.class);
    public static final long MAX_NUM_OF_NODES_FOR_DISCOURSE = 5000L;
    public TupleWriter tw_text = null;
    public TupleWriter tw_node = null;
    public TupleWriter tw_nodeAnno = null;
    public TupleWriter tw_rank = null;
    public TupleWriter tw_edgeAnno = null;
    public TupleWriter tw_component = null;
    public TupleWriter tw_corpus = null;
    public TupleWriter tw_corpusMeta = null;
    public TupleWriter tw_visualization = null;
    boolean overwriteResolverVisMap = true;
    boolean overwriteCorpusAnnotations = true;
    public String individualCorpusName = null;
    private ConcurrentMap<Character, String> characterEscapeTable = null;
    private boolean escapeCharacters = true;
    private boolean mergeTextsWithTimeline = true;
    private GlobalIdManager globalIdManager;
    private DomStatistics domStats;
    private SpanStatistics spanStats;
    private PointingStatistics pointingStats;
    private VirtualTokenStatistics virtualTokenStatistics;

    public ANNISExporter() {
        this.setProperties(new ANNISExporterProperties());
        this.setName("ANNISExporter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setDesc("This exporter transforms a Salt model into the annis format. ");
        this.addSupportedFormat("relANNIS", "3.3", null);
        this.addSupportedFormat("annis", "3.3", null);
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        Salt2ANNISMapper mapper = new Salt2ANNISMapper();
        mapper.setIdManager(new IdManager(this.globalIdManager));
        mapper.setGlobalDomStats(this.domStats);
        mapper.setGlobalPointingStats(this.pointingStats);
        mapper.setGlobalSpanStats(this.spanStats);
        mapper.setGlobalVirtualTokenStats(this.virtualTokenStatistics);
        mapper.setMergeTextsWithTimeline(this.mergeTextsWithTimeline);
        mapper.setOutputDir(new File(this.getCorpusDesc().getCorpusPath().toFileString()));
        mapper.tw_text = this.tw_text;
        mapper.tw_node = this.tw_node;
        mapper.tw_nodeAnno = this.tw_nodeAnno;
        mapper.tw_rank = this.tw_rank;
        mapper.tw_edgeAnno = this.tw_edgeAnno;
        mapper.tw_component = this.tw_component;
        mapper.tw_corpus = this.tw_corpus;
        mapper.tw_corpusMeta = this.tw_corpusMeta;
        mapper.tw_visualization = this.tw_visualization;
        mapper.individualCorpusName = this.individualCorpusName;
        mapper.mapRelationsInParallel(true);
        if (sElementId.getIdentifiableElement() != null && sElementId.getIdentifiableElement() instanceof SCorpus) {
            mapper.setCorpusGraph(((SCorpus)sElementId.getIdentifiableElement()).getGraph());
        }
        return mapper;
    }

    private synchronized TupleWriter createTupleWriter(File outFile) {
        return ANNISExporter.createTupleWriter(outFile, this.escapeCharacters, this.characterEscapeTable);
    }

    public static synchronized TupleWriter createTupleWriter(File outFile, boolean escapeCharacters, ConcurrentMap<Character, String> characterEscapeTable) {
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        if (!outFile.exists()) {
            try {
                outFile.createNewFile();
            }
            catch (IOException e) {
                throw new PepperModuleException("Could not create the corpus tab file " + outFile.getAbsolutePath() + " Exception:" + e.getMessage());
            }
        }
        TupleWriter tWriter = new TupleWriter();
        tWriter.setEscaping(escapeCharacters);
        if (characterEscapeTable != null) {
            tWriter.setEscapeTable(characterEscapeTable);
        }
        tWriter.setFile(outFile);
        return tWriter;
    }

    private ANNISExporterProperties getProps() {
        return (ANNISExporterProperties)this.getProperties();
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        if (this.getProperties() != null) {
            this.overwriteResolverVisMap = this.getProps().getClobberResolverVisMap();
            this.overwriteCorpusAnnotations = this.getProps().getClobberCorpusAnnotations();
            String individualCorpusName_tmp = this.getProps().getIndividualCorpusName();
            if (individualCorpusName_tmp != null) {
                this.individualCorpusName = individualCorpusName_tmp.trim();
            }
            this.escapeCharacters = this.getProps().getEscapeCharacters();
            if (this.escapeCharacters) {
                this.characterEscapeTable = this.getProps().getEscapeCharactersSet();
            }
            this.mergeTextsWithTimeline = this.getProps().getMergeTextsWithTimeline();
        }
        this.globalIdManager = new GlobalIdManager();
        this.domStats = new DomStatistics();
        this.spanStats = new SpanStatistics();
        this.pointingStats = new PointingStatistics();
        this.virtualTokenStatistics = new VirtualTokenStatistics();
        return super.isReadyToStart();
    }

    private void writeVersionFiles() {
        File versionFile = new File(this.getCorpusDesc().getCorpusPath().toFileString(), "annis.version");
        try {
            Files.write((CharSequence)"3.3", (File)versionFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException ex) {
            log.error("Can't write {} file", (Object)ex, (Object)"annis.version");
        }
    }

    private void createTupleWriters() {
        String corpPath = this.getCorpusDesc().getCorpusPath().toFileString() + (this.getCorpusDesc().getCorpusPath().toFileString().endsWith("/") ? "" : "/");
        this.tw_text = this.createTupleWriter(new File(corpPath + "text.annis"));
        this.tw_node = this.createTupleWriter(new File(corpPath + "node.annis"));
        this.tw_nodeAnno = this.createTupleWriter(new File(corpPath + "node_annotation.annis"));
        this.tw_rank = this.createTupleWriter(new File(corpPath + "rank.annis"));
        this.tw_edgeAnno = this.createTupleWriter(new File(corpPath + "edge_annotation.annis"));
        this.tw_component = this.createTupleWriter(new File(corpPath + "component.annis"));
        this.tw_corpus = this.createTupleWriter(new File(corpPath + "corpus.annis"));
        File resolverVisFile = new File(corpPath + "resolver_vis_map.annis");
        if (!resolverVisFile.exists()) {
            this.tw_visualization = this.createTupleWriter(resolverVisFile);
        } else if (this.overwriteResolverVisMap) {
            this.tw_visualization = this.createTupleWriter(resolverVisFile);
        }
        File corpusAnnotationFile = new File(corpPath + "corpus_annotation.annis");
        if (!corpusAnnotationFile.exists()) {
            this.tw_corpusMeta = this.createTupleWriter(corpusAnnotationFile);
        } else if (this.overwriteCorpusAnnotations) {
            this.tw_corpusMeta = this.createTupleWriter(corpusAnnotationFile);
        }
    }

    public void start() throws PepperModuleException {
        this.createTupleWriters();
        this.writeVersionFiles();
        super.start();
    }

    public void end() throws PepperModuleException {
        super.end();
        this.createVirtualTokenizationResolverEntries();
        for (String string : this.spanStats.getLayers()) {
            this.createSpanResolverEntry(string);
        }
        for (String string : this.domStats.getLayers()) {
            this.createDominanceResolverEntry(string);
        }
        for (QName qName : this.pointingStats.getLayers()) {
            this.createPointingResolverEntry(qName);
        }
        this.createMediaResolverEntries();
        for (SCorpusGraph sCorpusGraph : this.getSaltProject().getCorpusGraphs()) {
            if (this.tw_visualization == null) continue;
            this.printResolverVisMap(sCorpusGraph);
        }
    }

    private void createSpanResolverEntry(String layer) {
        String displayName = "grid";
        if (layer != null) {
            displayName = displayName + " (" + layer + ")";
        }
        ResolverEntry entry = new ResolverEntry();
        Set<QName> annosForLayer = this.spanStats.getNodeAnnotations(layer);
        Set<QName> virtualAnnoNames = this.virtualTokenStatistics.getVirtualAnnoNames();
        if (!virtualAnnoNames.isEmpty()) {
            String ns;
            entry.getMappings().put("hide_tok", "true");
            LinkedHashSet<String> annoNameFilter = new LinkedHashSet<String>();
            for (QName a : annosForLayer) {
                ns = a.getNs();
                if ("null".equals(ns)) {
                    ns = "default_ns";
                }
                annoNameFilter.add("/" + ns + "::" + a.getName() + "/");
            }
            for (QName virtualAnno : virtualAnnoNames) {
                ns = virtualAnno.hasNs() ? virtualAnno.getNs() : "default_ns";
                annoNameFilter.add("/" + ns + "::" + virtualAnno.getName() + "/");
                annosForLayer.add(virtualAnno);
            }
            entry.getMappings().put("annos", Joiner.on((String)",").join(annoNameFilter));
        }
        boolean showNamespace = false;
        HashSet<String> annoNames = new HashSet<String>();
        for (QName n : annosForLayer) {
            if (annoNames.contains(n.getName())) {
                showNamespace = true;
                break;
            }
            annoNames.add(n.getName());
        }
        entry.setVis(ResolverEntry.Vis.grid);
        entry.setDisplay(displayName);
        if (layer != null) {
            entry.setElement(ResolverEntry.Element.node);
            if (virtualAnnoNames.isEmpty()) {
                entry.setLayerName(layer);
            }
        }
        if (showNamespace) {
            entry.getMappings().put("show_ns", "true");
        }
        this.globalIdManager.getResolverEntryByDisplay().putIfAbsent(entry.getDisplay(), entry);
    }

    private void createDominanceResolverEntry(String layerName) {
        ResolverEntry entry = new ResolverEntry();
        if (layerName != null && (layerName.equalsIgnoreCase("rst") || layerName.startsWith("rhet"))) {
            entry.setVis(ResolverEntry.Vis.rstdoc);
            entry.setDisplay("rst (" + layerName + ")");
            entry.setLayerName(layerName);
            entry.setElement(ResolverEntry.Element.node);
        } else {
            SortedMap<Integer, String> etypes;
            Set<QName> edgeAnnos;
            SortedMap<Integer, QName> nodeAnnos;
            String displayName = "tree";
            if (layerName != null) {
                displayName = displayName + " (" + layerName + ")";
            }
            entry.setDisplay(displayName);
            if (layerName != null) {
                entry.setElement(ResolverEntry.Element.node);
                entry.setLayerName(layerName);
            }
            entry.setVis(ResolverEntry.Vis.tree);
            Set<QName> terminalAnnos = this.domStats.getTerminalAnno().get(layerName);
            if (terminalAnnos.size() >= 1) {
                QName qname = terminalAnnos.iterator().next();
                entry.getMappings().put("terminal_name", this.globalIdManager.getEscapedIdentifier(qname.getName()));
                if (!"null".equals(qname.getNs())) {
                    entry.getMappings().put("terminal_ns", this.globalIdManager.getEscapedIdentifier(qname.getNs()));
                }
            }
            if ((nodeAnnos = this.domStats.getNodeAnnoCounter().getBySize(layerName)).size() >= 1) {
                QName qname = (QName)nodeAnnos.get(nodeAnnos.lastKey());
                entry.getMappings().put("node_key", this.globalIdManager.getEscapedIdentifier(qname.getName()));
                String nodeNS = qname.getNs();
                if (nodeNS == null || "null".equals(nodeNS)) {
                    nodeNS = "default_ns";
                }
                if (!nodeNS.equals(layerName)) {
                    entry.getMappings().put("node_anno_ns", this.globalIdManager.getEscapedIdentifier(nodeNS));
                }
            }
            if ((edgeAnnos = this.domStats.getEdgeAnno().get(layerName)).size() >= 1) {
                QName qname = edgeAnnos.iterator().next();
                entry.getMappings().put("edge_key", this.globalIdManager.getEscapedIdentifier(qname.getName()));
                if (!"null".equals(qname.getNs())) {
                    entry.getMappings().put("edge_anno_ns", this.globalIdManager.getEscapedIdentifier(qname.getNs()));
                }
            }
            if ((etypes = this.domStats.getEdgeTypeCounter().getBySize(layerName)).isEmpty() || ((ANNISExporterProperties)this.getProperties()).getExcludeSingleDomType() && etypes.size() <= 1) {
                entry.getMappings().put("edge_type", this.globalIdManager.getEscapedIdentifier("null"));
            } else {
                String primaryType = (String)etypes.get(etypes.lastKey());
                String secondaryType = etypes.size() >= 2 ? (String)etypes.get(etypes.firstKey()) : null;
                Set<String> terminalRelationTypes = this.domStats.getTerminalEdgeType().get(layerName);
                if (secondaryType == null) {
                    if (!terminalRelationTypes.contains(primaryType)) {
                        primaryType = "null";
                    }
                } else if (!terminalRelationTypes.contains(primaryType) && !terminalRelationTypes.contains(secondaryType)) {
                    primaryType = "null";
                }
                entry.getMappings().put("edge_type", this.globalIdManager.getEscapedIdentifier(primaryType));
                if (secondaryType != null) {
                    entry.getMappings().put("secedge_type", this.globalIdManager.getEscapedIdentifier(secondaryType));
                }
            }
        }
        this.globalIdManager.getResolverEntryByDisplay().putIfAbsent(entry.getDisplay(), entry);
    }

    private void createPointingResolverEntry(QName layerName) {
        ResolverEntry entry = new ResolverEntry();
        Set<QName> terminalAnnos = this.pointingStats.getTerminalAnno().get(layerName);
        if (terminalAnnos.size() <= 1) {
            entry.setVis(ResolverEntry.Vis.arch_dependency);
            if (terminalAnnos.size() == 1) {
                QName qname = terminalAnnos.iterator().next();
                entry.getMappings().put("node_key", this.globalIdManager.getEscapedIdentifier(qname.getName()));
            }
        } else if (this.pointingStats.getMaxNodeCount() <= 5000L) {
            entry.setVis(ResolverEntry.Vis.discourse);
        } else {
            entry.setVis(ResolverEntry.Vis.coref);
        }
        String displayName = entry.getVis().name();
        if (layerName != null) {
            displayName = layerName.getName() + " (" + layerName.getNs() + ")";
        }
        entry.setDisplay(displayName);
        if (layerName != null) {
            entry.setElement(ResolverEntry.Element.edge);
            entry.setLayerName(layerName.getNs());
        }
        this.globalIdManager.getResolverEntryByDisplay().putIfAbsent(entry.getDisplay(), entry);
    }

    private void createMediaResolverEntries() {
        ResolverEntry entry;
        if (this.globalIdManager.isAudioFound()) {
            entry = new ResolverEntry();
            entry.setDisplay("audio");
            entry.setVis(ResolverEntry.Vis.audio);
            entry.setVisibility(ResolverEntry.Visibility.preloaded);
            this.globalIdManager.getResolverEntryByDisplay().putIfAbsent(entry.getDisplay(), entry);
        }
        if (this.globalIdManager.isVideoFound()) {
            entry = new ResolverEntry();
            entry.setDisplay("video");
            entry.setVis(ResolverEntry.Vis.video);
            entry.setVisibility(ResolverEntry.Visibility.preloaded);
            this.globalIdManager.getResolverEntryByDisplay().putIfAbsent(entry.getDisplay(), entry);
        }
        if (this.globalIdManager.isPDFFound()) {
            entry = new ResolverEntry();
            entry.setDisplay("pdf");
            entry.setVis(ResolverEntry.Vis.pdf);
            entry.setVisibility(ResolverEntry.Visibility.preloaded);
            this.globalIdManager.getResolverEntryByDisplay().putIfAbsent(entry.getDisplay(), entry);
        }
    }

    private void createVirtualTokenizationResolverEntries() {
        Set<QName> virtualAnnoNames = this.virtualTokenStatistics.getVirtualAnnoNames();
        if (!(virtualAnnoNames.isEmpty() || !this.globalIdManager.containsVirtualTokens() && this.virtualTokenStatistics.getHasRealToken())) {
            ResolverEntry entryHideKWIC = new ResolverEntry();
            entryHideKWIC.setDisplay("kwic");
            entryHideKWIC.setVisibility(ResolverEntry.Visibility.removed);
            entryHideKWIC.setVis(ResolverEntry.Vis.kwic);
            this.globalIdManager.getResolverEntryByDisplay().putIfAbsent(entryHideKWIC.getDisplay(), entryHideKWIC);
            ResolverEntry entryGrid = new ResolverEntry();
            entryGrid.setDisplay("");
            entryGrid.setVis(ResolverEntry.Vis.grid);
            entryGrid.setElement(ResolverEntry.Element.node);
            entryGrid.setVisibility(ResolverEntry.Visibility.permanent);
            entryGrid.getMappings().put("hide_tok", "true");
            LinkedHashSet<String> escapedNames = new LinkedHashSet<String>();
            for (QName origName : virtualAnnoNames) {
                escapedNames.add(this.globalIdManager.getEscapedIdentifier(origName.getName()));
            }
            entryGrid.getMappings().put("annos", Joiner.on((String)",").join(escapedNames));
            this.globalIdManager.getResolverEntryByDisplay().putIfAbsent(entryGrid.getDisplay(), entryGrid);
        }
    }

    private void printResolverVisMap(SCorpusGraph corpusGraph) {
        Long transactionId = this.tw_visualization.beginTA();
        try {
            String corpusName = "NULL";
            String corpusVersion = "NULL";
            if (corpusGraph.getRoots() != null && corpusGraph.getRoots().size() > 0) {
                SCorpus rootCorpus = (SCorpus)corpusGraph.getRoots().get(0);
                corpusName = this.individualCorpusName != null ? this.individualCorpusName : rootCorpus.getName();
                SMetaAnnotation version = rootCorpus.getMetaAnnotation("version");
                if (version != null && version.getValue_STEXT() != null) {
                    corpusVersion = version.getValue_STEXT();
                }
            }
            ArrayList entries = new ArrayList(this.getGlobalIdManager().getResolverEntryByDisplay().values());
            Collections.sort(entries, new ResolverComparator());
            int order = 1;
            for (ResolverEntry e : entries) {
                e.setOrder(order);
                ArrayList<String> resolverTuple = new ArrayList<String>();
                resolverTuple.add(corpusName);
                resolverTuple.add(corpusVersion);
                resolverTuple.add(e.getLayerName() == null ? "NULL" : e.getLayerName());
                resolverTuple.add(e.getElement().name());
                resolverTuple.add(e.getVis().name());
                resolverTuple.add(e.getDisplay());
                resolverTuple.add(e.getVisibility().name());
                resolverTuple.add("" + e.getOrder());
                LinkedList<String> mappings = new LinkedList<String>();
                for (Map.Entry<String, String> m : e.getMappings().entrySet()) {
                    mappings.add(m.getKey() + ":" + m.getValue());
                }
                if (mappings.isEmpty()) {
                    resolverTuple.add("NULL");
                } else {
                    resolverTuple.add(Joiner.on((String)";").join(mappings));
                }
                this.tw_visualization.addTuple(resolverTuple);
                ++order;
            }
            this.tw_visualization.commitTA(transactionId);
        }
        catch (FileNotFoundException e) {
            this.tw_visualization.abortTA(transactionId);
            throw new PepperModuleException((PepperModule)this, "Could not write to the file " + this.tw_visualization.getFile().getAbsolutePath() + ". Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public GlobalIdManager getGlobalIdManager() {
        return this.globalIdManager;
    }

    public static class ResolverComparator
    implements Comparator<ResolverEntry> {
        @Override
        public int compare(ResolverEntry o1, ResolverEntry o2) {
            int byVis = o1.getVis().compareTo(o2.getVis());
            if (byVis != 0) {
                return byVis;
            }
            return o1.getDisplay().compareTo(o2.getDisplay());
        }
    }
}

