/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal.persistence.dot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusDocumentRelation;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SCorpusRelation;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAbstractAnnotation;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.exceptions.SaltResourceException;
import org.corpus_tools.salt.util.internal.persistence.dot.DOTEdge;
import org.corpus_tools.salt.util.internal.persistence.dot.DOTNode;
import org.eclipse.emf.common.util.URI;

public class SCorpusGraphDOTWriter
implements GraphTraverseHandler {
    private URI outputURI = null;
    private SCorpusGraph sCorpusGraph = null;
    private PrintStream currOutputStream = null;

    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public URI getOutputURI() {
        return this.outputURI;
    }

    public void setSCorpusGraph(SCorpusGraph sCorpusGraph) {
        this.sCorpusGraph = sCorpusGraph;
    }

    public SCorpusGraph getSCorpusGraph() {
        return this.sCorpusGraph;
    }

    public void save() {
        if (this.getOutputURI() == null) {
            throw new SaltException("Cannot print the given model to dot, because no output file is given.");
        }
        String str = this.getOutputURI().toFileString();
        if (str == null) {
            str = this.getOutputURI().toString();
        }
        File outputFile = new File(str);
        File outputDir = null;
        outputDir = outputFile.getName().endsWith(".dot") ? outputFile.getParentFile() : outputFile;
        outputDir.mkdirs();
        try {
            this.currOutputStream = new PrintStream(outputFile, "UTF-8");
        }
        catch (FileNotFoundException e) {
            throw new SaltResourceException("Cannot save " + SCorpusGraph.class.getSimpleName() + " object to uri '" + this.outputURI + "'", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SaltResourceException("Cannot save " + SCorpusGraph.class.getSimpleName() + " object to uri '" + this.outputURI + "'", e);
        }
        this.currOutputStream.println("digraph G {");
        this.currOutputStream.println("ordering=out;");
        if (this.getSCorpusGraph() != null) {
            try {
                this.getSCorpusGraph().traverse(this.getSCorpusGraph().getRoots(), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "", this);
            }
            catch (Exception e) {
                throw new SaltException("Cannot print SCorpusGraph as dot serialization, because of nested exception. ", e);
            }
        } else {
            this.currOutputStream.println("<empty>[color=red,style=filled]");
        }
        this.currOutputStream.println("}");
        this.currOutputStream.flush();
        this.currOutputStream.close();
    }

    private String createAnnotations(SAbstractAnnotation sAnno) {
        String retStr = null;
        String anno = null;
        if (sAnno.getValue() != null) {
            anno = sAnno.getValue().toString().replace("\"", "\\\"");
        }
        retStr = sAnno.getQName() + "= " + anno;
        return retStr;
    }

    public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation edge, SNode currNode, long order) {
        return true;
    }

    public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode fromNode, long order) {
    }

    public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currSNode, SRelation relation, SNode fromSNode, long order) {
        DOTNode dotNode = new DOTNode();
        dotNode.id = currSNode.getId();
        if (currSNode.getName() != null) {
            dotNode.labels.add("name= " + currSNode.getName());
        }
        for (SMetaAnnotation sMetaAnno : currSNode.getMetaAnnotations()) {
            dotNode.labels.add(this.createAnnotations(sMetaAnno));
        }
        for (SAnnotation sAnno : currSNode.getAnnotations()) {
            String anno = sAnno.getValue().toString().replace("\"", "\\\"");
            dotNode.labels.add(sAnno.getQName() + "= " + anno);
        }
        if (currSNode instanceof SCorpus) {
            dotNode.color = "gray28";
            dotNode.style = "filled";
            dotNode.shape = "Mrecord";
        } else if (currSNode instanceof SDocument) {
            dotNode.color = "gray";
            dotNode.style = "filled";
            dotNode.shape = "Mrecord";
        }
        this.currOutputStream.println(dotNode.toString());
        if (relation != null) {
            String type;
            DOTEdge dotEdge = new DOTEdge();
            dotEdge.fromId = fromSNode.getId();
            dotEdge.toId = currSNode.getId();
            if (relation.getName() != null) {
                dotEdge.labels.add("name= " + relation.getName());
            }
            if ((type = relation.getType()) != null && !type.isEmpty()) {
                dotEdge.labels.add("type=[" + type + "]");
            }
            for (SAnnotation sAnno : relation.getAnnotations()) {
                dotEdge.labels.add(sAnno.getQName() + "= " + sAnno.getValue().toString());
            }
            if (relation instanceof SCorpusRelation) {
                dotEdge.color = "gray28";
                dotEdge.style = "filled";
            } else if (relation instanceof SCorpusDocumentRelation) {
                dotEdge.color = "gray";
                dotEdge.style = "filled";
            }
            this.currOutputStream.println(dotEdge.toString());
        }
    }
}

