/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import java.util.Set;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.util.DIFF_TYPES;
import org.corpus_tools.salt.util.DiffOptions;
import org.corpus_tools.salt.util.Difference;
import org.corpus_tools.salt.util.SaltUtil;
import org.corpus_tools.salt.util.internal.AbstractDiff;

public class SaltProjectDiff
extends AbstractDiff<SaltProject> {
    public SaltProjectDiff(SaltProject template, SaltProject other) {
        this(template, other, (DiffOptions)null);
    }

    public SaltProjectDiff(SaltProject template, SaltProject other, DiffOptions optionMap) {
        super(template, other, optionMap);
    }

    @Override
    protected boolean findDiffs(boolean diffsRequested) {
        boolean retVal = true;
        if (this.templateObject == null || this.otherObject == null) {
            if (!diffsRequested) {
                return false;
            }
            retVal = false;
            this.addDifference(this.templateObject, this.otherObject, null, DIFF_TYPES.PROJECT_MISSING, null);
        }
        if (((SaltProject)this.templateObject).getName() != null) {
            if (!((SaltProject)this.templateObject).getName().equals(((SaltProject)this.otherObject).getName())) {
                if (!diffsRequested) {
                    return false;
                }
                retVal = false;
                this.addDifference(this.templateObject, this.otherObject, null, DIFF_TYPES.PROJECT_NAME_DIFFERING, null);
            }
        } else if (((SaltProject)this.otherObject).getName() != null) {
            if (!diffsRequested) {
                return false;
            }
            retVal = false;
            this.addDifference(this.templateObject, this.otherObject, null, DIFF_TYPES.PROJECT_NAME_DIFFERING, null);
        }
        if (((SaltProject)this.otherObject).getCorpusGraphs().size() != ((SaltProject)this.templateObject).getCorpusGraphs().size()) {
            if (!diffsRequested) {
                return false;
            }
            retVal = false;
            this.addDifference(this.templateObject, this.otherObject, null, DIFF_TYPES.PROJECT_NUMBER_CORPUS_GRAPH_DIFFERING, null);
        }
        for (int i = 0; i < ((SaltProject)this.otherObject).getCorpusGraphs().size(); ++i) {
            if (!diffsRequested) {
                return SaltUtil.compare(((SaltProject)this.templateObject).getCorpusGraphs().get(0)).with(((SaltProject)this.otherObject).getCorpusGraphs().get(0)).useOptions(this.options).andCheckIsomorphie();
            }
            Set<Difference> diffs = SaltUtil.compare(((SaltProject)this.templateObject).getCorpusGraphs().get(0)).with(((SaltProject)this.otherObject).getCorpusGraphs().get(0)).useOptions(this.options).andFindDiffs();
            if (diffs.size() <= 0) continue;
            retVal = false;
            this.addDifference(this.templateObject, this.otherObject, null, DIFF_TYPES.CORPUS_GRAPH_DIFFERING, diffs);
        }
        return retVal;
    }
}

