/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SProcessingAnnotation;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.util.SaltUtil;

public class SAnnotationContainerHelper {
    private static final Set<? extends Label> DEFAULT_EMPTY_LIST = Collections.unmodifiableSet(new HashSet());

    public static void addAnnotation(SAnnotationContainer container, SAnnotation annotation) {
        container.addLabel(annotation);
    }

    public static SAnnotation getAnnotation(SAnnotationContainer container, String qName) {
        SAnnotation anno = null;
        Label label = container.getLabel(qName);
        if (label instanceof SAnnotation) {
            anno = (SAnnotation)label;
        }
        return anno;
    }

    public static Set<SAnnotation> createAnnotations(SAnnotationContainer container, String annotationString) {
        HashSet<SAnnotation> retVal = new HashSet<SAnnotation>();
        for (String[] triple : SaltUtil.unmarshalAnnotation(annotationString)) {
            retVal.add(container.createAnnotation(triple[0], triple[1], triple[2]));
        }
        return retVal;
    }

    public static <A extends SAnnotation> Set<A> getAnnotations(SAnnotationContainer container) {
        Set retVal = null;
        if (container != null && container.getLabels() != null) {
            for (Label label : container.getLabels()) {
                if (!(label instanceof SAnnotation)) continue;
                if (retVal == null) {
                    retVal = new HashSet();
                }
                retVal.add((SAnnotation)label);
            }
        }
        if (retVal == null) {
            return DEFAULT_EMPTY_LIST;
        }
        retVal = Collections.unmodifiableSet(retVal);
        return retVal;
    }

    public static Iterator<SAnnotation> iterator_SAnnotation(SAnnotationContainer container) {
        MyIterator<SAnnotation> retVal = null;
        if (container != null) {
            retVal = new MyIterator<SAnnotation>(container.getLabels().iterator(), SAnnotation.class);
        }
        return retVal;
    }

    public static SAnnotation createAnnotation(SAnnotationContainer container, String namespace, String name, Object value) {
        SAnnotation retVal = SaltFactory.createSAnnotation();
        retVal.setNamespace(namespace);
        retVal.setName(name);
        retVal.setValue(value);
        container.addAnnotation(retVal);
        return retVal;
    }

    public static void addMetaAnnotation(SAnnotationContainer container, SMetaAnnotation metaAnnotation) {
        container.addLabel(metaAnnotation);
    }

    public static SMetaAnnotation createMetaAnnotation(SAnnotationContainer container, String namespace, String name, Object value) {
        SMetaAnnotation retVal = SaltFactory.createSMetaAnnotation();
        retVal.setNamespace(namespace);
        retVal.setName(name);
        retVal.setValue(value);
        container.addMetaAnnotation(retVal);
        return retVal;
    }

    public static Set<SMetaAnnotation> createMetaAnnotations(SAnnotationContainer container, String metaAnnotationString) {
        HashSet<SMetaAnnotation> retVal = new HashSet<SMetaAnnotation>();
        for (String[] triple : SaltUtil.unmarshalAnnotation(metaAnnotationString)) {
            retVal.add(container.createMetaAnnotation(triple[0], triple[1], triple[2]));
        }
        return retVal;
    }

    public static <A extends SMetaAnnotation> Set<A> getMetaAnnotations(SAnnotationContainer container) {
        Set retVal = null;
        if (container != null && container.getLabels() != null) {
            for (Label label : container.getLabels()) {
                if (!(label instanceof SMetaAnnotation)) continue;
                if (retVal == null) {
                    retVal = new HashSet();
                }
                retVal.add((SMetaAnnotation)label);
            }
        }
        if (retVal == null) {
            return DEFAULT_EMPTY_LIST;
        }
        retVal = Collections.unmodifiableSet(retVal);
        return retVal;
    }

    public static SMetaAnnotation getMetaAnnotation(SAnnotationContainer container, String qName) {
        SMetaAnnotation anno = null;
        Label label = container.getLabel(qName);
        if (label instanceof SMetaAnnotation) {
            anno = (SMetaAnnotation)label;
        }
        return anno;
    }

    public static Iterator<SMetaAnnotation> iterator_SMetaAnnotation(SAnnotationContainer container) {
        MyIterator<SMetaAnnotation> retVal = null;
        if (container != null) {
            retVal = new MyIterator<SMetaAnnotation>(container.getLabels().iterator(), SMetaAnnotation.class);
        }
        return retVal;
    }

    public static void addProcessingAnnotation(SAnnotationContainer container, SProcessingAnnotation annotation) {
        container.addLabel(annotation);
    }

    public static SProcessingAnnotation getProcessingAnnotation(SAnnotationContainer container, String qName) {
        SProcessingAnnotation anno = null;
        Label label = container.getLabel(qName);
        if (label instanceof SProcessingAnnotation) {
            anno = (SProcessingAnnotation)label;
        }
        return anno;
    }

    public static Set<SProcessingAnnotation> createProcessingAnnotations(SAnnotationContainer container, String annotationString) {
        HashSet<SProcessingAnnotation> retVal = new HashSet<SProcessingAnnotation>();
        for (String[] triple : SaltUtil.unmarshalAnnotation(annotationString)) {
            retVal.add(container.createProcessingAnnotation(triple[0], triple[1], triple[2]));
        }
        return retVal;
    }

    public static <A extends SProcessingAnnotation> Set<A> getProcessingAnnotations(SAnnotationContainer container) {
        Set retVal = null;
        if (container != null && container.getLabels() != null) {
            for (Label label : container.getLabels()) {
                if (!(label instanceof SProcessingAnnotation)) continue;
                if (retVal == null) {
                    retVal = new HashSet();
                }
                retVal.add((SProcessingAnnotation)label);
            }
        }
        if (retVal == null) {
            return DEFAULT_EMPTY_LIST;
        }
        retVal = Collections.unmodifiableSet(retVal);
        return retVal;
    }

    public static Iterator<SProcessingAnnotation> iterator_SProcessingAnnotation(SAnnotationContainer container) {
        MyIterator<SProcessingAnnotation> retVal = null;
        if (container != null) {
            retVal = new MyIterator<SProcessingAnnotation>(container.getLabels().iterator(), SProcessingAnnotation.class);
        }
        return retVal;
    }

    public static SProcessingAnnotation createProcessingAnnotation(SAnnotationContainer container, String namespace, String name, Object value) {
        SProcessingAnnotation retVal = SaltFactory.createSProcessingAnnotation();
        retVal.setNamespace(namespace);
        retVal.setName(name);
        retVal.setValue(value);
        container.addProcessingAnnotation(retVal);
        return retVal;
    }

    public static void addFeature(SAnnotationContainer container, SFeature annotation) {
        container.addLabel(annotation);
    }

    public static SFeature getFeature(SAnnotationContainer container, String qName) {
        SFeature anno = null;
        Label label = container.getLabel(qName);
        if (label instanceof SFeature) {
            anno = (SFeature)label;
        }
        return anno;
    }

    public static Set<SFeature> createFeatures(SAnnotationContainer container, String annotationString) {
        HashSet<SFeature> retVal = new HashSet<SFeature>();
        for (String[] triple : SaltUtil.unmarshalAnnotation(annotationString)) {
            retVal.add(container.createFeature(triple[0], triple[1], triple[2]));
        }
        return retVal;
    }

    public static <A extends SFeature> Set<A> getFeatures(SAnnotationContainer container) {
        Set retVal = null;
        if (container != null && container.getLabels() != null) {
            for (Label label : container.getLabels()) {
                if (!(label instanceof SFeature)) continue;
                if (retVal == null) {
                    retVal = new HashSet();
                }
                retVal.add((SFeature)label);
            }
        }
        if (retVal == null) {
            return DEFAULT_EMPTY_LIST;
        }
        retVal = Collections.unmodifiableSet(retVal);
        return retVal;
    }

    public static Iterator<SFeature> iterator_SFeature(SAnnotationContainer container) {
        MyIterator<SFeature> retVal = null;
        if (container != null) {
            retVal = new MyIterator<SFeature>(container.getLabels().iterator(), SFeature.class);
        }
        return retVal;
    }

    public static SFeature createFeature(SAnnotationContainer container, String namespace, String name, Object value) {
        SFeature retVal = SaltFactory.createSFeature();
        retVal.setNamespace(namespace);
        retVal.setName(name);
        retVal.setValue(value);
        container.addFeature(retVal);
        return retVal;
    }

    public static class MyIterator<E extends Label>
    implements Iterator<E> {
        protected Iterator<Label> delegatee = null;
        protected Class<E> clazz = null;
        protected volatile E next = null;

        public MyIterator(Iterator<Label> delegatee, Class<E> clazz) {
            this.delegatee = delegatee;
            this.clazz = clazz;
        }

        @Override
        public boolean hasNext() {
            if (!this.delegatee.hasNext()) {
                return false;
            }
            this.next = this.next();
            return this.next != null;
        }

        @Override
        public synchronized E next() {
            Object retVal = this.next;
            this.next = null;
            if (retVal == null) {
                Label label = null;
                while (this.delegatee.hasNext() && (label = this.delegatee.next()) != null && !this.clazz.isInstance(label)) {
                }
                if (this.clazz.isInstance(label)) {
                    retVal = label;
                }
            }
            return retVal;
        }

        @Override
        public void remove() {
            this.delegatee.remove();
        }
    }
}

