/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSequentialRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextOverlappingRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.STimeOverlappingRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltInvalidModelException;
import org.corpus_tools.salt.exceptions.SaltParameterException;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.corpus_tools.salt.util.STextualRelationSStartComparator;
import org.corpus_tools.salt.util.TokenStartComparator;
import org.corpus_tools.salt.util.internal.GetXBySequence;

public class DataSourceAccessor {
    public static boolean isContinuousByText(SDocumentGraph documentGraph, List<? extends SNode> subSNodList, List<? extends SNode> fullSNodList) {
        if (documentGraph == null) {
            throw new SaltParameterException("Cannot start method 'getContinuously(List<SToken>, List<SToken>)' please set the document graph first.");
        }
        Boolean retVal = null;
        List<SToken> overlappedSTokens = DataSourceAccessor.getSortedSTokenByText(documentGraph, subSNodList);
        retVal = true;
        Integer posOfFirstOverlappedToken = fullSNodList.indexOf(overlappedSTokens.get(0));
        int ctr = 0;
        SToken sTokInAllTokens = null;
        for (SToken sToken : overlappedSTokens) {
            sTokInAllTokens = (SToken)fullSNodList.get(posOfFirstOverlappedToken + ctr);
            if (sToken.hashCode() != sTokInAllTokens.hashCode()) {
                retVal = false;
                break;
            }
            ++ctr;
        }
        return retVal;
    }

    public static boolean isContinuousByText(SDocumentGraph documentGraph, List<SNode> subSNodList) {
        return DataSourceAccessor.isContinuousByText(documentGraph, subSNodList, DataSourceAccessor.getSortedSTokenByText(documentGraph));
    }

    public static void sortSTokenByText(SDocumentGraph documentGraph) {
        if (documentGraph == null) {
            throw new SaltParameterException("Cannot start method please set the document graph first.");
        }
        if (documentGraph.getTokens() != null) {
            TokenStartComparator comparator = new TokenStartComparator();
            comparator.setDocumentGraph(documentGraph);
            List tokens = documentGraph.getIndexMgr().getAll("idx_sNodeType", SToken.class);
            LinkedList mutableTokens = new LinkedList(tokens);
            Collections.sort(mutableTokens, comparator);
            documentGraph.getIndexMgr().remove("idx_sNodeType", SToken.class);
            documentGraph.getIndexMgr().putAll("idx_sNodeType", SToken.class, mutableTokens);
            STextualRelationSStartComparator comparatortextrels = new STextualRelationSStartComparator();
            comparatortextrels.setDocumentGraph(documentGraph);
            List textualRelations = documentGraph.getIndexMgr().getAll("idx_sRelationType", STextualRelation.class);
            LinkedList mutableTextualRelations = new LinkedList(textualRelations);
            Collections.sort(mutableTextualRelations, comparatortextrels);
            documentGraph.getIndexMgr().remove("idx_sRelationType", STextualRelation.class);
            documentGraph.getIndexMgr().putAll("idx_sRelationType", STextualRelation.class, mutableTextualRelations);
        }
    }

    public static List<SToken> getSortedSTokenByText(SDocumentGraph documentGraph, List<SToken> sTokens2sort) {
        if (documentGraph == null) {
            throw new SaltParameterException("Cannot start method please set the document graph first.");
        }
        ArrayList<SToken> retVal = null;
        if (sTokens2sort != null) {
            TokenStartComparator comparator = new TokenStartComparator();
            comparator.setDocumentGraph(documentGraph);
            retVal = new ArrayList<SToken>();
            retVal.addAll(sTokens2sort);
            Collections.sort(retVal, comparator);
        }
        return retVal;
    }

    public static List<SToken> getSortedSTokenByText(SDocumentGraph documentGraph) {
        ArrayList<SToken> retVal = null;
        if (documentGraph == null) {
            throw new SaltParameterException("Cannot start method please set the document graph first.");
        }
        if (documentGraph.getTextualDSs() != null && documentGraph.getTextualDSs().size() > 0) {
            retVal = new ArrayList<SToken>();
            for (STextualDS sTextualDS : documentGraph.getTextualDSs()) {
                DataSourceSequence<Integer> sequence = new DataSourceSequence<Integer>();
                sequence.setDataSource(sTextualDS);
                sequence.setStart(0);
                sequence.setEnd(sTextualDS.getText() != null ? sTextualDS.getText().length() : 0);
                List<SToken> sTokens = new GetXBySequence(documentGraph).getTokensBySequence(sequence);
                if (sTokens == null) continue;
                retVal.addAll(DataSourceAccessor.getSortedSTokenByText(documentGraph, sTokens));
            }
        }
        return retVal;
    }

    public static List<DataSourceSequence> getOverlappedDataSourceSequence(SDocumentGraph documentGraph, SNode sNode, SALT_TYPE ... relationTypes) {
        ArrayList<SNode> rootSNodes = new ArrayList<SNode>();
        rootSNodes.add(sNode);
        return DataSourceAccessor.getOverlappedDataSourceSequence(documentGraph, rootSNodes, relationTypes);
    }

    public static List<DataSourceSequence> getOverlappedDataSourceSequence(SDocumentGraph documentGraph, List<SNode> nodes, SALT_TYPE ... relationTypes) {
        Traverser traverser = new Traverser();
        if (relationTypes != null && relationTypes.length != 0) {
            traverser.relationTypes2Traverse = new HashSet();
            Collections.addAll(traverser.relationTypes2Traverse, relationTypes);
            documentGraph.traverse(nodes, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, TRAVERSION_TYPE.OVERLAPPED_DS_SEQUENCES.toString(), traverser);
            return traverser.dataSourceSequences;
        }
        return new ArrayList<DataSourceSequence>();
    }

    public static List<SToken> getOverlappedSTokens(SDocumentGraph documentGraph, SNode overlappingNode, SALT_TYPE ... relationTypes) {
        Traverser traverser = new Traverser();
        traverser.overlappedSToken = new HashSet();
        traverser.relationTypes2Traverse = new HashSet();
        Collections.addAll(traverser.relationTypes2Traverse, relationTypes);
        ArrayList<SNode> rootNodes = new ArrayList<SNode>();
        rootNodes.add(overlappingNode);
        documentGraph.traverse(rootNodes, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, TRAVERSION_TYPE.OVERLAPPED_STOKEN.toString(), traverser);
        return new ArrayList<SToken>(traverser.overlappedSToken);
    }

    /*
     * WARNING - void declaration
     */
    public static List<SNode> getRootsByRelation(SDocumentGraph documentGraph, SALT_TYPE ... saltTypes) {
        void var6_8;
        LinkedHashSet retSet = new LinkedHashSet();
        ArrayList<SRelation<SSpan, SToken>> relations = new ArrayList<SRelation<SSpan, SToken>>();
        SALT_TYPE[] sALT_TYPEArray = saltTypes;
        int n = sALT_TYPEArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            SALT_TYPE saltType = sALT_TYPEArray[var6_8];
            if (SALT_TYPE.SSPANNING_RELATION.equals((Object)saltType)) {
                relations.addAll(documentGraph.getSpanningRelations());
            } else if (SALT_TYPE.SDOMINANCE_RELATION.equals((Object)saltType)) {
                relations.addAll(documentGraph.getDominanceRelations());
            } else if (SALT_TYPE.SPOINTING_RELATION.equals((Object)saltType)) {
                relations.addAll(documentGraph.getPointingRelations());
            } else if (SALT_TYPE.SORDER_RELATION.equals((Object)saltType)) {
                relations.addAll(documentGraph.getOrderRelations());
            } else if (SALT_TYPE.STEXTUAL_RELATION.equals((Object)saltType)) {
                relations.addAll(documentGraph.getTextualRelations());
            } else if (SALT_TYPE.STIMELINE_RELATION.equals((Object)saltType)) {
                relations.addAll(documentGraph.getTimelineRelations());
            } else if (SALT_TYPE.SMEDIAL_RELATION.equals((Object)saltType)) {
                relations.addAll(documentGraph.getMedialRelations());
            }
            ++var6_8;
        }
        HashSet notRootElements = new HashSet();
        for (SRelation sRelation : relations) {
            if (!notRootElements.contains(sRelation.getTarget())) {
                notRootElements.add(sRelation.getTarget());
            }
            if (!notRootElements.contains(sRelation.getSource()) && !retSet.contains(sRelation.getSource())) {
                retSet.add(sRelation.getSource());
            }
            if (!retSet.contains(sRelation.getTarget())) continue;
            retSet.remove(sRelation.getTarget());
        }
        ArrayList retVal = null;
        if (!retSet.isEmpty()) {
            retVal = new ArrayList(retSet);
        }
        return retVal;
    }

    public static Multimap<String, SNode> getRootsByRelationType(SDocumentGraph documentGraph, SALT_TYPE sType) {
        return DataSourceAccessor.getRootsByRelationType(documentGraph, sType.getJavaType());
    }

    public static Multimap<String, SNode> getRootsByRelationType(SDocumentGraph documentGraph, Class<? extends SRelation> clazz) {
        if (clazz == null) {
            throw new SaltParameterException("clazz", "getRootsBySRelationSType", null);
        }
        if (documentGraph == null) {
            throw new SaltParameterException("Cannot compute roots, because there is no SDocumentGraph set to traverse.");
        }
        Class<? extends SRelation> currRelationType = null;
        currRelationType = clazz;
        LinkedHashMultimap retVal = LinkedHashMultimap.create();
        List<SRelation> relations = documentGraph.getRelations(clazz);
        for (SRelation currentRel : relations) {
            if (currentRel.getSource() == null) {
                throw new SaltInvalidModelException("Cannot compute roots, because there is a SRelation object '" + currentRel.getId() + "' having no source node.");
            }
            boolean hasParent = false;
            for (SRelation parentRelation : documentGraph.getInRelations(((SNode)currentRel.getSource()).getId())) {
                if (!currRelationType.isInstance(parentRelation)) continue;
                if (currentRel.getType() == null) {
                    if (parentRelation.getType() == null) {
                        hasParent = true;
                    }
                } else if (currentRel.getType().equals(parentRelation.getType())) {
                    hasParent = true;
                }
                if (!hasParent) continue;
                break;
            }
            if (hasParent) continue;
            String type = currentRel.getType();
            if (type == null) {
                type = "salt::NULL";
            }
            retVal.put((Object)type, currentRel.getSource());
        }
        return retVal;
    }

    private static class Traverser
    implements GraphTraverseHandler {
        private Set<SALT_TYPE> relationTypes2Traverse = null;
        private List<DataSourceSequence> dataSourceSequences = null;
        private HashSet<SToken> overlappedSToken = null;
        private DataSourceSequence lastSeenDSSequence = null;

        @Override
        public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
            if (TRAVERSION_TYPE.OVERLAPPED_DS_SEQUENCES.equals((Object)TRAVERSION_TYPE.valueOf(traversalId))) {
                if (currNode instanceof SSequentialDS) {
                    SSequentialDS dataSource = (SSequentialDS)currNode;
                    DataSourceSequence sequence = null;
                    if (this.dataSourceSequences == null) {
                        this.dataSourceSequences = new ArrayList<DataSourceSequence>();
                    }
                    for (DataSourceSequence dsSequence : this.dataSourceSequences) {
                        if (!dsSequence.getDataSource().equals(dataSource)) continue;
                        sequence = dsSequence;
                        this.lastSeenDSSequence = dsSequence;
                        break;
                    }
                    if (sequence == null) {
                        sequence = new DataSourceSequence();
                        sequence.setDataSource(dataSource);
                        this.lastSeenDSSequence = sequence;
                        this.dataSourceSequences.add(sequence);
                    }
                }
            } else if (TRAVERSION_TYPE.OVERLAPPED_STOKEN.equals((Object)TRAVERSION_TYPE.valueOf(traversalId)) && currNode instanceof SToken) {
                this.overlappedSToken.add((SToken)currNode);
            }
        }

        @Override
        public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
            if (TRAVERSION_TYPE.OVERLAPPED_DS_SEQUENCES.equals((Object)TRAVERSION_TYPE.valueOf(traversalId)) && currNode instanceof SSequentialDS) {
                if (relation == null) {
                    this.lastSeenDSSequence.setDataSource((SSequentialDS)currNode);
                    this.lastSeenDSSequence.setStart(((SSequentialDS)currNode).getStart());
                    this.lastSeenDSSequence.setEnd(((SSequentialDS)currNode).getEnd());
                } else if (relation instanceof SSequentialRelation) {
                    SSequentialRelation seqRel = (SSequentialRelation)relation;
                    if (seqRel.getStart() == null) {
                        throw new SaltInvalidModelException("Cannot return overlapped DataSourceSequences, because the graph is inconsistent. The sStart value the SSequentialRelation '" + seqRel + "' is not set. ");
                    }
                    if (seqRel.getEnd() == null) {
                        throw new SaltInvalidModelException("Cannot return overlapped DataSourceSequences, because the graph is inconsistent. The sEnd value the SSequentialRelation '" + seqRel + "' is not set. ");
                    }
                    if (this.lastSeenDSSequence.getStart() == null || ((Number)seqRel.getStart()).doubleValue() < ((Number)this.lastSeenDSSequence.getStart()).doubleValue()) {
                        this.lastSeenDSSequence.setStart(seqRel.getStart());
                    }
                    if (this.lastSeenDSSequence.getEnd() == null || ((Number)seqRel.getEnd()).doubleValue() > ((Number)this.lastSeenDSSequence.getEnd()).doubleValue()) {
                        this.lastSeenDSSequence.setEnd(seqRel.getEnd());
                    }
                }
            }
        }

        @Override
        public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation<SNode, SNode> relation, SNode currNode, long order) {
            boolean retVal = false;
            if (TRAVERSION_TYPE.OVERLAPPED_DS_SEQUENCES.equals((Object)TRAVERSION_TYPE.valueOf(traversalId))) {
                if (relation != null) {
                    if ((this.relationTypes2Traverse.contains((Object)SALT_TYPE.STEXT_OVERLAPPING_RELATION) || this.relationTypes2Traverse.contains((Object)SALT_TYPE.SSEQUENTIAL_RELATION)) && relation instanceof STextOverlappingRelation) {
                        retVal = true;
                    } else if ((this.relationTypes2Traverse.contains((Object)SALT_TYPE.STIME_OVERLAPPING_RELATION) || this.relationTypes2Traverse.contains((Object)SALT_TYPE.SSEQUENTIAL_RELATION)) && relation instanceof STimeOverlappingRelation) {
                        retVal = true;
                    }
                } else {
                    retVal = true;
                }
            } else if (TRAVERSION_TYPE.OVERLAPPED_STOKEN.equals((Object)TRAVERSION_TYPE.valueOf(traversalId))) {
                if (relation != null) {
                    Set<SALT_TYPE> typeName = SALT_TYPE.class2SaltType(relation.getClass());
                    for (SALT_TYPE name : typeName) {
                        if (!this.relationTypes2Traverse.contains((Object)name)) continue;
                        return true;
                    }
                } else {
                    retVal = true;
                }
            }
            return retVal;
        }
    }

    public static enum TRAVERSION_TYPE {
        OVERLAPPED_DS_SEQUENCES,
        OVERLAPPED_STOKEN;

    }
}

