/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util;

import org.corpus_tools.salt.common.SSequentialDS;

public class DataSourceSequence<P extends Number> {
    protected P start = null;
    protected P end = null;
    protected SSequentialDS dataSource;

    public DataSourceSequence() {
    }

    public DataSourceSequence(SSequentialDS dataSource, P start, P end) {
        this.dataSource = dataSource;
        this.start = start;
        this.end = end;
    }

    public P getStart() {
        return this.start;
    }

    public void setStart(P start) {
        if (start != null) {
            if (start instanceof Integer) {
                if (((Number)start).intValue() < 0) {
                    start = null;
                }
            } else if (((Number)start).doubleValue() < 0.0) {
                start = null;
            }
        }
        this.start = start;
    }

    public P getEnd() {
        return this.end;
    }

    public void setEnd(P end) {
        if (end != null) {
            if (end instanceof Integer) {
                if (((Number)end).intValue() < 0) {
                    end = null;
                }
            } else if (((Number)end).doubleValue() < 0.0) {
                end = null;
            }
        }
        this.end = end;
    }

    public SSequentialDS getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(SSequentialDS dataSource) {
        this.dataSource = dataSource;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (");
        result.append(this.getDataSource().getId());
        result.append(this.getStart());
        result.append(", ");
        result.append(this.getEnd());
        result.append(')');
        return result.toString();
    }

    public static class Builder {
        public <P extends Number> Builder2<P> on(SSequentialDS<?, P> dataSource) {
            DataSourceSequence sequence = new DataSourceSequence();
            sequence.setDataSource(dataSource);
            return new Builder2(sequence);
        }

        public static class Builder2<P extends Number> {
            private final DataSourceSequence<P> sequence;

            public Builder2(DataSourceSequence<P> sequence) {
                this.sequence = sequence;
            }

            public Builder2<P> from(P start) {
                this.sequence.setStart(start);
                return this;
            }

            public Builder2<P> to(P end) {
                this.sequence.setEnd(end);
                return this;
            }

            public DataSourceSequence<P> build() {
                return this.sequence;
            }
        }
    }
}

