/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.exceptions.SaltInsertionException;
import org.corpus_tools.salt.exceptions.SaltParameterException;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.graph.impl.IdentifiableElementImpl;
import org.corpus_tools.salt.graph.impl.LayerImpl;
import org.corpus_tools.salt.graph.impl.NodeImpl;
import org.corpus_tools.salt.graph.impl.RelationImpl;
import org.corpus_tools.salt.index.IndexMgr;
import org.corpus_tools.salt.index.IndexMgrImpl;

public class GraphImpl<N extends Node, R extends Relation<N, N>, L extends Layer<N, R>>
extends IdentifiableElementImpl
implements Graph<N, R, L> {
    protected IndexMgr indexMgr = null;
    protected int expectedNodes = 16;
    protected int expectedRelations = 16;
    protected int approximatedNodeDegree = this.expectedRelations / this.expectedNodes;
    private List<N> nodes = null;
    private List<R> relations = null;
    private Set<L> layers = null;

    public GraphImpl(Graph<N, R, L> delegate) {
        super(delegate);
        this.init();
    }

    @Override
    protected Graph<N, R, L> getDelegate() {
        return (Graph)super.getDelegate();
    }

    public GraphImpl() {
        this.init();
    }

    @Override
    public IndexMgr getIndexMgr() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getIndexMgr();
        }
        return this.indexMgr;
    }

    public GraphImpl(int expectedNodes, int expectedRelations) {
        this.init();
        this.expectedNodes = expectedNodes;
        this.expectedRelations = expectedRelations;
        this.approximatedNodeDegree = expectedRelations / expectedNodes;
    }

    protected void init() {
        this.layers = Collections.synchronizedSet(new HashSet());
        this.nodes = Collections.synchronizedList(new ArrayList(this.expectedNodes));
        this.relations = Collections.synchronizedList(new ArrayList(this.expectedNodes));
        this.indexMgr = new IndexMgrImpl();
        this.indexMgr.createIndex("idx_id_nodes", String.class, Node.class, this.expectedNodes, this.expectedNodes);
        this.indexMgr.createIndex("idx_id_nodes_inverse", Node.class, String.class, this.expectedNodes, this.expectedNodes);
        this.indexMgr.createIndex("idx_id_relation", String.class, Relation.class, this.expectedRelations, this.expectedRelations);
        this.indexMgr.createIndex("idx_id_relation_inverse", Relation.class, String.class, this.expectedRelations, this.expectedRelations);
        this.indexMgr.createIndex("idx_id_layer", String.class, Layer.class);
        this.indexMgr.createIndex("idx_out_relations", String.class, Relation.class, this.expectedNodes, this.approximatedNodeDegree);
        this.indexMgr.createIndex("idx_in_relations", String.class, Relation.class, this.expectedNodes, this.approximatedNodeDegree);
    }

    @Override
    public List<N> getNodes() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getNodes();
        }
        return Collections.unmodifiableList(this.nodes);
    }

    @Override
    public N getNode(String nodeId) {
        if (this.getDelegate() != null) {
            return this.getDelegate().getNode(nodeId);
        }
        if (nodeId == null) {
            return null;
        }
        return (N)((Node)this.getIndexMgr().get("idx_id_nodes", nodeId));
    }

    @Override
    public void addNode(N node) {
        if (this.getDelegate() != null) {
            this.getDelegate().addNode(node);
            if (node instanceof NodeImpl) {
                ((NodeImpl)node).basicSetGraph_WithoutRemoving(this);
            }
            return;
        }
        if (this.getIndexMgr().containsKey("idx_id_nodes_inverse", node)) {
            return;
        }
        this.basicAddNode(node);
        if (node != null && node instanceof NodeImpl) {
            ((NodeImpl)node).basicSetGraph(this);
        }
    }

    protected void basicAddNode(N node) {
        if (node == null) {
            throw new SaltParameterException("node", "basicAddNode", GraphImpl.class, "A null value is not allowed. ");
        }
        if (this.getIndexMgr().containsKey("idx_id_nodes_inverse", node)) {
            return;
        }
        if (node.getId() == null) {
            node.setId("n" + this.getNodes().size());
        }
        int i = 0;
        String idBase = node.getId();
        while (this.getNode(node.getId()) != null) {
            node.setId(idBase + "_" + (this.getNodes().size() + i));
            ++i;
        }
        this.nodes.add(node);
        this.getIndexMgr().put("idx_id_nodes", node.getId(), node);
        this.getIndexMgr().put("idx_id_nodes_inverse", node, node.getId());
    }

    @Override
    public void removeNode(N node) {
        if (this.getDelegate() != null) {
            this.getDelegate().removeNode(node);
            if (node instanceof NodeImpl) {
                ((NodeImpl)node).basicSetGraph_WithoutRemoving(null);
            }
            return;
        }
        if (node != null) {
            if (node instanceof NodeImpl) {
                ((NodeImpl)node).basicSetGraph(null);
            }
            this.basicRemoveNode(node);
        }
    }

    protected void basicRemoveNode(N node) {
        this.nodes.remove(node);
        this.getIndexMgr().remove("idx_id_nodes_inverse", node);
        this.getIndexMgr().removeValue(node);
        ArrayList<R> rels = new ArrayList<R>(this.getInRelations(node.getId()));
        for (Relation r : rels) {
            this.removeRelation(r);
        }
        rels = new ArrayList<R>(this.getOutRelations(node.getId()));
        for (Relation r : rels) {
            this.removeRelation(r);
        }
        for (Layer layer : this.layers) {
            layer.removeNode(node);
        }
    }

    @Override
    public boolean containsNode(String nodeId) {
        if (this.getDelegate() != null) {
            return this.getDelegate().containsNode(nodeId);
        }
        if (nodeId == null) {
            return false;
        }
        return this.getIndexMgr().containsKey("idx_id_nodes", nodeId);
    }

    @Override
    public List<R> getRelations() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getRelations();
        }
        return Collections.unmodifiableList(this.relations);
    }

    @Override
    public R getRelation(String relationId) {
        if (this.getDelegate() != null) {
            return this.getDelegate().getRelation(relationId);
        }
        if (relationId == null) {
            return null;
        }
        return (R)((Relation)this.getIndexMgr().get("idx_id_relation", relationId));
    }

    @Override
    public List<R> getRelations(String sourceNodeId, String targetNodeId) {
        if (this.getDelegate() != null) {
            return this.getDelegate().getRelations(sourceNodeId, targetNodeId);
        }
        ArrayList<Relation> retList = new ArrayList<Relation>();
        List<R> outRelations = this.getOutRelations(sourceNodeId);
        if (outRelations != null) {
            for (Relation relation : outRelations) {
                if (!relation.getTarget().getId().equals(targetNodeId)) continue;
                retList.add(relation);
            }
        }
        return retList;
    }

    @Override
    public List<R> getInRelations(String nodeId) {
        if (this.getDelegate() != null) {
            return this.getDelegate().getInRelations(nodeId);
        }
        return this.getIndexMgr().getAll("idx_in_relations", nodeId);
    }

    @Override
    public List<R> getOutRelations(String nodeId) {
        if (this.getDelegate() != null) {
            return this.getDelegate().getOutRelations(nodeId);
        }
        return this.getIndexMgr().getAll("idx_out_relations", nodeId);
    }

    @Override
    public void addRelation(Relation<? extends N, ? extends N> relation) {
        if (this.getDelegate() != null) {
            this.getDelegate().addRelation(relation);
            if (relation instanceof RelationImpl) {
                ((RelationImpl)relation).basicSetGraph_WithoutRemoving(this);
            }
            return;
        }
        if (this.getIndexMgr().containsKey("idx_id_relation_inverse", relation)) {
            return;
        }
        this.basicAddRelation(relation);
        if (relation != null && relation instanceof RelationImpl) {
            ((RelationImpl)relation).basicSetGraph(this);
        }
    }

    protected void basicAddRelation(Relation<? extends Node, ? extends Node> relation) {
        if (this.getDelegate() != null) {
            if (this.getDelegate() instanceof GraphImpl) {
                ((GraphImpl)this.getDelegate()).basicAddRelation(relation);
            }
            return;
        }
        if (relation == null) {
            throw new SaltParameterException("relation", "basicAddRelation", GraphImpl.class, "A null value is not allowed. ");
        }
        if (relation.getSource() == null) {
            throw new SaltInsertionException(this, relation, "The source node is empty. ");
        }
        if (relation.getTarget() == null) {
            throw new SaltInsertionException(this, relation, "The target node is empty. ");
        }
        if (relation.getSource().getId() == null || !this.containsNode(relation.getSource().getId())) {
            throw new SaltInsertionException(this, relation, "The source node of the passed relation does not belong to this graph. ");
        }
        if (relation.getTarget().getId() == null || !this.containsNode(relation.getTarget().getId())) {
            throw new SaltInsertionException(this, relation, "The target node of the passed relation does not belong to this graph. ");
        }
        if (this.getIndexMgr().containsKey("idx_id_relation_inverse", relation)) {
            return;
        }
        if (relation.getId() == null) {
            relation.setId("r" + this.getRelations().size());
        }
        int i = 0;
        String idBase = relation.getId();
        while (this.getRelation(relation.getId()) != null) {
            relation.setId(idBase + "_" + (this.getRelations().size() + i));
            ++i;
        }
        this.relations.add(relation);
        this.getIndexMgr().put("idx_id_relation", relation.getId(), relation);
        this.getIndexMgr().put("idx_id_relation_inverse", relation, relation.getId());
        this.update(null, relation, UPDATE_TYPE.RELATION_SOURCE);
        this.update(null, relation, UPDATE_TYPE.RELATION_TARGET);
    }

    protected void update(Object oldValue, Object container, UPDATE_TYPE updateType) throws SaltException {
        if (this.getDelegate() != null && this.getDelegate() instanceof GraphImpl) {
            ((GraphImpl)this.getDelegate()).update(oldValue, container, updateType);
            return;
        }
        if (UPDATE_TYPE.RELATION_SOURCE.equals((Object)updateType)) {
            if (container instanceof Relation) {
                Relation relation = (Relation)container;
                this.getIndexMgr().put("idx_out_relations", relation.getSource().getId(), relation);
                if (oldValue != null && oldValue instanceof Node) {
                    Node node = (Node)oldValue;
                    this.getIndexMgr().remove("idx_out_relations", node.getId(), relation);
                }
            }
        } else if (UPDATE_TYPE.RELATION_TARGET.equals((Object)updateType) && container instanceof Relation) {
            Relation relation = (Relation)container;
            this.getIndexMgr().put("idx_in_relations", relation.getTarget().getId(), relation);
            if (oldValue != null && oldValue instanceof Node) {
                Node node = (Node)oldValue;
                this.getIndexMgr().remove("idx_in_relations", node.getId(), relation);
            }
        }
    }

    @Override
    public void removeRelation(Relation<? extends N, ? extends N> rel) {
        if (this.getDelegate() != null) {
            this.getDelegate().removeRelation(rel);
            return;
        }
        if (rel != null) {
            if (rel instanceof RelationImpl) {
                ((RelationImpl)rel).basicSetGraph(null);
            }
            this.basicRemoveRelation(rel);
        }
    }

    @Override
    public void removeRelations() {
        if (this.getDelegate() != null) {
            this.getDelegate().removeRelations();
            return;
        }
        this.relations.clear();
        this.getIndexMgr().clearIndex("idx_id_relation");
        this.getIndexMgr().clearIndex("idx_id_relation_inverse");
        this.getIndexMgr().clearIndex("idx_in_relations");
        this.getIndexMgr().clearIndex("idx_out_relations");
    }

    protected void basicRemoveRelation(Relation<? extends N, ? extends N> rel) {
        this.getIndexMgr().removeValue(rel);
        this.getIndexMgr().remove("idx_id_relation_inverse", rel);
        for (Layer layer : this.layers) {
            layer.removeRelation(rel);
        }
        this.relations.remove(rel);
    }

    @Override
    public boolean containsRelation(String relationId) {
        if (this.getDelegate() != null) {
            return this.getDelegate().containsRelation(relationId);
        }
        if (relationId == null) {
            return false;
        }
        return this.getIndexMgr().containsKey("idx_id_relation", relationId);
    }

    @Override
    public Set<L> getLayers() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getLayers();
        }
        return Collections.unmodifiableSet(this.layers);
    }

    @Override
    public L getLayer(String layerId) {
        if (this.getDelegate() != null) {
            return this.getDelegate().getLayer(layerId);
        }
        if (layerId == null) {
            return null;
        }
        return (L)((Layer)this.getIndexMgr().get("idx_id_layer", layerId));
    }

    @Override
    public boolean containsLayer(String layerId) {
        if (this.getDelegate() != null) {
            return this.getDelegate().containsLayer(layerId);
        }
        return this.getIndexMgr().containsKey("idx_id_layer", layerId);
    }

    @Override
    public void addLayer(L layer) {
        if (this.getDelegate() != null) {
            this.getDelegate().addLayer(layer);
            if (layer instanceof LayerImpl) {
                ((LayerImpl)layer).basicSetGraph_WithoutRemoving(this);
            }
            return;
        }
        if (layer != null && !this.layers.contains(layer)) {
            this.basicAddLayer(layer);
            if (layer instanceof LayerImpl) {
                ((LayerImpl)layer).basicSetGraph(this);
            }
            for (Node node : layer.getNodes()) {
                if (this.containsNode(node.getId())) continue;
                this.addNode(node);
            }
            for (Relation rel : layer.getRelations()) {
                if (this.containsRelation(rel.getId())) continue;
                this.addRelation(rel);
            }
        }
    }

    protected void basicAddLayer(L layer) {
        if (layer != null && !this.layers.contains(layer)) {
            if (layer.getId() == null) {
                layer.setId("l" + this.getLayers().size());
            }
            int i = 0;
            String idBase = layer.getId();
            while (this.getLayer(layer.getId()) != null) {
                layer.setId(idBase + "_" + (this.getLayers().size() + i));
                ++i;
            }
            this.layers.add(layer);
            this.getIndexMgr().put("idx_id_layer", layer.getId(), layer);
        }
    }

    @Override
    public void removeLayer(L layer) {
        if (this.getDelegate() != null) {
            this.getDelegate().removeLayer(layer);
            return;
        }
        if (layer instanceof LayerImpl) {
            ((LayerImpl)layer).basicSetGraph(null);
        }
        this.basicRemoveLayer(layer);
    }

    protected void basicRemoveLayer(L layer) {
        if (layer != null && this.layers.contains(layer)) {
            this.layers.remove(layer);
            this.getIndexMgr().removeValue(layer);
        }
    }

    static enum UPDATE_TYPE {
        RELATION_TARGET,
        RELATION_SOURCE;

    }
}

