/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepperModules_CoNLLCorefModules;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.pepperModules_CoNLLCorefModules.CoNLLCorefExporterProperties;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Salt2CoNLLCorefMapper
extends PepperMapperImpl {
    private static final String ERR_MSG_NO_DOCUMENT = "No document to convert.";
    private static final String ERR_MSG_EMPTY_DOCUMENT = "Document is empty.";
    private String nodeLayer = "";
    private String edgeTypePattern = "";
    private String edgeAnnoNamePattern = "";
    private String edgeAnnoValuePattern = "";
    private String outputAnno = "";
    private String outputSuffAnno = "";
    private boolean removeSingletons = false;
    private boolean removeEmptyTokens = false;
    private HashMap<SNode, String> nodesToGroups = null;
    private HashMap<String, List<SNode>> groupsToNodes = null;
    private HashMap<SToken, List<SNode>> startMap = null;
    private HashMap<SToken, List<SNode>> endMap = null;
    private int groupCounter;
    private int maxSeqID;
    private HashMap<String, String> groupsToSeqIDs = null;
    private SDocumentGraph docGraph = null;
    private static final Logger logger = LoggerFactory.getLogger(Salt2CoNLLCorefMapper.class);
    public StringBuilder stbOutput = new StringBuilder();

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument() == null) {
            throw new PepperModuleDataException((PepperMapper)this, ERR_MSG_NO_DOCUMENT);
        }
        this.docGraph = this.getDocument().getDocumentGraph();
        if (this.docGraph == null) {
            throw new PepperModuleDataException((PepperMapper)this, ERR_MSG_EMPTY_DOCUMENT);
        }
        this.readProperties();
        this.nodesToGroups = new HashMap();
        this.groupsToSeqIDs = new HashMap();
        this.groupsToNodes = new HashMap();
        this.startMap = new HashMap();
        this.endMap = new HashMap();
        List pointingRels = this.docGraph.getPointingRelations();
        for (Object rel : pointingRels) {
            String edgeType;
            SLayer layer;
            SNode src = (SNode)rel.getSource();
            SNode trg = (SNode)rel.getTarget();
            Iterator srcLayers = src.getLayers().iterator();
            Iterator trgLayers = src.getLayers().iterator();
            boolean srcOK = false;
            boolean trgOK = false;
            if (src.getLayers().isEmpty() && this.nodeLayer == "") {
                srcOK = true;
            } else {
                while (srcLayers.hasNext()) {
                    layer = (SLayer)srcLayers.next();
                    if (!layer.getName().matches(this.nodeLayer)) continue;
                    srcOK = true;
                }
            }
            if (trg.getLayers().isEmpty() && this.nodeLayer == "") {
                trgOK = true;
            } else {
                while (trgLayers.hasNext()) {
                    layer = (SLayer)trgLayers.next();
                    if (!layer.getName().matches(this.nodeLayer)) continue;
                    trgOK = true;
                }
            }
            if (!srcOK || !trgOK || !(edgeType = rel.getType()).matches(this.edgeTypePattern)) continue;
            if (this.edgeAnnoNamePattern == "") {
                this.addNodePair(src, trg);
                continue;
            }
            for (SAnnotation anno : rel.getAnnotations()) {
                if (!anno.getName().matches(this.edgeAnnoNamePattern) || !anno.getValue_STEXT().matches(this.edgeAnnoValuePattern)) continue;
                this.addNodePair(src, trg);
            }
        }
        List spans = this.docGraph.getSpans();
        for (SNode span : spans) {
            Iterator layers = span.getLayers().iterator();
            boolean spanOK = false;
            if (span.getLayers().isEmpty() && this.nodeLayer == "") {
                spanOK = true;
            } else {
                while (layers.hasNext()) {
                    SLayer layer = (SLayer)layers.next();
                    if (!layer.getName().matches(this.nodeLayer)) continue;
                    spanOK = true;
                }
            }
            if (!spanOK || this.removeSingletons) continue;
            this.addSingleNode(span);
        }
        String docName = this.getDocument().getName();
        this.stbOutput.append("# begin document " + docName + "\n");
        int i = -1;
        for (SToken out_tok : this.getDocument().getDocumentGraph().getSortedTokenByText()) {
            if (this.docGraph.getText((SNode)out_tok).trim().equals("") && this.removeEmptyTokens) continue;
            String coref_col = "";
            String line = Integer.toString(++i) + "\t" + this.docGraph.getText((SNode)out_tok) + "\t";
            if (this.startMap.containsKey(out_tok)) {
                for (SNode out_mark : this.startMap.get(out_tok)) {
                    coref_col = coref_col + "(" + this.getSeqID(out_mark);
                    if (!this.endMap.containsKey(out_tok) || !this.endMap.get(out_tok).contains(out_mark)) continue;
                    coref_col = coref_col + ")";
                    this.endMap.get(out_tok).remove(out_mark);
                }
            }
            if (this.endMap.containsKey(out_tok)) {
                for (SNode out_mark : this.endMap.get(out_tok)) {
                    if (this.startMap.containsKey(out_tok)) {
                        if (this.startMap.get(out_tok).contains(out_mark)) {
                            coref_col = coref_col + ")";
                            continue;
                        }
                        if (coref_col.length() > 0 && Character.isDigit(coref_col.charAt(coref_col.length() - 1))) {
                            coref_col = coref_col + "|";
                        }
                        coref_col = coref_col + this.getSeqID(out_mark) + ")";
                        continue;
                    }
                    if (coref_col.length() > 0 && Character.isDigit(coref_col.charAt(coref_col.length() - 1))) {
                        coref_col = coref_col + "|";
                    }
                    coref_col = coref_col + this.getSeqID(out_mark) + ")";
                }
            }
            if (!this.startMap.containsKey(out_tok) && !this.endMap.containsKey(out_tok)) {
                coref_col = "_";
            }
            line = line + coref_col + "\n";
            this.stbOutput.append(line);
        }
        this.stbOutput.append("# end document\n\n");
        File outputFile = this.getResourceURI().toFileString() != null ? new File(this.getResourceURI().toFileString()) : new File(this.getResourceURI().toString());
        if (!outputFile.isDirectory() && !outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        FileWriter flwTemp = null;
        try {
            flwTemp = new FileWriter(outputFile);
            flwTemp.write(this.stbOutput.toString());
            flwTemp.flush();
        }
        catch (IOException e) {
            throw new PepperModuleException((PepperMapper)this, "Unable to write output file for ConllCoref export '" + this.getResourceURI() + "'.", (Throwable)e);
        }
        finally {
            try {
                if (flwTemp != null) {
                    flwTemp.close();
                }
            }
            catch (IOException e) {
                throw new PepperModuleException((PepperMapper)this, "Unable to close output file writer for ConllCoref export '" + this.getResourceURI() + "'.", (Throwable)e);
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    private void readProperties() {
        CoNLLCorefExporterProperties properties = (CoNLLCorefExporterProperties)this.getProperties();
        this.nodeLayer = properties.getNodeLayer();
        this.edgeTypePattern = properties.getEdgeType();
        this.outputAnno = properties.getOutputAnno();
        this.outputSuffAnno = properties.getOutputSuffAnno();
        String annoKeyVal = properties.getEdgeAnno();
        if (annoKeyVal.contains("=")) {
            this.edgeAnnoNamePattern = annoKeyVal.split("=")[0];
            this.edgeAnnoValuePattern = annoKeyVal.split("=")[1];
        }
        this.removeSingletons = properties.getRemoveSingletons();
        this.removeEmptyTokens = properties.getRemoveEmptyTokens();
    }

    /*
     * WARNING - void declaration
     */
    private void addNodePair(SNode src, SNode trg) {
        String group;
        HashMap<String, SNode> NodesToAdd = new HashMap<String, SNode>();
        HashMap<String, SNode> NodesToRemove = new HashMap<String, SNode>();
        if (this.nodesToGroups.containsKey(src)) {
            group = this.nodesToGroups.get(src);
            if (this.nodesToGroups.containsKey(trg)) {
                SNode nd;
                String grp;
                String oldGroup = this.nodesToGroups.get(trg);
                for (SNode sNode : this.groupsToNodes.get(oldGroup)) {
                    this.nodesToGroups.put(sNode, group);
                    NodesToAdd.put(group, sNode);
                    NodesToRemove.put(oldGroup, sNode);
                }
                for (Map.Entry entry : NodesToAdd.entrySet()) {
                    grp = (String)entry.getKey();
                    nd = (SNode)entry.getValue();
                    this.groupsToNodes.get(grp).add(nd);
                }
                for (Map.Entry entry : NodesToRemove.entrySet()) {
                    grp = (String)entry.getKey();
                    nd = (SNode)entry.getValue();
                    this.groupsToNodes.get(grp).remove(nd);
                }
            }
        } else if (this.nodesToGroups.containsKey(trg)) {
            group = this.nodesToGroups.get(trg);
        } else {
            void var8_16;
            ++this.groupCounter;
            group = Integer.toString(this.groupCounter);
            String annoPrefix = this.getAnnoPrefix(src);
            String string = this.getAnnoSuffix(src);
            if (annoPrefix.length() == 0) {
                annoPrefix = this.getAnnoPrefix(trg);
            }
            if (string.length() == 0) {
                String string2 = this.getAnnoSuffix(trg);
            }
            group = annoPrefix + group + (String)var8_16;
        }
        this.nodesToGroups.put(src, group);
        this.nodesToGroups.put(trg, group);
        if (!this.groupsToNodes.containsKey(group)) {
            this.groupsToNodes.put(group, new ArrayList());
        }
        this.groupsToNodes.get(group).add(src);
        this.groupsToNodes.get(group).add(trg);
        if (this.removeSingletons) {
            this.addNodeStartEnd(src);
            this.addNodeStartEnd(trg);
        }
    }

    private String getAnnoPrefix(SNode span) {
        String val = "";
        if (this.outputAnno.length() > 0) {
            Set annos = span.getAnnotations();
            for (SAnnotation anno : annos) {
                if (!anno.getName().equals(this.outputAnno)) continue;
                val = anno.getValue_STEXT();
                break;
            }
            if (val.length() > 0) {
                val = val + "-";
            }
        }
        return val;
    }

    private String getAnnoSuffix(SNode span) {
        String val = "";
        if (this.outputSuffAnno.length() > 0) {
            Set annos = span.getAnnotations();
            for (SAnnotation anno : annos) {
                if (!anno.getName().equals(this.outputSuffAnno)) continue;
                val = anno.getValue_STEXT();
                break;
            }
            if (val.length() > 0) {
                val = "-" + val;
            }
        }
        return val;
    }

    private void addSingleNode(SNode span) {
        if (!this.nodesToGroups.containsKey(span)) {
            ++this.groupCounter;
            String group = Integer.toString(this.groupCounter);
            group = this.getAnnoPrefix(span) + group + this.getAnnoSuffix(span);
            this.nodesToGroups.put(span, group);
        }
        this.addNodeStartEnd(span);
    }

    private void addNodeStartEnd(SNode span) {
        List<SToken> borders = this.getBorders(span);
        if (borders != null) {
            ArrayList<SNode> nodeList;
            SToken firstTok = borders.get(0);
            SToken lastTok = borders.get(1);
            if (!this.startMap.containsKey(firstTok)) {
                nodeList = new ArrayList<SNode>();
                nodeList.add(span);
                this.startMap.put(firstTok, nodeList);
            } else if (!this.startMap.get(firstTok).contains(span)) {
                this.startMap.get(firstTok).add(span);
            }
            if (!this.endMap.containsKey(lastTok)) {
                nodeList = new ArrayList();
                nodeList.add(span);
                this.endMap.put(lastTok, nodeList);
            } else if (!this.endMap.get(lastTok).contains(span)) {
                this.endMap.get(lastTok).add(span);
            }
        } else {
            throw new PepperModuleException("Found node without start and end tokens: " + span);
        }
    }

    private List<SToken> getBorders(SNode span) {
        ArrayList<SToken> borderTokens = new ArrayList<SToken>();
        List tokens = this.getDocument().getDocumentGraph().getSortedTokenByText(this.getDocument().getDocumentGraph().getOverlappedTokens(span));
        if (!tokens.isEmpty()) {
            borderTokens.add((SToken)tokens.get(0));
            borderTokens.add((SToken)tokens.get(tokens.size() - 1));
        }
        return borderTokens;
    }

    private String getSeqID(SNode markable) {
        String temp_group = this.nodesToGroups.get(markable);
        String annoPrefix = this.getAnnoPrefix(markable);
        String annoSuffix = this.getAnnoSuffix(markable);
        if (!this.groupsToSeqIDs.containsKey(temp_group)) {
            ++this.maxSeqID;
            this.groupsToSeqIDs.put(temp_group, annoPrefix + Integer.toString(this.maxSeqID) + annoSuffix);
        }
        return this.groupsToSeqIDs.get(temp_group);
    }
}

