/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.conll.tupleconnector.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleWriter;
import org.corpus_tools.peppermodules.conll.tupleconnector.exceptions.TupleWriterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleWriterImpl
implements TupleWriter {
    private Logger logger = LoggerFactory.getLogger(TupleWriterImpl.class);
    private final Lock writerLock = new ReentrantLock();
    private String encoding = "UTF-8";
    private String sperator = "\t";
    private boolean escapeCharacters = false;
    private Hashtable<Character, String> charEscapeTable;
    private File outFile = null;
    private Collection<String> attNames = null;
    private PrintStream oStream = null;
    private volatile Long TAId = 0L;
    private volatile Map<Long, Collection<Collection<String>>> tupleMap = Collections.synchronizedMap(new HashMap());
    private Boolean distinct = false;

    public TupleWriterImpl() {
        this.charEscapeTable = new Hashtable();
        this.charEscapeTable.put(Character.valueOf('\t'), "TAB");
        this.charEscapeTable.put(Character.valueOf('\n'), "NEWLINE");
        this.charEscapeTable.put(Character.valueOf('\r'), "RETURN");
        this.charEscapeTable.put(Character.valueOf('\\'), "\\\\");
        this.charEscapeTable.put(Character.valueOf('\''), "\\'");
    }

    @Override
    public void addTuple(Collection<String> tuple) throws FileNotFoundException {
        Long taId = this.beginTA();
        this.addTuple(taId, tuple);
        this.commitTA(taId);
    }

    private synchronized Long getNewTAId() {
        long currTAId = this.TAId;
        Long l = this.TAId;
        Long l2 = this.TAId = Long.valueOf(this.TAId + 1L);
        return currTAId;
    }

    @Override
    public long beginTA() {
        if (this.logger != null) {
            this.logger.debug("begin ta of TupleWriter '" + this.getFile() + "' with id: " + this.TAId);
        }
        Long taId = this.getNewTAId();
        this.tupleMap.put(taId, new Vector());
        return taId;
    }

    @Override
    public void addTuple(Long TAId, Collection<String> tuple) throws FileNotFoundException {
        Collection<Collection<String>> taIdSlot = this.tupleMap.get(TAId);
        if (taIdSlot == null) {
            taIdSlot = new Vector<Collection<String>>();
        }
        if (!this.distinct.booleanValue()) {
            taIdSlot.add(tuple);
        } else {
            Object[] tupleArray = tuple.toArray();
            Boolean tupleExists = false;
            for (Collection<String> existingTuple : taIdSlot) {
                Object[] existingTupleArray = existingTuple.toArray();
                tupleExists = true;
                for (int i = 0; i < existingTupleArray.length - 1; ++i) {
                    if (existingTupleArray.length != tupleArray.length) {
                        throw new TupleWriterException("The given tuple has not the expected number of entries.");
                    }
                    if (existingTupleArray[i] == null && tupleArray[i] == null || !(existingTupleArray[i] == null && tupleArray[i] != null || existingTupleArray[i] != null && tupleArray[i] == null) && existingTupleArray[i].equals(tupleArray[i])) continue;
                    tupleExists = false;
                    break;
                }
                if (!tupleExists.booleanValue()) continue;
                break;
            }
            if (!tupleExists.booleanValue()) {
                taIdSlot.add(tuple);
            }
        }
    }

    @Override
    public void commitTA(Long TAId) throws FileNotFoundException {
        if (TAId == null) {
            throw new TupleWriterException("Cannot commit an empty transaction id for TupleWriter controlling file '" + this.getFile() + "'.");
        }
        if (this.logger != null) {
            this.logger.debug("commiting ta of TupleWriter '" + this.getFile() + "' with id: " + TAId);
        }
        if (this.tupleMap.containsKey(TAId)) {
            this.flush(TAId);
        }
    }

    @Override
    public void abortTA(Long TAId) {
        if (this.logger != null) {
            this.logger.debug("aborting ta with id: " + TAId);
        }
        this.tupleMap.remove(TAId);
    }

    private void flush(Long TAId) throws FileNotFoundException {
        if (this.logger != null) {
            this.logger.debug("flushing all tuples of tupleWriter '" + this.getFile().getName() + "' which belong to TA with id: " + TAId);
        }
        if (this.outFile == null) {
            throw new FileNotFoundException("Error(TupleWriter): The datasource is empty.");
        }
        try {
            this.writerLock.lock();
            StringBuffer tuples = new StringBuffer();
            Collection<Collection<String>> printableTuples = this.tupleMap.get(TAId);
            for (Collection<String> tuple : printableTuples) {
                int i = 0;
                for (String att : tuple) {
                    if (this.escapeCharacters && att != null) {
                        StringBuffer escaped = new StringBuffer();
                        for (char chr : att.toCharArray()) {
                            String escapeString = this.charEscapeTable.get(Character.valueOf(chr));
                            if (escapeString != null) {
                                escaped.append(escapeString);
                                continue;
                            }
                            escaped.append(chr);
                        }
                        tuples.append(escaped.toString());
                    } else {
                        tuples.append(att);
                    }
                    if (++i >= tuple.size()) continue;
                    tuples.append(this.getSeperator());
                }
                tuples.append("\n");
            }
            if (this.oStream == null) {
                this.oStream = new PrintStream((OutputStream)new FileOutputStream(this.outFile), true, this.encoding);
            }
            this.oStream.print(tuples.toString());
            this.oStream.flush();
            this.tupleMap.remove(TAId);
        }
        catch (RuntimeException e) {
            throw new TupleWriterException("Cannot commit ta, because writing to file does not worked. ", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new TupleWriterException("Cannot commit ta, because writing to file does not worked. ", e);
        }
        finally {
            this.writerLock.unlock();
        }
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setEscaping(boolean escape) {
        this.escapeCharacters = escape;
    }

    @Override
    public void setEscapeTable(Hashtable<Character, String> escapeTable) {
        if (escapeTable == null) {
            throw new TupleWriterException("Error(TupleWriter): The given escape table object is null.");
        }
        this.charEscapeTable = escapeTable;
    }

    @Override
    public Hashtable<Character, String> getEscapeTable() {
        return this.charEscapeTable;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setFile(File out) {
        if (out == null) {
            throw new TupleWriterException("Error(TupleWriter): an empty file-object is given.");
        }
        if (out.getParent() == null) {
            throw new TupleWriterException("Cannot set the given file, because it has no parent folder: " + out + ".");
        }
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        this.outFile = out;
    }

    @Override
    public File getFile() {
        return this.outFile;
    }

    @Override
    public void setAttNames(Collection<String> attNames) {
        if (attNames == null) {
            throw new TupleWriterException("ERROR(TupleWriter): The given collection with attribute names is empty.");
        }
        this.attNames = attNames;
    }

    @Override
    public Collection<String> getAttNames() {
        return this.attNames;
    }

    @Override
    public void setSeperator(String seperator) {
        this.sperator = seperator;
    }

    @Override
    public String getSeperator() {
        return this.sperator;
    }

    public void finalize() {
        if (this.tupleMap != null && this.tupleMap.size() != 0 && this.logger != null) {
            this.logger.warn("Warning(TupleWriter): Not all TAs are comitted or aborted. There remains " + this.tupleMap.size() + " TAs.");
        }
        this.oStream.close();
    }

    @Override
    public Boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void setDistinct(Boolean distinct) {
        if (distinct != null) {
            this.distinct = distinct;
        }
    }
}

