/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.conll.tupleconnector.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleReader;

public class TupleReaderImpl
implements TupleReader {
    private File inFile = null;
    private String seperator = "\t";
    private String encoding = null;
    private static final Character utf8BOM = new Character('\ufeff');
    Collection<Collection<String>> tuples = null;
    int tuplePtr = 0;
    private Integer charCount = 0;
    private ArrayList<Integer> charCountList = new ArrayList();

    @Override
    public void setFile(File inFile) {
        if (inFile == null) {
            throw new NullPointerException("Error(TupleReader): the given file-object is empty.");
        }
        if (!inFile.exists()) {
            throw new NullPointerException("Error(TupleReader): the given file does not exist: " + inFile + ".");
        }
        if (!inFile.isFile()) {
            throw new NullPointerException("Error(TupleReader): the given file-object is not a file: " + inFile + ".");
        }
        this.inFile = inFile;
    }

    @Override
    public File getFile() {
        return this.inFile;
    }

    @Override
    public void setSeperator(String seperator) {
        if (seperator == null || seperator.equals("")) {
            throw new NullPointerException("Error(TupleReader): the given seperator is empty.");
        }
        this.seperator = seperator;
    }

    @Override
    public String getSeperator() {
        return this.seperator;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void readFile() throws IOException {
        if (this.inFile == null) {
            throw new NullPointerException("Error(TupleReader): Cannot read from empty file.");
        }
        BufferedReader inReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.inFile), "UTF8"));
        Vector<String> atts = null;
        String input = "";
        this.tuples = new Vector<Collection<String>>();
        Integer fieldIndex = 0;
        this.charCount = 0;
        this.charCountList.clear();
        int fileLineCount = 0;
        while ((input = inReader.readLine()) != null) {
            if (++fileLineCount == 1 && input.startsWith(utf8BOM.toString())) {
                input = input.substring(utf8BOM.toString().length());
            }
            atts = new Vector<String>();
            if (input == null) continue;
            String[] attStr = input.split(this.seperator);
            fieldIndex = 0;
            for (String att : attStr) {
                atts.add(att);
                try {
                    this.charCountList.set(fieldIndex, this.charCountList.get(fieldIndex) + att.length());
                }
                catch (IndexOutOfBoundsException e) {
                    this.charCountList.add(att.length());
                }
                this.charCount = this.charCount + att.length();
                Integer n = fieldIndex;
                Integer n2 = fieldIndex = Integer.valueOf(fieldIndex + 1);
            }
            this.tuples.add(atts);
        }
        inReader.close();
    }

    @Override
    public Collection<String> getTuple() throws IOException {
        if (this.tuples == null) {
            this.readFile();
        }
        if (this.tuplePtr >= this.tuples.size()) {
            return null;
        }
        Collection tuple = (Collection)((Vector)this.tuples).get(this.tuplePtr);
        ++this.tuplePtr;
        return tuple;
    }

    @Override
    public Integer getNumOfTuples() {
        Integer retVal = 0;
        if (this.tuples != null) {
            retVal = this.tuples.size();
        }
        return retVal;
    }

    @Override
    public Collection<Collection<String>> getTuples() {
        return this.tuples;
    }

    @Override
    public Collection<String> getTuple(Integer index) throws IOException {
        Collection tuple = null;
        if (this.tuples != null) {
            tuple = (Collection)((Vector)this.tuples).get(index);
        }
        return tuple;
    }

    @Override
    public void restart() {
        this.tuplePtr = 0;
    }

    @Override
    public Integer size() {
        return this.getNumOfTuples();
    }

    @Override
    public Integer characterSize() {
        return this.charCount;
    }

    @Override
    public Integer characterSize(Integer fieldIndex) {
        return this.charCountList.get(fieldIndex);
    }
}

