/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.conll;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.peppermodules.CoNLLModules.CoNLLCorefMarkable;
import org.corpus_tools.peppermodules.CoNLLModules.CoNLLImporterProperties;
import org.corpus_tools.peppermodules.CoNLLModules.DefaultDict;
import org.corpus_tools.peppermodules.conll.ConllDataField;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleConnectorFactory;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleReader;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.semantics.SPOSAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conll2SaltMapper
extends PepperMapperImpl {
    private static final Logger logger = LoggerFactory.getLogger(Conll2SaltMapper.class);
    private ConllDataField firstSPOSField = null;
    private ConllDataField secondSPOSField = null;
    private final ConllDataField DEFAULT_SPOS = ConllDataField.POSTAG;
    private static final String PROJECTIVE = "projective";
    private static final String PRODEP = "prodep";
    private static final String DEP = "dep";
    private static final String DEPREL = "deprel";
    private static final String CAT = "cat";
    private static final String S = "S";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String TYPE = "TYPE";
    public static final String NAMESPACE = "NAMESPACE";
    public static final String DEFAULT_FEATURE = "morph";
    private final String FEATURESEPARATOR = "\\|";
    boolean splitFeatures;
    boolean keyValFeatures;
    String posName;
    String secondPosName;
    String lemmaName;
    String edgeAnnoName;
    String edgeAnnoNS;
    String edgeLayer;
    String edgeType;
    String enhancedEdgeType;
    String featuresNamespace;
    String miscNamespace;
    boolean dependenciesHaveLayers;
    boolean splitEnhancedDeprels;
    boolean noDuplicateEdeps;
    String ellipsisAnnoString;
    String ellipsisTokAnno;
    String ellipsisTokAnnoNS;
    String metaPrefix;
    String[] sentAnnos;
    String markNamespace;
    SLayer markLayer;
    String markAnnotation;
    String[] markLabels;
    Integer grpIdIndex;
    ArrayList<CoNLLCorefMarkable> markables = new ArrayList();
    boolean useSLemmaAnnotation;
    boolean useSPOSAnnotation;
    Map<String, SLayer> layerMap = new HashMap<String, SLayer>();

    public Conll2SaltMapper() {
        this.setProperties(new CoNLLImporterProperties());
    }

    private boolean getSplitFeatures() {
        return (Boolean)this.getProperties().getProperty("conll.splitFeatures").getValue();
    }

    private boolean getKeyValFeatures() {
        return (Boolean)this.getProperties().getProperty("conll.KeyValFeatures").getValue();
    }

    private String getEdgeType() {
        return this.getProperties().getProperties().getProperty("conll.EDGE.TYPE", DEP);
    }

    private String getEnhancedEdgeType() {
        return ((CoNLLImporterProperties)this.getProperties()).getEnhancedEdgeType();
    }

    private String getEdgeLayer() {
        return this.getProperties().getProperties().getProperty("conll.EDGE.LAYER", DEP);
    }

    private String getEdgeAnnoName() {
        return this.getProperties().getProperties().getProperty("conll.EDGE.ANNO.NAME", DEPREL);
    }

    private String getEdgeAnnoNS() {
        return this.getProperties().getProperties().getProperty("conll.EDGE.ANNO.NS", DEP);
    }

    private String getMetaPrefix() {
        return this.getProperties().getProperties().getProperty("conll.meta.prefix", "meta_");
    }

    private String[] getSentAnnos() {
        return ((CoNLLImporterProperties)this.getProperties()).getSentAnnos();
    }

    private String getMarkNamespace() {
        return this.getProperties().getProperties().getProperty("conll.markable.namespace", null);
    }

    private String getMarkAnnotation() {
        return this.getProperties().getProperties().getProperty("conll.markable.annotation", null);
    }

    private String[] getMarkLabels() {
        return ((CoNLLImporterProperties)this.getProperties()).getMarkLabels();
    }

    private String getMiscNamespace() {
        return this.getProperties().getProperties().getProperty("conll.MISC.NAMESPACE", null);
    }

    private String getFeaturesNamespace() {
        return this.getProperties().getProperties().getProperty("conll.FEATURES.NAMESPACE", null);
    }

    private String getPosName() {
        return this.getProperties().getProperties().getProperty("conll.POS.NAME", "");
    }

    private String getSecondPosName() {
        return this.getProperties().getProperties().getProperty("conll.SECOND.POS.NAME", "");
    }

    private String getLemmaName() {
        return this.getProperties().getProperties().getProperty("conll.LEMMA.NAME", "");
    }

    private boolean dependenciesHaveLayers() {
        return ((CoNLLImporterProperties)this.getProperties()).dependenciesHaveLayers();
    }

    private boolean splitEnhancedDeprels() {
        return ((CoNLLImporterProperties)this.getProperties()).splitEnhancedDeprels();
    }

    private boolean noDuplicateEdeps() {
        return ((CoNLLImporterProperties)this.getProperties()).noDuplicateEdeps();
    }

    private String getEllipsisAnno() {
        return ((CoNLLImporterProperties)this.getProperties()).getEllipsisAnno();
    }

    private boolean getUseSLemmaAnnotation() {
        String propVal = (String)this.getProperties().getProperty("conll.SLEMMA").getValue();
        if (propVal.equals("LEMMA")) {
            return true;
        }
        if (propVal.equals("NONE")) {
            return false;
        }
        logger.warn(String.format("Invalid value '%s' for property '%s'. Default value '%s' is used.", propVal, "conll.SLEMMA", "LEMMA"));
        return true;
    }

    private boolean getUseSPOSAnnotation() {
        String val;
        this.firstSPOSField = null;
        this.secondSPOSField = null;
        if (this.getProperties().getProperty("conll.SPOS") == null) {
            this.firstSPOSField = this.DEFAULT_SPOS;
            return true;
        }
        String propVal = (String)this.getProperties().getProperty("conll.SPOS").getValue();
        String[] propVals = propVal.split(",");
        if (propVals.length > 2) {
            logger.warn(String.format("Found '%s' for property '%s'. Only two values are regarded, the rest will be ignored.", propVal, "conll.SPOS"));
        }
        if (propVals.length > 1 && propVals[0].equals("NONE")) {
            logger.warn(String.format("Found '%s' for property '%s'. With this setting, no SPOSAnnotation will ever be created.", propVal, "conll.SPOS"));
        }
        if ((val = propVals[0].trim()).equals("NONE")) {
            return false;
        }
        if (val.equals("POSTAG") || val.equals("CPOSTAG")) {
            if (val.equals("POSTAG")) {
                this.firstSPOSField = ConllDataField.POSTAG;
            } else if (val.equals("CPOSTAG")) {
                this.firstSPOSField = ConllDataField.CPOSTAG;
            }
        } else if (propVals.length == 1) {
            logger.warn(String.format("Invalid value '%s' for property '%s'. Using default value.", val, "conll.SPOS"));
            this.firstSPOSField = this.DEFAULT_SPOS;
        } else {
            logger.warn(String.format("Invalid value '%s' for property '%s'. Using alternative value.", val, "conll.SPOS"));
        }
        if (propVals.length >= 2 && !(val = propVals[1].trim()).equals("NONE")) {
            if (val.equals("POSTAG") || val.equals("CPOSTAG")) {
                ConllDataField field = null;
                if (val.equals("POSTAG")) {
                    field = ConllDataField.POSTAG;
                } else if (val.equals("CPOSTAG")) {
                    field = ConllDataField.CPOSTAG;
                }
                if (this.firstSPOSField == null) {
                    this.firstSPOSField = field;
                } else {
                    this.secondSPOSField = field;
                }
            } else if (this.firstSPOSField == null) {
                logger.warn(String.format("Invalid alternative value '%s' for property '%s'. Using default value.", val, "conll.SPOS"));
                this.firstSPOSField = this.DEFAULT_SPOS;
            } else {
                logger.warn(String.format("Invalid alternative value '%s' for property '%s'.", val, "conll.SPOS"));
            }
        }
        return this.firstSPOSField != null;
    }

    private void createPOSandCPOSAnnotation(ArrayList<String> fieldValues, SToken sToken) {
        if (this.useSPOSAnnotation) {
            SPOSAnnotation anno;
            String fieldVal;
            int index;
            int SPOSAnnotationIndex = -1;
            ConllDataField[] bothFields = new ConllDataField[]{this.firstSPOSField, this.secondSPOSField};
            ConllDataField field = null;
            for (index = 0; index < bothFields.length; ++index) {
                ConllDataField field2;
                if (SPOSAnnotationIndex == -1) {
                    field = bothFields[index];
                    if (field == null || (fieldVal = fieldValues.get(field.getFieldNum() - 1)) == null) continue;
                    if (this.posName != null && this.posName.length() > 0) {
                        anno = SaltFactory.createSAnnotation();
                        anno.setName(this.posName);
                    } else {
                        anno = SaltFactory.createSPOSAnnotation();
                    }
                    anno.setValue((Object)fieldVal);
                    sToken.addAnnotation((SAnnotation)anno);
                    SPOSAnnotationIndex = index;
                    continue;
                }
                if (this.secondPosName == null || (field2 = bothFields[SPOSAnnotationIndex] == ConllDataField.POSTAG ? ConllDataField.CPOSTAG : ConllDataField.POSTAG) == null || (fieldVal = fieldValues.get(field2.getFieldNum() - 1)) == null || this.secondPosName.length() <= 0) continue;
                anno = SaltFactory.createSAnnotation();
                anno.setName(this.secondPosName);
                anno.setValue((Object)fieldVal);
                sToken.addAnnotation((SAnnotation)anno);
            }
            for (index = 0; index < bothFields.length; ++index) {
                if (SPOSAnnotationIndex == index || (field = bothFields[index]) == null || (fieldVal = fieldValues.get(field.getFieldNum() - 1)) == null) continue;
                anno = SaltFactory.createSAnnotation();
                anno.setName(this.getProperties().getProperties().getProperty(field.getPropertyKey_Name(), field.name()));
                anno.setValue((Object)fieldVal);
                sToken.addAnnotation((SAnnotation)anno);
                SPOSAnnotationIndex = index;
            }
        }
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        TupleReader tupleReader = TupleConnectorFactory.fINSTANCE.createTupleReader();
        try {
            tupleReader.setFile(new File(this.getResourceURI().toFileString()));
            tupleReader.readFile();
        }
        catch (IOException e) {
            String errorMessage = "input file could not be read. Abort conversion of file " + this.getResourceURI() + ".";
            logger.error(errorMessage);
            throw new PepperModuleDataException((PepperMapper)this, errorMessage);
        }
        STextualDS sTextualDS = SaltFactory.createSTextualDS();
        String textName = ((CoNLLImporterProperties)this.getProperties()).getTextName();
        if (textName != null && !textName.isEmpty()) {
            sTextualDS.setName(textName);
        }
        sTextualDS.setGraph((Graph)this.getDocument().getDocumentGraph());
        ArrayList<SToken> tokenList = new ArrayList<SToken>();
        HashMap<SPointingRelation, String> pointingRelationMap = new HashMap<SPointingRelation, String>();
        ArrayList<String> fieldValues = new ArrayList<String>();
        HashMap<String, Integer> SentTokMap = new HashMap<String, Integer>();
        Collection<String> tuple = null;
        int numOfTuples = tupleReader.getNumOfTuples();
        int lastTupleIndex = numOfTuples - 1;
        int tupleSize = 0;
        int numOfColumnsExpected = ConllDataField.values().length;
        int fieldNum = 1;
        this.useSLemmaAnnotation = this.getUseSLemmaAnnotation();
        this.useSPOSAnnotation = this.getUseSPOSAnnotation();
        this.splitFeatures = this.getSplitFeatures();
        this.keyValFeatures = this.getKeyValFeatures();
        this.posName = this.getPosName();
        this.secondPosName = this.getSecondPosName();
        this.lemmaName = this.getLemmaName();
        this.edgeType = this.getEdgeType();
        this.enhancedEdgeType = this.getEnhancedEdgeType();
        this.ellipsisAnnoString = this.getEllipsisAnno();
        this.ellipsisTokAnno = null;
        this.ellipsisTokAnnoNS = null;
        if (this.ellipsisAnnoString != null) {
            if (this.ellipsisAnnoString.contains(":")) {
                String[] parts = this.ellipsisAnnoString.split(":", 2);
                this.ellipsisTokAnnoNS = parts[0];
                this.ellipsisTokAnno = parts[1];
            } else {
                this.ellipsisTokAnno = this.ellipsisAnnoString;
            }
        }
        this.edgeLayer = this.getEdgeLayer();
        this.edgeAnnoName = this.getEdgeAnnoName();
        this.edgeAnnoNS = this.getEdgeAnnoNS();
        this.metaPrefix = this.getMetaPrefix();
        this.sentAnnos = this.getSentAnnos();
        this.markNamespace = this.getMarkNamespace();
        this.featuresNamespace = this.getFeaturesNamespace();
        this.miscNamespace = this.getMiscNamespace();
        this.dependenciesHaveLayers = this.dependenciesHaveLayers();
        this.splitEnhancedDeprels = this.splitEnhancedDeprels();
        this.noDuplicateEdeps = this.noDuplicateEdeps();
        if (this.markNamespace != null) {
            this.markLayer = SaltFactory.createSLayer();
            this.markLayer.setName(this.markNamespace);
            this.markLayer.setGraph((Graph)this.getDocument().getDocumentGraph());
        }
        this.markAnnotation = this.getMarkAnnotation();
        this.markLabels = this.getMarkLabels();
        this.grpIdIndex = Arrays.asList(this.markLabels).indexOf("GRP");
        Pattern patOpen = Pattern.compile("\\(([^|()]+)");
        Pattern patClose = Pattern.compile("([^|()]+)\\)");
        Pattern patDouble = Pattern.compile("\\(([^|()]+)\\)");
        boolean nestedClosed = true;
        int tok_counter = 0;
        DefaultDict markstart_dict = new DefaultDict(ArrayList.class);
        DefaultDict markend_dict = new DefaultDict(ArrayList.class);
        LinkedHashMap last_mark_by_group = new LinkedHashMap();
        LinkedHashMap open_marks_by_group = new LinkedHashMap();
        DefaultDict<String, String> mark_text_by_group = new DefaultDict<String, String>(String.class);
        boolean considerProjectivity = (Boolean)this.getProperties().getProperty("conll.considerProjectivity").getValue();
        boolean projectiveModeIsType = !this.getProperties().getProperties().getProperty("conll.projectiveMode", TYPE).equalsIgnoreCase(NAMESPACE);
        ArrayList<Integer> nonMatchingCategoryNumberLines = new ArrayList<Integer>();
        int stringBuilderCharBufferSize = tupleReader.characterSize(ConllDataField.FORM.getFieldNum() - 1) + numOfTuples;
        StringBuilder primaryText = new StringBuilder(stringBuilderCharBufferSize);
        SLayer lyr = SaltFactory.createSLayer();
        lyr.setName(this.edgeLayer);
        LinkedList<SToken> sentenceToken = new LinkedList<SToken>();
        LinkedList<SAnnotation> sentAnnos = new LinkedList<SAnnotation>();
        for (int rowIndex = 0; rowIndex < numOfTuples; ++rowIndex) {
            Iterator<Object> iter;
            try {
                tuple = tupleReader.getTuple();
            }
            catch (IOException e) {
                String string = String.format("line %d of input file could not be read. Abort conversion of file " + this.getResourceURI() + ".", rowIndex + 1);
                throw new PepperModuleDataException((PepperMapper)this, string);
            }
            tupleSize = tuple.size();
            fieldValues.clear();
            if (tupleSize != 1 && tupleSize != numOfColumnsExpected) {
                String errorMessage = String.format("invalid format in line %d of input file. lines must be empty or contain %d columns of data. Abort conversion of file " + this.getResourceURI() + ".", rowIndex + 1, numOfColumnsExpected);
                throw new PepperModuleDataException((PepperMapper)this, errorMessage);
            }
            if (tupleSize > 1) {
                String miscStr;
                String enhancedSpec;
                String tokText;
                fieldNum = 1;
                iter = tuple.iterator();
                while (iter.hasNext()) {
                    ConllDataField conllDataField = ConllDataField.getFieldByNum(fieldNum);
                    String fieldValue = (String)iter.next();
                    if (fieldValue.equals(conllDataField.getDummyValue())) {
                        fieldValue = null;
                        if (conllDataField.isMandatory()) {
                            String errorMessage = String.format("mandatory value for %s missing in line %d of input file '" + this.getResourceURI() + "'!", conllDataField.toString(), rowIndex + 1);
                            throw new PepperModuleDataException((PepperMapper)this, errorMessage);
                        }
                    }
                    fieldValues.add(fieldValue);
                    ++fieldNum;
                }
                String tokenIDStr = (String)fieldValues.get(ConllDataField.ID.getFieldNum() - 1);
                if (tokenIDStr.contains("-")) continue;
                SToken sToken = SaltFactory.createSToken();
                sToken.setGraph((Graph)this.getDocument().getDocumentGraph());
                tokenList.add(sToken);
                int tokenTextStartOffset = primaryText.length();
                if (tokenIDStr.contains(".") && this.ellipsisTokAnno != null) {
                    String ellipsisToken = (String)fieldValues.get(ConllDataField.FORM.getFieldNum() - 1);
                    SAnnotation sa = SaltFactory.createSAnnotation();
                    sa.setName(this.ellipsisTokAnno);
                    sa.setNamespace(this.ellipsisTokAnnoNS);
                    sa.setValue((Object)ellipsisToken);
                    sToken.addAnnotation(sa);
                    primaryText.append(" ").append(" ");
                    tokText = " ";
                } else {
                    tokText = (String)fieldValues.get(ConllDataField.FORM.getFieldNum() - 1);
                    primaryText.append(tokText).append(" ");
                }
                int tokenTextEndOffset = primaryText.length() - 1;
                STextualRelation sTextualRelation = SaltFactory.createSTextualRelation();
                sTextualRelation.setSource((Node)sToken);
                sTextualRelation.setTarget((Node)sTextualDS);
                sTextualRelation.setStart((Number)tokenTextStartOffset);
                sTextualRelation.setEnd((Number)tokenTextEndOffset);
                sTextualRelation.setGraph((Graph)this.getDocument().getDocumentGraph());
                sentenceToken.add(sToken);
                ConllDataField field = ConllDataField.LEMMA;
                String fieldValue = (String)fieldValues.get(field.getFieldNum() - 1);
                if (fieldValue != null) {
                    SAnnotation sAnnotation = SaltFactory.createSAnnotation();
                    if (this.useSLemmaAnnotation) {
                        if (this.lemmaName != null && this.lemmaName.length() > 0) {
                            sAnnotation.setName(this.lemmaName);
                        } else {
                            sAnnotation = SaltFactory.createSLemmaAnnotation();
                        }
                        sAnnotation.setValue((Object)fieldValue);
                        sToken.addAnnotation(sAnnotation);
                    }
                }
                this.createPOSandCPOSAnnotation(fieldValues, sToken);
                String featureValue = fieldValues.get(ConllDataField.FEATS.getFieldNum() - 1);
                if (featureValue != null && featureValue.length() > 0) {
                    String[] featureValues;
                    String ruleKey = "conll.field6.POSTAG." + fieldValues.get(ConllDataField.POSTAG.getFieldNum() - 1);
                    if (!this.getProperties().getProperties().containsKey(ruleKey)) {
                        ruleKey = "conll.field6.CPOSTAG." + fieldValues.get(ConllDataField.CPOSTAG.getFieldNum() - 1);
                        if (!this.getProperties().getProperties().containsKey(ruleKey)) {
                            ruleKey = "conll.field6.default";
                        }
                    }
                    String featureKey = this.getProperties().getProperties().getProperty(ruleKey, DEFAULT_FEATURE);
                    boolean doSplit = this.splitFeatures;
                    String[] featureKeys = null;
                    if (doSplit) {
                        featureKeys = featureKey.split("\\|");
                        if (ruleKey == "conll.field6.default") {
                            boolean bl = doSplit = featureKeys.length > 1;
                        }
                    }
                    if (this.keyValFeatures) {
                        for (String KeyVal : featureValues = featureValue.split("\\|")) {
                            String[] Parts;
                            if (!KeyVal.contains("=") || (Parts = KeyVal.split("=", 2)).length != 2) continue;
                            String AnnoKey = Parts[0];
                            String AnnoVal = Parts[1];
                            sToken.createAnnotation(this.featuresNamespace, AnnoKey, (Object)AnnoVal);
                        }
                    } else if (doSplit) {
                        featureValues = featureValue.split("\\|");
                        for (int idx = 0; idx < Math.min(featureKeys.length, featureValues.length); ++idx) {
                            sToken.createAnnotation(this.featuresNamespace, featureKeys[idx], (Object)featureValues[idx]);
                        }
                        if (featureKeys.length != featureValues.length) {
                            nonMatchingCategoryNumberLines.add(rowIndex + 1);
                        }
                    } else {
                        sToken.createAnnotation(this.featuresNamespace, featureKey, (Object)featureValue);
                    }
                }
                Float tokenID = null;
                try {
                    tokenID = Float.valueOf(Float.parseFloat(tokenIDStr));
                }
                catch (NumberFormatException e) {
                    String errorMessage = String.format("Invalid numerical value '%s' for ID in line %d of input file. Abort conversion of file " + this.getResourceURI() + ".", tokenIDStr, rowIndex + 1);
                    throw new PepperModuleDataException((PepperMapper)this, errorMessage);
                }
                SentTokMap.put(tokenID.toString(), tokenList.size() - 1);
                String headIDStr = fieldValues.get(ConllDataField.HEAD.getFieldNum() - 1);
                String headID = null;
                try {
                    headID = headIDStr.matches("[0-9]+(\\.[0-9]+)?") ? headIDStr : "-1";
                    headID = Float.valueOf(Float.parseFloat(headID)).toString();
                }
                catch (NumberFormatException e) {
                    String errorMessage = String.format("Invalid numerical value '%s' for HEAD in line %d of input file '" + this.getResourceURI() + "'. Abort conversion of file " + this.getResourceURI() + ".", headIDStr, rowIndex + 1);
                    throw new PepperModuleDataException((PepperMapper)this, errorMessage);
                }
                Integer headIDPosition = null;
                Pair primaryDependency = null;
                if (Float.parseFloat(headID) > 0.0f) {
                    String annoValue = fieldValues.get(ConllDataField.DEPREL.getFieldNum() - 1);
                    primaryDependency = Pair.of((Object)headID, (Object)annoValue);
                    if (Float.parseFloat(headID) <= tokenID.floatValue()) {
                        headIDPosition = (Integer)SentTokMap.get(headID.toString());
                        if (this.edgeAnnoName != DEPREL) {
                            this.modifyPointingRelation(null, (SStructuredNode)tokenList.get(headIDPosition), (SStructuredNode)sToken, this.edgeType, this.edgeAnnoName, annoValue);
                        } else {
                            this.modifyPointingRelation(null, (SStructuredNode)tokenList.get(headIDPosition), (SStructuredNode)sToken, this.edgeType, DEPREL, annoValue);
                        }
                    } else if (this.edgeAnnoName != DEPREL) {
                        pointingRelationMap.put(this.modifyPointingRelation(null, (SStructuredNode)sToken, (SStructuredNode)sToken, this.edgeType, this.edgeAnnoName, annoValue), headID);
                    } else {
                        pointingRelationMap.put(this.modifyPointingRelation(null, (SStructuredNode)sToken, (SStructuredNode)sToken, this.edgeType, DEPREL, annoValue), headID);
                    }
                }
                if (considerProjectivity) {
                    String proheadIDStr = fieldValues.get(ConllDataField.PHEAD.getFieldNum() - 1);
                    Integer proheadID = null;
                    try {
                        System.out.println("Entered critical scope");
                        proheadID = "_".equals(proheadIDStr.trim()) ? -1 : Integer.parseInt(proheadIDStr);
                    }
                    catch (NumberFormatException e) {
                        String errorMessage = String.format("invalid integer value '%s' for PHEAD in line %d of input file. Abort conversion of file " + this.getResourceURI() + ".", proheadIDStr, rowIndex + 1);
                        throw new PepperModuleDataException((PepperMapper)this, errorMessage);
                    }
                    if (proheadID > 0) {
                        SAnnotation sAnnotation = SaltFactory.createSAnnotation();
                        if (this.edgeAnnoName != DEPREL) {
                            sAnnotation.setName(this.edgeAnnoName);
                        } else {
                            sAnnotation.setName(DEPREL);
                        }
                        sAnnotation.setValue((Object)fieldValues.get(ConllDataField.PDEPREL.getFieldNum() - 1));
                        SPointingRelation sPointingRelation = SaltFactory.createSPointingRelation();
                        sPointingRelation.addAnnotation(sAnnotation);
                        if (!this.dependenciesHaveLayers) {
                            sPointingRelation.addLayer((Layer)lyr);
                        }
                        sPointingRelation.setSource((Node)sToken);
                        sPointingRelation.setTarget((Node)sToken);
                        sPointingRelation.setGraph((Graph)this.getDocument().getDocumentGraph());
                        if (projectiveModeIsType) {
                            sPointingRelation.setType(PRODEP);
                        } else {
                            if (this.edgeType != DEP) {
                                sPointingRelation.setType(this.edgeType);
                            } else {
                                sPointingRelation.setType(DEP);
                            }
                            if (this.edgeAnnoNS != DEP) {
                                sAnnotation.setNamespace(this.edgeAnnoNS);
                            } else {
                                sAnnotation.setNamespace(PROJECTIVE);
                            }
                        }
                        if ((float)proheadID.intValue() <= tokenID.floatValue()) {
                            sPointingRelation.setSource((Node)tokenList.get(proheadID - 1));
                        } else {
                            pointingRelationMap.put(sPointingRelation, proheadID.toString());
                        }
                    }
                } else if (this.enhancedEdgeType != null && (enhancedSpec = fieldValues.get(ConllDataField.PHEAD.getFieldNum() - 1)) != null) {
                    String[] segments;
                    int i = 0;
                    block18: for (String depSpec : segments = enhancedSpec.split("\\|")) {
                        String[] eDepRels;
                        Float eHead;
                        ++i;
                        try {
                            eHead = Float.valueOf(Float.parseFloat(depSpec.substring(0, depSpec.indexOf(58))));
                        }
                        catch (NumberFormatException e) {
                            throw new PepperModuleDataException((PepperMapper)this, "Could not parse head id from enhanced dependency specification `" + depSpec + "` for token with id " + tokenIDStr);
                        }
                        if (eHead.floatValue() == 0.0f) continue;
                        try {
                            eDepRels = this.splitEnhancedDeprels ? depSpec.substring(depSpec.indexOf(58) + 1).split(":") : depSpec.substring(depSpec.indexOf(58) + 1).split(" ");
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            throw new PepperModuleDataException((PepperMapper)this, "Enhanced dependency `" + depSpec + "` does not specify (a) proper relation label(s) or head id for token with id " + tokenIDStr);
                        }
                        for (String eDepRel : eDepRels) {
                            if (primaryDependency == null) {
                                primaryDependency = Pair.of((Object)"0", (Object)"_");
                            }
                            if (eHead.floatValue() == Float.parseFloat((String)primaryDependency.getLeft()) && eDepRel.equals(primaryDependency.getRight()) && this.noDuplicateEdeps) continue;
                            Integer eHeadPosition = null;
                            if (eHead.floatValue() <= tokenID.floatValue()) {
                                eHeadPosition = (Integer)SentTokMap.get(eHead.toString());
                                if (this.edgeAnnoName != DEPREL) {
                                    this.modifyPointingRelation(null, (SStructuredNode)tokenList.get(eHeadPosition), (SStructuredNode)sToken, this.enhancedEdgeType, this.edgeAnnoName, eDepRel);
                                    continue block18;
                                }
                                this.modifyPointingRelation(null, (SStructuredNode)tokenList.get(eHeadPosition), (SStructuredNode)sToken, this.enhancedEdgeType, DEPREL, eDepRel);
                                continue block18;
                            }
                            if (this.edgeAnnoName != DEPREL) {
                                pointingRelationMap.put(this.modifyPointingRelation(null, (SStructuredNode)sToken, (SStructuredNode)sToken, this.enhancedEdgeType, this.edgeAnnoName, eDepRel), eHead.toString());
                                continue block18;
                            }
                            pointingRelationMap.put(this.modifyPointingRelation(null, (SStructuredNode)sToken, (SStructuredNode)sToken, this.enhancedEdgeType, DEPREL, eDepRel), eHead.toString());
                            continue block18;
                        }
                    }
                }
                if (!considerProjectivity && (miscStr = fieldValues.get(ConllDataField.PDEPREL.getFieldNum() - 1)) != null) {
                    String[] annos;
                    for (String anno : annos = miscStr.split("\\|")) {
                        if (!anno.contains("=")) continue;
                        String[] parts = anno.split("=", 2);
                        String key = parts[0].trim();
                        String val = parts[1].trim();
                        if (key.equals(this.markAnnotation)) {
                            String group;
                            Matcher m = patDouble.matcher(val);
                            while (m.find()) {
                                group = m.group(1);
                                CoNLLCorefMarkable new_mark = new CoNLLCorefMarkable(tok_counter);
                                new_mark.setEnd(tok_counter);
                                new_mark.setAnnoString(group);
                                if (this.grpIdIndex > -1) {
                                    group = group.split("-")[this.grpIdIndex];
                                }
                                new_mark.setGroup(group);
                                if (last_mark_by_group.containsKey(group)) {
                                    if (((LinkedList)last_mark_by_group.get(group)).size() > 0) {
                                        new_mark.antecedent = (CoNLLCorefMarkable)((LinkedList)last_mark_by_group.get(group)).get(((LinkedList)last_mark_by_group.get(group)).size() - 1);
                                    }
                                } else {
                                    LinkedList emptyList = new LinkedList();
                                    last_mark_by_group.put(group, emptyList);
                                }
                                ((LinkedList)last_mark_by_group.get(group)).push(new_mark);
                                this.markables.add(new_mark);
                                ((List)markstart_dict.get(tok_counter)).add(new_mark);
                                ((List)markend_dict.get(tok_counter)).add(new_mark);
                            }
                            val = val.replaceAll("\\(([^|()]+)\\)", "");
                            m = patOpen.matcher(val);
                            while (m.find()) {
                                LinkedList emptyList;
                                group = m.group(1);
                                CoNLLCorefMarkable new_mark = new CoNLLCorefMarkable(tok_counter);
                                new_mark.setAnnoString(group);
                                if (this.grpIdIndex > -1) {
                                    group = group.split("-")[this.grpIdIndex];
                                }
                                new_mark.setGroup(group);
                                this.markables.add(new_mark);
                                if (last_mark_by_group.containsKey(group)) {
                                    if (((LinkedList)last_mark_by_group.get(group)).size() > 0) {
                                        new_mark.antecedent = (CoNLLCorefMarkable)((LinkedList)last_mark_by_group.get(group)).get(((LinkedList)last_mark_by_group.get(group)).size() - 1);
                                    }
                                } else {
                                    emptyList = new LinkedList();
                                    last_mark_by_group.put(group, emptyList);
                                }
                                if (!open_marks_by_group.containsKey(group)) {
                                    emptyList = new LinkedList();
                                    open_marks_by_group.put(group, emptyList);
                                }
                                ((LinkedList)open_marks_by_group.get(group)).push(new_mark);
                                ((LinkedList)last_mark_by_group.get(group)).push(new_mark);
                                mark_text_by_group.put(group, (String)mark_text_by_group.get(group) + tokText + " ");
                                ((List)markstart_dict.get(tok_counter)).add(new_mark);
                            }
                            val = val.replaceAll("\\(([^|()]+)", "");
                            m = patClose.matcher(val);
                            while (m.find()) {
                                group = m.group(1);
                                if (this.grpIdIndex > -1) {
                                    group = group.split("-")[this.grpIdIndex];
                                }
                                if (!open_marks_by_group.containsKey(group)) {
                                    throw new PepperModuleDataException((PepperMapper)this, "Found closing bracket " + group + " but group was not opened!");
                                }
                                CoNLLCorefMarkable mark = (CoNLLCorefMarkable)((LinkedList)open_marks_by_group.get(group)).pop();
                                mark.setText(((String)mark_text_by_group.get(group)).trim());
                                mark.setEnd(tok_counter);
                                ((List)markend_dict.get(tok_counter)).add(mark);
                            }
                            for (String g : mark_text_by_group.keySet()) {
                                if (((String)mark_text_by_group.get(g)).equals("")) continue;
                                mark_text_by_group.put(g, (String)mark_text_by_group.get(g) + tokText + " ");
                            }
                            continue;
                        }
                        SAnnotation sa = SaltFactory.createSAnnotation();
                        sa.setName(key);
                        sa.setValue((Object)val);
                        if (this.miscNamespace != null) {
                            sa.setNamespace(this.miscNamespace);
                        }
                        sToken.addAnnotation(sa);
                    }
                }
                ++tok_counter;
            } else {
                iter = tuple.iterator();
                String string = iter.next();
                if (string.startsWith("#") && string.contains("=")) {
                    String[] parts = string.split("=", 2);
                    Object key = parts[0].replaceFirst("#", "").trim();
                    String val = parts[1].trim();
                    if (((String)key).startsWith(this.metaPrefix)) {
                        key = ((String)key).replaceFirst(this.metaPrefix, "");
                        this.getDocument().createMetaAnnotation(null, (String)key, (Object)val);
                    } else if (ArrayUtils.contains((Object[])this.sentAnnos, (Object)key) || this.sentAnnos == null) {
                        SAnnotation anno = SaltFactory.createSAnnotation();
                        anno.setName((String)key);
                        anno.setValue((Object)val);
                        sentAnnos.add(anno);
                    }
                }
                if (!sentenceToken.isEmpty() && ((CoNLLImporterProperties)this.getProperties()).isSentence().booleanValue()) {
                    SSpan sSpan = this.getDocument().getDocumentGraph().createSpan(sentenceToken);
                    sSpan.createAnnotation(null, CAT, (Object)S);
                    for (SAnnotation sAnno : sentAnnos) {
                        sSpan.addAnnotation(sAnno);
                    }
                    sentAnnos.clear();
                }
                sentenceToken.clear();
            }
            if (tupleSize != 1 && rowIndex != lastTupleIndex) continue;
            for (Map.Entry entry : pointingRelationMap.entrySet()) {
                Integer position = (Integer)SentTokMap.get(entry.getValue());
                SToken src = (SToken)tokenList.get(position);
                ((SPointingRelation)entry.getKey()).setSource((Node)src);
            }
            tokenList.clear();
            SentTokMap.clear();
            pointingRelationMap.clear();
        }
        if (!sentenceToken.isEmpty() && ((CoNLLImporterProperties)this.getProperties()).isSentence().booleanValue()) {
            SSpan sSpan = this.getDocument().getDocumentGraph().createSpan(sentenceToken);
            sSpan.createAnnotation(null, CAT, (Object)S);
        }
        primaryText.deleteCharAt(primaryText.length() - 1);
        sTextualDS.setText(primaryText.toString());
        List tokens = this.getDocument().getDocumentGraph().getTokens();
        for (CoNLLCorefMarkable coNLLCorefMarkable : this.markables) {
            for (int i = coNLLCorefMarkable.getStart(); i <= coNLLCorefMarkable.getEnd(); ++i) {
                coNLLCorefMarkable.addToken((SToken)tokens.get(i));
            }
        }
        LinkedHashMap<CoNLLCorefMarkable, SSpan> marks2spans = new LinkedHashMap<CoNLLCorefMarkable, SSpan>();
        for (CoNLLCorefMarkable mark : this.markables) {
            SSpan sSpan = this.getDocument().getDocumentGraph().createSpan(mark.getTokens());
            if (this.markNamespace != null) {
                if (sSpan == null) {
                    throw new PepperModuleDataException((PepperMapper)this, "Null span detected, created from markable object: " + mark.toString());
                }
                sSpan.addLayer((Layer)this.markLayer);
            }
            if (this.markLabels != null) {
                int i = 0;
                for (String subval : mark.getAnnoString().split("-")) {
                    if (this.markLabels.length < i) break;
                    String annoName = this.markLabels[i];
                    ++i;
                    if (annoName.length() == 0 || subval.length() == 0 || annoName.equals("GRP")) continue;
                    if (annoName.equals("EDGE")) {
                        mark.setEdgeType(subval);
                        continue;
                    }
                    SAnnotation annotation = SaltFactory.createSAnnotation();
                    annotation.setName(annoName);
                    annotation.setValue((Object)subval);
                    if (this.markNamespace != null) {
                        annotation.setNamespace(this.markNamespace);
                    }
                    sSpan.addAnnotation(annotation);
                }
            }
            if (mark.getNodeName() != null) {
                sSpan.setName(mark.getNodeName());
            }
            marks2spans.put(mark, sSpan);
        }
        for (CoNLLCorefMarkable mark : this.markables) {
            if (mark.antecedent == null) continue;
            SPointingRelation sRel = SaltFactory.createSPointingRelation();
            sRel.setSource((Node)marks2spans.get(mark));
            sRel.setTarget((Node)marks2spans.get(mark.antecedent));
            sRel.setType("coref");
            SAnnotation relAnno = SaltFactory.createSAnnotation();
            relAnno.setName("type");
            relAnno.setValue((Object)mark.getEdgeType());
            sRel.addAnnotation(relAnno);
            if (this.markNamespace != null) {
                sRel.addLayer((Layer)this.markLayer);
            }
            this.getDocument().getDocumentGraph().addRelation((Relation)sRel);
        }
        if (nonMatchingCategoryNumberLines.size() > 0) {
            logger.warn("Number of feature values doesn't match number of categories in lines: " + nonMatchingCategoryNumberLines.toString());
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    private SPointingRelation mapDependency() {
        return null;
    }

    private SPointingRelation modifyPointingRelation(SPointingRelation rel, SStructuredNode source, SStructuredNode target, String type, String annoName, String annoVal) {
        boolean newRel;
        boolean bl = newRel = rel == null;
        if (newRel) {
            rel = SaltFactory.createSPointingRelation();
        }
        rel.setSource((Node)source);
        rel.setTarget((Node)target);
        rel.setType(type);
        if (annoName != null && annoVal != null) {
            rel.createAnnotation(this.edgeAnnoNS, annoName, (Object)annoVal);
        }
        if (newRel) {
            rel.setGraph((Graph)this.getDocument().getDocumentGraph());
        }
        if (this.dependenciesHaveLayers) {
            SLayer layer;
            if (!this.layerMap.containsKey(type)) {
                layer = SaltFactory.createSLayer();
                layer.setName(type);
                this.layerMap.put(type, layer);
                this.getDocument().getDocumentGraph().addLayer((Layer)layer);
            }
            layer = this.layerMap.get(type);
            rel.addLayer((Layer)layer);
        }
        return rel;
    }
}

