/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.CoNLLModules;

import java.util.ArrayList;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;

public class CoNLLCorefMarkable {
    private ArrayList<SToken> tokens;
    private ArrayList<SAnnotation> annotations;
    private String nodeName;
    private String text;
    private String group;
    private String annoString;
    private String edgeType = "ident";
    private int start;
    private int end;
    public CoNLLCorefMarkable antecedent;

    public int getStart() {
        return this.start;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getAnnoString() {
        return this.annoString;
    }

    public void setAnnoString(String annoString) {
        this.annoString = annoString;
    }

    public String getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(String edgeType) {
        this.edgeType = edgeType;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public CoNLLCorefMarkable() {
        this.tokens = new ArrayList();
        this.annotations = new ArrayList();
        this.antecedent = null;
    }

    public CoNLLCorefMarkable(int start) {
        this.tokens = new ArrayList();
        this.annotations = new ArrayList();
        this.start = start;
        this.antecedent = null;
    }

    public CoNLLCorefMarkable(ArrayList<SToken> tokens) {
        this.tokens = tokens;
        this.antecedent = null;
    }

    public ArrayList<SAnnotation> getAnnotations() {
        return this.annotations;
    }

    public ArrayList<SToken> getTokens() {
        return this.tokens;
    }

    public void addAnnotation(String namespace, String annoName, String annoValue) {
        SAnnotation sAnno = SaltFactory.createSAnnotation();
        sAnno.setNamespace(namespace);
        sAnno.setName(annoName);
        sAnno.setValue((Object)annoValue);
        this.annotations.add(sAnno);
    }

    public void addToken(SToken tok) {
        if (!this.tokens.contains(tok)) {
            this.tokens.add(tok);
        }
    }

    void setNodeName(String name) {
        this.nodeName = name;
    }

    public String toString() {
        StringBuilder coveredText = new StringBuilder();
        for (SToken tok : this.tokens) {
            coveredText.append(tok.getId() + " ");
        }
        return "CoNLLCorefMarkable in group " + this.getGroup() + ": " + this.nodeName + " > " + coveredText.toString() + " at token " + this.start;
    }
}

