/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.infoModules;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.io.FileUtils;
import org.corpus_tools.pepper.impl.PepperExporterImpl;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.peppermodules.infoModules.ContainerInfo;
import org.corpus_tools.peppermodules.infoModules.CorpusInfo;
import org.corpus_tools.peppermodules.infoModules.DocumentInfo;
import org.corpus_tools.peppermodules.infoModules.Salt2InfoMapper;
import org.corpus_tools.peppermodules.infoModules.SaltInfoDictionary;
import org.corpus_tools.peppermodules.infoModules.SaltInfoProperties;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusDocumentRelation;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SCorpusRelation;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SPathElement;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="SaltInfoExporterComponent", factory="PepperExporterComponentFactory")
public class SaltInfoExporter
extends PepperExporterImpl
implements PepperExporter,
SaltInfoDictionary {
    public static final String MODULE_NAME = "SaltInfoExporter";
    static final Logger logger = LoggerFactory.getLogger((String)"SaltInfoExporter");
    public static final String SITE_RESOURCES = "site/";
    public static final String CSS_RESOURCES = "css/";
    public static final String XSLT_INFO_TO_HTML = "xslt/saltInfo2html.xsl";
    public static final String XSLT_INDEX_TO_HTML = "xslt/saltInfo2index.xsl";
    public static final String PROJECT_INFO_FILE = "index";
    private static TransformerFactory transFac = null;
    private URI siteResources = null;
    private URI cssResources = null;
    private Map<Identifier, ContainerInfo> sElementId2Container = null;

    public SaltInfoExporter() {
        this.setName(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-SaltInfoModules"));
        this.setDesc("This module produces a corpus-site of a corpus. A corpus-site is a homepage for the corpus containing all annotation names and their values and the frequencies of annotations. The corpus site can be extended for further description, to be used as a documentation. ");
        this.addSupportedFormat("xml", "1.0", null);
        this.addSupportedFormat("html", "5.0", null);
        this.setProperties(new SaltInfoProperties());
        this.setProperties(new SaltInfoProperties());
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        boolean isReady = super.isReadyToStart();
        this.siteResources = URI.createFileURI((String)(this.getResources().toFileString() + (!this.getResources().toFileString().endsWith("/") ? "/" : "") + SITE_RESOURCES));
        this.cssResources = URI.createFileURI((String)(this.getResources().toFileString() + (!this.getResources().toFileString().endsWith("/") ? "/" : "") + SITE_RESOURCES + CSS_RESOURCES));
        File file = new File(this.siteResources.toFileString());
        if (!file.exists()) {
            logger.warn("Pepper module '{}' is not startable, because the folder '{}' does not exist in resource folder: {}.", new Object[]{this.getName(), SITE_RESOURCES, file.getAbsolutePath()});
            isReady = false;
        }
        if (!(file = new File(this.cssResources.toFileString())).exists()) {
            logger.warn("Pepper module '{}' is not startable, because the folder '{}' does not exist in resource folder: {}.", new Object[]{this.getName(), CSS_RESOURCES, file.getAbsolutePath()});
            isReady = false;
        }
        transFac = new TransformerFactoryImpl();
        return isReady;
    }

    public void start() throws PepperModuleException {
        this.sElementId2Container = new Hashtable<Identifier, ContainerInfo>();
        ContainerInfo cont = null;
        for (SCorpusGraph sCorpusGraph : this.getSaltProject().getCorpusGraphs()) {
            for (SCorpus sCorpus : sCorpusGraph.getCorpora()) {
                cont = new CorpusInfo();
                cont.setsName(sCorpus.getName());
                cont.setIdf(sCorpus.getId());
                this.sElementId2Container.put(sCorpus.getIdentifier(), cont);
            }
            for (SDocument sDocument : sCorpusGraph.getDocuments()) {
                cont = new DocumentInfo();
                cont.setsName(sDocument.getName());
                cont.setIdf(sDocument.getId());
                this.sElementId2Container.put(sDocument.getIdentifier(), cont);
            }
        }
        super.start();
    }

    public PepperMapper createPepperMapper(Identifier id) {
        Salt2InfoMapper mapper = new Salt2InfoMapper();
        mapper.setContainerInfo(this.sElementId2Container.get(id));
        if (id != null && id.getIdentifiableElement() != null) {
            if (!(id.getIdentifiableElement() instanceof SDocument) && id.getIdentifiableElement() instanceof SCorpus) {
                SCorpus sCorpus = (SCorpus)id.getIdentifiableElement();
                CorpusInfo corpInfo = (CorpusInfo)mapper.getContainerInfo();
                for (Relation edge : sCorpus.getGraph().getOutRelations(sCorpus.getId())) {
                    if (!(edge instanceof SCorpusRelation) && !(edge instanceof SCorpusDocumentRelation)) continue;
                    ContainerInfo cont = this.sElementId2Container.get(edge.getTarget().getIdentifier());
                    corpInfo.getContainerInfos().add(cont);
                }
            }
            URI resource = URI.createFileURI((String)this.getCorpusDesc().getCorpusPath().toFileString());
            for (String segment : ((SPathElement)id.getIdentifiableElement()).getPath().segments()) {
                resource = resource.appendSegment(segment);
            }
            resource = resource.appendFileExtension("xml");
            mapper.setResourceURI(resource);
            mapper.getContainerInfo().setExportFile(new File(resource.toFileString()));
            URI xslt = URI.createFileURI((String)(this.getResources().toFileString() + (!this.getResources().toFileString().endsWith("/") ? "/" : "") + XSLT_INFO_TO_HTML));
            Transformer transformer = SaltInfoExporter.loadXSLTTransformer(xslt.toFileString());
            mapper.setXsltTransformer(transformer);
        }
        return mapper;
    }

    public void end() throws PepperModuleException {
        File[] cssFiles;
        XMLStreamWriter xml;
        super.end();
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        File projectInfoFile = new File(this.getCorpusDesc().getCorpusPath().appendSegment(PROJECT_INFO_FILE).appendFileExtension("xml").toFileString());
        try {
            xml = xof.createXMLStreamWriter(new FileWriter(projectInfoFile));
        }
        catch (IOException | XMLStreamException e) {
            throw new PepperModuleException("Cannot write salt info to file '" + projectInfoFile + "'. ", (Throwable)e);
        }
        try {
            this.writeProjectInfo(this.getSaltProject(), xml);
        }
        catch (XMLStreamException e) {
            throw new PepperModuleException((PepperModule)this, "Cannot write salt info project file '" + projectInfoFile + "'. ", (Throwable)e);
        }
        if (((SaltInfoProperties)this.getProperties()).isHtmlOutput().booleanValue()) {
            URI htmlOutput = this.getCorpusDesc().getCorpusPath().appendSegment(PROJECT_INFO_FILE).appendFileExtension("html");
            URI xmlInput = URI.createFileURI((String)projectInfoFile.getAbsolutePath());
            URI xslt = URI.createFileURI((String)(this.getResources().toFileString() + (!this.getResources().toFileString().endsWith("/") ? "/" : "") + XSLT_INDEX_TO_HTML));
            Transformer transformer = SaltInfoExporter.loadXSLTTransformer(xslt.toFileString());
            SaltInfoExporter.applyXSLT(transformer, xmlInput, htmlOutput);
        }
        File resourceFolder = new File(this.siteResources.toFileString());
        File cssFolder = new File(this.cssResources.toFileString());
        if (resourceFolder != null && !resourceFolder.exists()) {
            logger.warn("Cannot export the resources for project site, since the resource folder is null or does not exist: " + resourceFolder);
        } else {
            try {
                if (((SaltInfoProperties)this.getProperties()).getHtmlInterpretation().booleanValue()) {
                    try {
                        File jsFile = new File(this.getResources().toFileString() + "site/js/saltinfo.js");
                        String fileContext = FileUtils.readFileToString((File)jsFile);
                        fileContext = fileContext.replaceAll("var INTERPRET_AS_HTML = false;", "var INTERPRET_AS_HTML = true;");
                        FileUtils.write((File)jsFile, (CharSequence)fileContext);
                    }
                    catch (IOException e) {
                        logger.warn("No java script file found. Html elements in the short corpus description will be escaped.");
                    }
                }
                FileUtils.copyDirectory((File)resourceFolder, (File)new File(this.getCorpusDesc().getCorpusPath().toFileString()), (FileFilter)new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        String name = pathname.getName();
                        return !name.contains("theme_") || !pathname.isDirectory();
                    }
                }, (boolean)true);
            }
            catch (IOException e) {
                logger.warn("Cannot export the resources for project site, because of a nested exception: " + e.getMessage());
            }
        }
        String theme_value = null;
        if ("default".equals(((SaltInfoProperties)this.getProperties()).getTheme())) {
            theme_value = "default";
        } else if ("historic".equals(((SaltInfoProperties)this.getProperties()).getTheme())) {
            theme_value = "historic";
        }
        File theme = new File(this.getCorpusDesc().getCorpusPath().toFileString() + "/css/theme/");
        for (File css : cssFiles = cssFolder.listFiles()) {
            if (!css.isDirectory()) continue;
            try {
                FileUtils.copyDirectory((File)new File(this.cssResources.toFileString() + "theme_" + theme_value), (File)theme);
            }
            catch (IOException e) {
                logger.warn("Cannot export the css_theme-resources for project site, because of a nested exception: " + e.getMessage());
            }
        }
    }

    private void writeProjectInfo(SaltProject saltProject, XMLStreamWriter xml) throws XMLStreamException {
        List roots;
        xml.writeStartDocument();
        xml.writeStartElement("saltProjectInfo");
        String name = PROJECT_INFO_FILE;
        if (saltProject.getCorpusGraphs().size() == 1 && (roots = ((SCorpusGraph)saltProject.getCorpusGraphs().get(0)).getRoots()).size() == 1) {
            name = ((SNode)roots.get(0)).getName();
        }
        xml.writeAttribute("sName", name);
        Date date = new Date();
        SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        xml.writeAttribute("generatedOn", dformat.format(date));
        for (SCorpusGraph sCorpusGraph : saltProject.getCorpusGraphs()) {
            List roots2 = sCorpusGraph.getRoots();
            if (roots2 == null || roots2.isEmpty()) continue;
            for (SNode sRoot : roots2) {
                ContainerInfo cont = this.sElementId2Container.get(sRoot.getIdentifier());
                this.writeContainerInfoRec(cont, xml);
            }
        }
        xml.writeEndElement();
        xml.writeEndDocument();
        xml.flush();
    }

    private void writeContainerInfoRec(ContainerInfo cont, XMLStreamWriter xml) throws XMLStreamException {
        if (cont != null) {
            if (cont.getExportFile() == null) {
                logger.warn("Cannot store project info file, because no file is given for ContainerInfo '" + cont.getId() + "'. ");
                cont.setStatus(ContainerInfo.STATUS.ERROR);
            } else {
                String containerTag = null;
                if (cont instanceof CorpusInfo) {
                    containerTag = "sCorpusInfo";
                } else if (cont instanceof DocumentInfo) {
                    containerTag = "sDocumentInfo";
                }
                xml.writeStartElement(containerTag);
                xml.writeAttribute("sName", cont.getsName());
                xml.writeAttribute("id", cont.getId());
                String location = "";
                try {
                    location = cont.getExportFile().getCanonicalPath().replace(this.getCorpusDesc().getCorpusPath().toFileString(), "");
                }
                catch (IOException e) {
                    location = cont.getExportFile().getAbsolutePath().replace(this.getCorpusDesc().getCorpusPath().toFileString(), "");
                }
                if (location.startsWith("/")) {
                    location.replaceFirst("/", "");
                }
                xml.writeAttribute("rel-location", location);
                if (cont instanceof CorpusInfo) {
                    for (ContainerInfo sub : ((CorpusInfo)cont).getContainerInfos()) {
                        this.writeContainerInfoRec(sub, xml);
                    }
                }
                xml.writeEndElement();
            }
        }
    }

    public static void applyXSLT(Transformer transformer, URI xml, URI out) {
        StreamSource source = new StreamSource(new File(xml.toFileString()));
        StreamResult result = new StreamResult(new File(out.toFileString()));
        try {
            transformer.transform(source, result);
            logger.debug(String.format("XSL-Transformation completed %s", out.path()));
        }
        catch (TransformerException e) {
            logger.debug("Failed to transform to :\t\t" + out.toFileString());
            logger.debug("from:\t\t" + xml.toFileString());
            logger.debug("with:\t\t" + transformer.toString());
            throw new PepperModuleException(String.format("Can't generate HTML output %s", xml), (Throwable)e);
        }
    }

    private static Transformer loadXSLTTransformer(String path) {
        File xslt = new File(path);
        if (!xslt.exists()) {
            throw new PepperModuleException("Cannot find xslt transformation to create html output at location " + xslt.getAbsolutePath());
        }
        Transformer t = null;
        try {
            StreamSource xsltSource = new StreamSource(xslt);
            t = transFac.newTransformer(xsltSource);
        }
        catch (Exception e) {
            throw new PepperModuleException("Can't create xslt transformer for " + path, (Throwable)e);
        }
        return t;
    }
}

