/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.infoModules;

import javax.xml.transform.Transformer;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.infoModules.ContainerInfo;
import org.corpus_tools.peppermodules.infoModules.CorpusInfo;
import org.corpus_tools.peppermodules.infoModules.DocumentInfo;
import org.corpus_tools.peppermodules.infoModules.SaltInfoExporter;
import org.corpus_tools.peppermodules.infoModules.SaltInfoProperties;
import org.corpus_tools.salt.core.SNode;
import org.eclipse.emf.common.util.URI;

public class Salt2InfoMapper
extends PepperMapperImpl {
    private ContainerInfo containerInfo = null;
    private Transformer xsltTransformer = null;

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public void setContainerInfo(ContainerInfo containerInfo) {
        this.containerInfo = containerInfo;
    }

    public Transformer getXsltTransformer() {
        return this.xsltTransformer;
    }

    public void setXsltTransformer(Transformer xsltTransformer) {
        this.xsltTransformer = xsltTransformer;
    }

    public DOCUMENT_STATUS mapSCorpus() {
        if (this.getCorpus() != null) {
            for (ContainerInfo cont : ((CorpusInfo)this.getContainerInfo()).getContainerInfos()) {
                while (!ContainerInfo.STATUS.FINISHED.equals((Object)cont.getStatus()) && !ContainerInfo.STATUS.ERROR.equals((Object)cont.getStatus())) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        throw new PepperModuleException((PepperMapper)this, "Cannot send thread to sleep, which is storing corpus '" + this.getCorpus().getId() + "'. ", (Throwable)e);
                    }
                }
            }
            this.getContainerInfo().write((SNode)this.getCorpus());
            if (((SaltInfoProperties)this.getProperties()).isHtmlOutput().booleanValue()) {
                URI htmlOutput = URI.createFileURI((String)this.getResourceURI().toFileString().replace(".xml", ".html"));
                SaltInfoExporter.applyXSLT(this.getXsltTransformer(), this.getResourceURI(), htmlOutput);
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument() != null && this.getDocument().getDocumentGraph() != null) {
            ((DocumentInfo)this.getContainerInfo()).retrieveData(this.getDocument());
            this.getContainerInfo().write((SNode)this.getDocument());
            if (((SaltInfoProperties)this.getProperties()).isHtmlOutput().booleanValue()) {
                URI htmlOutput = URI.createFileURI((String)this.getResourceURI().toFileString().replace(".xml", ".html"));
                SaltInfoExporter.applyXSLT(this.getXsltTransformer(), this.getResourceURI(), htmlOutput);
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }
}

