/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.infoModules;

import java.util.Hashtable;
import java.util.Map;
import org.corpus_tools.peppermodules.infoModules.ContainerInfo;
import org.corpus_tools.peppermodules.infoModules.SaltInfoDictionary;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;

public class DocumentInfo
extends ContainerInfo
implements SaltInfoDictionary {
    public void retrieveData(SDocument document) {
        Map<String, ContainerInfo.AnnotationInfo> annos;
        Map<String, ContainerInfo.AnnotationInfo> annos2;
        for (SMetaAnnotation sMeta : document.getMetaAnnotations()) {
            this.getMetaDataInfo().put((Object)sMeta.getQName(), (Object)sMeta.getValue_STEXT());
        }
        if (document.getDocumentGraph().getNodes().size() != 0) {
            this.getStructuralInfo().occurance_SNode = document.getDocumentGraph().getNodes().size();
        }
        if (document.getDocumentGraph().getTimeline() != null) {
            this.getStructuralInfo().occurance_STimeline = 1;
        }
        if (document.getDocumentGraph().getTextualDSs().size() != 0) {
            this.getStructuralInfo().occurance_STextualDS = document.getDocumentGraph().getTextualDSs().size();
        }
        if (document.getDocumentGraph().getTokens().size() != 0) {
            this.getStructuralInfo().occurance_SToken = document.getDocumentGraph().getTokens().size();
        }
        if (document.getDocumentGraph().getSpans().size() != 0) {
            this.getStructuralInfo().occurance_SSpan = document.getDocumentGraph().getSpans().size();
        }
        if (document.getDocumentGraph().getStructures().size() != 0) {
            this.getStructuralInfo().occurance_SStructure = document.getDocumentGraph().getStructures().size();
        }
        if (document.getDocumentGraph().getRelations().size() != 0) {
            this.getStructuralInfo().occurance_SRelation = document.getDocumentGraph().getRelations().size();
        }
        if (document.getDocumentGraph().getSpanningRelations().size() != 0) {
            this.getStructuralInfo().occurance_SSpanningRelation = document.getDocumentGraph().getSpanningRelations().size();
        }
        if (document.getDocumentGraph().getDominanceRelations().size() != 0) {
            this.getStructuralInfo().occurance_SDominanceRelation = document.getDocumentGraph().getDominanceRelations().size();
        }
        if (document.getDocumentGraph().getOrderRelations().size() != 0) {
            this.getStructuralInfo().occurance_SOrderRelation = document.getDocumentGraph().getOrderRelations().size();
        }
        if (document.getDocumentGraph().getPointingRelations().size() != 0) {
            this.getStructuralInfo().occurance_SPointingRelation = document.getDocumentGraph().getPointingRelations().size();
        }
        for (SNode node : document.getDocumentGraph().getNodes()) {
            if (node.getLayers() != null && node.getLayers().size() > 0) {
                for (SLayer sLayer : node.getLayers()) {
                    annos2 = this.getAnnotations().get(sLayer.getName());
                    if (annos2 == null) {
                        annos2 = new Hashtable<String, ContainerInfo.AnnotationInfo>();
                        this.getAnnotations().put(sLayer.getName(), annos2);
                    }
                    this.retrieveAnnotations((SAnnotationContainer)node, annos2);
                }
                continue;
            }
            annos = this.getAnnotations().get("_NO_LAYER_");
            if (annos == null) {
                annos = new Hashtable<String, ContainerInfo.AnnotationInfo>();
                this.getAnnotations().put("_NO_LAYER_", annos);
            }
            this.retrieveAnnotations((SAnnotationContainer)node, annos);
        }
        for (SRelation rel : document.getDocumentGraph().getRelations()) {
            if (rel.getLayers() == null && rel.getLayers().size() > 0) {
                for (SLayer layer : rel.getLayers()) {
                    annos2 = this.getAnnotations().get(layer.getName());
                    if (annos2 == null) {
                        annos2 = new Hashtable<String, ContainerInfo.AnnotationInfo>();
                        this.getAnnotations().put(layer.getName(), annos2);
                    }
                    this.retrieveAnnotations((SAnnotationContainer)rel, annos2);
                }
                continue;
            }
            annos = this.getAnnotations().get("_NO_LAYER_");
            if (annos == null) {
                annos = new Hashtable<String, ContainerInfo.AnnotationInfo>();
                this.getAnnotations().put("_NO_LAYER_", annos);
            }
            this.retrieveAnnotations((SAnnotationContainer)rel, annos);
        }
    }

    private void retrieveAnnotations(SAnnotationContainer sElem, Map<String, ContainerInfo.AnnotationInfo> annotations) {
        if (sElem != null && annotations != null) {
            for (SAnnotation sAnno : sElem.getAnnotations()) {
                ContainerInfo.AnnotationInfo annoInfo = annotations.get(sAnno.getName());
                if (annoInfo == null) {
                    annoInfo = new ContainerInfo.AnnotationInfo();
                    annotations.put(sAnno.getName(), annoInfo);
                }
                annoInfo.add(sAnno.getValue_STEXT());
            }
        }
    }

    public void write(SDocument sDocument) {
        this.retrieveData(sDocument);
        super.write((SNode)sDocument);
    }
}

