/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.infoModules;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.infoModules.SaltInfoDictionary;
import org.corpus_tools.peppermodules.infoModules.StructuralInfo;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.SNode;

public abstract class ContainerInfo
implements SaltInfoDictionary {
    private volatile STATUS status = STATUS.NOT_STARTED;
    public static final String NO_LAYER = "_NO_LAYER_";
    private StructuralInfo structuralInfo = new StructuralInfo();
    private String sName = "null";
    private String sId = "null";
    private File exportFile = null;
    private Multimap<String, String> metaDataInfo = null;
    private Map<String, Map<String, AnnotationInfo>> annotations = null;

    public STATUS getStatus() {
        return this.status;
    }

    public void setStatus(STATUS status) {
        this.status = status;
    }

    public StructuralInfo getStructuralInfo() {
        return this.structuralInfo;
    }

    public String getsName() {
        return this.sName;
    }

    public void setsName(String sName) {
        this.sName = sName;
    }

    public String getId() {
        return this.sId;
    }

    public void setIdf(String sId) {
        this.sId = sId;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public void setExportFile(File exportFile) {
        this.exportFile = exportFile;
    }

    public Multimap<String, String> getMetaDataInfo() {
        if (this.metaDataInfo == null) {
            this.metaDataInfo = HashMultimap.create();
        }
        return this.metaDataInfo;
    }

    public Map<String, Map<String, AnnotationInfo>> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new Hashtable<String, Map<String, AnnotationInfo>>();
        }
        return this.annotations;
    }

    public void write(SNode sNode) {
        XMLStreamWriter xml;
        if (this.getExportFile() == null) {
            throw new PepperModuleException("Cannot create SaltInfo for '" + sNode.getId() + "', because no file to export is given. ");
        }
        if (!this.getExportFile().getParentFile().exists()) {
            this.getExportFile().getParentFile().mkdirs();
        }
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        try {
            xml = xof.createXMLStreamWriter(new FileWriter(this.getExportFile()));
        }
        catch (IOException | XMLStreamException e) {
            throw new PepperModuleException("Cannot write salt info to file '" + this.getExportFile() + "'. ", (Throwable)e);
        }
        this.write(sNode, xml);
    }

    public void write(SNode sNode, XMLStreamWriter xml) {
        this.setStatus(STATUS.STARTED);
        try {
            xml.writeStartDocument();
            if (sNode instanceof SDocument) {
                xml.writeStartElement("sDocumentInfo");
            } else if (sNode instanceof SCorpus) {
                xml.writeStartElement("sCorpusInfo");
            }
            Date date = new Date();
            SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            xml.writeAttribute("generatedOn", dformat.format(date));
            xml.writeAttribute("sName", sNode.getName() != null ? sNode.getName() : "");
            xml.writeAttribute("id", sNode.getId() != null ? sNode.getId() : "");
            this.writeMetaDataInfo(xml);
            if (this.getStructuralInfo() != null) {
                this.getStructuralInfo().write(xml);
            }
            Map<String, AnnotationInfo> annotations = this.getAnnotations().get(NO_LAYER);
            this.writeAnnotations(annotations, xml);
            for (String sLayerName : this.getAnnotations().keySet()) {
                if (NO_LAYER.equals(sLayerName)) continue;
                xml.writeStartElement("sLayerInfo");
                xml.writeAttribute("sName", sLayerName);
                this.writeAnnotations(this.getAnnotations().get(sLayerName), xml);
                xml.writeEndElement();
            }
            xml.writeEndElement();
            xml.writeEndDocument();
            xml.flush();
        }
        catch (XMLStreamException e) {
            this.setStatus(STATUS.ERROR);
            throw new PepperModuleException("Cannot write salt info of sDocument or SCorpus '" + sNode.getId() + "' to stream. ", (Throwable)e);
        }
        this.setStatus(STATUS.FINISHED);
    }

    public void writeMetaDataInfo(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeStartElement("metaDataInfo");
        for (String key : this.getMetaDataInfo().keySet()) {
            xml.writeStartElement("entry");
            xml.writeAttribute("key", key);
            String sMetaValue = null;
            int i = 0;
            for (String sMetaDate : this.getMetaDataInfo().get((Object)key)) {
                sMetaValue = i == 0 ? sMetaDate : sMetaValue + ", " + sMetaDate;
                ++i;
            }
            xml.writeCharacters(sMetaValue);
            xml.writeEndElement();
        }
        xml.writeEndElement();
    }

    private void writeAnnotations(Map<String, AnnotationInfo> annotations, XMLStreamWriter xml) throws XMLStreamException {
        if (annotations != null) {
            for (String annoName : annotations.keySet()) {
                xml.writeStartElement("sAnnotationInfo");
                xml.writeAttribute("sName", annoName);
                xml.writeAttribute("occurrence", annotations.get((Object)annoName).occurrence.toString());
                for (String annoValue : annotations.get(annoName).keySet()) {
                    xml.writeStartElement("sValue");
                    xml.writeAttribute("occurrence", annotations.get(annoName).get(annoValue).toString());
                    xml.writeCharacters(annoValue);
                    xml.writeEndElement();
                }
                xml.writeEndElement();
            }
        }
    }

    public class AnnotationInfo {
        public Map<String, Integer> annotations = new Hashtable<String, Integer>();
        public Integer occurrence = 0;

        public void add(String sAnnoValue) {
            if (sAnnoValue != null && !sAnnoValue.isEmpty()) {
                Integer n = this.occurrence;
                Integer n2 = this.occurrence = Integer.valueOf(this.occurrence + 1);
                Integer occurrence = this.annotations.get(sAnnoValue);
                if (occurrence == null) {
                    this.annotations.put(sAnnoValue, 1);
                } else {
                    occurrence = occurrence + 1;
                    this.annotations.put(sAnnoValue, occurrence);
                }
            }
        }

        public Set<String> keySet() {
            return this.annotations.keySet();
        }

        public Object get(String key) {
            return this.annotations.get(key);
        }
    }

    static enum STATUS {
        NOT_STARTED,
        STARTED,
        FINISHED,
        ERROR;

    }
}

