/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.spreadsheet;

import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;

public class SpreadsheetImporterProperties
extends PepperModuleProperties {
    private static final long serialVersionUID = 6193481351811254201L;
    public static final String PROP_PRIMARY_TEXT = "primText";
    public static final String PROP_CORPUS_SHEET = "corpusSheet";
    public static final String PROP_META_SHEET = "metaSheet";
    public static final String PROP_ANNO_REFERS_TO = "annoPrimRel";
    public static final String PROP_SET_LAYER = "setLayer";
    public static final String PROP_META_ANNO = "metaAnnotation";
    public static final String PROP_INCLUDE_EMPTY_PRIM_CELLS = "includeEmptyPrimCells";
    public static final String PROP_ADD_ORDER_RELATION = "addOrderRelation";
    public static final String PROP_ANNO_SHORT_PRIM_REL = "shortAnnoPrimRel";

    public SpreadsheetImporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_PRIMARY_TEXT, String.class, "Defines the name of the column(s), that hold the primary text, this can either be a single column name, or a comma seperated enumeration of column names (key: 'primText', default value: 'tok').", (Object)"tok", false));
        this.addProperty(new PepperModuleProperty(PROP_CORPUS_SHEET, String.class, "Defines the sheet, that holds the actual corpus information (key: 'corpusSheet', default is 'Tabelle1'). By default the first sheet of your spreadsheets will be used (independent of the name).", (Object)"Tabelle1", false));
        this.addProperty(new PepperModuleProperty(PROP_ANNO_REFERS_TO, String.class, "Defines which annotation tier refers to which primary text tier in a direct way, therefor the annotation tier name is followed by the name of the tier, that holds the primary text in square brackets. A possible key-value set could be: key='annoPrimRel', value='anno1=anno1[tok1]' (key: 'annoPrimRel', default is 'null').", null, false));
        this.addProperty(new PepperModuleProperty(PROP_SET_LAYER, String.class, "Defines the corresponding layer to the given annotation layer (key: 'setLayer') ", null, false));
        this.addProperty(new PepperModuleProperty(PROP_META_SHEET, String.class, "Defines the sheet, that holds the meta information of the document (key: 'metaSheet', default is 'Tabelle2'). By default the second sheet of your spreadsheets will be used (independent of the name).", (Object)"Tabelle2", false));
        this.addProperty(new PepperModuleProperty(PROP_META_ANNO, Boolean.class, "Defines, if another sheet shall be scaned for meta annotation (key: 'metaAnnotation', default is 'true').", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_INCLUDE_EMPTY_PRIM_CELLS, Boolean.class, "If true allow empty cells of primary text, default is 'false'.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_ADD_ORDER_RELATION, Boolean.class, "If true add an explicit order relation between each primary text token. Default is 'true'.", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_ANNO_SHORT_PRIM_REL, String.class, "Defines which primary text tiers are the basis of which annotation tiers, therefor a comma seperated list of primary text tiers, followed by a list of all annotations that refer to the primary tier, is needed. A possible key-value set could be: key='shortAnnoPrimRel', value='primText1={anno1, anno2}, primText2={anno3}' (key: 'annoPrimRel', default is 'null').", null, false));
    }

    public String getPrimaryText() {
        return (String)this.getProperty(PROP_PRIMARY_TEXT).getValue();
    }

    public String getCorpusSheet() {
        return (String)this.getProperty(PROP_CORPUS_SHEET).getValue();
    }

    public String getMetaSheet() {
        return (String)this.getProperty(PROP_META_SHEET).getValue();
    }

    public String getAnnoPrimRel() {
        return (String)this.getProperty(PROP_ANNO_REFERS_TO).getValue();
    }

    public String getShortAnnoPrimRel() {
        return (String)this.getProperty(PROP_ANNO_SHORT_PRIM_REL).getValue();
    }

    public String getLayer() {
        return (String)this.getProperty(PROP_SET_LAYER).getValue();
    }

    public Boolean getMetaAnnotation() {
        return (Boolean)this.getProperty(PROP_META_ANNO).getValue();
    }

    public Boolean getIncludeEmptyPrimCells() {
        return (Boolean)this.getProperty(PROP_INCLUDE_EMPTY_PRIM_CELLS).getValue();
    }

    public Boolean getAddOrderRelation() {
        return (Boolean)this.getProperty(PROP_ADD_ORDER_RELATION).getValue();
    }
}

