/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.spreadsheet;

import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.peppermodules.spreadsheet.Spreadsheet2SaltMapper;
import org.corpus_tools.peppermodules.spreadsheet.SpreadsheetImporterProperties;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="SpreadsheetImporterComponent", factory="PepperImporterComponentFactory")
public class SpreadsheetImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final String MODULE_NAME = "SpreadsheetImporter";
    static final Logger logger = LoggerFactory.getLogger((String)"SpreadsheetImporter");

    public SpreadsheetImporter() {
        this.setSupplierContact(URI.createFileURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setName(MODULE_NAME);
        this.addSupportedFormat("xls", "97-2008", null);
        this.addSupportedFormat("xlsx", "2007+", null);
        this.getDocumentEndings().add("xlsx");
        this.getDocumentEndings().add("xls");
        this.setIsMultithreaded(true);
        this.setProperties(new SpreadsheetImporterProperties());
    }

    public PepperMapper createPepperMapper(Identifier identifier) {
        Spreadsheet2SaltMapper mapper = new Spreadsheet2SaltMapper();
        if (identifier.getIdentifiableElement() != null && identifier.getIdentifiableElement() instanceof SDocument) {
            URI resource = (URI)this.getIdentifier2ResourceTable().get(identifier);
            mapper.setResourceURI(resource);
        }
        return mapper;
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        return super.isReadyToStart();
    }
}

