/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.spreadsheet;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.peppermodules.spreadsheet.SpreadsheetImporter;
import org.corpus_tools.peppermodules.spreadsheet.SpreadsheetImporterProperties;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STimeline;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.eclipse.emf.common.util.URI;

public class Spreadsheet2SaltMapper
extends PepperMapperImpl
implements PepperMapper {
    public SpreadsheetImporterProperties getProps() {
        return (SpreadsheetImporterProperties)this.getProperties();
    }

    public DOCUMENT_STATUS mapSDocument() {
        URI resourceURI = this.getResourceURI();
        String resource = resourceURI.path();
        this.readSpreadsheetResource(resource);
        return DOCUMENT_STATUS.COMPLETED;
    }

    private void readSpreadsheetResource(String resource) {
        this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        STimeline timeline = SaltFactory.createSTimeline();
        this.getDocument().getDocumentGraph().setTimeline(timeline);
        SpreadsheetImporter.logger.debug("Importing the file {}.", (Object)resource);
        SpreadsheetImporter.logger.info(resource);
        Workbook workbook = null;
        try {
            File excelFile = new File(resource);
            FileInputStream excelFileStream = new FileInputStream(excelFile);
            workbook = WorkbookFactory.create((InputStream)excelFileStream);
            workbook.close();
        }
        catch (IOException | EncryptedDocumentException | InvalidFormatException e) {
            SpreadsheetImporter.logger.warn("Could not open file '" + resource + "'.");
        }
        this.getPrimTextTiers(workbook, timeline);
    }

    private void mapLinenumber2STimeline(int lastRow, STimeline timeline) {
        for (int currRow = 1; currRow <= lastRow; ++currRow) {
            timeline.increasePointOfTime();
        }
    }

    private Table<Integer, Integer, CellRangeAddress> calculateMergedCellIndex(List<CellRangeAddress> mergedCells) {
        HashBasedTable idx = HashBasedTable.create();
        if (mergedCells != null) {
            for (CellRangeAddress cell : mergedCells) {
                for (int i = cell.getFirstRow(); i <= cell.getLastRow(); ++i) {
                    for (int j = cell.getFirstColumn(); j <= cell.getLastColumn(); ++j) {
                        idx.put((Object)i, (Object)j, (Object)cell);
                    }
                }
            }
        }
        return Tables.unmodifiableTable((Table)idx);
    }

    private void getPrimTextTiers(Workbook workbook, STimeline timeline) {
        String primaryTextTier = this.getProps().getPrimaryText();
        List<String> primaryTextTierList = Arrays.asList(primaryTextTier.split("\\s*,\\s*"));
        TreeSet<String> annosWithoutPrim = new TreeSet<String>();
        if (workbook != null) {
            Sheet corpusSheet = this.getProps().getCorpusSheet().equals("Tabelle1") ? workbook.getSheetAt(0) : workbook.getSheet(this.getProps().getCorpusSheet());
            int lastRow = corpusSheet.getLastRowNum();
            this.mapLinenumber2STimeline(lastRow, timeline);
            if (corpusSheet != null) {
                Row headerRow = corpusSheet.getRow(0);
                HashMap<Integer, Integer> annoPrimRelations = new HashMap<Integer, Integer>();
                ArrayList<Integer> primTextPos = new ArrayList<Integer>();
                if (headerRow != null) {
                    int currColumn = 0;
                    ArrayList<String> emptyColumnList = new ArrayList<String>();
                    while (currColumn < headerRow.getPhysicalNumberOfCells()) {
                        if (headerRow.getCell(currColumn) == null || headerRow.getCell(currColumn).toString().isEmpty()) {
                            String emptyColumn = CellReference.convertNumToColString((int)currColumn);
                            emptyColumnList.add(emptyColumn);
                            ++currColumn;
                            continue;
                        }
                        if (!emptyColumnList.isEmpty()) {
                            for (String emptyColumn : emptyColumnList) {
                                SpreadsheetImporter.logger.warn("Column \"" + emptyColumn + "\" in document \"" + this.getResourceURI().lastSegment() + "\" has no name.");
                            }
                            emptyColumnList = new ArrayList();
                        }
                        boolean primWasFound = false;
                        String tierName = headerRow.getCell(currColumn).toString();
                        if (primaryTextTierList.contains(tierName)) {
                            primTextPos.add(currColumn);
                            primWasFound = true;
                        } else if (tierName.matches(".+\\[.+\\]") || this.getProps().getAnnoPrimRel() != null || this.getProps().getShortAnnoPrimRel() != null) {
                            String primOfAnnoFromConfig;
                            if (tierName.matches(".+\\[.+\\]")) {
                                String primTier = tierName.split("\\[")[1].replace("]", "");
                                this.setAnnotationPrimCouple(primTier, annoPrimRelations, currColumn, headerRow);
                                primWasFound = true;
                            }
                            if ((primOfAnnoFromConfig = this.getPrimOfAnnoPrimRel(tierName.split("\\[")[0])) != null) {
                                this.setAnnotationPrimCouple(primOfAnnoFromConfig, annoPrimRelations, currColumn, headerRow);
                                primWasFound = true;
                            }
                        } else if (primaryTextTierList.size() == 1 && this.getProps().getAnnoPrimRel() == null && this.getProps().getShortAnnoPrimRel() == null) {
                            this.setAnnotationPrimCouple(primaryTextTierList.get(0), annoPrimRelations, currColumn, headerRow);
                            primWasFound = true;
                        }
                        if (!primWasFound) {
                            annosWithoutPrim.add(tierName);
                        }
                        ++currColumn;
                    }
                }
                Map<String, SLayer> layerTierCouples = this.getLayerTierCouples();
                Table<Integer, Integer, CellRangeAddress> mergedCells = null;
                if (corpusSheet.getNumMergedRegions() > 0) {
                    mergedCells = this.calculateMergedCellIndex(corpusSheet.getMergedRegions());
                }
                int progressTotalNumberOfColumns = 0;
                if (!primTextPos.isEmpty()) {
                    progressTotalNumberOfColumns = this.setPrimText(corpusSheet, primTextPos, annoPrimRelations, headerRow, mergedCells, layerTierCouples);
                } else {
                    SpreadsheetImporter.logger.warn("No primary text for the document \"" + this.getResourceURI().lastSegment() + "\" found. Please check the spelling of your properties.");
                }
                this.setAnnotations(annoPrimRelations, corpusSheet, mergedCells, layerTierCouples, progressTotalNumberOfColumns);
            }
            if (this.getProps().getMetaAnnotation().booleanValue()) {
                this.setDocMetaData(workbook);
            }
            if (!annosWithoutPrim.isEmpty()) {
                SpreadsheetImporter.logger.warn("No primary text column found for columns\n- {}\nin document {}. This means these columns are not included in the conversion!", (Object)Joiner.on((String)"\n- ").join(annosWithoutPrim), (Object)this.getResourceURI().toFileString());
            }
        }
    }

    private void setAnnotations(HashMap<Integer, Integer> annoPrimRelations, Sheet corpusSheet, Table<Integer, Integer, CellRangeAddress> mergedCells, Map<String, SLayer> layerTierCouples, int progressProcessedNumberOfColumns) {
        if (!annoPrimRelations.isEmpty()) {
            Row headerRow = corpusSheet.getRow(0);
            DataFormatter formatter = new DataFormatter();
            int progressTotalNumberOfColumns = annoPrimRelations.keySet().size();
            for (int annoTier : annoPrimRelations.keySet()) {
                SSpan annoSpan = null;
                for (int currAnno = 1; currAnno < corpusSheet.getPhysicalNumberOfRows(); ++currAnno) {
                    String annoName = headerRow.getCell(annoTier).toString();
                    Row row = corpusSheet.getRow(currAnno);
                    Cell annoCell = row.getCell(annoTier);
                    if (annoCell != null && !annoCell.toString().isEmpty()) {
                        String annoText = "";
                        annoText = formatter.formatCellValue(annoCell);
                        int annoStart = currAnno - 1;
                        int annoEnd = this.getLastCell(annoCell, mergedCells);
                        DataSourceSequence sequence = new DataSourceSequence();
                        sequence.setStart((Number)annoStart);
                        sequence.setEnd((Number)annoEnd);
                        sequence.setDataSource((SSequentialDS)this.getDocument().getDocumentGraph().getTimeline());
                        List sTokens = this.getDocument().getDocumentGraph().getTokensBySequence(sequence);
                        ArrayList<SToken> tokenOfSpan = new ArrayList<SToken>();
                        if (sTokens == null) {
                            SpreadsheetImporter.logger.error("Segmentation error: The segmentation of the tier \"" + headerRow.getCell(annoTier).toString() + "\" in the document: \"" + this.getResourceURI().lastSegment() + "\" in line: " + currAnno + " does not match to its primary text: \"" + headerRow.getCell(annoPrimRelations.get(annoTier).intValue()).toString() + "\".");
                        } else {
                            for (SToken tok : sTokens) {
                                STextualDS textualDS = Spreadsheet2SaltMapper.getTextualDSForNode((SNode)tok, this.getDocument().getDocumentGraph());
                                if (!textualDS.getName().equals(headerRow.getCell(annoPrimRelations.get(annoTier).intValue()).toString())) continue;
                                tokenOfSpan.add(tok);
                            }
                        }
                        annoSpan = this.getDocument().getDocumentGraph().createSpan(tokenOfSpan);
                        if (annoSpan != null && annoName != null && !annoName.isEmpty()) {
                            if (annoName.matches(".+\\[.+\\]")) {
                                annoName = annoName.split("\\[")[0];
                            }
                            annoSpan.createAnnotation(null, annoName, (Object)annoText);
                            annoSpan.setName(annoName);
                        }
                    }
                    if (this.getProps().getLayer() == null || annoSpan == null || layerTierCouples.size() <= 0 || layerTierCouples.get(annoName) == null) continue;
                    SLayer sLayer = layerTierCouples.get(annoName);
                    this.getDocument().getDocumentGraph().addLayer((Layer)sLayer);
                    sLayer.addNode(annoSpan);
                }
                this.setProgress((double)(++progressProcessedNumberOfColumns) / (double)progressTotalNumberOfColumns);
            }
        } else {
            SpreadsheetImporter.logger.warn("No annotations except for primary texts found in document \"" + this.getResourceURI().lastSegment() + "\".");
        }
    }

    private int setPrimText(Sheet corpusSheet, List<Integer> primTextPos, HashMap<Integer, Integer> annoPrimRelations, Row headerRow, Table<Integer, Integer, CellRangeAddress> mergedCells, Map<String, SLayer> layerTierCouples) {
        int progressTotalNumberOfColumns = primTextPos.size();
        int progressProcessedNumberOfColumns = 0;
        DataFormatter formatter = new DataFormatter();
        ArrayList<SToken> currentTokList = new ArrayList<SToken>();
        for (int primText : primTextPos) {
            STextualDS primaryText = SaltFactory.createSTextualDS();
            StringBuilder currentText = new StringBuilder();
            if (headerRow.getCell(primText) != null) {
                primaryText.setName(headerRow.getCell(primText).toString());
            }
            this.getDocument().getDocumentGraph().addNode((Node)primaryText);
            int offset = currentText.length();
            SToken lastTok = null;
            for (int currRow = 1; currRow < corpusSheet.getPhysicalNumberOfRows(); ++currRow) {
                Row row = corpusSheet.getRow(currRow);
                Cell primCell = row.getCell(primText);
                SToken currTok = null;
                int endCell = currRow;
                String text = null;
                if (primCell != null && !primCell.toString().isEmpty()) {
                    text = formatter.formatCellValue(primCell);
                } else if (this.getProps().getIncludeEmptyPrimCells().booleanValue()) {
                    text = "";
                }
                if (text != null) {
                    int start = offset;
                    int end = start + text.length();
                    offset += text.length();
                    currentText.append(text);
                    currTok = this.getDocument().getDocumentGraph().createToken((SSequentialDS)primaryText, Integer.valueOf(start), Integer.valueOf(end));
                    if (primCell != null) {
                        endCell = this.getLastCell(primCell, mergedCells);
                    }
                }
                if (currTok != null) {
                    if (lastTok != null && this.getProps().getAddOrderRelation().booleanValue()) {
                        this.addOrderRelation(lastTok, currTok, headerRow.getCell(primText).toString());
                    }
                    this.addTimelineRelation(currTok, currRow, endCell, corpusSheet);
                    currentTokList.add(currTok);
                    if (text != null && currRow != corpusSheet.getLastRowNum()) {
                        currentText.append(" ");
                        ++offset;
                    }
                }
                if (currTok == null) continue;
                lastTok = currTok;
            }
            primaryText.setText(currentText.toString());
            this.setProgress((double)(++progressProcessedNumberOfColumns) / (double)progressTotalNumberOfColumns);
            if (this.getProps().getLayer() == null || currentTokList == null || layerTierCouples.size() <= 0 || layerTierCouples.get(primaryText.getName()) == null) continue;
            SLayer sLayer = layerTierCouples.get(primaryText.getName());
            this.getDocument().getDocumentGraph().addLayer((Layer)sLayer);
            for (SToken t : currentTokList) {
                sLayer.addNode((Node)t);
            }
        }
        return progressProcessedNumberOfColumns;
    }

    private void addTimelineRelation(SToken tok, int currRow, int endTime, Sheet corpusSheet) {
        STimelineRelation sTimeRel = SaltFactory.createSTimelineRelation();
        sTimeRel.setSource((Node)tok);
        sTimeRel.setTarget((Node)this.getDocument().getDocumentGraph().getTimeline());
        sTimeRel.setStart((Number)(currRow - 1));
        sTimeRel.setEnd((Number)endTime);
        this.getDocument().getDocumentGraph().addRelation((Relation)sTimeRel);
    }

    private void addOrderRelation(SToken lastTok, SToken currTok, String name) {
        SOrderRelation primTextOrder = SaltFactory.createSOrderRelation();
        primTextOrder.setType(name);
        primTextOrder.setSource((Node)lastTok);
        primTextOrder.setTarget((Node)currTok);
        this.getDocument().getDocumentGraph().addRelation((Relation)primTextOrder);
    }

    private void setAnnotationPrimCouple(String primTier, HashMap<Integer, Integer> annoPrimRelations, int currColumn, Row headerRow) {
        if (this.getColumn(primTier, headerRow) != null) {
            int primData = this.getColumn(primTier, headerRow);
            if (annoPrimRelations.get(currColumn) != null) {
                SpreadsheetImporter.logger.warn("The annotation \"" + headerRow.getCell(currColumn).toString().split("\\[")[0] + "\" was allready referenced to the primary text in column \"" + annoPrimRelations.get(currColumn) + "\". This reference was overwritten. The new primary text for \"" + headerRow.getCell(currColumn).toString().split("\\[")[0] + "\" is \"" + headerRow.getCell(primData) + "\".");
                annoPrimRelations.remove(currColumn);
                annoPrimRelations.put(currColumn, primData);
            } else {
                annoPrimRelations.put(currColumn, primData);
            }
        } else {
            SpreadsheetImporter.logger.warn("The primary text \"" + primTier + "\" does not exist in the document \"" + this.getResourceURI().lastSegment() + "\".");
        }
    }

    private int getLastCell(Cell cell, Table<Integer, Integer, CellRangeAddress> mergedCellsIdx) {
        int lastCell = cell.getRowIndex();
        CellRangeAddress mergedCell = null;
        if (mergedCellsIdx != null) {
            mergedCell = (CellRangeAddress)mergedCellsIdx.get((Object)cell.getRowIndex(), (Object)cell.getColumnIndex());
        }
        if (mergedCell != null) {
            lastCell = mergedCell.getLastRow();
        }
        return lastCell;
    }

    private String getPrimOfAnnoPrimRel(String currentTier) {
        String annoPrimNew = null;
        if (this.getProps().getAnnoPrimRel() != null && this.getProps().getShortAnnoPrimRel() != null) {
            SpreadsheetImporter.logger.error("Wrong property handling. Please use only one property to specify which annotation refers to which primary text tier (exclusive use of either 'annoPrimRel' or 'shortAnnoPrimRel').");
        } else {
            String shortAnnoPrimRel;
            String annoPrimRel = this.getProps().getAnnoPrimRel();
            if (annoPrimRel != null) {
                if (annoPrimRel.matches("(?s).+],.+") || annoPrimRel.matches("(?s).+]")) {
                    List<String> annoPrimRelation = Arrays.asList(annoPrimRel.split("\\s*,\\s*"));
                    for (String annoPrim : annoPrimRelation) {
                        String[] splitted = annoPrim.split("=", 2);
                        if (splitted.length > 1) {
                            String annoName = splitted[0];
                            String annoPrimCouple = splitted[1];
                            if (!annoName.equals(currentTier)) continue;
                            annoPrimNew = annoPrimCouple.split("\\[")[1].replace("]", "");
                            continue;
                        }
                        SpreadsheetImporter.logger.error("Can not match the annotations to their primary text, because of syntax errors. Please check the syntax of your property settings. The problematic entry is:\n" + annoPrim);
                    }
                } else {
                    SpreadsheetImporter.logger.error("Can not match the annotations to their primary text, because of syntax errors. Please check the syntax of your property settings.");
                }
            }
            if ((shortAnnoPrimRel = this.getProps().getShortAnnoPrimRel()) != null) {
                if (shortAnnoPrimRel.matches("(?s).+},.+") || shortAnnoPrimRel.matches("(?s).+}")) {
                    List<String> shortAnnoPrimRelation = Arrays.asList(shortAnnoPrimRel.split("\\s*},\\s*"));
                    for (String annoPrim : shortAnnoPrimRelation) {
                        List<String> primAnnoPair = Arrays.asList(annoPrim.split("="));
                        if (primAnnoPair.size() == 2) {
                            String[] annos;
                            for (String anno : annos = primAnnoPair.get(1).split("\\s*,\\s*")) {
                                if (!anno.replace("}", "").replace("{", "").equals(currentTier)) continue;
                                annoPrimNew = primAnnoPair.get(0);
                            }
                            continue;
                        }
                        SpreadsheetImporter.logger.error("Can not match the annotations to their primary text because the property settings do not match the needed syntax (missing \"=\"). Please check the syntax of your property settings.");
                    }
                } else {
                    SpreadsheetImporter.logger.error("Can not match the annotations to their primary text, because of syntax errors. Please check the syntax of your property settings.");
                }
            }
        }
        return annoPrimNew;
    }

    private Integer getColumn(String tierName, Row row) {
        Integer searchedColumn = null;
        for (int currCol = 0; currCol < row.getLastCellNum(); ++currCol) {
            if (row.getCell(currCol) == null || !row.getCell(currCol).toString().equals(tierName)) continue;
            searchedColumn = currCol;
        }
        return searchedColumn;
    }

    public static STextualDS getTextualDSForNode(SNode node, SDocumentGraph graph) {
        List dataSources;
        if (node != null && (dataSources = graph.getOverlappedDataSourceSequence(node, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION})) != null) {
            for (DataSourceSequence seq : dataSources) {
                if (!(seq.getDataSource() instanceof STextualDS)) continue;
                return (STextualDS)seq.getDataSource();
            }
        }
        return null;
    }

    private Map<String, SLayer> getLayerTierCouples() {
        String tierLayerCouple = this.getProps().getLayer();
        HashMap<String, SLayer> annoLayerCoupleMap = new HashMap<String, SLayer>();
        if (tierLayerCouple != null && !tierLayerCouple.isEmpty()) {
            if (tierLayerCouple.matches("(?s).+},.+") || tierLayerCouple.matches("(?s).+}")) {
                List<String> annoLayerCoupleList = Arrays.asList(tierLayerCouple.split("\\s*},\\s*"));
                for (String annoLayer : annoLayerCoupleList) {
                    List<String> annoLayerPair = Arrays.asList(annoLayer.split("="));
                    if (annoLayerPair.size() == 2) {
                        String[] assoAnno;
                        SLayer sLayer = SaltFactory.createSLayer();
                        sLayer.setName(annoLayerPair.get(0));
                        for (String tier : assoAnno = annoLayerPair.get(1).split("\\s*,\\s*")) {
                            tier = tier.replace("{", "");
                            tier = tier.replace("}", "");
                            annoLayerCoupleMap.put(tier, sLayer);
                        }
                        continue;
                    }
                    SpreadsheetImporter.logger.error("Can not create SLayer because the property settings do not match the needed syntax (missing \"=\"). Please check the syntax of your property settings.");
                }
            } else {
                SpreadsheetImporter.logger.error("Can not create SLayer because the property settings do not match the needed syntax. Please check the syntax of your property settings.");
            }
        }
        return annoLayerCoupleMap;
    }

    private void setDocMetaData(Workbook workbook) {
        Sheet metaSheet = null;
        if (this.getProps().getMetaSheet().equals("Tabelle2")) {
            if (workbook.getNumberOfSheets() > 1) {
                metaSheet = workbook.getSheetAt(1);
            }
        } else {
            metaSheet = workbook.getSheet(this.getProps().getCorpusSheet());
        }
        if (metaSheet != null) {
            DataFormatter formatter = new DataFormatter();
            for (int currRow = 1; currRow < metaSheet.getPhysicalNumberOfRows(); ++currRow) {
                Row row = metaSheet.getRow(currRow);
                Cell metaKey = row.getCell(0);
                Cell metaValue = row.getCell(1);
                if (metaKey != null && !metaKey.toString().isEmpty()) {
                    if (metaValue != null && !metaValue.toString().isEmpty()) {
                        if (this.getDocument().getMetaAnnotation(metaKey.toString()) == null) {
                            this.getDocument().createMetaAnnotation(null, formatter.formatCellValue(metaKey), (Object)formatter.formatCellValue(metaValue));
                            continue;
                        }
                        SpreadsheetImporter.logger.warn("A meta information with the name \"" + formatter.formatCellValue(metaKey) + "\" allready exists and will not be replaced.");
                        continue;
                    }
                    SpreadsheetImporter.logger.warn("No value for the meta data: \"" + metaKey.toString() + "\" found.");
                    continue;
                }
                if (metaValue == null || metaValue.toString().isEmpty()) continue;
                SpreadsheetImporter.logger.warn("No meta annotation name for the value \"" + metaValue.toString() + "\" found.");
            }
        }
    }
}

