/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepperModules_CounterModule;

import java.util.List;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperManipulatorImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="CounterModuleManipulatorComponent", factory="PepperManipulatorComponentFactory")
public class CounterModuleManipulator
extends PepperManipulatorImpl {
    public CounterModuleManipulator() {
        this.setName("Counter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This manipulator adds the token number to each token and can add the token count as metadata");
    }

    public PepperMapper createPepperMapper(Identifier Identifier2) {
        CounterModuleMapper mapper = new CounterModuleMapper();
        return mapper;
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        return true;
    }

    public static class CounterModuleMapper
    extends PepperMapperImpl
    implements GraphTraverseHandler {
        public DOCUMENT_STATUS mapSCorpus() {
            return DOCUMENT_STATUS.COMPLETED;
        }

        public DOCUMENT_STATUS mapSDocument() {
            String annoNS = this.getProperties().getProperties().getProperty("Counter.annoNamespace", "default_ns");
            String annoName = this.getProperties().getProperties().getProperty("Counter.annoName", "tok_num");
            String metaAnnoNS = this.getProperties().getProperties().getProperty("Counter.metaAnnoNamespace", null);
            String metaAnnoName = this.getProperties().getProperties().getProperty("Counter.metaAnnoName", "tok_count");
            boolean noMeta = Boolean.valueOf(this.getProperties().getProperties().getProperty("Counter.noCountAsMeta"));
            boolean noNumbering = Boolean.valueOf(this.getProperties().getProperties().getProperty("Counter.noTokenNumbers"));
            int counter = 0;
            List tokens = this.getDocument().getDocumentGraph().getSortedTokenByText();
            for (SNode token : tokens) {
                ++counter;
                if (noNumbering) continue;
                SAnnotation anno = SaltFactory.createSAnnotation();
                anno.setName(annoName);
                anno.setNamespace(annoNS);
                anno.setValue((Object)Integer.toString(counter));
                token.addAnnotation(anno);
            }
            if (!noMeta) {
                int tokCount = tokens.size();
                this.getDocument().createMetaAnnotation(metaAnnoNS, metaAnnoName, (Object)Integer.toString(tokCount));
            }
            return DOCUMENT_STATUS.COMPLETED;
        }

        public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation sRelation, SNode fromNode, long order) {
        }

        public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode fromNode, long order) {
        }

        public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation edge, SNode currNode, long order) {
            return !(currNode instanceof STextualDS);
        }
    }
}

