/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.jmmf;

import java.awt.Component;
import java.awt.Dimension;
import nl.mpi.jmmf.DIBInfoHeader;
import nl.mpi.jmmf.JMMFException;

public class JMMFPlayer {
    private static final int MS_TO_REF_TIME = 10000;
    public static final int STATE_STOP = 0;
    public static final int STATE_PAUSE = 1;
    public static final int STATE_RUN = 2;
    private static String initError = null;
    private String mediaPath;
    private long id = -1L;
    private Component visualComponent;
    private boolean stopTimeSupported = true;
    private boolean allowVideoScaling = true;
    private float videoScaleFactor = 1.0f;
    private int vx = 0;
    private int vy = 0;
    private int vw = 0;
    private int vh = 0;
    private int vdx = 0;
    private int vdy = 0;

    public JMMFPlayer() throws JMMFException {
        if (initError != null) {
            throw new JMMFException(initError);
        }
        this.id = this.initPlayer();
    }

    public JMMFPlayer(String mediaPath) throws JMMFException {
        if (initError != null) {
            throw new JMMFException(initError);
        }
        this.mediaPath = mediaPath;
        this.id = this.initWithFile(this.mediaPath);
    }

    public void start() {
        this.start(this.id);
    }

    public void stop() {
        this.pause(this.id);
    }

    public void pause() {
        this.pause(this.id);
    }

    public boolean isPlaying() {
        return this.isPlaying(this.id);
    }

    public int getState() {
        return this.getState(this.id);
    }

    public void setRate(float rate) {
        this.setRate(this.id, rate);
    }

    public float getRate() {
        return this.getRate(this.id);
    }

    public void setVolume(float volume) {
        this.setVolume(this.id, volume);
    }

    public float getVolume() {
        return this.getVolume(this.id);
    }

    public void setMediaTime(long time) {
        this.setMediaTime(this.id, 10000L * time);
    }

    public long getMediaTime() {
        return this.getMediaTime(this.id) / 10000L;
    }

    public long getDuration() {
        return this.getDuration(this.id) / 10000L;
    }

    public boolean isStopTimeSupported() {
        return this.stopTimeSupported;
    }

    public void setStopTime(long time) {
        if (this.stopTimeSupported) {
            try {
                this.setStopTime(this.id, 10000L * time);
            }
            catch (JMMFException jds) {
                this.stopTimeSupported = false;
                System.out.println(jds.getMessage());
            }
        }
    }

    public long getStopTime() {
        if (this.stopTimeSupported) {
            return this.getStopTime(this.id) / 10000L;
        }
        return 0L;
    }

    public double getFrameRate() {
        return this.getFrameRate(this.id);
    }

    public double getTimePerFrame() {
        return this.getTimePerFrame(this.id) * 1000.0;
    }

    public float getAspectRatio() {
        return this.getAspectRatio(this.id);
    }

    public Dimension getOriginalSize() {
        return this.getOriginalSize(this.id);
    }

    public boolean isVisualMedia() {
        return this.isVisualMedia(this.id);
    }

    public int[] getPreferredAspectRatio() {
        return this.getPreferredAspectRatio(this.id);
    }

    public int getSourceHeight() {
        return this.getSourceHeight(this.id);
    }

    public int getSourceWidth() {
        return this.getSourceWidth(this.id);
    }

    public void setVisualComponent(Component component) {
        if (this.visualComponent == null) {
            this.visualComponent = component;
            this.setVisualComponent(this.id, component);
        } else {
            this.visualComponent = component;
            this.setVisualComponent(this.id, component);
        }
    }

    public Component getVisualComponent() {
        return this.visualComponent;
    }

    public void setVisualComponentSize(int w, int h) {
        this.repositionVideoRect();
    }

    public void setVisible(boolean visible) {
        this.setVisible(this.id, visible);
    }

    public void setVideoSourcePos(float x, float y, float w, float h) {
        this.setVideoSourcePos(this.id, x, y, w, h);
    }

    public void setVideoDestinationPos(int x, int y, int w, int h) {
        this.setVideoDestinationPos(this.id, x, y, w, h);
    }

    public void setVideoSourceAndDestPos(float sx, float sy, float sw, float sh, int x, int y, int w, int h) {
        this.setVideoSourceAndDestPos(this.id, sx, sy, sw, sh, x, y, w, h);
    }

    public int[] getVideoDestinationPos() {
        return this.getVideoDestinationPos(this.id);
    }

    public float getVideoScaleFactor() {
        return this.videoScaleFactor;
    }

    public void setVideoScaleFactor(float videoScaleFactor) {
        this.videoScaleFactor = videoScaleFactor;
        this.repositionVideoRect();
    }

    public void moveVideoPos(int dx, int dy) {
        if (this.videoScaleFactor == 1.0f && this.allowVideoScaling) {
            return;
        }
        this.vdx += dx;
        this.vdy += dy;
        this.repositionVideoRect();
    }

    public int[] getVideoTranslation() {
        if (!this.isVisualMedia() || this.videoScaleFactor == 1.0f) {
            return new int[]{0, 0};
        }
        return new int[]{this.vx, this.vy};
    }

    public int[] getScaledVideoRect() {
        if (!this.isVisualMedia() || this.videoScaleFactor == 1.0f) {
            return new int[]{0, 0};
        }
        return new int[]{this.vw, this.vh};
    }

    public boolean isAllowVideoScaling() {
        return this.allowVideoScaling;
    }

    public void setAllowVideoScaling(boolean allowVideoScaling) {
        this.allowVideoScaling = allowVideoScaling;
    }

    public byte[] getCurrentImageData(DIBInfoHeader dih) {
        return this.getCurrentImage(this.id, dih);
    }

    public byte[] getImageDataAtTime(long time, DIBInfoHeader dih) {
        return this.getImageAtTime(this.id, dih, 10000L * time);
    }

    public void cleanUpOnClose() {
        long startTime;
        int STOP_TO = 7000;
        int CLOSE_TO = 10000;
        boolean stopped = false;
        boolean closed = false;
        if (this.getState(this.id) != PlayerState.STOPPED.value) {
            this.stop(this.id);
            startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 7000L) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    System.out.println("Interrupted while waiting for player to stop.");
                }
                if (this.getState(this.id) != PlayerState.STOPPED.value) continue;
                System.out.println("Player succesfully stopped.");
                stopped = true;
                break;
            }
        }
        if (!stopped) {
            // empty if block
        }
        if (this.getState(this.id) != PlayerState.CLOSING.value) {
            this.closeSession(this.id);
            startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 10000L) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    System.out.println("Interrupted while waiting for player to close session.");
                }
                if (this.getState(this.id) != PlayerState.CLOSED.value) continue;
                System.out.println("Player session succesfully closed.");
                closed = true;
                break;
            }
        }
        if (!closed) {
            System.out.println("Error: failed to close the player gracefully.");
        } else {
            this.deletePlayer(this.id);
        }
    }

    public long getID() {
        return this.id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void repositionVideoRect() {
        if (this.visualComponent == null) return;
        if (!this.allowVideoScaling) {
            int compW = this.visualComponent.getWidth();
            int compH = this.visualComponent.getHeight();
            int origW = this.getSourceWidth();
            int origH = this.getSourceHeight();
            float sx = 0.0f;
            float sy = 0.0f;
            float sw = 1.0f;
            float sh = 1.0f;
            float factW = (float)compW / (float)origW;
            float ar = (float)origW / (float)origH;
            if (!(factW > 1.0f)) return;
        }
        int compW = this.visualComponent.getWidth();
        int compH = this.visualComponent.getHeight();
        if (this.videoScaleFactor == 1.0f) {
            this.setVideoSourceAndDestPos(0.0f, 0.0f, 1.0f, 1.0f, 0, 0, compW, compH);
            return;
        } else {
            this.vw = (int)((float)compW * this.videoScaleFactor);
            this.vh = (int)((float)compH * this.videoScaleFactor);
            this.vx = this.vdx;
            this.vy = this.vdy;
            if (this.vx + this.vw < compW) {
                this.vx = compW - this.vw;
            }
            if (this.vx > 0) {
                this.vx = 0;
            }
            if (this.vy + this.vh < compH) {
                this.vy = compH - this.vh;
            }
            if (this.vy > 0) {
                this.vy = 0;
            }
            float sx1 = (float)(-this.vx) / (float)this.vw;
            float sy1 = (float)(-this.vy) / (float)this.vh;
            float sx2 = sx1 + (float)compW / (float)this.vw;
            float sy2 = sy1 + (float)compH / (float)this.vh;
            this.setVideoSourceAndDestPos(sx1, sy1, sx2, sy2, 0, 0, compW, compH);
        }
    }

    public void repaintVideo() {
        if (this.visualComponent != null) {
            this.repaintVideo(this.id);
        }
    }

    private native long initPlayer();

    private native void start(long var1);

    private native void stop(long var1);

    private native void pause(long var1);

    private native boolean isPlaying(long var1);

    private native int getState(long var1);

    private native void setRate(long var1, float var3);

    private native float getRate(long var1);

    private native void setVolume(long var1, float var3);

    private native float getVolume(long var1);

    private native void setMediaTime(long var1, long var3);

    private native long getMediaTime(long var1);

    private native long getDuration(long var1);

    private native double getFrameRate(long var1);

    private native double getTimePerFrame(long var1);

    private native float getAspectRatio(long var1);

    private native Dimension getOriginalSize(long var1);

    private native void setVisualComponent(long var1, Component var3);

    private native void setVisible(long var1, boolean var3);

    private native void setVideoSourcePos(long var1, float var3, float var4, float var5, float var6);

    private native void setVideoDestinationPos(long var1, int var3, int var4, int var5, int var6);

    private native void setVideoSourceAndDestPos(long var1, float var3, float var4, float var5, float var6, int var7, int var8, int var9, int var10);

    private native int[] getVideoDestinationPos(long var1);

    private native long initWithFile(String var1) throws JMMFException;

    public native String getFileType(String var1);

    private native boolean isVisualMedia(long var1);

    private native void setStopTime(long var1, long var3) throws JMMFException;

    private native long getStopTime(long var1);

    private native int getSourceHeight(long var1);

    private native int getSourceWidth(long var1);

    private native int[] getPreferredAspectRatio(long var1);

    private native byte[] getCurrentImage(long var1, DIBInfoHeader var3);

    private native byte[] getImageAtTime(long var1, DIBInfoHeader var3, long var4);

    private native void repaintVideo(long var1);

    public static native void enableDebugMode(boolean var0);

    public static native void correctAtPause(boolean var0);

    private native void clean(long var1);

    private native void closeSession(long var1);

    private native void deletePlayer(long var1);

    static {
        try {
            String correctAtPause;
            if (System.getProperty("os.name").indexOf("Vista") > -1) {
                System.loadLibrary("MMFPlayerVista");
            } else {
                System.loadLibrary("MMFPlayer");
            }
            String debug = System.getProperty("JMMFDebug");
            if (debug != null && debug.toLowerCase().equals("true")) {
                JMMFPlayer.enableDebugMode(true);
            }
            if ((correctAtPause = System.getProperty("JMMFCorrectAtPause")) != null) {
                if (correctAtPause.toLowerCase().equals("true")) {
                    JMMFPlayer.correctAtPause(true);
                } else if (correctAtPause.toLowerCase().equals("false")) {
                    JMMFPlayer.correctAtPause(false);
                }
            }
        }
        catch (UnsatisfiedLinkError ue) {
            initError = ue.getMessage();
        }
        catch (Throwable th) {
            initError = th.getMessage();
        }
    }

    public static enum PlayerState {
        NO_SESSION(0),
        READY(1),
        OPENING(2),
        STARTED(3),
        PAUSED(4),
        SEEKING(5),
        STOPPED(6),
        CLOSING(7),
        CLOSED(8);

        public int value;

        private PlayerState(int value) {
            this.value = value;
        }
    }
}

