/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.jds;

import java.awt.Component;
import java.awt.Dimension;
import nl.mpi.jds.JDSException;

public class JDSPlayer {
    private static final int MS_TO_REF_TIME = 10000;
    public static final int STATE_STOP = 0;
    public static final int STATE_PAUSE = 1;
    public static final int STATE_RUN = 2;
    private String mediaPath;
    private long id = -1L;
    private Component visualComponent;
    private boolean stopTimeSupported = true;
    private float videoScaleFactor = 1.0f;
    private int vx = 0;
    private int vy = 0;
    private int vw = 0;
    private int vh = 0;

    public JDSPlayer(String mediaPath) throws JDSException {
        this.mediaPath = mediaPath;
        this.id = this.initWithFile(this.mediaPath);
    }

    public JDSPlayer(String mediaPath, String preferredCodec) throws JDSException {
        this.mediaPath = mediaPath;
        this.id = this.initWithFileAndCodec(this.mediaPath, preferredCodec);
    }

    public String[] getFiltersInGraph() {
        return this.getFiltersInGraph(this.id);
    }

    public void start() {
        this.start(this.id);
    }

    public void stop() {
        this.stop(this.id);
    }

    public void pause() {
        this.pause(this.id);
    }

    public boolean isPlaying() {
        return this.isPlaying(this.id);
    }

    public void stopWhenReady() {
        this.stopWhenReady(this.id);
    }

    public int getState() {
        return this.getState(this.id);
    }

    public void setRate(float rate) {
        this.setRate(this.id, rate);
    }

    public float getRate() {
        return this.getRate(this.id);
    }

    public void setVolume(float volume) {
        this.setVolume(this.id, volume);
    }

    public float getVolume() {
        return this.getVolume(this.id);
    }

    public void setMediaTime(long time) {
        this.setMediaTime(this.id, 10000L * time);
    }

    public long getMediaTime() {
        return this.getMediaTime(this.id) / 10000L;
    }

    public long getDuration() {
        return this.getDuration(this.id) / 10000L;
    }

    public boolean isStopTimeSupported() {
        return this.stopTimeSupported;
    }

    public void setStopTime(long time) {
        if (this.stopTimeSupported) {
            try {
                this.setStopTime(this.id, 10000L * time);
            }
            catch (JDSException jds) {
                this.stopTimeSupported = false;
                System.out.println(jds.getMessage());
            }
        }
    }

    public long getStopTime() {
        if (this.stopTimeSupported) {
            return this.getStopTime(this.id) / 10000L;
        }
        return 0L;
    }

    public double getFrameRate() {
        return this.getFrameRate(this.id);
    }

    public double getTimePerFrame() {
        return this.getTimePerFrame(this.id) * 1000.0;
    }

    public float getAspectRatio() {
        return this.getAspectRatio(this.id);
    }

    public Dimension getOriginalSize() {
        return this.getOriginalSize(this.id);
    }

    public boolean isVisualMedia() {
        return this.isVisualMedia(this.id);
    }

    public int[] getPreferredAspectRatio() {
        return this.getPreferredAspectRatio(this.id);
    }

    public int getSourceHeight() {
        return this.getSourceHeight(this.id);
    }

    public int getSourceWidth() {
        return this.getSourceWidth(this.id);
    }

    public void setVisualComponent(Component component) {
        this.visualComponent = component;
        this.setVisualComponent(this.id, component);
        this.repositionVideoRect();
    }

    public Component getVisualComponent() {
        return this.visualComponent;
    }

    public void setVisualComponentPos(int x, int y, int w, int h) {
        this.setVisualComponentPos(this.id, x, y, w, h);
        this.repositionVideoRect();
    }

    public void setVisible(boolean visible) {
        this.setVisible(this.id, visible);
    }

    public void setVideoSourcePos(int x, int y, int w, int h) {
        this.setVideoSourcePos(this.id, x, y, w, h);
    }

    public void setVideoDestinationPos(int x, int y, int w, int h) {
        this.vx = x;
        this.vy = y;
        this.setVideoDestinationPos(this.id, x, y, w, h);
    }

    public int[] getVideoDestinationPos() {
        return this.getVideoDestinationPos(this.id);
    }

    public float getVideoScaleFactor() {
        return this.videoScaleFactor;
    }

    public void setVideoScaleFactor(float videoScaleFactor) {
        this.videoScaleFactor = videoScaleFactor;
        this.repositionVideoRect();
    }

    public byte[] getCurrentImageData() {
        return this.getCurrentImage(this.id);
    }

    public byte[] getImageDataAtTime(long time) {
        return this.getImageAtTime(this.id, 10000L * time);
    }

    public void cleanUpOnClose() {
        this.clean(this.id);
    }

    public long getID() {
        return this.id;
    }

    private void repositionVideoRect() {
        if (this.visualComponent != null) {
            this.vw = (int)((float)this.visualComponent.getWidth() * this.videoScaleFactor);
            this.vh = (int)((float)this.visualComponent.getHeight() * this.videoScaleFactor);
            if (this.vx + this.vw < this.visualComponent.getWidth()) {
                this.vx = this.visualComponent.getWidth() - this.vw;
            }
            if (this.vx > 0) {
                this.vx = 0;
            }
            if (this.vy + this.vh < this.visualComponent.getHeight()) {
                this.vy = this.visualComponent.getHeight() - this.vh;
            }
            if (this.vy > 0) {
                this.vy = 0;
            }
            this.setVideoDestinationPos(this.id, this.vx, this.vy, this.vw, this.vh);
        }
    }

    private native void start(long var1);

    private native void stop(long var1);

    private native void pause(long var1);

    private native boolean isPlaying(long var1);

    private native void stopWhenReady(long var1);

    private native int getState(long var1);

    private native void setRate(long var1, float var3);

    private native float getRate(long var1);

    private native void setVolume(long var1, float var3);

    private native float getVolume(long var1);

    private native void setMediaTime(long var1, long var3);

    private native long getMediaTime(long var1);

    private native long getDuration(long var1);

    private native double getFrameRate(long var1);

    private native double getTimePerFrame(long var1);

    private native float getAspectRatio(long var1);

    private native Dimension getOriginalSize(long var1);

    private native void setVisualComponent(long var1, Component var3);

    private native void setVisualComponentPos(long var1, int var3, int var4, int var5, int var6);

    private native void setVisible(long var1, boolean var3);

    private native void setVideoSourcePos(long var1, int var3, int var4, int var5, int var6);

    private native void setVideoDestinationPos(long var1, int var3, int var4, int var5, int var6);

    private native int[] getVideoDestinationPos(long var1);

    private native long initWithFile(String var1) throws JDSException;

    private native long initWithFileAndCodec(String var1, String var2) throws JDSException;

    public native boolean isCodecInstalled(String var1);

    public native String[] getRegisteredFilters();

    private native String[] getFiltersInGraph(long var1);

    public native String getFileType(String var1);

    private native boolean isVisualMedia(long var1);

    private native void setStopTime(long var1, long var3) throws JDSException;

    private native long getStopTime(long var1);

    private native int getSourceHeight(long var1);

    private native int getSourceWidth(long var1);

    private native int[] getPreferredAspectRatio(long var1);

    private native byte[] getCurrentImage(long var1);

    private native byte[] getImageAtTime(long var1, long var3);

    public static native void enableDebugMode(boolean var0);

    private native void clean(long var1);

    static {
        System.loadLibrary("DSPlayer");
        String debug = System.getProperty("JDSDebug");
        if (debug != null && debug.toLowerCase().equals("true")) {
            JDSPlayer.enableDebugMode(true);
        }
    }
}

