/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.search.gui.XNumericalJTextFieldFilter;

public class TimeField
extends JPanel {
    public final boolean FROM = false;
    public final boolean TO = true;
    protected final JTextField milliSecTextField = new JTextField(new XNumericalJTextFieldFilter(0), "", 3);
    protected final JTextField secTextField;
    private final boolean positiv;

    public TimeField() {
        this(true);
    }

    public TimeField(boolean positiv) {
        this.positiv = positiv;
        this.secTextField = new JTextField(new XNumericalJTextFieldFilter(positiv ? 4 : 5), "", 3);
        this.secTextField.setHorizontalAlignment(4);
        this.milliSecTextField.setHorizontalAlignment(4);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.secTextField);
        this.add(new JLabel("."));
        this.add(this.milliSecTextField);
        this.add(new JLabel("s"));
    }

    public void setTime(long milliSeconds) {
        if (this.positiv && milliSeconds == Long.MAX_VALUE || !this.positiv && milliSeconds == Long.MIN_VALUE) {
            this.secTextField.setText("");
            this.milliSecTextField.setText("");
        } else {
            this.secTextField.setText("" + milliSeconds / 1000L);
            this.milliSecTextField.setText("" + milliSeconds % 1000L);
        }
    }

    public long getTime() {
        long milliSeconds = 0L;
        if ((this.secTextField.getText() + this.milliSecTextField.getText()).trim().equals("")) {
            milliSeconds = this.positiv ? Long.MAX_VALUE : Long.MIN_VALUE;
        } else {
            try {
                milliSeconds = 1000L * Long.parseLong(this.secTextField.getText());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                milliSeconds += Long.parseLong(this.milliSecTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return milliSeconds;
    }
}

