/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.search.SearchLocale;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.viewer.LocalizeListCellRenderer;
import mpi.search.content.query.viewer.TemporalDistancePanel;

public class DependentTemporalDistancePanel
extends TemporalDistancePanel
implements ItemListener {
    private final CardLayout distanceLayout = new CardLayout();
    private final JPanel distancePanel = new JPanel(this.distanceLayout);

    public DependentTemporalDistancePanel() {
        this.timeRelationComboBox = new JComboBox<String>(Constraint.DEPENDENT_CONSTRAINT_TIME_RELATIONS);
        this.timeRelationComboBox.setRenderer(new LocalizeListCellRenderer());
        this.distancePanel.add((Component)this.toTimeField, "interval width");
        this.distancePanel.add((Component)new JLabel(""), "nothing");
        JLabel label = new JLabel(SearchLocale.getString("Search.And") + " ");
        label.setFont(this.getFont().deriveFont(0));
        this.add(label);
        this.add(this.timeRelationComboBox);
        this.add(new JLabel(" "));
        this.add(this.distancePanel);
        this.timeRelationComboBox.addItemListener(this);
        this.timeRelationComboBox.setSelectedIndex(0);
        this.updateDistancePanel();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.updateDistancePanel();
        }
    }

    private void updateDistancePanel() {
        Object selectedItem = this.timeRelationComboBox.getSelectedItem();
        if ("Search.Constraint.WithinOverallDistance".equals(selectedItem) || "Search.Constraint.WithinLeftDistance".equals(selectedItem) || "Search.Constraint.WithinRightDistance".equals(selectedItem) || "Search.Constraint.BeforeLeftDistance".equals(selectedItem) || "Search.Constraint.AfterRightDistance".equals(selectedItem)) {
            this.distanceLayout.show(this.distancePanel, "interval width");
        } else {
            this.distanceLayout.show(this.distancePanel, "nothing");
        }
    }
}

