/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.webserviceclient.typecraft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.webserviceclient.typecraft.MorphRecord;
import mpi.eudico.webserviceclient.typecraft.PhraseRecord;
import mpi.eudico.webserviceclient.typecraft.TextRecord;
import mpi.eudico.webserviceclient.typecraft.WordRecord;

public class TCtoTranscription {
    public static final String PHRASE = "phrase";
    public static final String TRANSLATION = "translation";
    public static final String DESCRIPTION = "description";
    public static final String VALIDITY = "validity";
    public static final String WORDS = "words";
    public static final String HEAD = "head";
    public static final String POS = "pos";
    public static final String MORPH = "morph";
    public static final String BASE = "baseform";
    public static final String MEANING = "meaning";
    public static final String GLOSS = "gloss";
    public static final String GLOSS_DELIMITER = ";";
    public static final String TC_ID_PREFIX = "tc";
    private List<String> firstLevelSymAssTiers;
    private List<PhraseRecord> phraseRecords;
    private TextRecord textRecord;
    private Map<String, String> speakerToSuffixMap = new HashMap<String, String>();
    private TranscriptionImpl transcription;
    private long curTime = 0L;
    private long defPhraseDur = 5000L;

    public TCtoTranscription() {
        this.firstLevelSymAssTiers = new ArrayList<String>();
        this.firstLevelSymAssTiers.add(TRANSLATION);
        this.firstLevelSymAssTiers.add(DESCRIPTION);
        this.firstLevelSymAssTiers.add(VALIDITY);
    }

    public TranscriptionImpl createTranscription(List<PhraseRecord> phraseRecords, TextRecord textRecord) {
        this.phraseRecords = phraseRecords;
        this.textRecord = textRecord;
        if (phraseRecords == null) {
            return null;
        }
        this.transcription = new TranscriptionImpl();
        this.transcription.setNotifying(false);
        if (textRecord != null) {
            PropertyImpl ti;
            PropertyImpl pi = new PropertyImpl();
            pi.setName("id");
            pi.setValue(textRecord.id);
            this.transcription.addDocProperty(pi);
            if (textRecord.lang != null) {
                PropertyImpl la = new PropertyImpl();
                la.setName("lang");
                la.setValue(textRecord.lang);
                this.transcription.addDocProperty(la);
            }
            if (textRecord.title != null) {
                ti = new PropertyImpl();
                ti.setName("title");
                ti.setValue(textRecord.title);
                this.transcription.addDocProperty(ti);
            }
            if (textRecord.titleTrans != null) {
                ti = new PropertyImpl();
                ti.setName("titleTranslation");
                ti.setValue(textRecord.titleTrans);
                this.transcription.addDocProperty(ti);
            }
            if (textRecord.body != null) {
                PropertyImpl bo = new PropertyImpl();
                bo.setName("body");
                bo.setValue(textRecord.body);
                this.transcription.addDocProperty(bo);
            }
        }
        this.addDefaultTypes();
        for (PhraseRecord record : phraseRecords) {
            this.createAnnotations(record);
        }
        return this.transcription;
    }

    private void addDefaultTypes() {
        LinguisticType type = new LinguisticType(PHRASE);
        type.setTimeAlignable(true);
        this.transcription.addLinguisticType(type);
        type = new LinguisticType(TRANSLATION);
        type.addConstraint(new SymbolicAssociation());
        type.setTimeAlignable(false);
        this.transcription.addLinguisticType(type);
        type = new LinguisticType(DESCRIPTION);
        type.addConstraint(new SymbolicAssociation());
        type.setTimeAlignable(false);
        this.transcription.addLinguisticType(type);
        type = new LinguisticType(VALIDITY);
        type.addConstraint(new SymbolicAssociation());
        type.setTimeAlignable(false);
        this.transcription.addLinguisticType(type);
        type = new LinguisticType(WORDS);
        type.addConstraint(new SymbolicSubdivision());
        type.setTimeAlignable(false);
        this.transcription.addLinguisticType(type);
        type = new LinguisticType(HEAD);
        type.addConstraint(new SymbolicAssociation());
        type.setTimeAlignable(false);
        this.transcription.addLinguisticType(type);
        type = new LinguisticType(POS);
        type.addConstraint(new SymbolicAssociation());
        type.setTimeAlignable(false);
        this.transcription.addLinguisticType(type);
        type = new LinguisticType(MORPH);
        type.addConstraint(new SymbolicSubdivision());
        type.setTimeAlignable(false);
        this.transcription.addLinguisticType(type);
        type = new LinguisticType(BASE);
        type.addConstraint(new SymbolicAssociation());
        type.setTimeAlignable(false);
        this.transcription.addLinguisticType(type);
        type = new LinguisticType(MEANING);
        type.addConstraint(new SymbolicAssociation());
        type.setTimeAlignable(false);
        this.transcription.addLinguisticType(type);
        type = new LinguisticType(GLOSS);
        type.addConstraint(new SymbolicAssociation());
        type.setTimeAlignable(false);
        this.transcription.addLinguisticType(type);
    }

    private void createAnnotations(PhraseRecord record) {
        TierImpl trTier;
        TierImpl phraseTier;
        long et;
        long bt;
        if (record == null) {
            return;
        }
        if (record.bt < record.et && record.et != 0L) {
            bt = record.bt;
            et = record.et;
        } else {
            bt = this.curTime;
            et = this.curTime + this.defPhraseDur;
        }
        this.curTime = et;
        String suffix = null;
        if (record.speaker != null && record.speaker.length() != 0) {
            suffix = this.speakerToSuffixMap.get(record.speaker);
            if (suffix == null) {
                char suf = (char)(65 + this.speakerToSuffixMap.size());
                String sufStr = "_" + suf;
                this.speakerToSuffixMap.put(record.speaker, sufStr);
                String tierName = PHRASE + sufStr;
                phraseTier = new TierImpl(tierName, record.speaker, this.transcription, this.transcription.getLinguisticTypeByName(PHRASE));
                this.transcription.addTier(phraseTier);
            } else {
                phraseTier = (TierImpl)this.transcription.getTierWithId(PHRASE + suffix);
            }
        } else {
            phraseTier = (TierImpl)this.transcription.getTierWithId(PHRASE);
            if (phraseTier == null) {
                phraseTier = new TierImpl(PHRASE, "", this.transcription, this.transcription.getLinguisticTypeByName(PHRASE));
                this.transcription.addTier(phraseTier);
            }
        }
        AbstractAnnotation rootAnn = (AbstractAnnotation)phraseTier.createAnnotation(bt, et);
        if (rootAnn == null) {
            System.out.println("Could not create annotation on Phrase: " + record.text);
            return;
        }
        rootAnn.setValue(record.text);
        rootAnn.setId(TC_ID_PREFIX + record.id);
        if (record.translation != null) {
            trTier = this.getTier(TRANSLATION, suffix);
            if (trTier == null) {
                trTier = this.createTier(phraseTier, this.transcription.getLinguisticTypeByName(TRANSLATION), TRANSLATION, suffix);
                this.transcription.addTier(trTier);
                if (record.speaker != null) {
                    trTier.setParticipant(record.speaker);
                }
            }
            if (trTier != null) {
                this.createDepAnnotationSA(trTier, record.translation, rootAnn);
            }
        }
        if (record.description != null) {
            trTier = this.getTier(DESCRIPTION, suffix);
            if (trTier == null) {
                trTier = this.createTier(phraseTier, this.transcription.getLinguisticTypeByName(DESCRIPTION), DESCRIPTION, suffix);
                this.transcription.addTier(trTier);
                if (record.speaker != null) {
                    trTier.setParticipant(record.speaker);
                }
            }
            if (trTier != null) {
                this.createDepAnnotationSA(trTier, record.description, rootAnn);
            }
        }
        if (record.valid != null) {
            trTier = this.getTier(VALIDITY, suffix);
            if (trTier == null) {
                trTier = this.createTier(phraseTier, this.transcription.getLinguisticTypeByName(VALIDITY), VALIDITY, suffix);
                this.transcription.addTier(trTier);
                if (record.speaker != null) {
                    trTier.setParticipant(record.speaker);
                }
            }
            if (trTier != null) {
                this.createDepAnnotationSA(trTier, record.valid, rootAnn);
            }
        }
        if (record.wordRecords != null && record.wordRecords.size() > 0) {
            AbstractAnnotation wa = null;
            AbstractAnnotation prevwa = null;
            long wbt = bt;
            long ebt = et;
            TierImpl wTier = this.getTier(WORDS, suffix);
            if (wTier == null) {
                wTier = this.createTier(phraseTier, this.transcription.getLinguisticTypeByName(WORDS), WORDS, suffix);
                this.transcription.addTier(wTier);
                if (record.speaker != null) {
                    wTier.setParticipant(record.speaker);
                }
            }
            for (int i = 0; i < record.wordRecords.size(); ++i) {
                WordRecord wrecord = record.wordRecords.get(i);
                if (wTier == null || (wa = this.createWordDepAnnotationSS(wTier, suffix, wrecord, rootAnn, prevwa)) == null) continue;
                prevwa = wa;
            }
        }
    }

    private TierImpl getTier(String name, String suffix) {
        TierImpl t = null;
        t = suffix != null ? (TierImpl)this.transcription.getTierWithId(name + suffix) : (TierImpl)this.transcription.getTierWithId(name);
        return t;
    }

    private TierImpl createTier(TierImpl parent, LinguisticType type, String name, String suffix) {
        TierImpl t = null;
        t = suffix != null ? new TierImpl(parent, name + suffix, null, this.transcription, type) : new TierImpl(parent, name, null, this.transcription, type);
        return t;
    }

    private AbstractAnnotation createDepAnnotationSA(TierImpl tier, String value, AbstractAnnotation parent) {
        long mid = (parent.getBeginTimeBoundary() + parent.getEndTimeBoundary()) / 2L;
        AbstractAnnotation aa = (AbstractAnnotation)tier.createAnnotation(mid, mid);
        if (aa != null) {
            aa.setValue(value);
        }
        return aa;
    }

    private AbstractAnnotation createWordDepAnnotationSS(TierImpl wTier, String suffix, WordRecord wRecord, AbstractAnnotation parent, AbstractAnnotation previous) {
        AbstractAnnotation aa = null;
        if (previous != null) {
            aa = (AbstractAnnotation)wTier.createAnnotationAfter(previous);
        } else {
            long mid = (parent.getBeginTimeBoundary() + parent.getEndTimeBoundary()) / 2L;
            aa = (AbstractAnnotation)wTier.createAnnotation(mid, mid);
        }
        if (aa != null) {
            aa.setValue(wRecord.text);
            if (wRecord.morphs != null && wRecord.morphs.size() > 0) {
                MorphRecord mRecord = null;
                TierImpl mTier = this.getTier(MORPH, suffix);
                if (mTier == null) {
                    mTier = this.createTier(wTier, this.transcription.getLinguisticTypeByName(MORPH), MORPH, suffix);
                    this.transcription.addTier(mTier);
                    mTier.setParticipant(wTier.getParticipant());
                }
                AbstractAnnotation ma = null;
                AbstractAnnotation prevma = null;
                for (int i = 0; i < wRecord.morphs.size() && (ma = this.createMorphDepAnnotationSS(mTier, suffix, mRecord = wRecord.morphs.get(i), aa, prevma)) != null; ++i) {
                    prevma = ma;
                }
            }
            if (wRecord.pos != null) {
                TierImpl pTier = this.getTier(POS, suffix);
                if (pTier == null) {
                    pTier = this.createTier(wTier, this.transcription.getLinguisticTypeByName(POS), POS, suffix);
                    this.transcription.addTier(pTier);
                    pTier.setParticipant(wTier.getParticipant());
                }
                this.createDepAnnotationSA(pTier, wRecord.pos, aa);
            }
            if (wRecord.head != null) {
                TierImpl hTier = this.getTier(HEAD, suffix);
                if (hTier == null) {
                    hTier = this.createTier(wTier, this.transcription.getLinguisticTypeByName(HEAD), HEAD, suffix);
                    this.transcription.addTier(hTier);
                    hTier.setParticipant(wTier.getParticipant());
                }
                this.createDepAnnotationSA(hTier, wRecord.head, aa);
            }
        }
        return aa;
    }

    private AbstractAnnotation createMorphDepAnnotationSS(TierImpl mTier, String suffix, MorphRecord mRecord, AbstractAnnotation parent, AbstractAnnotation previous) {
        AbstractAnnotation aa = null;
        if (previous != null) {
            aa = (AbstractAnnotation)mTier.createAnnotationAfter(previous);
        } else {
            long mid = (parent.getBeginTimeBoundary() + parent.getEndTimeBoundary()) / 2L;
            aa = (AbstractAnnotation)mTier.createAnnotation(mid, mid);
        }
        if (aa != null) {
            aa.setValue(mRecord.text);
            if (mRecord.baseform != null) {
                TierImpl bTier = this.getTier(BASE, suffix);
                if (bTier == null) {
                    bTier = this.createTier(mTier, this.transcription.getLinguisticTypeByName(BASE), BASE, suffix);
                    this.transcription.addTier(bTier);
                    bTier.setParticipant(mTier.getParticipant());
                }
                this.createDepAnnotationSA(bTier, mRecord.baseform, aa);
            }
            if (mRecord.meaning != null) {
                TierImpl nTier = this.getTier(MEANING, suffix);
                if (nTier == null) {
                    nTier = this.createTier(mTier, this.transcription.getLinguisticTypeByName(MEANING), MEANING, suffix);
                    this.transcription.addTier(nTier);
                    nTier.setParticipant(mTier.getParticipant());
                }
                this.createDepAnnotationSA(nTier, mRecord.meaning, aa);
            }
            if (mRecord.glosses != null && mRecord.glosses.size() > 0) {
                TierImpl gTier = this.getTier(GLOSS, suffix);
                if (gTier == null) {
                    gTier = this.createTier(mTier, this.transcription.getLinguisticTypeByName(GLOSS), GLOSS, suffix);
                    this.transcription.addTier(gTier);
                    gTier.setParticipant(mTier.getParticipant());
                }
                String gl = "";
                for (String s : mRecord.glosses) {
                    if (gl.length() > 0) {
                        gl = gl + GLOSS_DELIMITER + s;
                        continue;
                    }
                    gl = s;
                }
                this.createDepAnnotationSA(gTier, gl, aa);
            }
        }
        return aa;
    }
}

