/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class TimeFormatter {
    private static String hourString;
    private static String minuteString;
    private static String secondString;
    private static String milliString;
    private static final DecimalFormat twoDigits;
    private static final DecimalFormat threeDigits;
    private static final DecimalFormat secondsMillis;

    public static long toMilliSeconds(String timeString) {
        try {
            int mark1;
            boolean negative;
            String hourString = new String("0.0");
            String minuteString = new String("0.0");
            String secondString = new String("0.0");
            boolean bl = negative = timeString.charAt(0) == '-';
            if (negative) {
                timeString = timeString.substring(1);
            }
            if ((mark1 = timeString.indexOf(58, 0)) == -1) {
                if (timeString.indexOf(46) < 0) {
                    if (negative) {
                        return -Long.parseLong(timeString);
                    }
                    return Long.parseLong(timeString);
                }
                secondString = timeString;
            } else {
                int mark2 = timeString.indexOf(58, mark1 + 1);
                if (mark2 == -1) {
                    minuteString = timeString.substring(0, mark1);
                    secondString = timeString.substring(mark1 + 1, timeString.length());
                } else {
                    hourString = timeString.substring(0, mark1);
                    minuteString = timeString.substring(mark1 + 1, mark2);
                    secondString = timeString.substring(mark2 + 1, timeString.length());
                }
            }
            double hours = Double.valueOf(hourString);
            double minutes = Double.valueOf(minuteString);
            double seconds = Double.valueOf(secondString);
            if (negative) {
                return (long)(-(1000.0 * (hours * 3600.0 + minutes * 60.0 + seconds)));
            }
            return (long)(1000.0 * (hours * 3600.0 + minutes * 60.0 + seconds));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String toString(long time) {
        long hours = time / 3600000L;
        hourString = twoDigits.format(hours);
        long minutes = (time - 3600000L * hours) / 60000L;
        minuteString = twoDigits.format(minutes);
        long seconds = (time - 3600000L * hours - 60000L * minutes) / 1000L;
        secondString = twoDigits.format(seconds);
        long millis = time - 3600000L * hours - 60000L * minutes - 1000L * seconds;
        milliString = threeDigits.format(millis);
        return hourString + ":" + minuteString + ":" + secondString + "." + milliString;
    }

    public static String toSSMSString(long time) {
        double dd = (double)time / 1000.0;
        return secondsMillis.format(dd);
    }

    public static String toTimecodePAL(long time) {
        long hours = time / 3600000L;
        hourString = twoDigits.format(hours);
        long minutes = (time - 3600000L * hours) / 60000L;
        minuteString = twoDigits.format(minutes);
        long seconds = (time - 3600000L * hours - 60000L * minutes) / 1000L;
        secondString = twoDigits.format(seconds);
        long frames = (time - 3600000L * hours - 60000L * minutes - 1000L * seconds) / 40L;
        milliString = twoDigits.format(frames);
        return hourString + ":" + minuteString + ":" + secondString + ":" + milliString;
    }

    public static String toFrameNumberPAL(long time) {
        return String.valueOf(time / 40L);
    }

    public static String toTimecodeNTSC(long time) {
        int frameNumber = (int)((double)((float)time / 1000.0f) * 29.97);
        int numTenMin = frameNumber / 17982;
        int hours = numTenMin / 6;
        numTenMin -= 6 * hours;
        int numMin = frameNumber % 17982;
        int min = numMin / 1800;
        int rest = numMin - min * 1800;
        int sec = rest / 30;
        int fr = rest - sec * 30;
        if ((fr += min * 2) > 29) {
            fr -= 30;
            if (++sec > 59) {
                sec = 0;
                ++min;
                fr += 2;
            }
        }
        return twoDigits.format(hours) + ":" + twoDigits.format(numTenMin * 10 + min) + ":" + twoDigits.format(sec) + ":" + twoDigits.format(fr);
    }

    public static String toFrameNumberNTSC(long time) {
        int frameNumber = (int)((double)((float)time / 1000.0f) * 29.97);
        return String.valueOf(frameNumber);
    }

    static {
        twoDigits = new DecimalFormat("00");
        threeDigits = new DecimalFormat("000");
        secondsMillis = new DecimalFormat("#0.000", new DecimalFormatSymbols(Locale.US));
    }
}

