/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.type;

import java.util.Iterator;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.NoTimeGapWithinParent;

public class TimeSubdivision
extends ConstraintImpl {
    public TimeSubdivision() {
        this.addConstraint(new NoTimeGapWithinParent());
    }

    @Override
    public int getStereoType() {
        return 0;
    }

    @Override
    public void forceTimes(long[] segment, Tier forTier) {
        if (forTier != null) {
            Annotation annAtBegin = ((TierImpl)forTier).getAnnotationAtTime(segment[0]);
            Annotation annAtEnd = ((TierImpl)forTier).getAnnotationAtTime(segment[1]);
            if (annAtBegin != null && annAtEnd == null) {
                segment[1] = annAtBegin.getEndTimeBoundary();
            } else if (annAtBegin == null && annAtEnd != null) {
                segment[0] = annAtEnd.getBeginTimeBoundary();
            } else if (annAtBegin != null && annAtEnd != null && annAtBegin != annAtEnd) {
                segment[0] = annAtEnd.getBeginTimeBoundary();
            } else if (annAtBegin == null && annAtEnd == null) {
                Vector annotsInBetween = ((TierImpl)forTier).getOverlappingAnnotations(segment[0], segment[1]);
                if (annotsInBetween.size() > 0) {
                    AlignableAnnotation a = (AlignableAnnotation)annotsInBetween.elementAt(0);
                    segment[0] = a.getBegin().getTime();
                    segment[1] = a.getEnd().getTime();
                } else {
                    segment[0] = segment[1];
                }
            }
        }
    }

    @Override
    public void enforceOnWholeTier(Tier theTier) {
        System.out.println("enforcing on tier: " + theTier.getName());
        Iterator annIter = null;
        for (AlignableAnnotation ann : ((TierImpl)theTier).getAnnotations()) {
            long[] segment = new long[]{ann.getBeginTimeBoundary(), ann.getEndTimeBoundary()};
            Tier parent = ((TierImpl)theTier).getParentTier();
            this.forceTimes(segment, parent);
            ann.getBegin().setTime(segment[0]);
            ann.getEnd().setTime(segment[1]);
        }
        Iterator cIter = this.nestedConstraints.iterator();
        while (cIter.hasNext()) {
            ((Constraint)cIter.next()).enforceOnWholeTier(theTier);
        }
    }

    @Override
    public boolean supportsInsertion() {
        return true;
    }

    @Override
    public Annotation insertBefore(Annotation beforeAnn, Tier theTier) {
        return ((NoTimeGapWithinParent)this.nestedConstraints.elementAt(0)).insertBefore(beforeAnn, theTier);
    }

    @Override
    public Annotation insertAfter(Annotation afterAnn, Tier theTier) {
        return ((NoTimeGapWithinParent)this.nestedConstraints.elementAt(0)).insertAfter(afterAnn, theTier);
    }

    @Override
    public void detachAnnotation(Annotation theAnn, Tier theTier) {
        ((NoTimeGapWithinParent)this.nestedConstraints.elementAt(0)).detachAnnotation(theAnn, theTier);
    }
}

