/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.textconversion;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACM27TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;

public class NystWordToTab {
    private String inFile = null;
    private long lastHMTime = 0L;
    private long lastT = -1L;
    private long timeShift = 0L;
    private final Pattern colonPat = Pattern.compile(":");
    private final String TAB = "\t";

    public NystWordToTab(String inFile) {
        this.inFile = inFile;
        this.convert();
    }

    private void convert() {
        BufferedReader read = null;
        try {
            read = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.inFile), "UTF-8"));
        }
        catch (FileNotFoundException fe) {
            System.out.println("File not found: " + fe.getMessage());
            return;
        }
        catch (UnsupportedEncodingException nee) {
            System.out.println("Unsupported encoding: " + nee.getMessage());
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.inFile + ".tab.txt"), "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println("Unsupported encoding: " + uee.getMessage());
            return;
        }
        catch (FileNotFoundException fne) {
            System.out.println("File not found: " + fne.getMessage());
            return;
        }
        Pattern pat = Pattern.compile("\t");
        long lineCount = 0L;
        boolean secLine = false;
        String lastValues = null;
        try {
            String line;
            while ((line = read.readLine()) != null) {
                ++lineCount;
                String trimmed = line.trim();
                if (trimmed.length() == 0) {
                    secLine = false;
                    continue;
                }
                String[] tokens = pat.split(trimmed);
                if (tokens.length == 3) {
                    long t = this.getTime(tokens[0]);
                    if (t == -1L) {
                        System.out.println("Cannot extract time, continuing anyway... " + tokens[0] + " line: " + lineCount);
                    }
                    if (this.lastT != -1L) {
                        bw.newLine();
                        bw.write(Long.toString(this.lastT));
                        bw.write("\t");
                        bw.write(Long.toString(t - this.timeShift));
                        bw.write("\t");
                        bw.write(lastValues);
                    } else if (t != -1L) {
                        this.timeShift = t;
                    }
                    this.lastT = t - this.timeShift;
                    lastValues = tokens[2];
                    secLine = true;
                    continue;
                }
                if (tokens.length == 1 && secLine) {
                    lastValues = lastValues + "\t";
                    lastValues = lastValues + tokens[0];
                    secLine = false;
                    continue;
                }
                if (tokens.length != 1 || secLine) continue;
            }
            if (this.lastT != -1L) {
                bw.newLine();
                bw.write(Long.toString(this.lastT));
                bw.write("\t");
                bw.write(Long.toString(this.lastT + 1000L));
                bw.write("\t");
                bw.write(lastValues);
            }
            bw.flush();
            bw.close();
            read.close();
            System.out.println("Finished transforming file...");
        }
        catch (IOException ioe) {
            System.out.println("IO Exception: " + ioe.getMessage());
        }
        this.createEAF(this.inFile);
    }

    private void createEAF(String inFile) {
        TranscriptionImpl trans = new TranscriptionImpl();
        LinguisticType lt1 = new LinguisticType("text");
        lt1.setTimeAlignable(true);
        trans.addLinguisticType(lt1);
        LinguisticType lt2 = new LinguisticType("translation");
        lt2.setTimeAlignable(false);
        lt2.addConstraint(new SymbolicAssociation());
        trans.addLinguisticType(lt2);
        TierImpl textTier = new TierImpl("text", "", trans, lt1);
        trans.addTier(textTier);
        TierImpl transTier = new TierImpl(textTier, "trans", "", trans, lt2);
        trans.addTier(transTier);
        BufferedReader read = null;
        try {
            read = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile + ".tab.txt"), "UTF-8"));
        }
        catch (FileNotFoundException fe) {
            System.out.println("File not found 2: " + fe.getMessage());
            return;
        }
        catch (UnsupportedEncodingException nee) {
            System.out.println("Unsupported encoding 2: " + nee.getMessage());
            return;
        }
        Pattern pat = Pattern.compile("\t");
        try {
            String line;
            while ((line = read.readLine()) != null) {
                if (line.length() == 0) continue;
                AbstractAnnotation parAnn = null;
                AbstractAnnotation chAnn = null;
                String[] tokens = pat.split(line);
                if (tokens.length <= 3) continue;
                long bt = this.getMsTime(tokens[0]);
                long et = this.getMsTime(tokens[1]);
                if (bt == -1L || et == -1L) {
                    System.out.println("Begin or end time is unknown, skipping: " + line);
                    continue;
                }
                String par = tokens[2];
                String ch = tokens.length >= 4 ? tokens[3] : "";
                parAnn = (AbstractAnnotation)textTier.createAnnotation(bt, et);
                if (parAnn != null) {
                    parAnn.setValue(par);
                    long mid = (bt + et) / 2L;
                    chAnn = (AbstractAnnotation)transTier.createAnnotation(mid, mid);
                    if (chAnn != null) {
                        chAnn.setValue(ch);
                        continue;
                    }
                    System.out.println("Cannot create child annotation: " + ch);
                    continue;
                }
                System.out.println("Cannot create parent annotation: " + par + " line: " + line);
            }
            read.close();
        }
        catch (IOException ioe) {
            System.out.println("IO Exception 2: " + ioe.getMessage());
        }
        try {
            ACM27TranscriptionStore store = new ACM27TranscriptionStore();
            store.storeTranscription(trans, null, null, inFile + ".eaf", 0);
        }
        catch (IOException ioe) {
            System.out.println("Cannot save transcription: " + ioe.getMessage());
        }
    }

    private long getTime(String time) {
        if (time.indexOf(58) > -1) {
            String[] hhmmss = this.colonPat.split(time);
            if (hhmmss.length == 3) {
                try {
                    long t;
                    int h = Integer.parseInt(hhmmss[0], 10);
                    int m = Integer.parseInt(hhmmss[1], 10);
                    int s = Integer.parseInt(hhmmss[2], 10);
                    this.lastHMTime = t = (long)(h * 3600000 + m * 60000);
                    return t += (long)(s * 1000);
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Could not parse time...: " + time + " " + nfe.getMessage());
                    return -1L;
                }
            }
        } else {
            try {
                int t = Integer.parseInt(time, 10);
                return this.lastHMTime + (long)(t * 1000);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Could not parse single time...: " + time + " " + nfe.getMessage());
                return -1L;
            }
        }
        System.out.println("Unexpected time format...:" + time);
        return -1L;
    }

    private long getMsTime(String msString) {
        try {
            return Long.parseLong(msString);
        }
        catch (NumberFormatException nfe) {
            System.out.println("Failed to convert ms string");
            return -1L;
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("No file...");
            return;
        }
        NystWordToTab inst = new NystWordToTab(args[0]);
    }
}

