/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.textconversion;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACM27TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class ConvertTxtToEaf {
    private final String TAB = "\t";
    private final String UNKNOWN_PART = "unknown";
    private final String UNKNOWN_SPEECH = "---";
    private final long timeRqdForCh = 50L;
    private final String CHAT_TIER = "*";

    public ConvertTxtToEaf(String inFile) {
        this.createEAF(inFile, null);
    }

    public ConvertTxtToEaf(String inFile, Vector mediaFiles) {
        this.createEAF(inFile, mediaFiles);
    }

    private void createEAF(String inFile, Vector<String> mediaFiles) {
        TranscriptionImpl trans = new TranscriptionImpl();
        if (mediaFiles != null && mediaFiles.size() > 0) {
            trans.setMediaDescriptors(MediaDescriptorUtil.createMediaDescriptors(mediaFiles));
        }
        LinguisticType type = new LinguisticType("Text");
        type.setTimeAlignable(true);
        trans.addLinguisticType(type);
        BufferedReader read = null;
        try {
            read = new BufferedReader(new InputStreamReader(new FileInputStream(inFile)));
        }
        catch (FileNotFoundException fe) {
            System.out.println("File not found : " + fe.getMessage());
            return;
        }
        Pattern pat = Pattern.compile("\t");
        long bt = 0L;
        long et = 0L;
        long dur = 0L;
        System.out.println("Reading file... ");
        try {
            String line;
            while ((line = read.readLine()) != null) {
                TierImpl tier;
                if (line.length() == 0) continue;
                AbstractAnnotation ann = null;
                String[] tokens = pat.split(line);
                if (tokens.length != 2) continue;
                String tierName = tokens[0];
                String annVal = tokens[1];
                if (tierName.startsWith("*")) {
                    tierName = tierName.substring(1);
                } else if (tierName.trim().length() == 0) {
                    tierName = "unknown";
                }
                if (tierName.endsWith(":")) {
                    tierName = tierName.substring(0, tierName.length() - 1);
                }
                if ((tier = (TierImpl)trans.getTierWithId(tierName)) == null) {
                    tier = new TierImpl(tierName, "", trans, type);
                    trans.addTier(tier);
                }
                if ((ann = (AbstractAnnotation)tier.createAnnotation(bt = et, et += (dur = this.getDuration(annVal)))) != null) {
                    ann.setValue(annVal);
                    continue;
                }
                System.out.println("Cannot create annotation: " + annVal + " line: " + line);
            }
            read.close();
        }
        catch (IOException ioe) {
            System.out.println("IO Exception : " + ioe.getMessage());
        }
        try {
            String fileName = this.getValidFileName(inFile);
            if (fileName == null) {
                System.out.println("Transcription not created for '" + inFile + "'.");
                return;
            }
            ACM27TranscriptionStore store = new ACM27TranscriptionStore();
            store.storeTranscription(trans, null, null, fileName, 0);
        }
        catch (IOException ioe) {
            System.out.println("Cannot save transcription: " + ioe.getMessage());
        }
    }

    private String getValidFileName(String infile) {
        String fileName = infile;
        if (fileName != null) {
            int li = infile.lastIndexOf(".");
            fileName = infile.substring(0, li) + ".eaf";
        }
        if (new File(fileName).exists()) {
            int option = JOptionPane.showConfirmDialog(null, fileName + " already exists. Do you want to overwrite the existing file", "Warning", 0, 2);
            if (option == 0) {
                return fileName;
            }
            FileChooser chooser = new FileChooser(null);
            chooser.setCurrentDirectory(infile);
            chooser.createAndShowFileDialog("", 1, null, null, FileExtension.EAF_EXT, true, null, 0, fileName);
            if (chooser.getSelectedFile() == null) {
                return null;
            }
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return fileName;
    }

    private long getDuration(String value) {
        long dur = 0L;
        int numOfChars = value.length();
        dur = value.contains("---") ? (long)(numOfChars -= "---".length()) * 50L + 1000L : (long)numOfChars * 50L;
        return dur;
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("No file...");
            return;
        }
        File dir = new File(args[0]);
        if (!dir.exists()) {
            System.out.println(dir + " file does not exist");
            return;
        }
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (!file.getName().endsWith(".txt") && !file.getName().endsWith(".TXT")) continue;
                ConvertTxtToEaf convertTxtToEaf = new ConvertTxtToEaf(file.getAbsolutePath());
            }
        } else if (dir.isFile()) {
            Vector<String> mediaFiles = new Vector<String>();
            for (int i = 1; i < args.length; ++i) {
                mediaFiles.add(args[i]);
            }
            ConvertTxtToEaf convertTxtToEaf = new ConvertTxtToEaf(args[0], mediaFiles);
        }
    }
}

