/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.utr22;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleConverter {
    private String[] a = new String[256];
    private String[] fbu = new String[256];
    private int badchars;
    private HashMap u = new HashMap();

    public SimpleConverter(InputSource inps) throws IOException, SAXException, ParserConfigurationException {
        this.loadUtr22(inps);
        this.test();
    }

    private String decodeList(String y) {
        if (y == null) {
            return "";
        }
        if (y.indexOf(32) != -1) {
            String[] arrb = y.split(" ");
            String result = "";
            for (int ii = 0; ii < arrb.length; ++ii) {
                result = result + this.decode(arrb[ii]);
            }
            return result;
        }
        return this.decode(y);
    }

    private String decode(String y) {
        char x = (char)Integer.parseInt(y, 16);
        return "" + x;
    }

    private final String toUnicode(char eightbit) {
        if (eightbit > '\u0100') {
            ++this.badchars;
            return "" + eightbit;
        }
        String y = this.a[eightbit];
        if (y == null) {
            ++this.badchars;
            return "\ufffd";
        }
        return y;
    }

    private final String toBinary(Character unicode) {
        char i = unicode.charValue();
        if (i < '\u0080') {
            return "" + unicode;
        }
        if (this.u.containsKey(unicode.toString())) {
            char x = (char)Integer.decode("" + this.u.get(unicode.toString())).intValue();
            String rr = "" + new Character(x);
            return rr;
        }
        return "?";
    }

    public final String toBinary(String u) {
        String result = "";
        for (int i = 0; i < u.length(); ++i) {
            result = result + this.toBinary(new Character(u.charAt(i)));
        }
        return result;
    }

    public final String toUnicode(String eightbit) {
        String result = "";
        eightbit = this.decodeAmpersands(eightbit);
        for (int i = 0; i < eightbit.length(); ++i) {
            result = result + this.toUnicode(eightbit.charAt(i));
        }
        return result;
    }

    private String decodeAmpersands(String eightbit) {
        return this.decodeAmpersands(eightbit, 0);
    }

    private String decodeAmpersands(String eightbit, int start) {
        if (eightbit == null) {
            return "";
        }
        int dix = eightbit.indexOf("&x", start);
        if (dix < 0) {
            return eightbit;
        }
        if (eightbit.length() < dix + 6) {
            return eightbit;
        }
        if (!";".equals("" + eightbit.charAt(dix + 6))) {
            return eightbit;
        }
        String numbers = eightbit.substring(dix + 2, dix + 6);
        String result = eightbit;
        try {
            char x = (char)Integer.parseInt(numbers, 16);
            String a = eightbit.substring(0, dix);
            String z = eightbit.substring(dix + 7, eightbit.length());
            result = a + new Character(x) + z;
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        return this.decodeAmpersands(result, dix);
    }

    private final void loadUtr22(InputSource inps) throws IOException, SAXException, ParserConfigurationException {
        int i;
        Element ea;
        int ii;
        if (inps == null) {
            URL url = this.getClass().getResource("/mpi/eudico/server/corpora/clomimpl/shoebox/utr22/silipa93.xml");
            inps = new InputSource(url.openStream());
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = null;
        doc = db.parse(inps);
        NodeList nla = doc.getElementsByTagName("a");
        for (ii = 0; ii < nla.getLength(); ++ii) {
            ea = (Element)nla.item(ii);
            String ubctxt = ea.getAttribute("ubctxt");
            if (ubctxt.length() > 0) continue;
            String encb = ea.getAttribute("b");
            String encu = ea.getAttribute("u");
            int x = Integer.parseInt(encb, 16);
            this.a[x] = this.decodeList(encu);
        }
        nla = doc.getElementsByTagName("fbu");
        for (ii = 0; ii < nla.getLength(); ++ii) {
            ea = (Element)nla.item(ii);
            String encb = ea.getAttribute("b");
            String encu = ea.getAttribute("u");
            int x = Integer.parseInt(encb, 16);
            this.fbu[x] = this.decodeList(encu);
        }
        for (i = 0; i < 256; ++i) {
            if (this.a[i] != null || this.fbu[i] == null) continue;
            this.a[i] = this.fbu[i];
        }
        for (i = 0; i < 256; ++i) {
            if (this.a[i] == null) continue;
            this.u.put(this.a[i], new Integer(i));
        }
    }

    void test() {
    }

    public static void main(String[] args) throws Exception {
        SimpleConverter sc = new SimpleConverter(null);
    }
}

