/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.InterlinearToolboxLine;
import mpi.eudico.server.corpora.clomimpl.shoebox.SimpleToolboxLine;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo2;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxLine;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxMarker;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxTypFile;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxWord;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.util.ServerLogger;

public class ToolboxParser
extends Parser {
    private static final String ANN_ID_PREFIX = "ann";
    private static final String TS_ID_PREFIX = "ts";
    private static final String UNKNOWN = "unknown";
    private static final String AT = "@";
    public static String label_eudicoparticipant = "EUDICOp";
    public static String label_eudicot0 = "EUDICOt0";
    public static String label_eudicot1 = "EUDICOt1";
    public static final String elanELANLabel = "ELANExport";
    public static final String elanBlockStart = "block";
    public static final String elanBeginLabel = "ELANBegin";
    public static final String elanEndLabel = "ELANEnd";
    public static final String elanParticipantLabel = "ELANParticipant";
    public static final String elanMediaURLLabel = "ELANMediaURL";
    public static final String elanMediaExtractedLabel = "ELANMediaExtracted";
    public static final String elanMediaMIMELabel = "ELANMediaMIME";
    public static final String elanMediaOriginLabel = "ELANMediaOrigin";
    private long annotId = 0L;
    private long tsId = 0L;
    private ToolboxTypFile typFile;
    private ToolboxDecoderInfo2 decoderInfo;
    private String lastParsed = "";
    private String userParticipantMarker = null;
    private DefaultMutableTreeNode tierTree;
    private ArrayList<LingTypeRecord> lingTypeRecords = new ArrayList();
    private ArrayList<String> participantOrder = new ArrayList();
    private TreeSet<String> tierNameSet = new TreeSet();
    private ArrayList<String> markerOrder = new ArrayList();
    private HashMap<String, String> parentHash = new HashMap();
    private ArrayList<long[]> timeOrder = new ArrayList();
    private ArrayList<long[]> timeSlots = new ArrayList();
    private ArrayList<AnnotationRecord> annotationRecords = new ArrayList();
    private HashMap<AnnotationRecord, String> annotRecordToTierMap = new HashMap();
    private HashMap<String, ArrayList<AnnotationRecord>> tierNameToAnnRecordMap = new HashMap();
    private ArrayList<long[]> rootSlots = new ArrayList();
    private ArrayList<MediaDescriptor> mediaDescriptors = new ArrayList();
    private final ArrayList<String> specialMarkers = new ArrayList(10);
    private int preferredBlockDuration = 1000;
    private char[] scrubbables = new char[]{' ', '\t', '\f', '\r'};
    private int noOfDefectiveBlocks = 0;

    public ToolboxParser() {
        this.specialMarkers.add(label_eudicoparticipant);
        this.specialMarkers.add(elanParticipantLabel);
        this.specialMarkers.add(label_eudicot0);
        this.specialMarkers.add(elanBeginLabel);
        this.specialMarkers.add(label_eudicot1);
        this.specialMarkers.add(elanEndLabel);
        this.specialMarkers.add(elanMediaExtractedLabel);
        this.specialMarkers.add(elanMediaMIMELabel);
        this.specialMarkers.add(elanMediaOriginLabel);
        this.specialMarkers.add(elanMediaURLLabel);
    }

    private void parse(String fileName) {
        if (this.lastParsed.equals(fileName)) {
            return;
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Toolbox file not specified");
        }
        File tbFile = new File(fileName);
        if (!tbFile.exists()) {
            throw new IllegalArgumentException("Specified Toolbox file does not exist: " + fileName);
        }
        if (this.decoderInfo == null || this.decoderInfo.getTypeFile() == null) {
            throw new IllegalArgumentException("No Toolbox typ file specified");
        }
        this.lingTypeRecords.clear();
        this.participantOrder.clear();
        this.tierNameSet.clear();
        this.parentHash.clear();
        this.timeOrder.clear();
        this.timeSlots.clear();
        this.annotationRecords.clear();
        this.annotRecordToTierMap.clear();
        this.rootSlots.clear();
        this.mediaDescriptors.clear();
        this.annotId = 0L;
        this.tsId = 0L;
        this.lastParsed = fileName;
        if (this.decoderInfo != null && this.decoderInfo.getToolboxTypFile() != null) {
            this.typFile = this.decoderInfo.getToolboxTypFile();
            this.userParticipantMarker = this.typFile.getParticipantMarker();
            if (elanParticipantLabel.equals(this.userParticipantMarker) || label_eudicoparticipant.equals(this.userParticipantMarker)) {
                this.userParticipantMarker = null;
            }
            this.tierTree = this.typFile.getMarkerTree();
        } else {
            this.tierTree = new DefaultMutableTreeNode();
        }
        this.parseFile(tbFile);
    }

    private void parseFile(File toolboxFile) {
        BufferedReader bufRead;
        try {
            InputStreamReader reader;
            if (this.decoderInfo.isAllUnicode()) {
                reader = new InputStreamReader((InputStream)new FileInputStream(toolboxFile), "UTF-8");
                bufRead = new BufferedReader(reader);
            } else {
                reader = new InputStreamReader((InputStream)new FileInputStream(toolboxFile), "ISO-8859-1");
                bufRead = new BufferedReader(reader);
            }
        }
        catch (FileNotFoundException fne) {
            ServerLogger.LOG.severe("Toolbox file not found");
            return;
        }
        catch (UnsupportedEncodingException uee) {
            ServerLogger.LOG.severe("Encoding not supported");
            return;
        }
        int successiveBlocks = 0;
        String line = null;
        int lineCount = 0;
        boolean headerFound = false;
        ArrayList<String> blockLines = new ArrayList<String>();
        try {
            while ((line = bufRead.readLine()) != null) {
                line = line.trim();
                if (++lineCount <= 3 && (line.indexOf("\\_sh v4.0") > -1 || line.indexOf("\\_sh v3.0") > -1)) {
                    headerFound = true;
                    int lastSpaceIndex = line.trim().lastIndexOf(32);
                    if (lastSpaceIndex > -1) {
                        String db = line.substring(lastSpaceIndex).trim();
                        ServerLogger.LOG.info("Database type in header: " + db);
                        continue;
                    }
                }
                if (lineCount > 3 && !headerFound) {
                    ServerLogger.LOG.warning("No Toolbox header found, no Toolbox file?");
                    headerFound = true;
                }
                if (line.startsWith("\\" + this.typFile.getRecordMarker())) {
                    if (blockLines.size() > 0) {
                        int defectiveBlocks = this.noOfDefectiveBlocks;
                        this.processBlock(blockLines);
                        if (defectiveBlocks == this.noOfDefectiveBlocks) {
                            ++successiveBlocks;
                        }
                        blockLines.clear();
                    }
                    blockLines.add(line);
                    continue;
                }
                if (line.length() <= 0) continue;
                blockLines.add(line);
            }
            if (blockLines.size() > 0) {
                this.processLastBlock(blockLines);
            }
            if (this.noOfDefectiveBlocks > 0) {
                if (successiveBlocks == 0) {
                    throw new ParseException("Import Failed: Might be due to toolbox type file mismatch with the tollbox file.");
                }
                ClientLogger.LOG.warning(toolboxFile.getName() + " : ToolBox file imported but it might miss some details, since few blocks were not imported(possibly due to mismatch btw the toolbox type file).");
            } else if (successiveBlocks == 0) {
                throw new ParseException("Import Failed: Toolbox file or the type file might be invalid.");
            }
            this.calculateRootTimes();
        }
        catch (IOException ioe) {
            ServerLogger.LOG.severe("Error reading file: " + ioe.getMessage());
        }
    }

    private void processLastBlock(ArrayList<String> lines) {
        int i;
        if (lines == null || lines.size() == 0) {
            return;
        }
        String line = null;
        String curMark = null;
        ArrayList<Integer> removables = new ArrayList<Integer>(4);
        MediaDescriptor mediaDescriptor = null;
        for (i = 0; i < lines.size(); ++i) {
            line = lines.get(i);
            if (!line.startsWith("\\") || line.length() <= 1 || line.charAt(1) == ' ' || line.charAt(1) == '\t') continue;
            int space = line.indexOf(32);
            curMark = space <= 1 ? line.substring(1) : line.substring(1, space);
            if (curMark.equals(elanMediaURLLabel)) {
                if (space < line.length() && space > -1) {
                    mediaDescriptor = new MediaDescriptor(line.substring(space + 1), null);
                    this.mediaDescriptors.add(mediaDescriptor);
                }
                removables.add(i);
                continue;
            }
            if (curMark.equals(elanMediaMIMELabel)) {
                if (space < line.length() && space > -1 && mediaDescriptor != null) {
                    mediaDescriptor.mimeType = line.substring(space + 1);
                }
                removables.add(i);
                continue;
            }
            if (curMark.equals(elanMediaExtractedLabel)) {
                if (space < line.length() && space > -1 && mediaDescriptor != null) {
                    mediaDescriptor.extractedFrom = line.substring(space + 1);
                }
                removables.add(i);
                continue;
            }
            if (!curMark.equals(elanMediaOriginLabel)) continue;
            if (space < line.length() && space > -1 && mediaDescriptor != null) {
                try {
                    mediaDescriptor.timeOrigin = new Long(line.substring(space + 1));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            removables.add(i);
        }
        if (removables.size() > 0) {
            for (i = removables.size() - 1; i >= 0; --i) {
                lines.remove((Integer)removables.get(i));
            }
        }
        this.processBlock(lines);
    }

    private void processBlock(ArrayList<String> lines) {
        int i;
        if (lines == null || lines.size() == 0) {
            return;
        }
        String line = null;
        String curMark = null;
        String prevMark = null;
        ToolboxLine tl = null;
        LinkedHashMap<String, ToolboxLine> tbLines = new LinkedHashMap<String, ToolboxLine>(12);
        HashMap<String, Integer> numLinesPerMarker = new HashMap<String, Integer>(12);
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            line = lines.get(i2);
            if (line.startsWith("\\")) {
                if (line.length() > 1 && line.charAt(1) != ' ' && line.charAt(1) != '\t') {
                    int space = line.indexOf(32);
                    prevMark = curMark;
                    curMark = space <= 1 ? line.substring(1) : line.substring(1, space);
                    this.storeLabelInOrder(curMark, prevMark);
                    if (this.typFile.isIncluded(curMark)) {
                        String parMark;
                        if (tbLines.containsKey(curMark)) {
                            if (this.typFile.isInterlinear(curMark)) {
                                int numL = 0;
                                if (numLinesPerMarker.containsKey(curMark)) {
                                    numL = (Integer)numLinesPerMarker.get(curMark);
                                }
                                int numPL = 0;
                                parMark = this.typFile.getParentMarker(curMark);
                                if (parMark != null) {
                                    int numDif;
                                    if (numLinesPerMarker.containsKey(parMark)) {
                                        numPL = (Integer)numLinesPerMarker.get(parMark);
                                    }
                                    if ((numDif = numPL - numL) > 1) {
                                        for (int k = 1; k < numDif; ++k) {
                                            ((ToolboxLine)((HashMap)tbLines).get(curMark)).appendLine(" ");
                                        }
                                    }
                                }
                                if (line.length() > space && space > -1) {
                                    ((ToolboxLine)((HashMap)tbLines).get(curMark)).appendLine(line.substring(space + 1));
                                } else {
                                    ((ToolboxLine)((HashMap)tbLines).get(curMark)).appendLine(" ");
                                }
                                numLinesPerMarker.put(curMark, numL + 1);
                                continue;
                            }
                            if (line.length() > space && space > -1) {
                                ((ToolboxLine)((HashMap)tbLines).get(curMark)).appendLine(line.substring(space + 1));
                                continue;
                            }
                            ((ToolboxLine)((HashMap)tbLines).get(curMark)).appendLine(" ");
                            continue;
                        }
                        if (this.typFile.isInterlinear(curMark)) {
                            int numPL = 0;
                            parMark = this.typFile.getParentMarker(curMark);
                            if (parMark != null && numLinesPerMarker.containsKey(parMark)) {
                                numPL = (Integer)numLinesPerMarker.get(parMark);
                            }
                            if (numPL > 1) {
                                tl = new InterlinearToolboxLine(curMark, " ");
                                for (int k = 1; k < numPL - 1; ++k) {
                                    tl.appendLine(" ");
                                }
                                if (line.length() > space && space > -1) {
                                    tl.appendLine(line.substring(space + 1));
                                } else {
                                    tl.appendLine(" ");
                                }
                                tbLines.put(curMark, tl);
                                numLinesPerMarker.put(curMark, numPL);
                                continue;
                            }
                            tl = line.length() > space && space > -1 ? new InterlinearToolboxLine(curMark, line.substring(space + 1)) : new InterlinearToolboxLine(curMark, " ");
                            tbLines.put(curMark, tl);
                            numLinesPerMarker.put(curMark, 1);
                            continue;
                        }
                        tl = line.length() > space && space > -1 ? new SimpleToolboxLine(curMark, line.substring(space + 1)) : new SimpleToolboxLine(curMark, "");
                        tbLines.put(curMark, tl);
                        numLinesPerMarker.put(curMark, 1);
                        continue;
                    }
                    if (!this.specialMarkers.contains(curMark)) continue;
                    tl = line.length() > space && space > -1 ? new SimpleToolboxLine(curMark, line.substring(space + 1)) : new SimpleToolboxLine(curMark, "");
                    tbLines.put(curMark, tl);
                    numLinesPerMarker.put(curMark, 1);
                    continue;
                }
                if (!this.typFile.isIncluded(curMark) && !this.specialMarkers.contains(curMark) || tl == null) continue;
                tl.appendLine(line);
                continue;
            }
            if (!this.typFile.isIncluded(curMark) && !this.specialMarkers.contains(curMark) || tl == null) continue;
            tl.appendLine(line);
        }
        ArrayList<ToolboxLine> allLines = new ArrayList<ToolboxLine>(((HashMap)tbLines).values());
        tl = null;
        ToolboxLine tl2 = null;
        String parentMarker = null;
        block3: for (i = 0; i < allLines.size(); ++i) {
            tl = (ToolboxLine)allLines.get(i);
            if (tl.getMarkerName().equals(this.typFile.getRecordMarker()) || (parentMarker = this.typFile.getParentMarker(tl.getMarkerName())) == null) continue;
            for (int j = 0; j < allLines.size(); ++j) {
                ToolboxLine recLine;
                if (j == i) continue;
                tl2 = allLines.get(j);
                if (tl2.getMarkerName().equals(parentMarker)) {
                    tl.setParent(tl2);
                    continue block3;
                }
                if (j != allLines.size() - 1 || (recLine = (ToolboxLine)((HashMap)tbLines).get(this.typFile.getRecordMarker())) == null) continue;
                tl.setParent(recLine);
                ServerLogger.LOG.warning("Parent for " + tl.getMarkerName() + " not found; reparenting under the record marker");
            }
        }
        tl = null;
        for (i = 0; i < allLines.size(); ++i) {
            tl = (ToolboxLine)allLines.get(i);
            if (!(tl instanceof InterlinearToolboxLine)) continue;
            ((InterlinearToolboxLine)tl).setCorrectForMultipleByteChars(this.decoderInfo.isRecalculateForCharBytes());
            ((InterlinearToolboxLine)tl).createIndices2();
        }
        Enumeration<TreeNode> breadthEn = this.tierTree.breadthFirstEnumeration();
        while (breadthEn.hasMoreElements()) {
            ToolboxMarker tm2;
            DefaultMutableTreeNode node2;
            ToolboxMarker tm1;
            DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)breadthEn.nextElement();
            if (node1.getParent() == null || node1.getParent() == this.tierTree || !this.typFile.isInterlinear((tm1 = (ToolboxMarker)node1.getUserObject()).getMarker()) || !((node2 = (DefaultMutableTreeNode)node1.getParent()).getUserObject() instanceof ToolboxMarker) || !this.typFile.isInterlinear((tm2 = (ToolboxMarker)node2.getUserObject()).getMarker())) continue;
            ToolboxLine tbl1 = (ToolboxLine)((HashMap)tbLines).get(tm1.getMarker());
            ToolboxLine tbl2 = (ToolboxLine)((HashMap)tbLines).get(tm2.getMarker());
            if (!(tbl1 instanceof InterlinearToolboxLine) || !(tbl2 instanceof InterlinearToolboxLine)) continue;
            this.addMissingIndicesOnChild((InterlinearToolboxLine)tbl2, (InterlinearToolboxLine)tbl1);
        }
        this.createAnnotations(allLines);
    }

    private void createAnnotations(ArrayList<ToolboxLine> allLines) {
        ToolboxLine tl;
        if (allLines == null || allLines.size() == 0) {
            return;
        }
        SimpleToolboxLine stl = null;
        SimpleToolboxLine rootTl = null;
        String speaker = UNKNOWN;
        long t0 = -1L;
        long t1 = -1L;
        ArrayList<SimpleToolboxLine> removables = new ArrayList<SimpleToolboxLine>();
        MediaDescriptor mediaDescriptor = null;
        for (int i = 0; i < allLines.size(); ++i) {
            tl = allLines.get(i);
            if (!(tl instanceof SimpleToolboxLine)) continue;
            stl = (SimpleToolboxLine)tl;
            if (stl.getMarkerName().equals(this.typFile.getRecordMarker())) {
                if (this.decoderInfo.isTimeInRefMarker()) {
                    t0 = this.timeForString(stl.getLine());
                }
                rootTl = stl;
                continue;
            }
            if (stl.getMarkerName().equals(elanBeginLabel) || stl.getMarkerName().equals(label_eudicot0)) {
                t0 = this.timeForString(stl.getLine());
                removables.add(stl);
                continue;
            }
            if (stl.getMarkerName().equals(elanEndLabel) || stl.getMarkerName().equals(label_eudicot1)) {
                t1 = this.timeForString(stl.getLine());
                removables.add(stl);
                continue;
            }
            if (stl.getMarkerName().equals(elanParticipantLabel) || stl.getMarkerName().equals(label_eudicoparticipant) || stl.getMarkerName().equals(this.userParticipantMarker)) {
                speaker = stl.getLine();
                removables.add(stl);
                continue;
            }
            if (stl.getMarkerName().equals(elanMediaURLLabel)) {
                mediaDescriptor = new MediaDescriptor(stl.getLine(), null);
                this.mediaDescriptors.add(mediaDescriptor);
                removables.add(stl);
                continue;
            }
            if (stl.getMarkerName().equals(elanMediaMIMELabel)) {
                if (mediaDescriptor != null) {
                    mediaDescriptor.mimeType = stl.getLine();
                }
                removables.add(stl);
                continue;
            }
            if (stl.getMarkerName().equals(elanMediaExtractedLabel)) {
                if (mediaDescriptor != null) {
                    mediaDescriptor.extractedFrom = stl.getLine();
                }
                removables.add(stl);
                continue;
            }
            if (!stl.getMarkerName().equals(elanMediaOriginLabel)) continue;
            if (mediaDescriptor != null) {
                try {
                    mediaDescriptor.timeOrigin = new Long(stl.getLine());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            removables.add(stl);
        }
        if (rootTl == null) {
            ++this.noOfDefectiveBlocks;
            System.out.println(" defective blocks : " + this.noOfDefectiveBlocks);
            if (this.noOfDefectiveBlocks >= 5) {
                throw new ParseException("defective blocks");
            }
        } else {
            DefaultMutableTreeNode n2;
            int i;
            if (!this.participantOrder.contains(speaker)) {
                this.participantOrder.add(speaker);
            }
            this.tierNameSet.add(rootTl.getMarkerName() + AT + speaker);
            allLines.removeAll(removables);
            ArrayList<DefaultMutableTreeNode> allNodes = new ArrayList<DefaultMutableTreeNode>(allLines.size());
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(rootTl);
            for (int i2 = 0; i2 < allLines.size(); ++i2) {
                tl = allLines.get(i2);
                if (tl != rootTl) {
                    allNodes.add(new DefaultMutableTreeNode(tl));
                }
                this.tierNameSet.add(tl.getMarkerName() + AT + speaker);
            }
            block4: for (i = 0; i < allNodes.size(); ++i) {
                DefaultMutableTreeNode n1 = (DefaultMutableTreeNode)allNodes.get(i);
                tl = (ToolboxLine)n1.getUserObject();
                if (tl.getParent() == rootTl) {
                    rootNode.add(n1);
                    this.parentHash.put(tl.getMarkerName() + AT + speaker, rootTl.getMarkerName() + AT + UNKNOWN);
                    continue;
                }
                for (int j = 0; j < allNodes.size(); ++j) {
                    n2 = (DefaultMutableTreeNode)allNodes.get(j);
                    ToolboxLine tl2 = (ToolboxLine)n2.getUserObject();
                    if (tl2 != tl.getParent()) continue;
                    n2.add(n1);
                    this.parentHash.put(tl.getMarkerName() + AT + speaker, tl2.getMarkerName() + AT + UNKNOWN);
                    continue block4;
                }
            }
            DefaultMutableTreeNode n1 = null;
            n2 = null;
            for (i = 0; i < rootNode.getChildCount(); ++i) {
                n1 = (DefaultMutableTreeNode)rootNode.getChildAt(i);
                if (n1.getUserObject() instanceof InterlinearToolboxLine) {
                    this.createWordNodes(rootNode, n1);
                    continue;
                }
                if (!(n1.getUserObject() instanceof SimpleToolboxLine)) continue;
                Enumeration<TreeNode> depEnum = n1.depthFirstEnumeration();
                while (depEnum.hasMoreElements()) {
                    n2 = (DefaultMutableTreeNode)depEnum.nextElement();
                    if (!(n2.getUserObject() instanceof InterlinearToolboxLine) || !(((DefaultMutableTreeNode)n2.getParent()).getUserObject() instanceof SimpleToolboxLine)) continue;
                    this.createWordNodes((DefaultMutableTreeNode)n2.getParent(), n2);
                }
            }
            String rootTierName = rootTl.getMarkerName() + AT + speaker;
            AnnotationRecord annRec = new AnnotationRecord();
            annRec.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
            annRec.setAnnotationType("alignable");
            long beginTSId = this.tsId++;
            long endTSId = this.tsId++;
            annRec.setBeginTimeSlotId(TS_ID_PREFIX + Long.toString(beginTSId));
            annRec.setEndTimeSlotId(TS_ID_PREFIX + Long.toString(endTSId));
            if (this.decoderInfo.isScrubAnnotations()) {
                annRec.setValue(this.scrubAnnotation(rootTl.getLine()));
            } else {
                annRec.setValue(rootTl.getLine());
            }
            if (this.rootSlots.size() == 0 && t0 < 0L) {
                t0 = 0L;
            }
            long[] begin = new long[]{beginTSId, t0};
            long[] end = new long[]{endTSId, t1};
            this.timeSlots.add(begin);
            this.timeSlots.add(end);
            this.timeOrder.add(begin);
            this.timeOrder.add(end);
            this.rootSlots.add(begin);
            this.rootSlots.add(end);
            this.annotationRecords.add(annRec);
            this.addRecordToTierMap(annRec, rootTierName);
            this.createChildAnnotations(rootNode, annRec, speaker);
        }
    }

    private void createChildAnnotations(DefaultMutableTreeNode parNode, AnnotationRecord parentRecord, String speaker) {
        ToolboxWord tw;
        AnnotationRecord annRec;
        DefaultMutableTreeNode chNode;
        LinkedHashMap wordsMap = null;
        for (int i = 0; i < parNode.getChildCount(); ++i) {
            chNode = (DefaultMutableTreeNode)parNode.getChildAt(i);
            Object userObj = chNode.getUserObject();
            if (userObj instanceof InterlinearToolboxLine) {
                if (chNode.getChildCount() <= 0) continue;
                this.createChildAnnotations(chNode, parentRecord, speaker);
            }
            if (userObj instanceof SimpleToolboxLine) {
                SimpleToolboxLine stl = (SimpleToolboxLine)userObj;
                String tierName = stl.getMarkerName() + AT + speaker;
                annRec = new AnnotationRecord();
                annRec.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
                annRec.setAnnotationType("reference");
                if (this.decoderInfo.isScrubAnnotations()) {
                    annRec.setValue(this.scrubAnnotation(stl.getLine()));
                } else {
                    annRec.setValue(stl.getLine());
                }
                annRec.setReferredAnnotId(parentRecord.getAnnotationId());
                this.annotationRecords.add(annRec);
                this.addRecordToTierMap(annRec, tierName);
                this.createChildAnnotations(chNode, annRec, speaker);
                continue;
            }
            if (!(userObj instanceof ToolboxWord)) continue;
            tw = (ToolboxWord)userObj;
            if (wordsMap == null) {
                wordsMap = new LinkedHashMap();
            }
            if (wordsMap.containsKey(tw.getMarkerName())) {
                ((ArrayList)wordsMap.get(tw.getMarkerName())).add(chNode);
                continue;
            }
            wordsMap.put(tw.getMarkerName(), new ArrayList());
            ((ArrayList)wordsMap.get(tw.getMarkerName())).add(chNode);
        }
        if (wordsMap != null) {
            Iterator markIt = wordsMap.keySet().iterator();
            AnnotationRecord prevRec = null;
            while (markIt.hasNext()) {
                prevRec = null;
                String curMarker = (String)markIt.next();
                String curTier = curMarker + AT + speaker;
                ArrayList curWords = (ArrayList)wordsMap.get(curMarker);
                int type = this.typFile.getStereoType(curMarker);
                boolean alignable = type == 1 || type == 0;
                for (int i = 0; i < curWords.size(); ++i) {
                    chNode = (DefaultMutableTreeNode)curWords.get(i);
                    tw = (ToolboxWord)chNode.getUserObject();
                    annRec = new AnnotationRecord();
                    annRec.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
                    if (this.decoderInfo.isScrubAnnotations()) {
                        annRec.setValue(this.scrubAnnotation(tw.word));
                    } else {
                        annRec.setValue(tw.word);
                    }
                    if (alignable) {
                        long[] end;
                        long endTsId;
                        annRec.setAnnotationType("alignable");
                        if (i == 0) {
                            annRec.setBeginTimeSlotId(parentRecord.getBeginTimeSlotId());
                            if (i < curWords.size() - 1) {
                                ++this.tsId;
                                annRec.setEndTimeSlotId(TS_ID_PREFIX + Long.toString(endTsId));
                                end = new long[]{endTsId, -1L};
                                this.timeSlots.add(end);
                                this.insertTimeSlot(end, parentRecord.getBeginTimeSlotId());
                            } else {
                                annRec.setEndTimeSlotId(parentRecord.getEndTimeSlotId());
                            }
                        } else if (i == curWords.size() - 1) {
                            annRec.setEndTimeSlotId(parentRecord.getEndTimeSlotId());
                            annRec.setBeginTimeSlotId(prevRec.getEndTimeSlotId());
                        } else {
                            annRec.setBeginTimeSlotId(prevRec.getEndTimeSlotId());
                            ++this.tsId;
                            annRec.setEndTimeSlotId(TS_ID_PREFIX + Long.toString(endTsId));
                            end = new long[]{endTsId, -1L};
                            this.timeSlots.add(end);
                            this.insertTimeSlot(end, prevRec.getEndTimeSlotId());
                        }
                    } else {
                        annRec.setAnnotationType("reference");
                        annRec.setReferredAnnotId(parentRecord.getAnnotationId());
                        if (prevRec != null && type == 3) {
                            annRec.setPreviousAnnotId(prevRec.getAnnotationId());
                        }
                    }
                    prevRec = annRec;
                    this.annotationRecords.add(annRec);
                    this.addRecordToTierMap(annRec, curTier);
                    this.createChildAnnotations(chNode, annRec, speaker);
                }
            }
        }
    }

    private void createWordNodes(List<DefaultMutableTreeNode> parNodes, DefaultMutableTreeNode chLine) {
        DefaultMutableTreeNode nextNode;
        int i;
        ArrayList<DefaultMutableTreeNode> chNodes = new ArrayList<DefaultMutableTreeNode>();
        InterlinearToolboxLine tbl = (InterlinearToolboxLine)chLine.getUserObject();
        ToolboxWord tw = null;
        ToolboxWord parw = null;
        block0: for (i = 0; i < tbl.getStartIndices().length; ++i) {
            tw = tbl.getWordAtIndex(tbl.getStartIndices()[i], 0);
            if (tw == null) continue;
            for (int j = 0; j < parNodes.size(); ++j) {
                DefaultMutableTreeNode parNode = parNodes.get(j);
                parw = (ToolboxWord)parNode.getUserObject();
                if (tw.calcX >= parw.calcX && tw.calcX + tw.calcW <= parw.calcX + parw.calcW || j == parNodes.size() - 1 && tw.calcX >= parw.calcX) {
                    if (this.typFile.isSubdivision(tw.getMarkerName())) {
                        nextNode = new DefaultMutableTreeNode(tw);
                        parNode.add(nextNode);
                        chNodes.add(nextNode);
                        continue block0;
                    }
                    if (parNode.getChildCount() == 0) {
                        nextNode = new DefaultMutableTreeNode(tw);
                        parNode.add(nextNode);
                        chNodes.add(nextNode);
                        continue block0;
                    }
                    nextNode = new DefaultMutableTreeNode(tw);
                    parNode.add(nextNode);
                    chNodes.add(nextNode);
                    continue block0;
                }
                if (j != parNodes.size() - 1) continue;
                ServerLogger.LOG.warning("Could not add child: " + tw.getMarkerName() + " - " + tw.word);
                if (i < parNodes.size()) {
                    parNode = parNodes.get(i);
                    parw = (ToolboxWord)parNode.getUserObject();
                    int maxX1 = Math.max(tw.calcX, parw.calcX);
                    int minX2 = Math.min(tw.calcX + tw.calcW, parw.calcX + parw.calcW);
                    int curO = minX2 - maxX1;
                    if (curO > 0) {
                        DefaultMutableTreeNode tmpNode;
                        ToolboxWord tmpw = null;
                        int prevO = -1;
                        int prevX = 0;
                        int nextO = -1;
                        int nextX = 0;
                        if (i > 0) {
                            tmpNode = parNodes.get(i - 1);
                            tmpw = (ToolboxWord)tmpNode.getUserObject();
                            prevX = tmpw.calcX;
                            prevO = Math.min(tw.calcX + tw.calcW, tmpw.calcX + tmpw.calcW) - Math.max(tw.calcX, tmpw.calcX);
                        }
                        if (i < parNodes.size() - 1) {
                            tmpNode = parNodes.get(i + 1);
                            tmpw = (ToolboxWord)tmpNode.getUserObject();
                            nextX = tmpw.calcX;
                            nextO = Math.min(tw.calcX + tw.calcW, tmpw.calcX + tmpw.calcW) - Math.max(tw.calcX, tmpw.calcX);
                        }
                        int bestMatch = i;
                        if (prevO > curO && Math.abs(prevX - tw.calcX) < Math.abs(parw.calcX - tw.calcX)) {
                            bestMatch = i - 1;
                        }
                        if (nextO > curO && Math.abs(nextX - tw.calcX) < Math.abs(parw.calcX - tw.calcX)) {
                            bestMatch = i + 1;
                        }
                        if (bestMatch != i) {
                            parNode = parNodes.get(bestMatch);
                        }
                        parw = (ToolboxWord)parNode.getUserObject();
                        nextNode = new DefaultMutableTreeNode(tw);
                        parNode.add(nextNode);
                        chNodes.add(nextNode);
                        ServerLogger.LOG.info("Added child: " + tw.getMarkerName() + " - " + tw.word + " to parent: " + parw.word);
                        continue;
                    }
                    int bestMatch = -1;
                    curO = -1;
                    int curdifX = Integer.MAX_VALUE;
                    int bestO = curO;
                    int bestdifX = curdifX;
                    for (int k = 0; k < parNodes.size(); ++k) {
                        parNode = parNodes.get(k);
                        parw = (ToolboxWord)parNode.getUserObject();
                        curO = Math.min(tw.calcX + tw.calcW, parw.calcX + parw.calcW) - Math.max(tw.calcX, parw.calcX);
                        curdifX = Math.abs(parw.calcX - tw.calcX);
                        if (curO < bestO || curdifX >= bestdifX) continue;
                        bestO = curO;
                        bestdifX = curdifX;
                        bestMatch = k;
                    }
                    if (bestMatch <= -1) continue;
                    parNode = parNodes.get(bestMatch);
                    parw = (ToolboxWord)parNode.getUserObject();
                    nextNode = new DefaultMutableTreeNode(tw);
                    parNode.add(nextNode);
                    chNodes.add(nextNode);
                    ServerLogger.LOG.info("Added child 2: " + tw.getMarkerName() + " - " + tw.word + " to parent: " + parw.word);
                    continue;
                }
                int bestMatch = -1;
                int curO = -1;
                int curdifX = Integer.MAX_VALUE;
                int bestO = curO;
                int bestdifX = curdifX;
                for (int k = 0; k < parNodes.size(); ++k) {
                    parNode = parNodes.get(k);
                    parw = (ToolboxWord)parNode.getUserObject();
                    curO = Math.min(tw.calcX + tw.calcW, parw.calcX + parw.calcW) - Math.max(tw.calcX, parw.calcX);
                    curdifX = Math.abs(parw.calcX - tw.calcX);
                    if (curO < bestO || curdifX >= bestdifX) continue;
                    bestO = curO;
                    bestdifX = curdifX;
                    bestMatch = k;
                }
                if (bestMatch <= -1) continue;
                parNode = parNodes.get(bestMatch);
                parw = (ToolboxWord)parNode.getUserObject();
                nextNode = new DefaultMutableTreeNode(tw);
                parNode.add(nextNode);
                chNodes.add(nextNode);
                ServerLogger.LOG.info("Added child 3: " + tw.getMarkerName() + " - " + tw.word + " to parent: " + parw.word);
            }
        }
        for (i = 0; i < chLine.getChildCount(); ++i) {
            nextNode = (DefaultMutableTreeNode)chLine.getChildAt(i);
            this.createWordNodes(chNodes, nextNode);
        }
    }

    private void createWordNodes(DefaultMutableTreeNode parNode, DefaultMutableTreeNode chLine) {
        DefaultMutableTreeNode nextNode;
        int i;
        ArrayList<DefaultMutableTreeNode> chNodes = new ArrayList<DefaultMutableTreeNode>();
        InterlinearToolboxLine tbl = (InterlinearToolboxLine)chLine.getUserObject();
        ToolboxWord tw = null;
        for (i = 0; i < tbl.getStartIndices().length; ++i) {
            tw = tbl.getWordAtIndex(tbl.getStartIndices()[i], 0);
            if (tw == null) continue;
            nextNode = new DefaultMutableTreeNode(tw);
            chNodes.add(nextNode);
        }
        for (int j = 0; j < chLine.getChildCount(); ++j) {
            nextNode = (DefaultMutableTreeNode)chLine.getChildAt(j);
            if (!(nextNode.getUserObject() instanceof InterlinearToolboxLine)) continue;
            this.createWordNodes(chNodes, nextNode);
        }
        for (i = 0; i < chNodes.size(); ++i) {
            parNode.add((MutableTreeNode)chNodes.get(i));
        }
    }

    private void harmonizeLines(InterlinearToolboxLine parentLine, InterlinearToolboxLine childLine) {
        if (parentLine != null && childLine != null) {
            int parNumWords = parentLine.getNumberOfWords();
            int chNumWords = childLine.getNumberOfWords();
            if (parNumWords == 0 && chNumWords == 0) {
                return;
            }
            boolean isSubDiv = this.typFile.isSubdivision(childLine.getMarkerName());
            int[] parInd = parentLine.getStartIndices();
            int[] chInd = childLine.getStartIndices();
            int j = 0;
            block0: for (int i = 0; i < parInd.length; ++i) {
                while (j < chInd.length) {
                    if (i == j && parInd[i] == chInd[j]) {
                        ++j;
                        continue block0;
                    }
                    if (j <= i || isSubDiv || chInd[j] <= parInd[i] + 1) {
                        if (i == j && !isSubDiv && chInd[j] > parInd[i]) {
                            int end = 0;
                            end = i < parInd.length - 1 ? parInd[i + 1] - 1 : parentLine.getWordAtIndex((int)parInd[i], (int)0).calcW;
                            boolean succ = childLine.conditionallyInsertWord(parInd[i], end);
                            ServerLogger.LOG.info("Inserted word on child: " + childLine.getMarkerName() + parInd[i] + " " + succ);
                            if (succ) {
                                ++j;
                            }
                        } else if (chInd[j] > parInd[i]) {
                            // empty if block
                        }
                    }
                    ++j;
                }
            }
        }
    }

    private void addMissingIndicesOnChild(InterlinearToolboxLine parentLine, InterlinearToolboxLine childLine) {
        if (parentLine != null && childLine != null) {
            int[] parInd = parentLine.getStartIndices();
            int[] chInd = childLine.getStartIndices();
            block0: for (int i = 0; i < parInd.length; ++i) {
                for (int j = 0; j < chInd.length && parInd[i] != chInd[j]; ++j) {
                    int begin;
                    if (chInd[j] <= parInd[i]) continue;
                    int end = begin = parInd[i];
                    end = i < parInd.length - 1 ? parInd[i + 1] - 1 : parInd[i] + parentLine.getWordAtIndex((int)parInd[i], (int)0).calcW;
                    boolean succ = childLine.conditionallyInsertWord(parInd[i], end);
                    if (succ) {
                        ServerLogger.LOG.info("Inserted on " + childLine.getMarkerName() + " at " + begin);
                        chInd = childLine.getStartIndices();
                        continue block0;
                    }
                    ServerLogger.LOG.info("Could not insert on " + childLine.getMarkerName() + " at " + begin);
                    continue block0;
                }
            }
        }
    }

    private void checkIndices(InterlinearToolboxLine parentLine, InterlinearToolboxLine childLine) {
        if (parentLine != null && childLine != null) {
            int[] parInd = parentLine.getStartIndices();
            int[] chInd = childLine.getStartIndices();
            block0: for (int i = 0; i < parInd.length; ++i) {
                for (int j = 0; j < chInd.length && parInd[i] != chInd[j]; ++j) {
                    if (chInd[j] <= parInd[i]) continue;
                    if (j == 0) {
                        System.out.println("pb: " + parInd[i] + " rw: " + parentLine.getWordAtIndex((int)parInd[i], (int)0).realW + " cw: " + parentLine.getWordAtIndex((int)parInd[i], (int)0).calcW);
                        System.out.println("cb: " + chInd[j] + " rw: " + childLine.getWordAtIndex((int)chInd[j], (int)0).realW + " cw: " + childLine.getWordAtIndex((int)chInd[j], (int)0).calcW);
                        continue block0;
                    }
                    System.out.println("pb: " + parInd[i] + " rw: " + parentLine.getWordAtIndex((int)parInd[i], (int)0).realW + " cw: " + parentLine.getWordAtIndex((int)parInd[i], (int)0).calcW);
                    System.out.println("cb: " + chInd[j - 1] + " rw: " + childLine.getWordAtIndex((int)chInd[j - 1], (int)0).realW + " cw: " + childLine.getWordAtIndex((int)chInd[j - 1], (int)0).calcW);
                    continue block0;
                }
            }
        }
    }

    private void storeLabelInOrder(String label, String prevLabel) {
        if (label == null || label.length() == 0 || this.markerOrder.contains(label)) {
            return;
        }
        if (prevLabel == null) {
            this.markerOrder.add(label);
        } else {
            if (this.markerOrder.size() == 0) {
                this.markerOrder.add(label);
                return;
            }
            for (int i = 0; i < this.markerOrder.size(); ++i) {
                if (!prevLabel.equals(this.markerOrder.get(i))) continue;
                this.markerOrder.add(i + 1, label);
                return;
            }
        }
    }

    private long timeForString(String time) {
        if (time == null) {
            return -1L;
        }
        long t0 = -1L;
        try {
            double d = Double.parseDouble(time);
            if ((d *= 1000.0) == -1000.0) {
                d = -1.0;
            }
            t0 = (long)d;
        }
        catch (NumberFormatException nfe) {
            t0 = this.toMilliSeconds(time);
        }
        return t0;
    }

    private void addRecordToTierMap(AnnotationRecord annRec, String tierName) {
        this.annotRecordToTierMap.put(annRec, tierName);
        if (this.tierNameToAnnRecordMap.containsKey(tierName)) {
            this.tierNameToAnnRecordMap.get(tierName).add(annRec);
        } else {
            ArrayList<AnnotationRecord> ar = new ArrayList<AnnotationRecord>();
            ar.add(annRec);
            this.tierNameToAnnRecordMap.put(tierName, ar);
        }
    }

    private void insertTimeSlot(long[] ts, String afterId) {
        long afterIndex = -1L;
        try {
            afterIndex = Long.valueOf(afterId.substring(TS_ID_PREFIX.length()));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        int toIndex = this.timeOrder.size();
        for (int j = 0; j < this.timeOrder.size(); ++j) {
            long[] loopTs = this.timeOrder.get(j);
            if (loopTs[0] != afterIndex) continue;
            toIndex = j;
            break;
        }
        if (toIndex > this.timeOrder.size() - 1) {
            this.timeOrder.add(ts);
        } else {
            this.timeOrder.add(toIndex + 1, ts);
        }
    }

    private void calculateRootTimes() {
        int firstUAIndex = -1;
        for (int i = 0; i < this.rootSlots.size(); ++i) {
            long[] slot = this.rootSlots.get(i);
            if (slot[1] == -1L) {
                if (firstUAIndex == -1) {
                    firstUAIndex = i;
                }
            } else if (firstUAIndex != -1) {
                this.calculateSlotsInInterval(firstUAIndex, i - 1);
                firstUAIndex = -1;
            }
            if (i != this.rootSlots.size() - 1 || firstUAIndex == -1) continue;
            this.calculateSlotsInInterval(firstUAIndex, i);
        }
    }

    private void calculateSlotsInInterval(int firstUAIndex, int lastUAIndex) {
        if (firstUAIndex == lastUAIndex) {
            if (firstUAIndex % 2 == 0) {
                long[] otherSlot = this.rootSlots.get(firstUAIndex - 1);
                long[] slot = this.rootSlots.get(firstUAIndex);
                slot[1] = otherSlot[1];
            } else if (lastUAIndex < this.rootSlots.size() - 1) {
                long[] otherSlot = this.rootSlots.get(lastUAIndex + 1);
                long nextVal = otherSlot[1];
                long[] slot = this.rootSlots.get(lastUAIndex);
                otherSlot = this.rootSlots.get(lastUAIndex - 1);
                if (nextVal - otherSlot[1] > (long)this.preferredBlockDuration) {
                    nextVal = otherSlot[1] + (long)this.preferredBlockDuration;
                }
                slot[1] = nextVal;
            } else {
                long[] otherSlot = this.rootSlots.get(lastUAIndex - 1);
                long[] slot = this.rootSlots.get(lastUAIndex);
                slot[1] = otherSlot[1] + (long)this.preferredBlockDuration;
            }
            return;
        }
        if (firstUAIndex == 1 && lastUAIndex == this.rootSlots.size() - 1) {
            for (int i = 1; i <= lastUAIndex; ++i) {
                long[] slot = this.rootSlots.get(i);
                slot[1] = (long)Math.ceil((float)i / 2.0f) * (long)this.preferredBlockDuration;
            }
            return;
        }
        if (lastUAIndex == this.rootSlots.size() - 1) {
            long[] slot = this.rootSlots.get(firstUAIndex - 1);
            long startTime = slot[1];
            int j = firstUAIndex % 2 == 0 ? 1 : 2;
            int i = firstUAIndex;
            while (i <= lastUAIndex) {
                slot = this.rootSlots.get(i);
                slot[1] = startTime + (long)(j / 2 * this.preferredBlockDuration);
                ++i;
                ++j;
            }
        } else {
            long startTime;
            int numIntervals = 0;
            long delta = 0L;
            int begin = firstUAIndex % 2 == 0 ? firstUAIndex + 1 : firstUAIndex;
            int end = lastUAIndex % 2 == 0 ? lastUAIndex + 1 : lastUAIndex;
            numIntervals = (end - begin) / 2 + 1;
            long[] slot = this.rootSlots.get(firstUAIndex - 1);
            long[] otherSlot = this.rootSlots.get(lastUAIndex + 1);
            long endTime = otherSlot[1];
            delta = (endTime - (startTime = slot[1])) / (long)numIntervals;
            if (delta > (long)this.preferredBlockDuration) {
                delta = this.preferredBlockDuration;
            }
            int j = firstUAIndex % 2 == 0 ? 1 : 2;
            int i = firstUAIndex;
            while (i <= lastUAIndex) {
                slot = this.rootSlots.get(i);
                slot[1] = startTime + (long)(j / 2) * delta;
                ++i;
                ++j;
            }
        }
    }

    private String scrubAnnotation(String origString) {
        if (origString == null) {
            return origString;
        }
        char[] chars = origString.toCharArray();
        StringBuilder b = new StringBuilder(origString.length());
        boolean lastSpace = false;
        boolean isSp = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < ' ') continue;
            isSp = false;
            for (int j = 0; j < this.scrubbables.length; ++j) {
                if (c != this.scrubbables[j]) continue;
                isSp = true;
                break;
            }
            if (!isSp) {
                b.append(c);
                lastSpace = false;
                continue;
            }
            if (c != this.scrubbables[0] || lastSpace) continue;
            b.append(c);
            lastSpace = true;
        }
        return b.toString();
    }

    public long toMilliSeconds(String timeString) {
        try {
            String hourString = new String("0.0");
            String minuteString = new String("0.0");
            String secondString = new String("0.0");
            int mark1 = timeString.indexOf(58, 0);
            if (mark1 == -1) {
                secondString = timeString;
            } else {
                int mark2 = timeString.indexOf(58, mark1 + 1);
                if (mark2 == -1) {
                    minuteString = timeString.substring(0, mark1);
                    secondString = timeString.substring(mark1 + 1, timeString.length());
                } else {
                    hourString = timeString.substring(0, mark1);
                    minuteString = timeString.substring(mark1 + 1, mark2);
                    secondString = timeString.substring(mark2 + 1, timeString.length());
                }
            }
            double hours = Double.valueOf(hourString);
            double minutes = Double.valueOf(minuteString);
            double seconds = Double.valueOf(secondString);
            return (long)(1000.0 * (hours * 3600.0 + minutes * 60.0 + seconds));
        }
        catch (Exception e) {
            ServerLogger.LOG.warning("Unknown time format: " + timeString);
            return -1L;
        }
    }

    @Override
    public ArrayList getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        ArrayList<AnnotationRecord> records = this.tierNameToAnnRecordMap.get(tierName);
        if (records == null) {
            records = new ArrayList(0);
        }
        return records;
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        String result = tierName;
        this.parse(fileName);
        int index = tierName.indexOf(AT);
        if (index > 0) {
            result = tierName.substring(0, index);
        }
        return result;
    }

    @Override
    public ArrayList<LingTypeRecord> getLinguisticTypes(String fileName) {
        this.parse(fileName);
        if (this.lingTypeRecords.size() == 0) {
            for (String name : this.markerOrder) {
                if (name.equals(elanBeginLabel) || name.equals(elanELANLabel) || name.equals(elanEndLabel) || name.equals(elanParticipantLabel) || name.equals(label_eudicoparticipant) || name.equals(label_eudicot0) || name.equals(label_eudicot1) || name.equals(this.userParticipantMarker)) continue;
                LingTypeRecord lt = new LingTypeRecord();
                lt.setLingTypeId(name);
                lt.setGraphicReferences("false");
                lt.setTimeAlignable("false");
                lt.setStereoType(Constraint.stereoTypes[4]);
                if (this.typFile.getRecordMarker().equals(name)) {
                    lt.setStereoType(null);
                    lt.setTimeAlignable("true");
                    this.lingTypeRecords.add(lt);
                    continue;
                }
                int stereotype = this.typFile.getStereoType(name);
                if (stereotype == 3) {
                    lt.setStereoType(Constraint.stereoTypes[3]);
                } else if (stereotype == 0) {
                    lt.setStereoType(Constraint.stereoTypes[0]);
                    lt.setTimeAlignable("true");
                } else if (stereotype == 1) {
                    lt.setStereoType(Constraint.stereoTypes[1]);
                    lt.setTimeAlignable("true");
                }
                this.lingTypeRecords.add(lt);
            }
        }
        return this.lingTypeRecords;
    }

    @Override
    public ArrayList getMediaDescriptors(String fileName) {
        this.parse(fileName);
        return this.mediaDescriptors;
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        int atIndex = tierName.indexOf(AT);
        if (atIndex > 0 && tierName.length() > atIndex) {
            String name = tierName.substring(0, atIndex);
            if (name.equals(this.typFile.getRecordMarker())) {
                return null;
            }
            String spk = tierName.substring(atIndex);
            String par = this.typFile.getParentMarker(name);
            if (par != null) {
                return par + spk;
            }
        } else {
            return this.typFile.getParentMarker(tierName);
        }
        return null;
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        String participant = "";
        int atIndex = tierName.indexOf(AT);
        if (atIndex > -1 && tierName.length() > atIndex + 1) {
            participant = tierName.substring(atIndex + 1);
        }
        return participant;
    }

    @Override
    public ArrayList getTierNames(String fileName) {
        this.parse(fileName);
        ArrayList<String> names = new ArrayList<String>(this.tierNameSet.size());
        String spk = null;
        String marker = null;
        String fullName = null;
        for (int i = 0; i < this.participantOrder.size(); ++i) {
            spk = this.participantOrder.get(i);
            for (int j = 0; j < this.markerOrder.size(); ++j) {
                marker = this.markerOrder.get(j);
                fullName = marker + AT + spk;
                if (!this.tierNameSet.contains(fullName)) continue;
                names.add(fullName);
            }
        }
        return names;
    }

    @Override
    public ArrayList getTimeOrder(String fileName) {
        this.parse(fileName);
        ArrayList<String> resultTimeOrder = new ArrayList<String>();
        for (int i = 0; i < this.timeOrder.size(); ++i) {
            resultTimeOrder.add(TS_ID_PREFIX + this.timeOrder.get(i)[0]);
        }
        return resultTimeOrder;
    }

    @Override
    public HashMap getTimeSlots(String fileName) {
        HashMap<String, String> resultSlots = new HashMap<String, String>();
        for (long[] timeSlot : this.timeSlots) {
            String tsId = TS_ID_PREFIX + timeSlot[0];
            String timeValue = Long.toString(timeSlot[1]);
            resultSlots.put(tsId, timeValue);
        }
        return resultSlots;
    }

    @Override
    public void setDecoderInfo(DecoderInfo decoderInfo) {
        if (decoderInfo instanceof ToolboxDecoderInfo2) {
            this.decoderInfo = (ToolboxDecoderInfo2)decoderInfo;
            this.preferredBlockDuration = (int)this.decoderInfo.getBlockDuration();
        }
    }
}

