/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.io.File;
import java.util.List;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxTypFile;

public class ToolboxDecoderInfo2
extends ToolboxDecoderInfo {
    private ToolboxTypFile toolboxTypFile;
    private boolean recalculateForCharBytes = true;
    private boolean scrubAnnotations = false;

    public ToolboxDecoderInfo2() {
    }

    public ToolboxDecoderInfo2(String shoeboxFilePath) {
        super(shoeboxFilePath);
    }

    @Override
    public void setShoeboxMarkers(List shoeboxMarkers) {
        super.setShoeboxMarkers(shoeboxMarkers);
        if (shoeboxMarkers == null || shoeboxMarkers.size() == 0) {
            throw new IllegalArgumentException("No markers specified");
        }
        this.toolboxTypFile = new ToolboxTypFile(shoeboxMarkers);
    }

    @Override
    public void setTypeFile(String typeFile) {
        super.setTypeFile(typeFile);
        if (typeFile == null) {
            throw new IllegalArgumentException("No .typ file specified");
        }
        File tpFile = new File(typeFile);
        this.toolboxTypFile = new ToolboxTypFile(tpFile);
    }

    public ToolboxTypFile getToolboxTypFile() {
        return this.toolboxTypFile;
    }

    public boolean isRecalculateForCharBytes() {
        return this.recalculateForCharBytes;
    }

    public void setRecalculateForCharBytes(boolean recalculateForCharBytes) {
        this.recalculateForCharBytes = recalculateForCharBytes;
    }

    public boolean isScrubAnnotations() {
        return this.scrubAnnotations;
    }

    public void setScrubAnnotations(boolean scrubAnnotations) {
        this.scrubAnnotations = scrubAnnotations;
    }
}

