/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.MarkerRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxArray;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxTypFile;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.shoebox.utr22.SimpleConverter;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.util.ServerLogger;

public class ShoeboxParser
extends Parser
implements ServerLogger {
    private static final String ANN_ID_PREFIX = "ann";
    private static final String TS_ID_PREFIX = "ts";
    private long annotId = 0L;
    private long tsId = 0L;
    private SimpleConverter simpleConverter;
    private ShoeboxArray sbxfile;
    private ShoeboxTypFile typfile;
    private ToolboxDecoderInfo decoderInfo;
    DefaultMutableTreeNode tiertree = new DefaultMutableTreeNode();
    private ArrayList lingTypeRecords = new ArrayList();
    private ArrayList participantOrder = new ArrayList();
    private TreeSet tierNameSet = new TreeSet();
    private HashMap parentHash = new HashMap();
    private ArrayList timeOrder = new ArrayList();
    private ArrayList timeSlots = new ArrayList();
    private ArrayList annotationRecords = new ArrayList();
    private HashMap annotRecordToTierMap = new HashMap();
    private String lastParsed = "";
    private ArrayList rootSlots = new ArrayList();
    private boolean fixImproperAlign = true;
    private int preferredBlockDuration = 1000;

    public ShoeboxParser() {
        try {
            this.simpleConverter = new SimpleConverter(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ArrayList getMediaDescriptors(String fileName) {
        this.parse(fileName);
        return this.sbxfile.getMediaDescriptors();
    }

    @Override
    public ArrayList getLinguisticTypes(String fileName) {
        this.parse(fileName);
        Enumeration en = this.sbxfile.getLabels();
        while (en.hasMoreElements()) {
            String procType;
            String label = (String)en.nextElement();
            if (label.equals(ShoeboxArray.label_eudicoparticipant) || label.equals(ShoeboxArray.label_eudicot0) || label.equals(ShoeboxArray.label_eudicot1) || label.equals("\\ELANParticipant") || label.equals("\\ELANBegin") || label.equals("\\ELANEnd") || label.equals("\\block") || label.equals("\\ELANExport")) continue;
            String ltName = label.substring(1);
            LingTypeRecord lt = new LingTypeRecord();
            lt.setLingTypeId(ltName);
            lt.setGraphicReferences("false");
            lt.setTimeAlignable("false");
            lt.setStereoType(Constraint.stereoTypes[4]);
            if (this.typfile.interlinearRootMarker != null && this.typfile.interlinearRootMarker.equals(ltName)) {
                lt.setStereoType(null);
                lt.setTimeAlignable("true");
            }
            if (this.typfile.getDatabaseType().equals("ElanExport") && !this.typfile.tofromHash.containsKey(ltName)) {
                lt.setStereoType(null);
                lt.setTimeAlignable("true");
            }
            if (this.typfile.tofromHash.containsKey(ltName) && this.typfile.fromArray.contains(label) && !this.typfile.procedureTypeHash.contains(label)) {
                lt.setStereoType(Constraint.stereoTypes[3]);
                lt.setTimeAlignable("false");
            }
            if ((procType = (String)this.typfile.procedureTypeHash.get(label)) != null) {
                if (procType.equals("Lookup")) {
                    lt.setStereoType(Constraint.stereoTypes[4]);
                    lt.setTimeAlignable("false");
                } else if (procType.equals("Parse")) {
                    lt.setStereoType(Constraint.stereoTypes[3]);
                    lt.setTimeAlignable("false");
                } else if (procType.equals("TimeSubdivision")) {
                    lt.setStereoType(Constraint.stereoTypes[0]);
                    lt.setTimeAlignable("true");
                } else if (procType.equals("IncludedIn")) {
                    lt.setStereoType(Constraint.stereoTypes[1]);
                    lt.setTimeAlignable("true");
                }
            }
            this.lingTypeRecords.add(lt);
        }
        return this.lingTypeRecords;
    }

    @Override
    public ArrayList getTimeOrder(String fileName) {
        this.parse(fileName);
        ArrayList<String> resultTimeOrder = new ArrayList<String>();
        for (int i = 0; i < this.timeOrder.size(); ++i) {
            resultTimeOrder.add(TS_ID_PREFIX + ((long[])this.timeOrder.get(i))[0]);
        }
        return resultTimeOrder;
    }

    @Override
    public HashMap getTimeSlots(String fileName) {
        this.parse(fileName);
        HashMap<String, String> resultSlots = new HashMap<String, String>();
        for (long[] timeSlot : this.timeSlots) {
            String tsId = TS_ID_PREFIX + timeSlot[0];
            String timeValue = Long.toString(timeSlot[1]);
            resultSlots.put(tsId, timeValue);
        }
        return resultSlots;
    }

    @Override
    public ArrayList getTierNames(String fileName) {
        this.parse(fileName);
        ArrayList<String> result = new ArrayList<String>();
        ArrayList allNames = new ArrayList(this.tierNameSet);
        ArrayList markerOrder = this.sbxfile.getMarkerOrder();
        String spk = null;
        String marker = null;
        for (int i = 0; i < this.participantOrder.size(); ++i) {
            spk = (String)this.participantOrder.get(i);
            for (int j = 0; j < markerOrder.size(); ++j) {
                marker = (String)markerOrder.get(j);
                if (!allNames.contains(marker + "@" + spk)) continue;
                result.add((marker + "@" + spk).substring(1));
            }
        }
        return result;
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        String result = "";
        this.parse(fileName);
        int index = tierName.indexOf("@");
        if (index > 0 && tierName.length() > index + 1) {
            result = tierName.substring(index + 1);
        }
        return result;
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        String result = tierName;
        this.parse(fileName);
        int index = tierName.indexOf("@");
        if (index > 0) {
            result = tierName.substring(0, index);
        }
        return result;
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        String parentName = null;
        this.parse(fileName);
        String labelPart = "\\" + tierName;
        String spkr = "@";
        int index = tierName.indexOf("@");
        if (index > 0 && tierName.length() > index) {
            labelPart = "\\" + tierName.substring(0, index);
            spkr = tierName.substring(index);
        }
        if (this.typfile.tofromHash.keySet().contains(labelPart)) {
            parentName = ((String)this.typfile.tofromHash.get(labelPart)).substring(1);
        } else if (this.typfile.interlinearRootMarker != null && !tierName.equals(this.typfile.interlinearRootMarker + spkr)) {
            parentName = this.typfile.interlinearRootMarker;
        }
        if (parentName != null) {
            return parentName + spkr;
        }
        return null;
    }

    @Override
    public ArrayList getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        ArrayList<AnnotationRecord> resultAnnotRecords = new ArrayList<AnnotationRecord>();
        tierName = "\\" + tierName;
        for (AnnotationRecord annRec : this.annotRecordToTierMap.keySet()) {
            if (!this.annotRecordToTierMap.get(annRec).equals(tierName)) continue;
            resultAnnotRecords.add(annRec);
        }
        return resultAnnotRecords;
    }

    private void parse(String fileName) {
        if (this.lastParsed.equals(fileName)) {
            return;
        }
        this.lingTypeRecords.clear();
        this.participantOrder.clear();
        this.tierNameSet.clear();
        this.parentHash.clear();
        this.timeOrder.clear();
        this.timeSlots.clear();
        this.annotationRecords.clear();
        this.annotRecordToTierMap.clear();
        this.rootSlots.clear();
        this.annotId = 0L;
        this.tsId = 0L;
        this.tiertree = null;
        this.lastParsed = fileName;
        List markers = null;
        String typFileName = "";
        if (this.decoderInfo != null) {
            markers = this.decoderInfo.getShoeboxMarkers();
            typFileName = this.decoderInfo.getTypeFile();
        }
        this.checkArguments(fileName, typFileName, markers);
        try {
            if (typFileName.equals("")) {
                this.typfile = new ShoeboxTypFile(markers);
            } else {
                this.typfile = new ShoeboxTypFile(new File(typFileName));
                this.typfile.setAllTiersUnicode(this.decoderInfo.isAllUnicode());
            }
            String rootMarker = null;
            if (this.typfile.interlinearRootMarker != null) {
                rootMarker = "\\" + this.typfile.interlinearRootMarker;
            }
            this.sbxfile = new ShoeboxArray(new File(fileName), rootMarker, this.typfile);
            this.tiertreeInit();
            for (int i = 0; i < this.sbxfile.getNumberOfBlocks(); ++i) {
                this.createBlock(i);
            }
            this.calculateRootTimes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void checkArguments(String sbxfn, String typfn, List markers) throws IllegalArgumentException {
        if (sbxfn == null || sbxfn.length() == 0) {
            throw new IllegalArgumentException("Please specify a shoebox file.");
        }
        if ((typfn == null || typfn.length() == 0) && markers.size() == 0) {
            String mkrFileName = sbxfn;
            if (sbxfn.endsWith(".txt")) {
                mkrFileName = sbxfn.substring(0, sbxfn.length() - 4) + ".mkr";
            }
            if (new File(mkrFileName).exists()) {
                this.readMarkersFromFile(mkrFileName, markers);
            } else {
                throw new IllegalArgumentException("Please specify a shoebox typ file or define markers.");
            }
        }
        if (!new File(sbxfn).exists()) {
            throw new IllegalArgumentException("Shoebox file doesn't exist.");
        }
        if (typfn != null && typfn.length() > 0 && !new File(typfn).exists()) {
            throw new IllegalArgumentException("Shoebox type file doesn't exist.");
        }
    }

    private void readMarkersFromFile(String mkrFileName, List markers) {
        File f = new File(mkrFileName);
        if (f != null) {
            String line = null;
            try {
                FileReader filereader = new FileReader(f);
                BufferedReader br = new BufferedReader(filereader);
                MarkerRecord newRecord = null;
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    String label = this.getLabelPart(line);
                    String value = this.getValuePart(line);
                    if (label.equals("marker")) {
                        newRecord = new MarkerRecord();
                        if (value.equals("null")) continue;
                        newRecord.setMarker(value);
                        continue;
                    }
                    if (label.equals("parent")) {
                        if (value.equals("null")) continue;
                        newRecord.setParentMarker(value);
                        continue;
                    }
                    if (label.equals("stereotype")) {
                        if (value.equals("null")) continue;
                        newRecord.setStereoType(value);
                        continue;
                    }
                    if (label.equals("charset")) {
                        if (value.equals("null")) continue;
                        newRecord.setCharset(value);
                        continue;
                    }
                    if (label.equals("exclude")) {
                        if (value.equals("null")) continue;
                        if (value.equals("true")) {
                            newRecord.setExcluded(true);
                            continue;
                        }
                        newRecord.setExcluded(false);
                        continue;
                    }
                    if (!label.equals("participant")) continue;
                    if (!value.equals("null")) {
                        if (value.equals("true")) {
                            newRecord.setParticipantMarker(true);
                        } else {
                            newRecord.setParticipantMarker(false);
                        }
                    }
                    markers.add(newRecord);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String getLabelPart(String theLine) {
        String label = null;
        int index = theLine.indexOf(58);
        if (index > 0) {
            label = theLine.substring(0, index);
        }
        return label;
    }

    private String getValuePart(String theLine) {
        String value = null;
        int index = theLine.indexOf(58);
        if (index < theLine.length() - 2) {
            value = theLine.substring(index + 1).trim();
        }
        return value;
    }

    private final void tiertreeInit() {
        DefaultMutableTreeNode elanTopNode = null;
        String rec = "\\" + this.typfile.interlinearRootMarker;
        this.tiertree = new DefaultMutableTreeNode();
        if (this.typfile.getDatabaseType().equals("ElanExport")) {
            elanTopNode = new DefaultMutableTreeNode("\\ELANExport");
            this.tiertree.add(elanTopNode);
        } else {
            elanTopNode = this.tiertree;
        }
        for (int i = 0; i < this.sbxfile.getNumberOfLabels(); ++i) {
            String label = this.sbxfile.getLabel(i);
            if (label.startsWith("\\ELAN")) continue;
            DefaultMutableTreeNode labelNode = this.sbxfile.getLabelNode(i);
            if (label.equals(rec)) {
                elanTopNode.add(labelNode);
                continue;
            }
            DefaultMutableTreeNode parentnode = null;
            String parent = null;
            if (this.typfile.tofromHash.containsKey(label)) {
                parent = (String)this.typfile.tofromHash.get(label);
                parentnode = this.sbxfile.getLabelNode(parent);
            } else if (!this.typfile.excludeFromImport(label)) {
                parentnode = this.typfile.getDatabaseType().equals("ElanExport") ? elanTopNode : this.sbxfile.getLabelNode(rec);
            }
            if (parentnode == null) continue;
            parentnode.add(labelNode);
        }
    }

    private void createBlock(int row) throws Exception {
        String spk = this.sbxfile.getSpeaker(row);
        long t0 = this.sbxfile.getT0(row);
        long t1 = this.sbxfile.getT1(row);
        String rootMarker = this.sbxfile.getRootMarkerForBlock(row);
        String val = this.sbxfile.getCell(rootMarker, row);
        if (this.decoderInfo != null && this.decoderInfo.isTimeInRefMarker()) {
            t0 = this.sbxfile.toMilliSeconds(val, row);
            t1 = -1L;
        }
        String tierName = rootMarker + "@" + spk;
        if (!this.participantOrder.contains(spk)) {
            this.participantOrder.add(spk);
        }
        this.tierNameSet.add(tierName);
        AnnotationRecord annRec = new AnnotationRecord();
        annRec.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
        annRec.setAnnotationType("alignable");
        long beginTSId = this.tsId++;
        long endTSId = this.tsId++;
        annRec.setBeginTimeSlotId(TS_ID_PREFIX + Long.toString(beginTSId));
        annRec.setEndTimeSlotId(TS_ID_PREFIX + Long.toString(endTSId));
        annRec.setValue(val);
        this.annotationRecords.add(annRec);
        this.annotRecordToTierMap.put(annRec, tierName);
        long[] begin = new long[]{beginTSId, t0};
        long[] end = new long[]{endTSId, t1};
        this.timeSlots.add(begin);
        this.timeSlots.add(end);
        this.timeOrder.add(begin);
        this.timeOrder.add(end);
        this.rootSlots.add(begin);
        this.rootSlots.add(end);
        String topTierName = "";
        topTierName = rootMarker;
        Vector<String> vdcs = this.childs(rootMarker);
        if (topTierName != "") {
            int maxDepth = 0;
            Vector<String> reorderedChildren = new Vector<String>();
            for (String n : vdcs) {
                DefaultMutableTreeNode childNode = this.sbxfile.getLabelNode(n);
                if (childNode.getDepth() > maxDepth) {
                    reorderedChildren.add(0, n);
                    maxDepth = childNode.getDepth();
                    continue;
                }
                reorderedChildren.add(n);
            }
            vdcs = reorderedChildren;
        }
        int wordcounter = 0;
        boolean hasMoreWords = true;
        while (hasMoreWords) {
            Enumeration dcs = vdcs.elements();
            hasMoreWords = this.createChildrenInBlock(annRec, dcs, row, null, wordcounter);
            ++wordcounter;
        }
    }

    private boolean createChildrenInBlock(AnnotationRecord par, Enumeration brothers, int row, ArrayList wordboundaries, int wordcount) throws Exception {
        String procName;
        boolean result = true;
        if (!brothers.hasMoreElements()) {
            return false;
        }
        String name = (String)brothers.nextElement();
        String spk = this.sbxfile.getSpeaker(row);
        ArrayList mywordboundaries = null;
        String val = this.sbxfile.getCell(name, row);
        if (val == null || val.length() == 0) {
            return this.createChildrenInBlock(par, brothers, row, wordboundaries, wordcount);
        }
        if (this.simpleConverter != null && this.typfile.isIPAtier(name)) {
            val = this.simpleConverter.toUnicode(val);
        }
        Vector vdcs = this.childs(name);
        Enumeration dcs = vdcs.elements();
        boolean iHaveKids = dcs.hasMoreElements();
        if (wordboundaries == null && !iHaveKids && this.typfile.getInterlinearTierMarkers().contains(name) && (procName = (String)this.typfile.procedureTypeHash.get(name)) != null && (procName.equals("TimeSubdivision") || procName.equals("IncludedIn") || procName.equals("Parse"))) {
            if (wordcount > 0) {
                return false;
            }
            StringTokenizer valToken = new StringTokenizer(val);
            while (valToken.hasMoreTokens()) {
                String annVal = valToken.nextToken();
                AnnotationRecord annRec = new AnnotationRecord();
                annRec.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
                annRec.setValue(annVal.trim());
                if (procName.equals("TimeSubdivision") || procName.equals("IncludedIn")) {
                    annRec.setAnnotationType("alignable");
                    annRec.setReferredAnnotId(par.getAnnotationId());
                    this.annotRecordToTierMap.put(annRec, name + "@" + spk);
                    this.createAndConnectTimeSlots(annRec);
                    this.annotationRecords.add(annRec);
                    continue;
                }
                annRec.setAnnotationType("reference");
                annRec.setReferredAnnotId(par.getAnnotationId());
                this.annotRecordToTierMap.put(annRec, name + "@" + spk);
                this.fillInPrevAnnotRef(annRec);
                this.annotationRecords.add(annRec);
            }
            if (!this.participantOrder.contains(spk)) {
                this.participantOrder.add(spk);
            }
            this.tierNameSet.add(name + "@" + spk);
            return this.createChildrenInBlock(par, brothers, row, wordboundaries, wordcount);
        }
        if (this.typfile.getInterlinearTierMarkers().size() == 0 && (procName = (String)this.typfile.procedureTypeHash.get(name)) != null && procName.equals("Lookup")) {
            return this.createSymAssociatedChildren(par, brothers, row, name);
        }
        if (wordboundaries == null && !iHaveKids) {
            if (wordcount > 0) {
                return false;
            }
        } else {
            if (wordboundaries == null) {
                mywordboundaries = this.wordbounds(val);
                result = wordcount < mywordboundaries.size() - 2;
            } else {
                mywordboundaries = wordboundaries;
                String xval = this.snapWord(val, mywordboundaries, wordcount, true);
                int index = (Integer)mywordboundaries.get(wordcount);
                int endIndex = (Integer)mywordboundaries.get(wordcount + 1);
                int xvalLength = xval.length();
                for (int i = 0; i < endIndex - index - xvalLength - 1; ++i) {
                    xval = xval + " ";
                }
                ArrayList xmywordboundaries = this.wordbounds(xval, index);
                if (xmywordboundaries.size() > 2) {
                    int ww_wordcount = 0;
                    boolean ww_hasMoreWords = true;
                    while (ww_hasMoreWords) {
                        String ww_val = this.snapWord(val, xmywordboundaries, ww_wordcount, true);
                        AnnotationRecord annRec = new AnnotationRecord();
                        annRec.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
                        annRec.setValue(ww_val.trim());
                        if (this.typfile.procedureTypeHash.get(name) != null && (this.typfile.procedureTypeHash.get(name).equals("TimeSubdivision") || this.typfile.procedureTypeHash.get(name).equals("IncludedIn"))) {
                            annRec.setAnnotationType("alignable");
                            annRec.setReferredAnnotId(par.getAnnotationId());
                            this.annotRecordToTierMap.put(annRec, name + "@" + spk);
                            this.createAndConnectTimeSlots(annRec);
                            this.annotationRecords.add(annRec);
                        } else {
                            annRec.setAnnotationType("reference");
                            annRec.setReferredAnnotId(par.getAnnotationId());
                            this.annotRecordToTierMap.put(annRec, name + "@" + spk);
                            this.fillInPrevAnnotRef(annRec);
                            this.annotationRecords.add(annRec);
                        }
                        if (!this.participantOrder.contains(spk)) {
                            this.participantOrder.add(spk);
                        }
                        this.tierNameSet.add(name + "@" + spk);
                        this.createChildrenInBlock(annRec, vdcs.elements(), row, xmywordboundaries, ww_wordcount);
                        ww_hasMoreWords = ww_wordcount < xmywordboundaries.size() - 2;
                        ++ww_wordcount;
                    }
                    return this.createChildrenInBlock(par, brothers, row, wordboundaries, wordcount);
                }
            }
            val = this.snapWord(val, mywordboundaries, wordcount, true);
        }
        AnnotationRecord aRec = new AnnotationRecord();
        aRec.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
        aRec.setValue(val.trim());
        if (this.typfile.procedureTypeHash.get(name) != null && (this.typfile.procedureTypeHash.get(name).equals("TimeSubdivision") || this.typfile.procedureTypeHash.get(name).equals("IncludedIn"))) {
            aRec.setAnnotationType("alignable");
            aRec.setReferredAnnotId(par.getAnnotationId());
            this.annotRecordToTierMap.put(aRec, name + "@" + spk);
            this.createAndConnectTimeSlots(aRec);
            this.annotationRecords.add(aRec);
        } else {
            aRec.setAnnotationType("reference");
            aRec.setReferredAnnotId(par.getAnnotationId());
            this.annotRecordToTierMap.put(aRec, name + "@" + spk);
            this.fillInPrevAnnotRef(aRec);
            this.annotationRecords.add(aRec);
        }
        if (!this.participantOrder.contains(spk)) {
            this.participantOrder.add(spk);
        }
        this.tierNameSet.add(name + "@" + spk);
        if (iHaveKids) {
            this.createChildrenInBlock(aRec, dcs, row, mywordboundaries, wordcount);
        }
        this.createChildrenInBlock(par, brothers, row, wordboundaries, wordcount);
        return result;
    }

    private boolean createSymAssociatedChildren(AnnotationRecord par, Enumeration brothers, int row, String name) throws Exception {
        String spk = this.sbxfile.getSpeaker(row);
        String val = this.sbxfile.getCell(name, row);
        if (val == null || val.length() == 0) {
            return this.createChildrenInBlock(par, brothers, row, this.wordbounds(val), 0);
        }
        if (this.simpleConverter != null && this.typfile.isIPAtier(name)) {
            val = this.simpleConverter.toUnicode(val);
        }
        Vector vdcs = this.childs(name);
        Enumeration dcs = vdcs.elements();
        boolean iHaveKids = dcs.hasMoreElements();
        AnnotationRecord aRec = new AnnotationRecord();
        aRec.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
        aRec.setValue(val.replace('\n', ' ').trim());
        aRec.setAnnotationType("reference");
        aRec.setReferredAnnotId(par.getAnnotationId());
        this.annotRecordToTierMap.put(aRec, name + "@" + spk);
        this.fillInPrevAnnotRef(aRec);
        this.annotationRecords.add(aRec);
        if (!this.participantOrder.contains(spk)) {
            this.participantOrder.add(spk);
        }
        this.tierNameSet.add(name + "@" + spk);
        if (iHaveKids) {
            this.createChildrenInBlock(aRec, dcs, row, this.wordbounds(val), 0);
        }
        return this.createChildrenInBlock(par, brothers, row, this.wordbounds(val), 0);
    }

    private final ArrayList wordbounds(String s) {
        return this.wordbounds(s, 0);
    }

    private final ArrayList wordbounds(String s, int offset) {
        ArrayList result = new ArrayList();
        result.add(new Integer(offset));
        ArrayList idx = this.indicesOf(s.trim(), ' ');
        idx = ShoeboxParser.lastIntInRow(idx);
        idx = ShoeboxParser.addToAllIntegers(idx, offset + 1);
        result.addAll(idx);
        result.add(new Integer(s.length() + 1 + offset));
        result = ShoeboxParser.lastIntInRow(result);
        return result;
    }

    private final ArrayList indicesOf(String val, char lookingfor) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            char[] chars = new char[val.length()];
            val.getChars(0, val.length(), chars, 0);
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != lookingfor) continue;
                result.add(new Integer(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private final String snapWord(String val, ArrayList wb, int wc, boolean trim) {
        String result = "";
        int b = 0;
        int e = 0;
        if (wc < wb.size()) {
            b = (Integer)wb.get(wc);
        }
        if (wc < wb.size() - 1) {
            e = (Integer)wb.get(wc + 1);
        }
        if (val.length() < e) {
            e = val.length();
        }
        if (this.fixImproperAlign) {
            if (val.charAt(e - 1) != ' ' && wc < wb.size() - 2) {
                e = (Integer)wb.get(wc + 2);
            }
            if (val.length() < e) {
                e = val.length();
            }
            if (val.length() < b) {
                b = val.length();
            }
            if (b > 0 && val.charAt(b - 1) != ' ') {
                b = e;
            }
        }
        if (b > e) {
            LOG.warning("begin > end: " + b + " - " + e + " value: " + val);
            e = val.length();
        }
        if (b >= val.length()) {
            LOG.warning("begin >= length: " + b + " - " + val.length() + " value: " + val);
            return result;
        }
        if (e >= val.length()) {
            if (e > val.length()) {
                LOG.warning("end > length: " + e + " - " + val.length() + " value: " + val);
            }
            result = val.substring(b);
        } else {
            result = val.substring(b, e);
        }
        if (trim) {
            result = result.trim();
        }
        return result;
    }

    private final Vector childs(String tname) throws Exception {
        if (!tname.startsWith("\\")) {
            tname = "\\" + tname;
        }
        Vector<String> result = new Vector<String>();
        DefaultMutableTreeNode found = null;
        Enumeration<TreeNode> all = this.tiertree.postorderEnumeration();
        while (found == null && all.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)all.nextElement();
            String name = (String)node.getUserObject();
            if (name == null || !name.equals(tname)) continue;
            found = node;
        }
        if (found == null) {
            return result;
        }
        Enumeration<TreeNode> kids = found.children();
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode kid = (DefaultMutableTreeNode)kids.nextElement();
            String name = (String)kid.getUserObject();
            if (name == null || name.startsWith("\\EUDICO") || name.startsWith("\\ELAN") || name.startsWith(ShoeboxArray.label_eudicoparticipant)) continue;
            result.add(name);
        }
        return result;
    }

    private boolean createChildsInBlock(AnnotationRecord dad, Enumeration brothers, int row, ArrayList wordboundaries, int wordcount) throws Exception {
        String dadtierName = (String)this.annotRecordToTierMap.get(dad);
        boolean result = true;
        if (!brothers.hasMoreElements()) {
            return false;
        }
        String name = (String)brothers.nextElement();
        String spk = this.sbxfile.getSpeaker(row);
        ArrayList mywordboundaries = null;
        String val = this.sbxfile.getCell(name, row);
        if (val == null || val.length() == 0) {
            return this.createChildsInBlock(dad, brothers, row, wordboundaries, wordcount);
        }
        if (this.simpleConverter != null && this.typfile.isIPAtier(name)) {
            val = this.simpleConverter.toUnicode(val);
        }
        Vector vdcs = this.childs(name);
        Enumeration dcs = vdcs.elements();
        boolean iHaveKids = dcs.hasMoreElements();
        if (wordboundaries == null && !iHaveKids) {
            if (wordcount > 0) {
                return false;
            }
        } else {
            if (wordboundaries == null) {
                mywordboundaries = this.wbound(val, this.typfile.isUnicodeTier(name));
                result = wordcount < mywordboundaries.size() - 2;
            } else {
                mywordboundaries = wordboundaries;
                String xval = this.snap(val, mywordboundaries, wordcount, true, this.typfile.isUnicodeTier(name));
                int index = (Integer)mywordboundaries.get(wordcount);
                int endIndex = (Integer)mywordboundaries.get(wordcount + 1);
                int xvalLength = xval.length();
                for (int i = 0; i < endIndex - index - xvalLength - 1; ++i) {
                    xval = xval + " ";
                }
                ArrayList xmywordboundaries = this.wbound(xval, this.typfile.isUnicodeTier(name), index);
                if (xmywordboundaries.size() > 2) {
                    int ww_wordcount = 0;
                    boolean ww_hasMoreWords = true;
                    while (ww_hasMoreWords) {
                        String ww_val = this.snap(val, xmywordboundaries, ww_wordcount, true, this.typfile.isUnicodeTier(name));
                        AnnotationRecord annRec = new AnnotationRecord();
                        annRec.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
                        annRec.setValue(ww_val.trim());
                        if (this.typfile.procedureTypeHash.get(name) != null && (this.typfile.procedureTypeHash.get(name).equals("TimeSubdivision") || this.typfile.procedureTypeHash.get(name).equals("IncludedIn"))) {
                            annRec.setAnnotationType("alignable");
                            annRec.setReferredAnnotId(dad.getAnnotationId());
                            this.annotRecordToTierMap.put(annRec, name + "@" + spk);
                            this.createAndConnectTimeSlots(annRec);
                            this.annotationRecords.add(annRec);
                        } else {
                            annRec.setAnnotationType("reference");
                            annRec.setReferredAnnotId(dad.getAnnotationId());
                            this.annotRecordToTierMap.put(annRec, name + "@" + spk);
                            this.fillInPrevAnnotRef(annRec);
                            this.annotationRecords.add(annRec);
                        }
                        if (!this.participantOrder.contains(spk)) {
                            this.participantOrder.add(spk);
                        }
                        this.tierNameSet.add(name + "@" + spk);
                        this.createChildsInBlock(annRec, vdcs.elements(), row, xmywordboundaries, ww_wordcount);
                        ww_hasMoreWords = ww_wordcount < xmywordboundaries.size() - 2;
                        ++ww_wordcount;
                    }
                    return this.createChildsInBlock(dad, brothers, row, wordboundaries, wordcount);
                }
            }
            val = this.snap(val, mywordboundaries, wordcount, true, this.typfile.isUnicodeTier(name));
        }
        AnnotationRecord aRec = new AnnotationRecord();
        aRec.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
        aRec.setValue(val.trim());
        if (this.typfile.procedureTypeHash.get(name) != null && (this.typfile.procedureTypeHash.get(name).equals("TimeSubdivision") || this.typfile.procedureTypeHash.get(name).equals("IncludedIn"))) {
            aRec.setAnnotationType("alignable");
            aRec.setReferredAnnotId(dad.getAnnotationId());
            this.annotRecordToTierMap.put(aRec, name + "@" + spk);
            this.createAndConnectTimeSlots(aRec);
            this.annotationRecords.add(aRec);
        } else {
            aRec.setAnnotationType("reference");
            aRec.setReferredAnnotId(dad.getAnnotationId());
            this.annotRecordToTierMap.put(aRec, name + "@" + spk);
            this.fillInPrevAnnotRef(aRec);
            this.annotationRecords.add(aRec);
        }
        if (!this.participantOrder.contains(spk)) {
            this.participantOrder.add(spk);
        }
        this.tierNameSet.add(name + "@" + spk);
        if (iHaveKids) {
            this.createChildsInBlock(aRec, dcs, row, mywordboundaries, wordcount);
        }
        this.createChildsInBlock(dad, brothers, row, wordboundaries, wordcount);
        return result;
    }

    private void fillInPrevAnnotRef(AnnotationRecord annRec) {
        long highestIndex = -1L;
        String onTier = (String)this.annotRecordToTierMap.get(annRec);
        for (AnnotationRecord aRec : this.annotationRecords) {
            String idString;
            long annotIndex;
            if (!((String)this.annotRecordToTierMap.get(aRec)).equals(onTier) || !aRec.getReferredAnnotId().equals(annRec.getReferredAnnotId()) || (annotIndex = Long.valueOf((idString = aRec.getAnnotationId()).substring(ANN_ID_PREFIX.length())).longValue()) <= highestIndex) continue;
            highestIndex = annotIndex;
        }
        if (highestIndex >= 0L) {
            annRec.setPreviousAnnotId(ANN_ID_PREFIX + highestIndex);
        }
    }

    private void createAndConnectTimeSlots(AnnotationRecord annRec) {
        long highestIndex = -1L;
        AnnotationRecord highestAnnot = null;
        AnnotationRecord parentRec = null;
        AnnotationRecord aRec2 = null;
        String onTier = (String)this.annotRecordToTierMap.get(annRec);
        for (AnnotationRecord aRec2 : this.annotationRecords) {
            String idString;
            long annotIndex;
            if (parentRec == null && annRec.getReferredAnnotId().equals(aRec2.getAnnotationId())) {
                parentRec = aRec2;
            }
            if (!((String)this.annotRecordToTierMap.get(aRec2)).equals(onTier) || !aRec2.getReferredAnnotId().equals(annRec.getReferredAnnotId()) || (annotIndex = Long.valueOf((idString = aRec2.getAnnotationId()).substring(ANN_ID_PREFIX.length())).longValue()) <= highestIndex) continue;
            highestIndex = annotIndex;
            highestAnnot = aRec2;
        }
        if (highestIndex >= 0L) {
            long beginTSId = this.tsId++;
            annRec.setBeginTimeSlotId(TS_ID_PREFIX + Long.toString(beginTSId));
            String oldEndTSId = highestAnnot.getEndTimeSlotId();
            highestAnnot.setEndTimeSlotId(TS_ID_PREFIX + Long.toString(beginTSId));
            this.updateChildAnnot(highestAnnot, oldEndTSId);
            long[] begin = new long[]{beginTSId, -1L};
            this.timeSlots.add(begin);
            String beginId = highestAnnot.getBeginTimeSlotId();
            String beginNo = "";
            int index = this.timeOrder.size();
            if (beginId != null) {
                beginNo = highestAnnot.getBeginTimeSlotId().substring(TS_ID_PREFIX.length());
                for (int i = 0; i < this.timeOrder.size(); ++i) {
                    long[] ts = (long[])this.timeOrder.get(i);
                    if (ts[0] != (long)new Integer(beginNo).intValue()) continue;
                    index = i;
                    break;
                }
            }
            if (index > this.timeOrder.size() - 1) {
                this.timeOrder.add(begin);
            } else {
                this.timeOrder.add(index + 1, begin);
            }
        } else if (parentRec != null) {
            annRec.setBeginTimeSlotId(parentRec.getBeginTimeSlotId());
        }
        if (parentRec != null) {
            annRec.setEndTimeSlotId(parentRec.getEndTimeSlotId());
        }
    }

    private void updateChildAnnot(AnnotationRecord par, String oldEndTSId) {
        AnnotationRecord aRec2 = null;
        for (AnnotationRecord aRec2 : this.annotationRecords) {
            if (aRec2.getReferredAnnotId() != par.getAnnotationId() || aRec2.getEndTimeSlotId() != oldEndTSId) continue;
            aRec2.setEndTimeSlotId(par.getEndTimeSlotId());
            this.updateChildAnnot(aRec2, oldEndTSId);
            return;
        }
    }

    private final ArrayList wbound(String s, boolean utf8) {
        return this.wbound(s, utf8, 0);
    }

    private final ArrayList wbound(String s, boolean utf8, int offset) {
        ArrayList result = new ArrayList();
        result.add(new Integer(offset));
        ArrayList idx = ShoeboxParser.indexesOf(s.trim(), utf8, ' ');
        idx = ShoeboxParser.lastIntInRow(idx);
        idx = ShoeboxParser.addToAllIntegers(idx, offset + 1);
        result.addAll(idx);
        result.add(new Integer(s.length() + 1 + offset));
        result = ShoeboxParser.lastIntInRow(result);
        return result;
    }

    private static final ArrayList indexesOf(String myself, String lookingfor) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = myself.indexOf(lookingfor, 0);
        while (i != -1) {
            result.add(new Integer(i));
            i = myself.indexOf(lookingfor, i + 1);
        }
        return result;
    }

    private static final ArrayList indexesOf(String myself, boolean utf8, char lookingfor) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            byte[] bytes = null;
            bytes = utf8 ? myself.getBytes("UTF-8") : myself.getBytes("ISO-8859-1");
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != lookingfor) continue;
                result.add(new Integer(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static final ArrayList lastIntInRow(ArrayList in) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Iterator it = in.iterator();
        int last = 0;
        Integer Last = null;
        if (it.hasNext()) {
            Last = (Integer)it.next();
            last = Last;
        }
        while (it.hasNext()) {
            Integer I = (Integer)it.next();
            int i = I;
            if (last + 1 == i) {
                Last = I;
                last = i;
                continue;
            }
            result.add(Last);
            Last = I;
            last = i;
        }
        if (Last != null) {
            result.add(Last);
        }
        return result;
    }

    private static final ArrayList addToAllIntegers(ArrayList myself, int offset) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < myself.size(); ++i) {
            Object e = myself.get(i);
            if (e instanceof Integer) {
                int ii = (Integer)e;
                result.add(new Integer(ii += offset));
                continue;
            }
            result.add((Integer)e);
        }
        return result;
    }

    private final String snap(String val, ArrayList wb, int wc, boolean trim, boolean utf8) {
        String result = "";
        int b = 0;
        int e = 0;
        if (wc < wb.size()) {
            b = (Integer)wb.get(wc);
        }
        if (wc < wb.size() - 1) {
            e = (Integer)wb.get(wc + 1);
        }
        if (!utf8 && val.length() < e) {
            e = val.length();
        }
        if (!utf8) {
            if (val.charAt(e - 1) != ' ' && wc < wb.size() - 2) {
                e = (Integer)wb.get(wc + 2);
            }
            if (val.length() < e) {
                e = val.length();
            }
            if (val.length() < b) {
                b = val.length();
            }
            if (b > 0 && val.charAt(b - 1) != ' ') {
                b = e;
            }
        }
        if (utf8) {
            char[] chars = new char[val.length()];
            val.getChars(0, val.length(), chars, 0);
            for (int i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                if (ch == '\u0000' || ch >= '\u0080' && ch <= '\u07ff') {
                    if (i < b) {
                        --b;
                    }
                    if (i <= e) {
                        --e;
                    }
                } else if (ch >= '\u0800' && ch <= '\uffff') {
                    if (i < b) {
                        b -= 2;
                    }
                    if (i <= e) {
                        e -= 2;
                    }
                }
                if (i > e) break;
            }
        }
        if (b > e) {
            System.out.println("Val: " + val);
            System.out.println("b > e: " + b + " - " + e + " l: " + val.length());
            e = val.length();
        }
        if (b >= val.length()) {
            return result;
        }
        result = e >= val.length() ? val.substring(b) : val.substring(b, e);
        if (trim) {
            result = result.trim();
        }
        return result;
    }

    private void calculateRootTimes() {
        int firstUAIndex = -1;
        for (int i = 0; i < this.rootSlots.size(); ++i) {
            long[] slot = (long[])this.rootSlots.get(i);
            if (slot[1] == -1L) {
                if (firstUAIndex == -1) {
                    firstUAIndex = i;
                }
            } else if (firstUAIndex != -1) {
                this.calculateSlotsInInterval(firstUAIndex, i - 1);
                firstUAIndex = -1;
            }
            if (i != this.rootSlots.size() - 1 || firstUAIndex == -1) continue;
            this.calculateSlotsInInterval(firstUAIndex, i);
        }
    }

    private void calculateSlotsInInterval(int firstUAIndex, int lastUAIndex) {
        if (firstUAIndex == lastUAIndex) {
            if (firstUAIndex % 2 == 0) {
                long[] otherSlot = (long[])this.rootSlots.get(firstUAIndex - 1);
                long[] slot = (long[])this.rootSlots.get(firstUAIndex);
                slot[1] = otherSlot[1];
            } else if (lastUAIndex < this.rootSlots.size() - 1) {
                long[] otherSlot = (long[])this.rootSlots.get(lastUAIndex + 1);
                long nextVal = otherSlot[1];
                long[] slot = (long[])this.rootSlots.get(lastUAIndex);
                otherSlot = (long[])this.rootSlots.get(lastUAIndex - 1);
                if (nextVal - otherSlot[1] > (long)this.preferredBlockDuration) {
                    nextVal = otherSlot[1] + (long)this.preferredBlockDuration;
                }
                slot[1] = nextVal;
            } else {
                long[] otherSlot = (long[])this.rootSlots.get(lastUAIndex - 1);
                long[] slot = (long[])this.rootSlots.get(lastUAIndex);
                slot[1] = otherSlot[1] + (long)this.preferredBlockDuration;
            }
            return;
        }
        if (firstUAIndex == 1 && lastUAIndex == this.rootSlots.size() - 1) {
            for (int i = 1; i <= lastUAIndex; ++i) {
                long[] slot = (long[])this.rootSlots.get(i);
                slot[1] = (long)Math.ceil((float)i / 2.0f) * (long)this.preferredBlockDuration;
            }
            return;
        }
        if (lastUAIndex == this.rootSlots.size() - 1) {
            long[] slot = (long[])this.rootSlots.get(firstUAIndex - 1);
            long startTime = slot[1];
            int j = firstUAIndex % 2 == 0 ? 1 : 2;
            int i = firstUAIndex;
            while (i <= lastUAIndex) {
                slot = (long[])this.rootSlots.get(i);
                slot[1] = startTime + (long)(j / 2 * this.preferredBlockDuration);
                ++i;
                ++j;
            }
        } else {
            long startTime;
            int numIntervals = 0;
            long delta = 0L;
            int begin = firstUAIndex % 2 == 0 ? firstUAIndex + 1 : firstUAIndex;
            int end = lastUAIndex % 2 == 0 ? lastUAIndex + 1 : lastUAIndex;
            numIntervals = (end - begin) / 2 + 1;
            long[] slot = (long[])this.rootSlots.get(firstUAIndex - 1);
            long[] otherSlot = (long[])this.rootSlots.get(lastUAIndex + 1);
            long endTime = otherSlot[1];
            delta = (endTime - (startTime = slot[1])) / (long)numIntervals;
            if (delta > (long)this.preferredBlockDuration) {
                delta = this.preferredBlockDuration;
            }
            int j = firstUAIndex % 2 == 0 ? 1 : 2;
            int i = firstUAIndex;
            while (i <= lastUAIndex) {
                slot = (long[])this.rootSlots.get(i);
                slot[1] = startTime + (long)(j / 2) * delta;
                ++i;
                ++j;
            }
        }
    }

    @Override
    public void setDecoderInfo(DecoderInfo decoderInfo) {
        if (decoderInfo instanceof ToolboxDecoderInfo) {
            this.decoderInfo = (ToolboxDecoderInfo)decoderInfo;
            this.preferredBlockDuration = (int)this.decoderInfo.getBlockDuration();
        }
    }
}

