/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.AnnotationSizeContainer;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class AnnotationSize
implements ACMEditListener {
    Transcription _trans = null;
    Annotation _refAnn = null;
    Vector _vBlockTiers = new Vector();
    TreeMap _htTimeList = new TreeMap();
    FontMetrics _fontmetric = null;
    Hashtable htAnnBetween = new Hashtable();
    HashMap metricsPerTier = null;

    public AnnotationSize(Transcription trans, Annotation _ref) {
        this._trans = trans;
        this._refAnn = _ref;
        this._fontmetric = null;
        this.getBlockTiers();
        this.buildTimeBlock();
    }

    public AnnotationSize(Transcription trans, Annotation _ref, FontMetrics fontmetrics) {
        this._trans = trans;
        this._refAnn = _ref;
        this._fontmetric = fontmetrics;
        this.getBlockTiers();
        this.buildTimeBlock();
    }

    public AnnotationSize(Transcription trans, Annotation _ref, FontMetrics defaultFontMetrics, HashMap metricsPerTier) {
        this._trans = trans;
        this._refAnn = _ref;
        this._fontmetric = defaultFontMetrics;
        this.metricsPerTier = metricsPerTier;
        this.getBlockTiers();
        this.buildTimeBlock();
    }

    public Vector getTierLayoutInChar(Tier tier) {
        return new Vector();
    }

    public ArrayList getTierLayoutInPixels(Tier tier, FontMetrics fontmetrics) {
        int type;
        boolean bNaturalSize = false;
        this._fontmetric = fontmetrics;
        ArrayList<AnnotationSizeContainer> vecRet = new ArrayList<AnnotationSizeContainer>(50);
        Vector vans = this.getAnnBetweenTime(tier, this._refAnn.getBeginTimeBoundary(), this._refAnn.getEndTimeBoundary());
        if (!this.includeTierInCalculation((TierImpl)tier)) {
            bNaturalSize = true;
        }
        Iterator enumTime = this._htTimeList.keySet().iterator();
        long currentTime = this._refAnn.getBeginTimeBoundary();
        long origCurrentTime = 0L;
        int endMarker = 0;
        if (enumTime.hasNext()) {
            origCurrentTime = currentTime = ((Long)enumTime.next()).longValue();
        }
        int n = type = this._fontmetric != null ? AnnotationSizeContainer.PIXELS : AnnotationSizeContainer.SPACES;
        if (vans.size() == 0) {
            Integer tmptime = (Integer)this._htTimeList.get(new Long(currentTime));
            if (tmptime == null) {
                tmptime = new Integer(999);
            }
            vecRet.add(new AnnotationSizeContainer(null, tmptime, currentTime, currentTime, type));
            if (enumTime.hasNext()) {
                currentTime = (Long)enumTime.next();
            }
        }
        for (int ii = 0; ii < vans.size(); ++ii) {
            Annotation aa = (Annotation)vans.elementAt(ii);
            while (aa.getBeginTimeBoundary() != currentTime && enumTime.hasNext()) {
                vecRet.add(new AnnotationSizeContainer(null, (Integer)this._htTimeList.get(new Long(currentTime)), currentTime, currentTime, type));
                currentTime = (Long)enumTime.next();
            }
            if (!bNaturalSize) {
                vecRet.add(new AnnotationSizeContainer(aa, (Integer)this._htTimeList.get(new Long(currentTime)), type));
            } else {
                vecRet.add(new AnnotationSizeContainer(aa, this.getStringSize(aa.getValue()), type));
            }
            if (enumTime.hasNext()) {
                currentTime = (Long)enumTime.next();
                continue;
            }
            endMarker = -1;
        }
        boolean truth = true;
        while (truth && currentTime != origCurrentTime && endMarker != -1 && !bNaturalSize) {
            vecRet.add(new AnnotationSizeContainer(null, (Integer)this._htTimeList.get(new Long(currentTime)), currentTime, currentTime, type));
            if (enumTime.hasNext()) {
                currentTime = (Long)enumTime.next();
                continue;
            }
            truth = false;
        }
        return vecRet;
    }

    public Vector getTiers() {
        return this._vBlockTiers;
    }

    public void getBlockTiers() {
        Vector vAllTiers = null;
        Enumeration etier = null;
        try {
            vAllTiers = this._trans.getTiers();
            etier = vAllTiers.elements();
        }
        catch (Exception rmiexp) {
            rmiexp.printStackTrace();
            return;
        }
        while (etier.hasMoreElements()) {
            TierImpl t = (TierImpl)etier.nextElement();
            if (t.getRootTier() != this._refAnn.getTier()) continue;
            this._vBlockTiers.add(t);
        }
    }

    private void buildTimeBlock() {
        Enumeration e = this._vBlockTiers.elements();
        while (e.hasMoreElements()) {
            TierImpl ti = (TierImpl)e.nextElement();
            this.fillTimeBlock(ti);
        }
    }

    private void fillTimeBlock(TierImpl ti) {
        if (!this.includeTierInCalculation(ti)) {
            return;
        }
        FontMetrics tiMetrics = null;
        FontMetrics refAnnMetrics = null;
        if (this.metricsPerTier != null) {
            tiMetrics = (FontMetrics)this.metricsPerTier.get(ti.getName());
            refAnnMetrics = (FontMetrics)this.metricsPerTier.get(this._refAnn.getTier().getName());
        }
        Vector v = this.getAnnBetweenTime(ti, this._refAnn.getBeginTimeBoundary(), this._refAnn.getEndTimeBoundary());
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Annotation a = (Annotation)e.nextElement();
            Integer blocklen = null;
            blocklen = (Integer)this._htTimeList.get(new Long(a.getBeginTimeBoundary()));
            if (blocklen != null) {
                int strLength = this.getStringSize(a.getValue(), tiMetrics);
                if (blocklen >= strLength) continue;
                this._htTimeList.put(new Long(a.getBeginTimeBoundary()), new Integer(strLength));
                continue;
            }
            this._htTimeList.put(new Long(a.getBeginTimeBoundary()), new Integer(this.getStringSize(a.getValue(), tiMetrics)));
        }
        if (this._htTimeList.size() == 0) {
            this._htTimeList.put(new Long(this._refAnn.getBeginTimeBoundary()), new Integer(this.getStringSize(this._refAnn.getValue(), refAnnMetrics)));
        }
    }

    private Vector getAnnBetweenTime(Tier tier, long start, long end) {
        Vector v = null;
        TierImpl ti = (TierImpl)tier;
        if (this.htAnnBetween.containsKey(tier)) {
            return (Vector)this.htAnnBetween.get(tier);
        }
        Vector<Annotation> vecRet = new Vector<Annotation>(50);
        try {
            v = ti.getAnnotations();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        for (int i = 0; i < v.size(); ++i) {
            Annotation a = (Annotation)v.elementAt(i);
            if (a.getBeginTimeBoundary() >= start && a.getEndTimeBoundary() <= end) {
                vecRet.add(a);
                continue;
            }
            if (a.getEndTimeBoundary() > start) break;
        }
        this.htAnnBetween.put(tier, vecRet);
        return vecRet;
    }

    private boolean includeTierInCalculation(TierImpl ti) {
        if (!ti.hasParentTier()) {
            return false;
        }
        if (ti.getLinguisticType() == null) {
            return true;
        }
        if (ti.getLinguisticType().getConstraints() == null) {
            return true;
        }
        return ti.getLinguisticType().getConstraints().getStereoType() != 4 || ti.getParentTier() != ti.getRootTier();
    }

    public int getStringSize(String str) {
        if (this._fontmetric != null) {
            return this._fontmetric.stringWidth(str.trim());
        }
        return str.trim().length();
    }

    public int getStringSize(String str, FontMetrics metrics) {
        if (metrics == null) {
            return this.getStringSize(str);
        }
        return metrics.stringWidth(str.trim());
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
    }
}

