/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.praat;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AnnotationCoreImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.praat.PraatTGEncoderInfo;
import mpi.eudico.server.corpora.util.ServerLogger;

public class PraatTextGridEncoder
implements AnnotationDocEncoder,
ServerLogger {
    private final String indent = "    ";
    private final String indent2 = "        ";
    private final String indent3 = "            ";
    private final String xmin = "xmin = ";
    private final String xmax = "xmax = ";
    private final String intervals = "intervals [";
    private final String tx = "text = ";
    private final String NEW_LINE = "\n";
    private String encoding;

    @Override
    public void encodeAndSave(Transcription theTranscription, EncoderInfo theEncoderInfo, List tierOrder, String path) throws IOException {
        if (theTranscription == null) {
            LOG.warning("The transcription is null");
            throw new IllegalArgumentException("The transcription is null.");
        }
        if (tierOrder == null || tierOrder.size() == 0) {
            LOG.warning("No tiers have been specified for export");
            throw new IllegalArgumentException("No tiers specified for export");
        }
        if (path == null) {
            LOG.warning("No file path for the TextGrid file has been specified");
            throw new IllegalArgumentException("No file path for the TextGrid file has been specified");
        }
        long bt = 0L;
        long et = 0L;
        long offset = 0L;
        if (theEncoderInfo instanceof PraatTGEncoderInfo) {
            bt = ((PraatTGEncoderInfo)theEncoderInfo).getBeginTime();
            et = ((PraatTGEncoderInfo)theEncoderInfo).getEndTime();
            this.encoding = ((PraatTGEncoderInfo)theEncoderInfo).getEncoding();
            boolean exportSelection = ((PraatTGEncoderInfo)theEncoderInfo).isExportSelection();
            offset = ((PraatTGEncoderInfo)theEncoderInfo).getOffset();
            if (offset > 0L) {
                if (exportSelection) {
                    bt += offset;
                }
                et += offset;
            }
        }
        OutputStreamWriter out = null;
        try {
            out = this.encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(path), this.encoding) : new OutputStreamWriter(new FileOutputStream(path));
        }
        catch (UnsupportedEncodingException uee) {
            LOG.warning("Encoding not supported: " + uee.getMessage());
            out = new OutputStreamWriter(new FileOutputStream(path));
        }
        BufferedWriter writer = new BufferedWriter(out);
        writer.write("File type = \"ooTextFile\"");
        writer.write("\n");
        writer.write("Object class = \"TextGrid\"");
        writer.write("\n\n");
        writer.write("xmin = " + (double)bt / 1000.0);
        writer.write("\n");
        writer.write("xmax = " + (double)et / 1000.0);
        writer.write("\n");
        writer.write("tiers? <exists>");
        writer.write("\n");
        writer.write("size = " + tierOrder.size());
        writer.write("\n");
        writer.write("item []:");
        writer.write("\n");
        this.writeTiers(theTranscription, tierOrder, bt, et, offset, writer);
        writer.flush();
        writer.close();
    }

    private void writeTiers(Transcription theTranscription, List tiers, long bt, long et, long offset, Writer out) throws IOException {
        if (tiers == null || tiers.size() == 0) {
            return;
        }
        ArrayList<AnnotationCoreImpl> annotations = new ArrayList<AnnotationCoreImpl>();
        TierImpl tier = null;
        Annotation ann1 = null;
        Annotation ann2 = null;
        for (int i = 0; i < tiers.size(); ++i) {
            tier = (TierImpl)theTranscription.getTierWithId((String)tiers.get(i));
            out.write("    ");
            out.write("item[" + (i + 1) + "]:");
            out.write("\n");
            out.write("        ");
            out.write("class = \"IntervalTier\"");
            out.write("\n");
            out.write("        ");
            out.write("name = \"" + tier.getName() + "\"");
            out.write("\n");
            out.write("        ");
            out.write("xmin = " + (double)bt / 1000.0);
            out.write("\n");
            out.write("        ");
            out.write("xmax = " + (double)et / 1000.0);
            out.write("\n");
            annotations.clear();
            ann1 = null;
            ann2 = null;
            Vector anns = tier.getAnnotations();
            for (int j = 0; j < anns.size(); ++j) {
                ann2 = (Annotation)anns.get(j);
                if (ann2.getEndTimeBoundary() + offset <= bt) {
                    ann1 = ann2;
                    continue;
                }
                if (ann2.getBeginTimeBoundary() + offset <= bt) {
                    annotations.add(new AnnotationCoreImpl(ann2.getValue(), Math.max(bt, ann2.getBeginTimeBoundary() + offset), Math.min(et, ann2.getEndTimeBoundary() + offset)));
                    if (ann2.getEndTimeBoundary() + offset >= et) {
                        break;
                    }
                } else {
                    if (ann1 != null) {
                        if (ann1.getEndTimeBoundary() < ann2.getBeginTimeBoundary()) {
                            annotations.add(new AnnotationCoreImpl("", Math.max(bt, ann1.getEndTimeBoundary() + offset), Math.min(et, ann2.getBeginTimeBoundary() + offset)));
                        }
                    } else {
                        annotations.add(new AnnotationCoreImpl("", bt, Math.min(et, ann2.getBeginTimeBoundary() + offset)));
                    }
                    if (ann2.getBeginTimeBoundary() + offset >= et) break;
                    annotations.add(new AnnotationCoreImpl(ann2.getValue(), ann2.getBeginTimeBoundary() + offset, Math.min(et, ann2.getEndTimeBoundary() + offset)));
                    if (ann2.getEndTimeBoundary() + offset >= et) break;
                }
                ann1 = ann2;
            }
            if (annotations.size() > 0) {
                AnnotationCoreImpl record = (AnnotationCoreImpl)annotations.get(annotations.size() - 1);
                if (record.getEndTimeBoundary() < et) {
                    annotations.add(new AnnotationCoreImpl("", record.getEndTimeBoundary(), et));
                }
            } else {
                annotations.add(new AnnotationCoreImpl("", bt, et));
            }
            out.write("        ");
            out.write("intervals: size = " + annotations.size());
            out.write("\n");
            AnnotationCoreImpl record = null;
            String value = null;
            for (int j = 0; j < annotations.size(); ++j) {
                record = (AnnotationCoreImpl)annotations.get(j);
                value = record.getValue().replaceAll("\"", "\"\"");
                out.write("        ");
                out.write("intervals [" + (j + 1) + "]");
                out.write("\n");
                out.write("            ");
                out.write("xmin = ");
                out.write(String.valueOf((double)record.getBeginTimeBoundary() / 1000.0));
                out.write("\n");
                out.write("            ");
                out.write("xmax = ");
                out.write(String.valueOf((double)record.getEndTimeBoundary() / 1000.0));
                out.write("\n");
                out.write("            ");
                out.write("text = ");
                out.write("\"" + value + "\"");
                out.write("\n");
            }
        }
    }
}

