/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVEntryRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TierRecord;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class EAF23Parser
extends Parser {
    private static boolean verbose = false;
    private final SAXParser saxParser;
    private final HashMap tierMap = new HashMap();
    private final HashMap tiers = new HashMap();
    private final ArrayList tierNames = new ArrayList();
    private final ArrayList linguisticTypes = new ArrayList();
    private final ArrayList locales = new ArrayList();
    private final HashMap timeSlots = new HashMap();
    private final HashMap controlledVocabularies = new HashMap();
    private final ArrayList timeOrder = new ArrayList();
    private String mediaFile;
    private ArrayList mediaDescriptors = new ArrayList();
    private ArrayList linkedFileDescriptors = new ArrayList();
    private String svgFile;
    private String author;
    private String currentTierId;
    private String currentAnnotationId;
    private AnnotationRecord currentAnnRecord;
    private String currentCVId;
    private CVEntryRecord currentEntryRecord;
    private String content = "";
    private String lastParsed = "";
    private String currentFileName;
    private boolean parseError;

    public EAF23Parser() {
        this.saxParser = new SAXParser();
        try {
            this.saxParser.setFeature("http://xml.org/sax/features/validation", true);
            this.saxParser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            this.saxParser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)"http://www.mpi.nl/tools/elan/EAFv2.3.xsd");
            this.saxParser.setContentHandler((ContentHandler)new EAFContentHandler());
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getMediaFile(String fileName) {
        this.parse(fileName);
        return this.mediaFile;
    }

    @Override
    public ArrayList getMediaDescriptors(String fileName) {
        this.parse(fileName);
        return this.mediaDescriptors;
    }

    @Override
    public ArrayList getLinkedFileDescriptors(String fileName) {
        this.parse(fileName);
        return this.linkedFileDescriptors;
    }

    @Override
    public String getSVGFile(String fileName) {
        this.parse(fileName);
        return this.svgFile;
    }

    @Override
    public String getAuthor(String fileName) {
        this.parse(fileName);
        return this.author;
    }

    @Override
    public ArrayList getLinguisticTypes(String fileName) {
        this.parse(fileName);
        return this.linguisticTypes;
    }

    @Override
    public ArrayList getTimeOrder(String fileName) {
        this.parse(fileName);
        return this.timeOrder;
    }

    @Override
    public HashMap getTimeSlots(String fileName) {
        this.parse(fileName);
        return this.timeSlots;
    }

    @Override
    public HashMap getControlledVocabularies(String fileName) {
        this.parse(fileName);
        return this.controlledVocabularies;
    }

    @Override
    public ArrayList getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null && ((TierRecord)this.tierMap.get(tierName)).getParticipant() != null) {
            return ((TierRecord)this.tierMap.get(tierName)).getParticipant();
        }
        return "";
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null && ((TierRecord)this.tierMap.get(tierName)).getLinguisticType() != null) {
            return ((TierRecord)this.tierMap.get(tierName)).getLinguisticType();
        }
        return "";
    }

    @Override
    public Locale getDefaultLanguageOf(String tierName, String fileName) {
        this.parse(fileName);
        Locale resultLoc = null;
        String localeId = null;
        if (this.tierMap.get(tierName) != null) {
            localeId = ((TierRecord)this.tierMap.get(tierName)).getDefaultLocale();
        }
        for (Locale l : this.locales) {
            if (!l.getLanguage().equals(localeId)) continue;
            resultLoc = l;
        }
        return resultLoc;
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null) {
            return ((TierRecord)this.tierMap.get(tierName)).getParentTier();
        }
        return null;
    }

    @Override
    public ArrayList getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        return (ArrayList)this.tiers.get(tierName);
    }

    private void parse(String fileName) {
        if (this.lastParsed.equals(fileName)) {
            return;
        }
        this.tiers.clear();
        this.tierNames.clear();
        this.mediaFile = "";
        this.linguisticTypes.clear();
        this.locales.clear();
        this.timeSlots.clear();
        this.timeOrder.clear();
        this.mediaDescriptors.clear();
        this.linkedFileDescriptors.clear();
        this.controlledVocabularies.clear();
        this.lastParsed = fileName;
        this.currentFileName = fileName;
        try {
            this.saxParser.parse(fileName);
        }
        catch (SAXException e) {
            System.out.println("Parsing error: " + e.getMessage());
            File f = new File(fileName);
            if (f.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    InputSource source = new InputSource(fis);
                    this.saxParser.parse(source);
                }
                catch (Exception ee) {
                    System.out.println("Parsing retry error: " + ee.getMessage());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.printErrorLocationInfo("Fatal(?) Error! " + e.getMessage());
        }
    }

    private void println(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }

    private void printErrorLocationInfo(String message) {
        System.out.println(message);
        System.out.println("Exception for " + this.currentFileName);
        System.out.println("Tier id " + this.currentTierId);
        System.out.println("Annotation id " + this.currentAnnotationId);
    }

    class EAFContentHandler
    implements ContentHandler {
        private Locator locator;

        EAFContentHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int end) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
            EAF23Parser.this.parseError = false;
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            EAF23Parser.this.content = "";
            if (name.equals("ANNOTATION_DOCUMENT")) {
                EAF23Parser.this.author = attributes.getValue("AUTHOR");
            } else if (name.equals("HEADER")) {
                EAF23Parser.this.mediaFile = attributes.getValue("MEDIA_FILE");
                EAF23Parser.this.svgFile = attributes.getValue("SVG_FILE");
            } else if (name.equals("MEDIA_DESCRIPTOR")) {
                String mediaURL = attributes.getValue("MEDIA_URL");
                String mimeType = attributes.getValue("MIME_TYPE");
                MediaDescriptor md = new MediaDescriptor(mediaURL, mimeType);
                long timeOrigin = 0L;
                if (attributes.getValue("TIME_ORIGIN") != null) {
                    md.timeOrigin = timeOrigin = Long.parseLong(attributes.getValue("TIME_ORIGIN"));
                }
                String extractedFrom = "";
                if (attributes.getValue("EXTRACTED_FROM") != null) {
                    md.extractedFrom = extractedFrom = attributes.getValue("EXTRACTED_FROM");
                }
                EAF23Parser.this.mediaDescriptors.add(md);
            } else if (name.equals("LINKED_FILE_DESCRIPTOR")) {
                String assoc;
                String linkURL = attributes.getValue("LINK_URL");
                String mime = attributes.getValue("MIME_TYPE");
                LinkedFileDescriptor lfd = new LinkedFileDescriptor(linkURL, mime);
                if (attributes.getValue("TIME_ORIGIN") != null) {
                    try {
                        long origin;
                        lfd.timeOrigin = origin = Long.parseLong(attributes.getValue("TIME_ORIGIN"));
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Could not parse the time origin: " + nfe.getMessage());
                    }
                }
                if ((assoc = attributes.getValue("ASSOCIATED_WITH")) != null) {
                    lfd.associatedWith = assoc;
                }
                EAF23Parser.this.linkedFileDescriptors.add(lfd);
            } else if (!name.equals("TIME_ORDER")) {
                if (name.equals("TIME_SLOT")) {
                    String timeValue = String.valueOf(-1);
                    if (attributes.getValue("TIME_VALUE") != null) {
                        timeValue = attributes.getValue("TIME_VALUE");
                    }
                    EAF23Parser.this.timeSlots.put(attributes.getValue("TIME_SLOT_ID"), timeValue);
                    EAF23Parser.this.timeOrder.add(attributes.getValue("TIME_SLOT_ID"));
                } else if (name.equals("TIER")) {
                    EAF23Parser.this.currentTierId = attributes.getValue("TIER_ID");
                    if (!EAF23Parser.this.tiers.containsKey(EAF23Parser.this.currentTierId)) {
                        TierRecord tr = new TierRecord();
                        tr.setName(EAF23Parser.this.currentTierId);
                        EAF23Parser.this.tierMap.put(EAF23Parser.this.currentTierId, tr);
                        tr.setParticipant(attributes.getValue("PARTICIPANT"));
                        tr.setLinguisticType(attributes.getValue("LINGUISTIC_TYPE_REF"));
                        tr.setDefaultLocale(attributes.getValue("DEFAULT_LOCALE"));
                        tr.setParentTier(attributes.getValue("PARENT_REF"));
                        EAF23Parser.this.tiers.put(EAF23Parser.this.currentTierId, new ArrayList());
                        EAF23Parser.this.tierNames.add(EAF23Parser.this.currentTierId);
                    }
                } else if (name.equals("ALIGNABLE_ANNOTATION")) {
                    EAF23Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    EAF23Parser.this.currentAnnRecord = new AnnotationRecord();
                    EAF23Parser.this.currentAnnRecord.setAnnotationId(EAF23Parser.this.currentAnnotationId);
                    String svg_ref = attributes.getValue("SVG_REF");
                    if (svg_ref != null) {
                        EAF23Parser.this.currentAnnRecord.setAnnotationType("alignable_svg");
                        EAF23Parser.this.currentAnnRecord.setSvgReference(svg_ref);
                    } else {
                        EAF23Parser.this.currentAnnRecord.setAnnotationType("alignable");
                    }
                    EAF23Parser.this.currentAnnRecord.setBeginTimeSlotId(attributes.getValue("TIME_SLOT_REF1"));
                    EAF23Parser.this.currentAnnRecord.setEndTimeSlotId(attributes.getValue("TIME_SLOT_REF2"));
                    ((ArrayList)EAF23Parser.this.tiers.get(EAF23Parser.this.currentTierId)).add(EAF23Parser.this.currentAnnRecord);
                } else if (name.equals("REF_ANNOTATION")) {
                    EAF23Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    EAF23Parser.this.currentAnnRecord = new AnnotationRecord();
                    EAF23Parser.this.currentAnnRecord.setAnnotationId(EAF23Parser.this.currentAnnotationId);
                    EAF23Parser.this.currentAnnRecord.setAnnotationType("reference");
                    EAF23Parser.this.currentAnnRecord.setReferredAnnotId(attributes.getValue("ANNOTATION_REF"));
                    if (attributes.getValue("PREVIOUS_ANNOTATION") != null) {
                        EAF23Parser.this.currentAnnRecord.setPreviousAnnotId(attributes.getValue("PREVIOUS_ANNOTATION"));
                    } else {
                        EAF23Parser.this.currentAnnRecord.setPreviousAnnotId("");
                    }
                    ((ArrayList)EAF23Parser.this.tiers.get(EAF23Parser.this.currentTierId)).add(EAF23Parser.this.currentAnnRecord);
                } else if (name.equals("LINGUISTIC_TYPE")) {
                    LingTypeRecord ltr = new LingTypeRecord();
                    ltr.setLingTypeId(attributes.getValue("LINGUISTIC_TYPE_ID"));
                    String timeAlignable = "true";
                    if (attributes.getValue("TIME_ALIGNABLE") != null && attributes.getValue("TIME_ALIGNABLE").equals("false")) {
                        timeAlignable = "false";
                    }
                    ltr.setTimeAlignable(timeAlignable);
                    String graphicReferences = "false";
                    if (attributes.getValue("GRAPHIC_REFERENCES") != null && attributes.getValue("GRAPHIC_REFERENCES").equals("true")) {
                        graphicReferences = "true";
                    }
                    ltr.setGraphicReferences(graphicReferences);
                    String stereotype = attributes.getValue("CONSTRAINTS");
                    ltr.setStereoType(stereotype);
                    ltr.setControlledVocabulary(attributes.getValue("CONTROLLED_VOCABULARY_REF"));
                    EAF23Parser.this.linguisticTypes.add(ltr);
                } else if (name.equals("LOCALE")) {
                    String variant;
                    String langCode = attributes.getValue("LANGUAGE_CODE");
                    String countryCode = attributes.getValue("COUNTRY_CODE");
                    if (countryCode == null) {
                        countryCode = "";
                    }
                    if ((variant = attributes.getValue("VARIANT")) == null) {
                        variant = "";
                    }
                    Locale l = new Locale(langCode, countryCode, variant);
                    EAF23Parser.this.locales.add(l);
                } else if (name.equals("CONTROLLED_VOCABULARY")) {
                    EAF23Parser.this.currentCVId = attributes.getValue("CV_ID");
                    ArrayList<String> cv = new ArrayList<String>();
                    String desc = attributes.getValue("DESCRIPTION");
                    if (desc != null) {
                        cv.add(desc);
                    }
                    EAF23Parser.this.controlledVocabularies.put(EAF23Parser.this.currentCVId, cv);
                } else if (name.equals("CV_ENTRY")) {
                    EAF23Parser.this.currentEntryRecord = new CVEntryRecord();
                    EAF23Parser.this.currentEntryRecord.setDescription(attributes.getValue("DESCRIPTION"));
                    ((ArrayList)EAF23Parser.this.controlledVocabularies.get(EAF23Parser.this.currentCVId)).add(EAF23Parser.this.currentEntryRecord);
                }
            }
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("ANNOTATION_VALUE")) {
                EAF23Parser.this.currentAnnRecord.setValue(EAF23Parser.this.content);
            } else if (name.equals("CV_ENTRY")) {
                EAF23Parser.this.currentEntryRecord.setValue(EAF23Parser.this.content);
            }
        }

        @Override
        public void characters(char[] ch, int start, int end) throws SAXException {
            EAF23Parser.this.content = EAF23Parser.this.content + new String(ch, start, end);
        }
    }
}

