/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JOptionPane;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.abstr.ParserFactory;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF21;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EAF21TranscriptionStore
implements TranscriptionStore {
    public File fileToWriteXMLinto = null;

    public PrintWriter addPrintln(File f) {
        try {
            FileWriter fileWriter1 = new FileWriter(f);
            return new PrintWriter((Writer)fileWriter1, true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, int format) {
        if (theTranscription instanceof TranscriptionImpl) {
            String pathName = ((TranscriptionImpl)theTranscription).getPathName();
            if (!pathName.substring(pathName.length() - 4, pathName.length() - 3).equals(".")) {
                pathName = pathName + ".eaf";
            } else {
                pathName = pathName.substring(0, pathName.length() - 3);
                pathName = pathName + "eaf";
            }
            this.storeTranscriptionIn(theTranscription, tierOrder, pathName);
        }
    }

    @Override
    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String pathName, int format) {
        if (theTranscription instanceof TranscriptionImpl) {
            if (!pathName.substring(pathName.length() - 4, pathName.length() - 3).equals(".")) {
                pathName = pathName + ".eaf";
            } else {
                pathName = pathName.substring(0, pathName.length() - 3);
                pathName = pathName + "eaf";
            }
            this.storeTranscriptionIn(theTranscription, tierOrder, pathName);
        }
    }

    public void storeTranscriptionIn(Transcription theTranscription, List tierOrder, String path) {
        Element documentElement = EAF21TranscriptionStore.createDOM(theTranscription, tierOrder);
        if (this.fileToWriteXMLinto != null) {
            EAF21TranscriptionStore.save(documentElement, this.fileToWriteXMLinto.getAbsolutePath(), true);
        } else {
            EAF21TranscriptionStore.save(documentElement, path, false);
        }
    }

    private static void save(Element documentElement, String path, boolean backup) {
        System.out.println(path + " <----XML output\n");
        try {
            if (("" + documentElement).length() == 0) {
                String txt = "Sorry: unable to save this file (zero length).";
                JOptionPane.showMessageDialog(null, txt, txt, 0);
                return;
            }
            IoUtil.writeEncodedFile("UTF-8", path, documentElement);
        }
        catch (Exception eee) {
            String txt = "Sorry: unable to save this file. (" + eee.getMessage() + ")";
            JOptionPane.showMessageDialog(null, txt, txt, 0);
        }
    }

    private static String correctDate(String strIn) {
        String strResult = new String(strIn);
        try {
            int offsetGMT = Calendar.getInstance().getTimeZone().getRawOffset() / 3600000;
            String strOffset = "+";
            if (offsetGMT < 0) {
                strOffset = "-";
            }
            if ((offsetGMT = Math.abs(offsetGMT)) < 10) {
                strOffset = strOffset + "0";
            }
            strOffset = strOffset + offsetGMT + ":00";
            int indexSpace = (strResult = strResult + strOffset).indexOf(" ");
            if (indexSpace != -1) {
                String strEnd = strResult.substring(indexSpace + 1);
                strResult = strResult.substring(0, indexSpace);
                strResult = strResult + "T";
                strResult = strResult + strEnd;
            }
            strResult = strResult.replace('.', '-');
        }
        catch (Exception ex) {
            return strIn;
        }
        return strResult;
    }

    public static Element createDOM(Transcription theTranscription, List tierOrder) {
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        Hashtable<TimeSlot, String> timeSlotIds = new Hashtable<TimeSlot, String>();
        Hashtable<Annotation, String> annotationIds = new Hashtable<Annotation, String>();
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            System.out.println("[[ASSERTION FAILED]] EAF21TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF21 eafFactory = null;
        try {
            eafFactory = new EAF21();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = EAF21TranscriptionStore.correctDate(dateString);
        String author = attisTr.getAuthor();
        if (author == null) {
            author = "unspecified";
        }
        String version = "2.1";
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, version);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        for (MediaDescriptor md : attisTr.getMediaDescriptors()) {
            String origin = null;
            if (md.timeOrigin != 0L) {
                origin = String.valueOf(md.timeOrigin);
            }
            String extrFrom = null;
            if (md.extractedFrom != null && md.extractedFrom != "") {
                extrFrom = md.extractedFrom;
            }
            Element mdElement = eafFactory.newMediaDescriptor(md.mediaURL, md.mimeType, origin, extrFrom);
            header.appendChild(mdElement);
        }
        TimeOrder timeOrder = attisTr.getTimeOrder();
        timeOrder.pruneTimeSlots();
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        int index = 1;
        Enumeration tsElements = timeOrder.elements();
        while (tsElements.hasMoreElements()) {
            TimeSlot ts = (TimeSlot)tsElements.nextElement();
            Element tsElement = null;
            String tsId = "ts" + index;
            timeSlotIds.put(ts, tsId);
            tsElement = ts.getTime() != -1L ? eafFactory.newTimeSlot(tsId, ts.getTime()) : eafFactory.newTimeSlot(tsId);
            timeOrderElement.appendChild(tsElement);
            ++index;
        }
        Vector tiers = attisTr.getTiers();
        Vector<Tier> storeOrder = new Vector<Tier>(tierOrder);
        for (Tier t : tiers) {
            if (storeOrder.contains(t)) continue;
            storeOrder.add(t);
        }
        int annIndex = 1;
        int svgIndex = 1;
        for (TierImpl tierImpl : storeOrder) {
            Locale lang;
            String string = tierImpl.getName();
            String participant = (String)tierImpl.getMetadataValue("PARTICIPANT");
            String lingType = tierImpl.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = (Locale)tierImpl.getMetadataValue("DEFAULT_LOCALE")) == null) {
                lang = new Locale("not specified", "", "");
            }
            if (!usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (tierImpl.getParentTier() != null) {
                parentName = tierImpl.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(string, participant, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(tierImpl.getName(), tierElement);
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                annotationIds.put(ann, "a" + annIndex);
                ++annIndex;
            }
        }
        for (TierImpl tierImpl : storeOrder) {
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                Element annElement = eafFactory.newAnnotation();
                ((Element)tierElements.get(tierImpl.getName())).appendChild(annElement);
                Node annSubElement = null;
                String annId = (String)annotationIds.get(ann);
                if (ann instanceof AlignableAnnotation) {
                    String beginTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getBegin());
                    String endTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getEnd());
                    if (ann instanceof SVGAlignableAnnotation) {
                        if (((SVGAlignableAnnotation)ann).getShape() != null) {
                            String svgId = "ga" + svgIndex;
                            ((SVGAlignableAnnotation)ann).setSVGElementID(svgId);
                            ++svgIndex;
                            annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, svgId);
                        } else {
                            ((SVGAlignableAnnotation)ann).setSVGElementID(null);
                            annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, null);
                        }
                    } else {
                        annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, null);
                    }
                } else if (ann instanceof RefAnnotation) {
                    String refId = null;
                    String prevId = null;
                    Vector refs = ((RefAnnotation)ann).getReferences();
                    RefAnnotation prev = ((RefAnnotation)ann).getPrevious();
                    if (refs.size() > 0) {
                        refId = (String)annotationIds.get((Annotation)refs.firstElement());
                    }
                    if (prev != null) {
                        prevId = (String)annotationIds.get(prev);
                    }
                    annSubElement = eafFactory.newRefAnnotation(annId, refId, prevId);
                }
                annElement.appendChild(annSubElement);
                Element valueElement = eafFactory.newAnnotationValue(ann.getValue());
                annSubElement.appendChild(valueElement);
            }
        }
        Vector vector = attisTr.getLinguisticTypes();
        if (vector != null) {
            for (LinguisticType lt : vector) {
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), lt.hasGraphicReferences(), stereotype);
                annotDocument.appendChild(typeElement);
            }
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        return eafFactory.getDocumentElement();
    }

    @Override
    public void storeTranscriptionAsTemplateIn(Transcription theTranscription, List tierOrder, String path) {
        Element documentElement = EAF21TranscriptionStore.createTemplateDOM(theTranscription, tierOrder);
        if (this.fileToWriteXMLinto != null) {
            EAF21TranscriptionStore.save(documentElement, this.fileToWriteXMLinto.getAbsolutePath(), true);
        } else {
            EAF21TranscriptionStore.save(documentElement, path, false);
        }
    }

    public static Element createTemplateDOM(Transcription theTranscription, List tierOrder) {
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        Hashtable<Annotation, String> annotationIds = new Hashtable<Annotation, String>();
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            System.out.println("[[ASSERTION FAILED]] EAF21TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF21 eafFactory = null;
        try {
            eafFactory = new EAF21();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm z");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        String author = attisTr.getAuthor();
        author = "";
        String version = "2.1";
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, version);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        Vector tiers = attisTr.getTiers();
        Vector<Tier> storeOrder = new Vector<Tier>(tierOrder);
        for (Tier t : tiers) {
            if (storeOrder.contains(t)) continue;
            storeOrder.add(t);
        }
        int annIndex = 1;
        for (TierImpl tierImpl : storeOrder) {
            Locale lang;
            String id = tierImpl.getName();
            String participant = (String)tierImpl.getMetadataValue("PARTICIPANT");
            String lingType = tierImpl.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = (Locale)tierImpl.getMetadataValue("DEFAULT_LOCALE")) == null) {
                lang = new Locale("not specified", "", "");
            }
            if (!usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (tierImpl.getParentTier() != null) {
                parentName = tierImpl.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(id, participant, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(tierImpl.getName(), tierElement);
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                annotationIds.put(ann, "a" + annIndex);
                ++annIndex;
            }
        }
        Vector vector = attisTr.getLinguisticTypes();
        if (vector != null) {
            for (LinguisticType lt : vector) {
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), lt.hasGraphicReferences(), stereotype);
                annotDocument.appendChild(typeElement);
            }
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        return eafFactory.getDocumentElement();
    }

    @Override
    public void loadTranscription(Transcription theTranscription) {
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        String trPathName = attisTr.getPathName();
        Parser parser = null;
        parser = trPathName.endsWith("cha") ? ParserFactory.getParser(1) : ParserFactory.getParser(0);
        String mediaFileName = parser.getMediaFile(trPathName);
        if (mediaFileName != null && mediaFileName.startsWith("file:")) {
            mediaFileName = mediaFileName.substring(5);
        }
        attisTr.setMainMediaFile(mediaFileName);
        ArrayList mediaDescriptors = parser.getMediaDescriptors(trPathName);
        attisTr.setMediaDescriptors(new Vector(mediaDescriptors));
        String svgFile = parser.getSVGFile(trPathName);
        if (svgFile != null) {
            if (!svgFile.startsWith("file:")) {
                svgFile = "file:" + mediaFileName;
            }
            attisTr.setSVGFile(svgFile);
        }
        String author = parser.getAuthor(trPathName);
        if (attisTr.getAuthor().equals("")) {
            attisTr.setAuthor(author);
        }
        ArrayList linguisticTypes = parser.getLinguisticTypes(trPathName);
        Vector<LinguisticType> typesCopy = new Vector<LinguisticType>(linguisticTypes.size());
        for (int i = 0; i < linguisticTypes.size(); ++i) {
            LingTypeRecord ltr = (LingTypeRecord)linguisticTypes.get(i);
            LinguisticType lt = new LinguisticType(ltr.getLingTypeId());
            boolean timeAlignable = true;
            if (ltr.getTimeAlignable().equals("false")) {
                timeAlignable = false;
            }
            lt.setTimeAlignable(timeAlignable);
            boolean graphicReferences = false;
            if (ltr.getGraphicReferences().equals("true")) {
                graphicReferences = true;
            }
            lt.setGraphicReferences(graphicReferences);
            String stereotype = ltr.getStereoType();
            ConstraintImpl c = null;
            if (stereotype != null) {
                if ((stereotype = stereotype.replace('_', ' ')).equals(Constraint.stereoTypes[0])) {
                    c = new TimeSubdivision();
                } else if (stereotype.equals(Constraint.stereoTypes[3])) {
                    c = new SymbolicSubdivision();
                } else if (stereotype.equals(Constraint.stereoTypes[4])) {
                    c = new SymbolicAssociation();
                }
            }
            if (c != null) {
                lt.addConstraint(c);
            }
            typesCopy.add(lt);
        }
        attisTr.setLinguisticTypes(typesCopy);
        TimeOrder timeOrder = attisTr.getTimeOrder();
        ArrayList order = parser.getTimeOrder(trPathName);
        HashMap slots = parser.getTimeSlots(trPathName);
        Hashtable<String, TimeSlotImpl> timeSlothash = new Hashtable<String, TimeSlotImpl>();
        Iterator orderedIter = order.iterator();
        while (orderedIter.hasNext()) {
            TimeSlotImpl ts = null;
            String key = (String)orderedIter.next();
            long time = Long.parseLong((String)slots.get(key));
            ts = time != -1L ? new TimeSlotImpl(time, timeOrder) : new TimeSlotImpl(timeOrder);
            timeOrder.insertTimeSlot(ts);
            timeSlothash.put(key, ts);
        }
        Hashtable<TierImpl, String> parentHash = new Hashtable<TierImpl, String>();
        if (!attisTr.isLoaded()) {
            Iterator iter = parser.getTierNames(trPathName).iterator();
            attisTr.setLoaded(true);
            while (iter.hasNext()) {
                String parentId;
                String tierName = (String)iter.next();
                TierImpl tier = new TierImpl(null, tierName, null, attisTr, null);
                String participant = parser.getParticipantOf(tierName, trPathName);
                String linguisticTypeID = parser.getLinguisticTypeIDOf(tierName, trPathName);
                LinguisticType linguisticType = null;
                for (LinguisticType lt : typesCopy) {
                    if (!lt.getLinguisticTypeName().equals(linguisticTypeID)) continue;
                    linguisticType = lt;
                    break;
                }
                Locale defaultLanguage = parser.getDefaultLanguageOf(tierName, trPathName);
                tier.setMetadata("PARTICIPANT", participant);
                tier.setLinguisticType(linguisticType);
                if (defaultLanguage != null) {
                    tier.setMetadata("DEFAULT_LOCALE", defaultLanguage);
                }
                if ((parentId = parser.getParentNameOf(tierName, trPathName)) != null) {
                    parentHash.put(tier, parentId);
                }
                attisTr.addTier(tier);
            }
        }
        for (TierImpl t : parentHash.keySet()) {
            t.setParentTier(attisTr.getTierWithId((String)parentHash.get(t)));
        }
        Vector tiers = attisTr.getTiers();
        Hashtable<String, RefAnnotation> idToAnnotation = new Hashtable<String, RefAnnotation>();
        Hashtable<String, String> references = new Hashtable<String, String>();
        Hashtable<String, String> referenceChains = new Hashtable<String, String>();
        Hashtable tempAnnotationsForTiers = new Hashtable();
        for (Tier tier : tiers) {
            ArrayList annotationRecords = parser.getAnnotationsOf(tier.getName(), trPathName);
            Vector<RefAnnotation> tempAnnotations = new Vector<RefAnnotation>();
            Iterator it1 = annotationRecords.iterator();
            while (it1.hasNext()) {
                AbstractAnnotation annotation = null;
                AnnotationRecord annotationRecord = (AnnotationRecord)it1.next();
                if (annotationRecord.getAnnotationType().equals("alignable")) {
                    annotation = ((TierImpl)tier).getLinguisticType().hasGraphicReferences() ? new SVGAlignableAnnotation((TimeSlot)timeSlothash.get(annotationRecord.getBeginTimeSlotId()), (TimeSlot)timeSlothash.get(annotationRecord.getEndTimeSlotId()), tier, null) : new AlignableAnnotation((TimeSlot)timeSlothash.get(annotationRecord.getBeginTimeSlotId()), (TimeSlot)timeSlothash.get(annotationRecord.getEndTimeSlotId()), tier);
                } else if (annotationRecord.getAnnotationType().equals("alignable_svg")) {
                    annotation = new SVGAlignableAnnotation((TimeSlot)timeSlothash.get(annotationRecord.getBeginTimeSlotId()), (TimeSlot)timeSlothash.get(annotationRecord.getEndTimeSlotId()), tier, annotationRecord.getSvgReference());
                } else if (annotationRecord.getAnnotationType().equals("reference")) {
                    annotation = new RefAnnotation(null, tier);
                    references.put(annotationRecord.getAnnotationId(), annotationRecord.getReferredAnnotId());
                    if (annotationRecord.getPreviousAnnotId() != null) {
                        referenceChains.put(annotationRecord.getAnnotationId(), annotationRecord.getPreviousAnnotId());
                    }
                }
                if (annotationRecord.getValue() != null) {
                    annotation.setValue(annotationRecord.getValue());
                }
                idToAnnotation.put(annotationRecord.getAnnotationId(), (RefAnnotation)annotation);
                tempAnnotations.add((RefAnnotation)annotation);
            }
            tempAnnotationsForTiers.put(tier, tempAnnotations);
        }
        for (String key : references.keySet()) {
            Annotation referedAnnotation = (Annotation)idToAnnotation.get(references.get(key));
            RefAnnotation refAnnotation = null;
            try {
                refAnnotation = (RefAnnotation)idToAnnotation.get(key);
                refAnnotation.addReference(referedAnnotation);
            }
            catch (Exception ex) {
                Object o = idToAnnotation.get(key);
                System.out.println("failed to add a refanno to  (" + referedAnnotation.getTier().getName() + ", " + referedAnnotation.getBeginTimeBoundary() + ", " + referedAnnotation.getEndTimeBoundary() + ") " + referedAnnotation.getValue());
                if (o instanceof AlignableAnnotation) {
                    Annotation a = (AlignableAnnotation)o;
                    System.out.println("  found AlignableAnnotation (" + ((AbstractAnnotation)a).getTier().getName() + ", " + ((AlignableAnnotation)a).getBeginTimeBoundary() + ", " + ((AlignableAnnotation)a).getEndTimeBoundary() + ") " + ((AbstractAnnotation)a).getValue());
                    continue;
                }
                System.out.println("  found " + o);
            }
        }
        for (String key : referenceChains.keySet()) {
            RefAnnotation previous = (RefAnnotation)idToAnnotation.get(referenceChains.get(key));
            RefAnnotation a = (RefAnnotation)idToAnnotation.get(key);
            if (previous == null) continue;
            previous.setNext(a);
        }
        for (TierImpl t : tempAnnotationsForTiers.keySet()) {
            Vector annots = (Vector)tempAnnotationsForTiers.get(t);
            Iterator aIter = annots.iterator();
            while (aIter.hasNext()) {
                t.insertAnnotation((Annotation)aIter.next());
            }
        }
        for (TierImpl t : tiers) {
            if (!t.isTimeAlignable() || !t.hasParentTier()) continue;
            for (Annotation a : t.getAnnotations()) {
                if (!(a instanceof AlignableAnnotation)) continue;
                ((AlignableAnnotation)a).registerWithParent();
            }
        }
        if (attisTr.allRootAnnotsUnaligned()) {
            attisTr.alignRootAnnots();
        }
        System.out.println("getName: " + attisTr.getName());
        System.out.println("fullpath: " + attisTr.getFullPath());
        System.out.println("pathname: " + attisTr.getPathName());
    }

    @Override
    public void loadTranscription(Transcription theTranscription, DecoderInfo decoderInfo) {
        this.loadTranscription(theTranscription);
    }

    @Override
    public void storeTranscriptionIn(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String path, int format) throws IOException {
        this.storeTranscriptionIn(theTranscription, tierOrder, path);
    }
}

