/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class EAF21Parser
extends Parser {
    private static boolean verbose = false;
    private static EAF21Parser parser;
    private final SAXParser saxParser;
    private final HashMap tiers = new HashMap();
    private final ArrayList tierNames = new ArrayList();
    private final HashMap tierAttributes = new HashMap();
    private final ArrayList linguisticTypes = new ArrayList();
    private final ArrayList locales = new ArrayList();
    private final HashMap timeSlots = new HashMap();
    private final ArrayList timeOrder = new ArrayList();
    private String mediaFile;
    private ArrayList mediaDescriptors = new ArrayList();
    private String svgFile;
    private String author;
    private String currentTierId;
    private String currentAnnotationId;
    private String content = "";
    private String lastParsed = "";
    private String currentFileName;
    private boolean parseError;

    public EAF21Parser() {
        this.saxParser = new SAXParser();
        try {
            this.saxParser.setFeature("http://xml.org/sax/features/validation", true);
            this.saxParser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            this.saxParser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)"http://www.mpi.nl/tools/elan/EAFv2.1.xsd");
            this.saxParser.setContentHandler((ContentHandler)new EAFContentHandler());
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getMediaFile(String fileName) {
        this.parse(fileName);
        return this.mediaFile;
    }

    @Override
    public ArrayList getMediaDescriptors(String fileName) {
        this.parse(fileName);
        return this.mediaDescriptors;
    }

    @Override
    public String getSVGFile(String fileName) {
        this.parse(fileName);
        return this.svgFile;
    }

    @Override
    public String getAuthor(String fileName) {
        this.parse(fileName);
        return this.author;
    }

    @Override
    public ArrayList getLinguisticTypes(String fileName) {
        this.parse(fileName);
        return this.linguisticTypes;
    }

    @Override
    public ArrayList getTimeOrder(String fileName) {
        this.parse(fileName);
        return this.timeOrder;
    }

    @Override
    public HashMap getTimeSlots(String fileName) {
        this.parse(fileName);
        return this.timeSlots;
    }

    @Override
    public ArrayList getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        String part = "";
        if (((HashMap)this.tierAttributes.get(tierName)).get("PARTICIPANT") != null) {
            part = (String)((HashMap)this.tierAttributes.get(tierName)).get("PARTICIPANT");
        }
        return part;
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        String lType = "";
        if (((HashMap)this.tierAttributes.get(tierName)).get("LINGUISTIC_TYPE_REF") != null) {
            lType = (String)((HashMap)this.tierAttributes.get(tierName)).get("LINGUISTIC_TYPE_REF");
        }
        return lType;
    }

    @Override
    public Locale getDefaultLanguageOf(String tierName, String fileName) {
        this.parse(fileName);
        Locale resultLoc = null;
        String localeId = (String)((HashMap)this.tierAttributes.get(tierName)).get("DEFAULT_LOCALE");
        for (Locale l : this.locales) {
            if (!l.getLanguage().equals(localeId)) continue;
            resultLoc = l;
        }
        return resultLoc;
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        return (String)((HashMap)this.tierAttributes.get(tierName)).get("PARENT_REF");
    }

    @Override
    public ArrayList getAnnotationsOf(String tierName, String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        long start = System.currentTimeMillis();
        ArrayList<AnnotationRecord> annotationArrayList = new ArrayList<AnnotationRecord>();
        HashMap annotations = (HashMap)this.tiers.get(tierName);
        for (Object key : annotations.keySet()) {
            AnnotationRecord annotationRecord = new AnnotationRecord();
            annotationRecord.setAnnotationId((String)key);
            ArrayList annotationParams = (ArrayList)annotations.get(key);
            String annotType = (String)annotationParams.get(0);
            annotationRecord.setAnnotationType(annotType);
            if (annotType.equals("reference")) {
                String referredAnnotId = (String)annotationParams.get(1);
                String previousAnnotId = (String)annotationParams.get(2);
                annotationRecord.setReferredAnnotId(referredAnnotId);
                annotationRecord.setPreviousAnnotId(previousAnnotId);
            } else {
                String beginTimeSlotId = (String)annotationParams.get(1);
                String endTimeSlotId = (String)annotationParams.get(2);
                annotationRecord.setBeginTimeSlotId(beginTimeSlotId);
                annotationRecord.setEndTimeSlotId(endTimeSlotId);
            }
            if (annotType.equals("alignable_svg")) {
                String svgRefId = (String)annotationParams.get(3);
                String annotValue = (String)annotationParams.get(4);
                annotationRecord.setSvgReference(svgRefId);
                annotationRecord.setValue(annotValue);
            } else {
                String annotValue = (String)annotationParams.get(3);
                annotationRecord.setValue(annotValue);
            }
            annotationArrayList.add(annotationRecord);
        }
        long duration = System.currentTimeMillis() - start;
        return annotationArrayList;
    }

    private void parse(String fileName) {
        long start = System.currentTimeMillis();
        if (this.lastParsed.equals(fileName)) {
            return;
        }
        this.tiers.clear();
        this.tierNames.clear();
        this.tierAttributes.clear();
        this.mediaFile = "";
        this.linguisticTypes.clear();
        this.locales.clear();
        this.timeSlots.clear();
        this.timeOrder.clear();
        this.mediaDescriptors.clear();
        this.lastParsed = fileName;
        this.currentFileName = fileName;
        try {
            this.saxParser.parse(fileName);
        }
        catch (SAXException e) {
            System.out.println("Parsing error: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.printErrorLocationInfo("Fatal(?) Error! " + e.getMessage());
        }
        long duration = System.currentTimeMillis() - start;
    }

    private void println(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }

    private void printErrorLocationInfo(String message) {
        System.out.println(message);
        System.out.println("Exception for " + this.currentFileName);
        System.out.println("Tier id " + this.currentTierId);
        System.out.println("Annotation id " + this.currentAnnotationId);
    }

    class EAFContentHandler
    implements ContentHandler {
        private Locator locator;

        EAFContentHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int end) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
            EAF21Parser.this.parseError = false;
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            EAF21Parser.this.content = "";
            if (name.equals("ANNOTATION_DOCUMENT")) {
                EAF21Parser.this.author = attributes.getValue("AUTHOR");
            } else if (name.equals("HEADER")) {
                EAF21Parser.this.mediaFile = attributes.getValue("MEDIA_FILE");
                EAF21Parser.this.svgFile = attributes.getValue("SVG_FILE");
            } else if (name.equals("MEDIA_DESCRIPTOR")) {
                String mediaURL = attributes.getValue("MEDIA_URL");
                String mimeType = attributes.getValue("MIME_TYPE");
                MediaDescriptor md = new MediaDescriptor(mediaURL, mimeType);
                long timeOrigin = 0L;
                if (attributes.getValue("TIME_ORIGIN") != null) {
                    md.timeOrigin = timeOrigin = Long.parseLong(attributes.getValue("TIME_ORIGIN"));
                }
                String extractedFrom = "";
                if (attributes.getValue("EXTRACTED_FROM") != null) {
                    md.extractedFrom = extractedFrom = attributes.getValue("EXTRACTED_FROM");
                }
                EAF21Parser.this.mediaDescriptors.add(md);
            } else if (!name.equals("TIME_ORDER")) {
                if (name.equals("TIME_SLOT")) {
                    String timeValue = String.valueOf(-1);
                    if (attributes.getValue("TIME_VALUE") != null) {
                        timeValue = attributes.getValue("TIME_VALUE");
                    }
                    EAF21Parser.this.timeSlots.put(attributes.getValue("TIME_SLOT_ID"), timeValue);
                    EAF21Parser.this.timeOrder.add(attributes.getValue("TIME_SLOT_ID"));
                } else if (name.equals("TIER")) {
                    EAF21Parser.this.currentTierId = attributes.getValue("TIER_ID");
                    if (!EAF21Parser.this.tiers.containsKey(EAF21Parser.this.currentTierId)) {
                        EAF21Parser.this.tiers.put(EAF21Parser.this.currentTierId, new HashMap());
                        EAF21Parser.this.tierAttributes.put(EAF21Parser.this.currentTierId, new HashMap());
                        EAF21Parser.this.tierNames.add(EAF21Parser.this.currentTierId);
                    }
                    HashMap attrHash = (HashMap)EAF21Parser.this.tierAttributes.get(EAF21Parser.this.currentTierId);
                    if (attributes.getValue("PARTICIPANT") != null) {
                        attrHash.put("PARTICIPANT", attributes.getValue("PARTICIPANT"));
                    }
                    attrHash.put("LINGUISTIC_TYPE_REF", attributes.getValue("LINGUISTIC_TYPE_REF"));
                    if (attributes.getValue("DEFAULT_LOCALE") != null) {
                        attrHash.put("DEFAULT_LOCALE", attributes.getValue("DEFAULT_LOCALE"));
                    } else {
                        attrHash.put("DEFAULT_LOCALE", "en");
                    }
                    if (attributes.getValue("PARENT_REF") != null) {
                        attrHash.put("PARENT_REF", attributes.getValue("PARENT_REF"));
                    }
                } else if (name.equals("ALIGNABLE_ANNOTATION")) {
                    EAF21Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    ((HashMap)EAF21Parser.this.tiers.get(EAF21Parser.this.currentTierId)).put(EAF21Parser.this.currentAnnotationId, new ArrayList());
                    String svg_ref = attributes.getValue("SVG_REF");
                    ((ArrayList)((HashMap)EAF21Parser.this.tiers.get(EAF21Parser.this.currentTierId)).get(EAF21Parser.this.currentAnnotationId)).add(svg_ref == null ? "alignable" : "alignable_svg");
                    ((ArrayList)((HashMap)EAF21Parser.this.tiers.get(EAF21Parser.this.currentTierId)).get(EAF21Parser.this.currentAnnotationId)).add(attributes.getValue("TIME_SLOT_REF1"));
                    ((ArrayList)((HashMap)EAF21Parser.this.tiers.get(EAF21Parser.this.currentTierId)).get(EAF21Parser.this.currentAnnotationId)).add(attributes.getValue("TIME_SLOT_REF2"));
                    if (svg_ref != null) {
                        ((ArrayList)((HashMap)EAF21Parser.this.tiers.get(EAF21Parser.this.currentTierId)).get(EAF21Parser.this.currentAnnotationId)).add(svg_ref);
                    }
                } else if (name.equals("REF_ANNOTATION")) {
                    EAF21Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    ((HashMap)EAF21Parser.this.tiers.get(EAF21Parser.this.currentTierId)).put(EAF21Parser.this.currentAnnotationId, new ArrayList());
                    ((ArrayList)((HashMap)EAF21Parser.this.tiers.get(EAF21Parser.this.currentTierId)).get(EAF21Parser.this.currentAnnotationId)).add("reference");
                    ((ArrayList)((HashMap)EAF21Parser.this.tiers.get(EAF21Parser.this.currentTierId)).get(EAF21Parser.this.currentAnnotationId)).add(attributes.getValue("ANNOTATION_REF"));
                    if (attributes.getValue("PREVIOUS_ANNOTATION") != null) {
                        ((ArrayList)((HashMap)EAF21Parser.this.tiers.get(EAF21Parser.this.currentTierId)).get(EAF21Parser.this.currentAnnotationId)).add(attributes.getValue("PREVIOUS_ANNOTATION"));
                    } else {
                        ((ArrayList)((HashMap)EAF21Parser.this.tiers.get(EAF21Parser.this.currentTierId)).get(EAF21Parser.this.currentAnnotationId)).add("");
                    }
                } else if (name.equals("LINGUISTIC_TYPE")) {
                    LingTypeRecord ltr = new LingTypeRecord();
                    ltr.setLingTypeId(attributes.getValue("LINGUISTIC_TYPE_ID"));
                    String timeAlignable = "true";
                    if (attributes.getValue("TIME_ALIGNABLE") != null && attributes.getValue("TIME_ALIGNABLE").equals("false")) {
                        timeAlignable = "false";
                    }
                    ltr.setTimeAlignable(timeAlignable);
                    String graphicReferences = "false";
                    if (attributes.getValue("GRAPHIC_REFERENCES") != null && attributes.getValue("GRAPHIC_REFERENCES").equals("true")) {
                        graphicReferences = "true";
                    }
                    ltr.setGraphicReferences(graphicReferences);
                    String stereotype = attributes.getValue("CONSTRAINTS");
                    ltr.setStereoType(stereotype);
                    EAF21Parser.this.linguisticTypes.add(ltr);
                } else if (name.equals("LOCALE")) {
                    String variant;
                    String langCode = attributes.getValue("LANGUAGE_CODE");
                    String countryCode = attributes.getValue("COUNTRY_CODE");
                    if (countryCode == null) {
                        countryCode = "";
                    }
                    if ((variant = attributes.getValue("VARIANT")) == null) {
                        variant = "";
                    }
                    Locale l = new Locale(langCode, countryCode, variant);
                    EAF21Parser.this.locales.add(l);
                }
            }
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("ANNOTATION_VALUE")) {
                ((ArrayList)((HashMap)EAF21Parser.this.tiers.get(EAF21Parser.this.currentTierId)).get(EAF21Parser.this.currentAnnotationId)).add(EAF21Parser.this.content);
            }
        }

        @Override
        public void characters(char[] ch, int start, int end) throws SAXException {
            EAF21Parser.this.content = EAF21Parser.this.content + new String(ch, start, end);
        }
    }
}

