/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.p2p;

import java.util.Iterator;
import java.util.Vector;
import mpi.eudico.client.annotator.ActiveAnnotationListener;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.SelectionListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.StartEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.p2p.ElanP2P;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class P2P2Here
implements ControllerListener,
SelectionListener,
ActiveAnnotationListener,
ACMEditListener {
    public static final String SET_MEDIA_TIME = "setMediaTime";
    public static final String SET_SELECTION = "setSelection";
    public static final String SET_ACTIVE_ANNOTATION = "setActiveAnnotation";
    public static final String CHANGE_ANNOTATION_VALUE = "changeAnnValue";
    private ElanP2P p2p;
    private ViewerManager2 viewerManager;
    private ElanFrame2 frame;
    private boolean deaf;

    public P2P2Here(ElanP2P p2p, ViewerManager2 viewerManager, ElanFrame2 frame) {
        this.p2p = p2p;
        this.viewerManager = viewerManager;
        this.frame = frame;
        viewerManager.connectListener(this);
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        if (this.deaf) {
            return;
        }
        if (event instanceof TimeEvent) {
            long time = this.viewerManager.getMasterMediaPlayer().getMediaTime();
            this.p2p.sendElanCommand(SET_MEDIA_TIME, Long.toString(time));
        } else if (event instanceof StartEvent) {
            this.deaf = true;
        } else if (event instanceof StopEvent) {
            this.deaf = false;
        }
    }

    public void handleCommand(String command, String parameter1, String parameter2) {
        if (command.equals(SET_MEDIA_TIME)) {
            long time = Long.parseLong(parameter1);
            this.viewerManager.getMasterMediaPlayer().setMediaTime(time);
        } else if (command.equals(SET_SELECTION)) {
            long beginTime = Long.parseLong(parameter1);
            long endTime = Long.parseLong(parameter2);
            this.viewerManager.getSelection().setSelection(beginTime, endTime);
        } else if (command.equals(SET_ACTIVE_ANNOTATION)) {
            String name = parameter1;
            int i = Integer.parseInt(parameter2);
            Annotation ann = this.getAnnotationForIndexOnTier(name, i);
            this.viewerManager.getActiveAnnotation().setAnnotation(ann);
        } else if (command.equals(CHANGE_ANNOTATION_VALUE)) {
            int i = Integer.parseInt(parameter1);
            Annotation ann = this.getAnnotationForIndex(i);
            String value = parameter2;
            if (ann != null) {
                ann.setValue(value);
            }
        }
        System.out.println("received command: " + command + " par1 = " + parameter1 + " par2 = " + parameter2 + "\n");
    }

    @Override
    public void updateSelection() {
        long beginTime = this.viewerManager.getSelection().getBeginTime();
        long endTime = this.viewerManager.getSelection().getEndTime();
        this.p2p.sendElanCommand(SET_SELECTION, Long.toString(beginTime), Long.toString(endTime));
    }

    @Override
    public void updateActiveAnnotation() {
        Annotation annotation = this.viewerManager.getActiveAnnotation().getAnnotation();
        int index = this.getIndexOnTier(annotation);
        String tiername = "";
        if (annotation != null) {
            tiername = annotation.getTier().getName();
        }
        this.p2p.sendElanCommand(SET_ACTIVE_ANNOTATION, tiername, Integer.toString(index));
    }

    @Override
    public void ACMEdited(ACMEditEvent event) {
        System.out.println("ACM: " + event);
        switch (event.getOperation()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                if (!(event.getSource() instanceof Annotation)) break;
                Annotation a = (Annotation)event.getSource();
                String value = a.getValue();
                int index = this.getIndexForAnnotation(a);
                this.p2p.sendElanCommand(CHANGE_ANNOTATION_VALUE, Integer.toString(index), value);
                break;
            }
        }
    }

    public void openEAF(String fullPath) {
        this.frame.openEAF(fullPath);
    }

    public void setVideoPointer(float relX, float relY) {
    }

    private int getIndexForAnnotation(Annotation annotation) {
        TranscriptionImpl transcription = (TranscriptionImpl)this.viewerManager.getTranscription();
        int index = 0;
        try {
            Vector tiers = transcription.getTiers();
            Iterator tierIter = tiers.iterator();
            while (tierIter.hasNext()) {
                Vector annots = ((TierImpl)tierIter.next()).getAnnotations();
                Iterator annIter = annots.iterator();
                while (annIter.hasNext()) {
                    if (annIter.next() == annotation) {
                        return index;
                    }
                    ++index;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    private Annotation getAnnotationForIndex(int index) {
        TranscriptionImpl transcription = (TranscriptionImpl)this.viewerManager.getTranscription();
        Annotation annot2 = null;
        int counter = 0;
        try {
            Vector tiers = transcription.getTiers();
            Iterator tierIter = tiers.iterator();
            while (tierIter.hasNext()) {
                Vector annots = ((TierImpl)tierIter.next()).getAnnotations();
                for (Annotation annot2 : annots) {
                    if (counter == index) {
                        return annot2;
                    }
                    ++counter;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private int getIndexOnTier(Annotation annotation) {
        if (annotation == null) {
            return -1;
        }
        TierImpl tier = (TierImpl)annotation.getTier();
        int index = 0;
        Vector annots = tier.getAnnotations();
        Iterator annIter = annots.iterator();
        while (annIter.hasNext()) {
            if (annIter.next() == annotation) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private Annotation getAnnotationForIndexOnTier(String name, int index) {
        if (name == null || name.length() == 0 || index < 0) {
            return null;
        }
        TranscriptionImpl transcription = (TranscriptionImpl)this.viewerManager.getTranscription();
        Annotation annot2 = null;
        int counter = 0;
        TierImpl tier = (TierImpl)transcription.getTierWithId(name);
        Vector annots = tier.getAnnotations();
        for (Annotation annot2 : annots) {
            if (counter == index) {
                return annot2;
            }
            ++counter;
        }
        return null;
    }
}

