/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class FavoriteColorPanel
extends AbstractColorChooserPanel
implements ActionListener,
ComponentListener,
MouseListener {
    public final int NUM_ROWS = 5;
    public final int NUM_COLS = 10;
    private final int GAP = 5;
    private final int CELL_DIM = 20;
    private Dimension matrixSize;
    private int selIndex = 0;
    private ResourceBundle bundle;
    private Color[] colors = new Color[50];
    private JButton addButton;
    private JButton insertButton;
    private JButton removeButton;
    private JButton copyButton;
    private JButton cutButton;
    private JButton pasteButton;
    private JPanel buttonPanel;
    private Color copyColor = null;

    public FavoriteColorPanel() {
        this.matrixSize = new Dimension(255, 130);
    }

    public FavoriteColorPanel(ResourceBundle bundle) {
        this();
        this.bundle = bundle;
    }

    public FavoriteColorPanel(Color[] favColors) {
        this();
        this.setColors(favColors);
    }

    public FavoriteColorPanel(ResourceBundle bundle, Color[] favColors) {
        this();
        this.bundle = bundle;
        this.setColors(favColors);
    }

    public void setColors(Color[] nextColors) {
        if (nextColors != null) {
            int numColors = 50;
            for (int i = 0; i < numColors && i < nextColors.length; ++i) {
                this.colors[i] = nextColors[i];
            }
        }
    }

    public Color[] getColors() {
        return this.colors;
    }

    @Override
    protected void buildChooser() {
        this.setLayout(null);
        int margin = 2;
        this.buttonPanel = new JPanel(new GridLayout(1, 7, margin, margin));
        this.addButton = new JButton();
        this.addButton.addActionListener(this);
        this.buttonPanel.add(this.addButton);
        this.insertButton = new JButton();
        this.insertButton.addActionListener(this);
        this.buttonPanel.add(this.insertButton);
        this.removeButton = new JButton();
        this.removeButton.addActionListener(this);
        this.buttonPanel.add(this.removeButton);
        JPanel div = new JPanel();
        div.setPreferredSize(new Dimension(8, 8));
        this.buttonPanel.add(div);
        this.copyButton = new JButton();
        this.copyButton.addActionListener(this);
        this.buttonPanel.add(this.copyButton);
        this.cutButton = new JButton();
        this.cutButton.addActionListener(this);
        this.buttonPanel.add(this.cutButton);
        this.pasteButton = new JButton();
        this.pasteButton.addActionListener(this);
        this.buttonPanel.add(this.pasteButton);
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Add16.gif"));
            if (icon != null) {
                this.addButton.setIcon(icon);
            } else {
                this.addButton.setText("A");
            }
        }
        catch (Exception ex) {
            this.addButton.setText("A");
        }
        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Insert16.gif"));
            if (icon != null) {
                this.insertButton.setIcon(icon);
            } else {
                this.insertButton.setText("I");
            }
        }
        catch (Exception ex) {
            this.insertButton.setText("I");
        }
        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Delete16.gif"));
            if (icon != null) {
                this.removeButton.setIcon(icon);
            } else {
                this.removeButton.setText("D");
            }
        }
        catch (Exception ex) {
            this.removeButton.setText("D");
        }
        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Copy16.gif"));
            if (icon != null) {
                this.copyButton.setIcon(icon);
            } else {
                this.copyButton.setText("C");
            }
        }
        catch (Exception ex) {
            this.copyButton.setText("C");
        }
        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Cut16.gif"));
            if (icon != null) {
                this.cutButton.setIcon(icon);
            } else {
                this.cutButton.setText("X");
            }
        }
        catch (Exception ex) {
            this.copyButton.setText("X");
        }
        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Paste16.gif"));
            if (icon != null) {
                this.pasteButton.setIcon(icon);
            } else {
                this.pasteButton.setText("P");
            }
        }
        catch (Exception ex) {
            this.copyButton.setText("P");
        }
        Dimension bdim = this.addButton.getPreferredSize();
        this.buttonPanel.setPreferredSize(new Dimension(6 * bdim.width + 5 * margin, bdim.height + 2 * margin));
        this.add(this.buttonPanel);
        this.addMouseListener(this);
        this.setFocusable(true);
        this.setTexts();
    }

    private void setTexts() {
        if (this.bundle != null) {
            String tt = null;
            tt = this.bundle.getString("Button.Add");
            if (tt != null) {
                this.addButton.setToolTipText(tt);
            }
            if ((tt = this.bundle.getString("Button.Insert")) != null) {
                this.insertButton.setToolTipText(tt);
            }
            if ((tt = this.bundle.getString("Button.Delete")) != null) {
                this.removeButton.setToolTipText(tt);
            }
            if ((tt = this.bundle.getString("Button.Copy")) != null) {
                this.copyButton.setToolTipText(tt);
            }
            if ((tt = this.bundle.getString("Button.Cut")) != null) {
                this.cutButton.setToolTipText(tt);
            }
            if ((tt = this.bundle.getString("Button.Paste")) != null) {
                this.pasteButton.setToolTipText(tt);
            }
        } else {
            this.addButton.setToolTipText("Add");
            this.insertButton.setToolTipText("Insert");
            this.removeButton.setToolTipText("Delete");
            this.copyButton.setToolTipText("Copy");
            this.cutButton.setToolTipText("Cut");
            this.pasteButton.setToolTipText("Paste");
        }
    }

    @Override
    public String getDisplayName() {
        String title;
        if (this.bundle != null && (title = this.bundle.getString("ColorChooser.Favorites.Title")) != null) {
            return title;
        }
        return "Favorites";
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public void updateChooser() {
        if (this.buttonPanel != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            this.buttonPanel.setBounds((w - this.buttonPanel.getPreferredSize().width) / 2, h - this.buttonPanel.getPreferredSize().height, this.buttonPanel.getPreferredSize().width, this.buttonPanel.getPreferredSize().height);
        }
        Color curCol = this.getColorSelectionModel().getSelectedColor();
        int firstEmpty = -1;
        for (int i = 0; i < this.colors.length; ++i) {
            if (firstEmpty < 0 && this.colors[i] == null) {
                firstEmpty = i;
            }
            if (this.colors[i] != null && this.colors[i].equals(curCol)) {
                this.selIndex = i;
                break;
            }
            if (i != this.colors.length - 1) continue;
            this.selIndex = firstEmpty < 0 ? i : firstEmpty;
        }
        this.requestFocus();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.matrixSize.width + 10;
        int h = this.matrixSize.height + 30 + 5;
        if (this.buttonPanel != null) {
            int bw = this.buttonPanel.getPreferredSize().width;
            w = bw > w ? bw : w;
            int bh = this.buttonPanel.getPreferredSize().height;
            h = bh > h ? bh : h;
        }
        return new Dimension(w, h);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int x = (this.getWidth() - this.matrixSize.width) / 2;
        int bh = 0;
        if (this.buttonPanel != null) {
            bh = this.buttonPanel.getPreferredSize().height;
        }
        int y = (this.getHeight() - bh - this.matrixSize.height) / 2;
        g.setColor(this.getForeground());
        g.drawRect(x, y, this.matrixSize.width, this.matrixSize.height);
        x += 5;
        y += 5;
        for (int i = 0; i < this.colors.length; ++i) {
            int r = i / 10;
            int c = i - r * 10;
            if (i == this.selIndex) {
                g.setColor(Color.BLUE);
                g.drawRect(x + c * 20 + c * 5 - 2, y + r * 20 + r * 5 - 2, 24, 24);
            }
            if (this.colors[i] != null) {
                g.setColor(this.colors[i]);
                g.fillRect(x + c * 20 + c * 5, y + r * 20 + r * 5, 20, 20);
            }
            g.setColor(Color.DARK_GRAY);
            g.drawRect(x + c * 20 + c * 5, y + r * 20 + r * 5, 20, 20);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            Color curCol = this.getColorFromModel();
            if (curCol != null) {
                for (int i = this.colors.length - 1; i >= 0; --i) {
                    if (this.colors[i] != null && i < this.colors.length - 2) {
                        this.colors[i + 1] = curCol;
                        this.selIndex = i + 1;
                        break;
                    }
                    if (i != 0 || this.colors[i] != null) continue;
                    this.colors[0] = curCol;
                    this.selIndex = 0;
                }
            }
        } else if (e.getSource() == this.insertButton) {
            Color curCol = this.getColorFromModel();
            if (curCol != null && this.selIndex >= 0 && this.selIndex < this.colors.length) {
                if (this.colors[this.selIndex] != null) {
                    for (int i = this.colors.length - 2; i >= this.selIndex; --i) {
                        this.colors[i + 1] = this.colors[i];
                    }
                }
                this.colors[this.selIndex] = null;
            }
        } else if (e.getSource() == this.removeButton) {
            if (this.selIndex >= 0 && this.selIndex < this.colors.length) {
                this.colors[this.selIndex] = null;
            }
        } else if (e.getSource() == this.copyButton) {
            if (this.selIndex >= 0 && this.selIndex < this.colors.length) {
                this.copyColor = this.colors[this.selIndex];
            }
        } else if (e.getSource() == this.cutButton) {
            if (this.selIndex >= 0 && this.selIndex < this.colors.length) {
                this.copyColor = this.colors[this.selIndex];
                this.colors[this.selIndex] = null;
            }
        } else if (e.getSource() == this.pasteButton && this.copyColor != null && this.selIndex >= 0 && this.selIndex < this.colors.length) {
            this.colors[this.selIndex] = this.copyColor;
        }
        this.getColorSelectionModel().setSelectedColor(this.colors[this.selIndex]);
        this.repaint();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.buttonPanel != null) {
            int x = (this.getWidth() - this.buttonPanel.getPreferredSize().width) / 2;
            int y = this.getHeight() - this.buttonPanel.getPreferredSize().height;
            this.buttonPanel.setBounds(x, y, this.buttonPanel.getPreferredSize().width, this.buttonPanel.getPreferredSize().height);
        }
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int matX = (this.getWidth() - this.matrixSize.width) / 2 + 5;
        int bh = 0;
        if (this.buttonPanel != null) {
            bh = this.buttonPanel.getPreferredSize().height;
        }
        int matY = (this.getHeight() - bh - this.matrixSize.height) / 2 + 5;
        int rowY = e.getY() - matY;
        int colX = e.getX() - matX;
        if (colX < 0 || rowY < 0 || colX > matX + this.matrixSize.width || rowY > matY + this.matrixSize.height) {
            return;
        }
        int row = -1;
        while (rowY > 0) {
            ++row;
            if ((rowY -= 25) >= 0 || rowY <= -5) continue;
            row = -1;
            break;
        }
        if (row >= 0) {
            int index;
            int col = -1;
            while (colX > 0) {
                ++col;
                if ((colX -= 25) >= 0 || colX <= -5) continue;
                col = -1;
                break;
            }
            if (col >= 0 && (index = row * 10 + col) >= 0 && index < this.colors.length) {
                this.selIndex = index;
                if (this.colors[this.selIndex] != null) {
                    this.getColorSelectionModel().setSelectedColor(this.colors[this.selIndex]);
                }
                this.repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (pressed) {
            if (e.getKeyCode() == 39) {
                ++this.selIndex;
                if (this.selIndex >= this.colors.length) {
                    this.selIndex = 0;
                }
                this.repaint();
                if (this.colors[this.selIndex] != null) {
                    this.getColorSelectionModel().setSelectedColor(this.colors[this.selIndex]);
                }
                return true;
            }
            if (e.getKeyCode() == 37) {
                --this.selIndex;
                if (this.selIndex < 0) {
                    this.selIndex = this.colors.length - 1;
                }
                this.repaint();
                if (this.colors[this.selIndex] != null) {
                    this.getColorSelectionModel().setSelectedColor(this.colors[this.selIndex]);
                }
                return true;
            }
            if (e.getKeyCode() == 38) {
                this.selIndex -= 10;
                if (this.selIndex < 0) {
                    this.selIndex += this.colors.length;
                }
                this.repaint();
                if (this.colors[this.selIndex] != null) {
                    this.getColorSelectionModel().setSelectedColor(this.colors[this.selIndex]);
                }
                return true;
            }
            if (e.getKeyCode() == 40) {
                this.selIndex += 10;
                if (this.selIndex > this.colors.length - 1) {
                    this.selIndex -= this.colors.length;
                }
                this.repaint();
                if (this.colors[this.selIndex] != null) {
                    this.getColorSelectionModel().setSelectedColor(this.colors[this.selIndex]);
                }
                return true;
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }
}

