/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import mpi.eudico.client.util.SelectableObject;

public class CheckboxTreeCellEditor
extends JCheckBox
implements TreeCellEditor,
ItemListener {
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    private Object uObject;
    private boolean edited = false;
    private JTree tree;

    public CheckboxTreeCellEditor() {
        this.addItemListener(this);
        this.initColors();
    }

    private void initColors() {
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.tree = tree;
        if (value instanceof DefaultMutableTreeNode) {
            this.uObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (this.uObject instanceof String) {
                this.setText(this.uObject.toString());
                this.setSelected(false);
            } else if (this.uObject instanceof SelectableObject) {
                this.setText(this.uObject.toString());
                this.setSelected(((SelectableObject)this.uObject).isSelected());
            }
        } else if (value instanceof String) {
            this.setText((String)value);
            this.setSelected(false);
        }
        this.edited = false;
        if (isSelected) {
            this.setForeground(this.getTextSelectionColor());
            this.setBackground(this.getBackgroundSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
            this.setBackground(this.getBackgroundNonSelectionColor());
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        return this;
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    @Override
    public Object getCellEditorValue() {
        return this.uObject;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.uObject instanceof SelectableObject && !this.edited) {
            ((SelectableObject)this.uObject).setSelected(this.isSelected());
            this.edited = true;
        }
        if (this.tree != null) {
            this.tree.stopEditing();
        }
    }
}

