/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.mac;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import java.io.File;
import java.util.List;
import mpi.eudico.client.mac.MacApplicationListener;

public class MacAppHandler2
implements AboutHandler,
OpenFilesHandler,
PrintFilesHandler,
PreferencesHandler,
QuitHandler {
    private MacApplicationListener macApp;

    public MacAppHandler2(MacApplicationListener macApp) {
        this.macApp = macApp;
        Application.getApplication().setQuitHandler((QuitHandler)this);
        Application.getApplication().setAboutHandler((AboutHandler)this);
        Application.getApplication().setOpenFileHandler((OpenFilesHandler)this);
        Application.getApplication().setPreferencesHandler((PreferencesHandler)this);
        Application.getApplication().setPrintFileHandler((PrintFilesHandler)this);
    }

    public void handleAbout(AppEvent.AboutEvent arg0) {
        this.macApp.macHandleAbout();
    }

    public void openFiles(AppEvent.OpenFilesEvent event) {
        List files = event.getFiles();
        if (files != null && files.size() > 0) {
            for (File f : files) {
                this.macApp.macHandleOpenFile(f.getAbsolutePath());
            }
        }
    }

    public void handlePreferences(AppEvent.PreferencesEvent arg0) {
        this.macApp.macHandlePreferences();
    }

    public void handleQuitRequestWith(AppEvent.QuitEvent arg0, QuitResponse arg1) {
        arg1.cancelQuit();
        this.macApp.macHandleQuit();
    }

    public void printFiles(AppEvent.PrintFilesEvent event) {
        List files = event.getFiles();
        if (files != null && files.size() > 0) {
            for (File f : files) {
                this.macApp.macHandlePrintFile(f.getAbsolutePath());
            }
        }
    }
}

