/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient.weblicht;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.TierTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class WebLichtTierBasedStep2
extends StepPane
implements ItemListener,
ListSelectionListener {
    private TierTableModel ttm;
    private JTable tierTable;
    private ComboBoxModel typeModel;
    private JComboBox typeCB;
    private boolean tiersLoaded = false;

    public WebLichtTierBasedStep2(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        Insets insets;
        this.setLayout(new GridBagLayout());
        JLabel selectLabel = new JLabel("Select the tier to upload.");
        JLabel typeLabel = new JLabel("Specify the content type of the tier to upload");
        this.ttm = new TierTableModel();
        this.tierTable = new JTable(this.ttm);
        JScrollPane tierScroll = new JScrollPane(this.tierTable);
        this.typeModel = new DefaultComboBoxModel();
        this.typeCB = new JComboBox(this.typeModel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets = new Insets(2, 0, 2, 0);
        gbc.anchor = 18;
        gbc.gridwidth = 2;
        this.add((Component)selectLabel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)tierScroll, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)typeLabel, gbc);
        gbc.gridx = 1;
        this.add((Component)this.typeCB, gbc);
    }

    @Override
    public void enterStepForward() {
        if (!this.tiersLoaded) {
            TranscriptionImpl trans = (TranscriptionImpl)this.multiPane.getStepProperty("transcription");
            if (trans != null) {
                Vector tiers = trans.getTiers();
                for (int i = 0; i < tiers.size(); ++i) {
                    this.ttm.addRow((TierImpl)tiers.get(i));
                }
            }
            this.tierTable.getSelectionModel().addListSelectionListener(this);
            this.tierTable.getSelectionModel().setSelectionMode(0);
            this.typeCB.addItem("Unknown");
            this.typeCB.addItem("Sentence");
            this.typeCB.addItem("Word/token");
            this.typeCB.addItem("POS");
            this.typeCB.addItemListener(this);
            this.tiersLoaded = true;
        }
        if (this.tierTable.getSelectedRow() > -1 && this.typeCB.getSelectedIndex() != 0) {
            this.multiPane.setButtonEnabled(1, true);
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
        this.multiPane.setButtonEnabled(2, true);
    }

    @Override
    public void enterStepBackward() {
        super.enterStepBackward();
        this.multiPane.setButtonEnabled(1, true);
    }

    @Override
    public String getPreferredPreviousStep() {
        return "TextOrTierStep1";
    }

    @Override
    public String getStepTitle() {
        return "WebLicht processing: select a tier and a content type";
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            String selected = (String)this.typeCB.getSelectedItem();
            if ("Unknown".equals(selected)) {
                this.multiPane.setButtonEnabled(1, false);
            } else if (this.tierTable.getSelectedRow() < 0) {
                this.multiPane.setButtonEnabled(1, false);
            } else {
                this.multiPane.setButtonEnabled(1, true);
            }
        }
    }

    @Override
    public boolean leaveStepForward() {
        if (this.tierTable.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Please select a tier to upload", "Warning", 2, null);
            this.multiPane.setButtonEnabled(1, false);
            return false;
        }
        if (this.typeCB.getSelectedIndex() == 0) {
            JOptionPane.showMessageDialog(this, "Please select the type of content to be uploaded.", "Warning", 2, null);
            this.multiPane.setButtonEnabled(1, false);
            return false;
        }
        this.multiPane.putStepProperty("Tier", this.tierTable.getValueAt(this.tierTable.getSelectedRow(), 0));
        this.multiPane.putStepProperty("ContentType", this.typeCB.getSelectedItem());
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.tierTable.getSelectedRow();
        if (row < 0) {
            this.multiPane.setButtonEnabled(1, false);
        } else {
            String selected = (String)this.typeCB.getSelectedItem();
            if ("Unknown".equals(selected)) {
                this.multiPane.setButtonEnabled(1, false);
            } else {
                this.multiPane.setButtonEnabled(1, true);
            }
        }
    }
}

