/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.imports.MergeUtil;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.webserviceclient.typecraft.TCParser;
import mpi.eudico.webserviceclient.typecraft.TCTextId;
import mpi.eudico.webserviceclient.typecraft.TCWsClient;
import mpi.eudico.webserviceclient.typecraft.TCtoTranscription;
import org.xml.sax.SAXException;

public class WebServicesDialogTCStepTwo
extends StepPane
implements ActionListener {
    private JButton listTextButton;
    private JButton importTextButton;
    private JList textList;
    private DefaultListModel model;
    private JLabel loadByIdLabel;
    private JTextField idTextField;
    private JButton loadByIdButton;

    public WebServicesDialogTCStepTwo(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.listTextButton = new JButton("List my texts");
        this.model = new DefaultListModel();
        this.textList = new JList(this.model);
        this.textList.getSelectionModel().setSelectionMode(0);
        this.importTextButton = new JButton("Import selected text");
        this.importTextButton.setEnabled(false);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(2, 0, 2, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = insets;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.listTextButton, gbc);
        this.listTextButton.addActionListener(this);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        this.add((Component)new JScrollPane(this.textList), gbc);
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.importTextButton, gbc);
        this.importTextButton.addActionListener(this);
        this.loadByIdLabel = new JLabel("Import text by ID: ");
        this.idTextField = new JTextField();
        this.loadByIdButton = new JButton("Import");
        this.loadByIdButton.addActionListener(this);
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(8, 0, 2, 0);
        this.add((Component)this.loadByIdLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.idTextField, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.add((Component)this.loadByIdButton, gbc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.listTextButton) {
            Object sid = this.multiPane.getStepProperty("SessionId");
            Object wsclObj = this.multiPane.getStepProperty("TCWsClient");
            if (sid instanceof String && wsclObj instanceof TCWsClient) {
                TCWsClient tcws = (TCWsClient)wsclObj;
                String sessionId = (String)sid;
                List<TCTextId> texts = tcws.listTexts(sessionId);
                if (texts == null) {
                    this.showMessage("Failed to list the texts.");
                } else if (texts.size() == 0) {
                    this.showMessage("There are no texts of this user.");
                } else {
                    this.model.clear();
                    for (int i = 0; i < texts.size(); ++i) {
                        this.model.addElement(texts.get(i));
                    }
                    this.textList.setSelectedIndex(0);
                    this.importTextButton.setEnabled(true);
                }
            } else {
                this.showMessage("Not logged in or the session timed out.");
                this.multiPane.previousStep();
            }
        } else if (source == this.importTextButton) {
            Object sid = this.multiPane.getStepProperty("SessionId");
            Object wsclObj = this.multiPane.getStepProperty("TCWsClient");
            if (sid instanceof String && wsclObj instanceof TCWsClient) {
                String sessionId = (String)sid;
                TCWsClient tcws = (TCWsClient)wsclObj;
                TCTextId selText = (TCTextId)this.textList.getSelectedValue();
                if (selText != null) {
                    String textId = selText.id;
                    String result = tcws.downloadText(textId, sessionId);
                    if (result == null) {
                        this.showMessage("Failed to download the specified text");
                        return;
                    }
                    this.parseText(result);
                }
            }
        } else if (source == this.loadByIdButton) {
            String id = this.idTextField.getText();
            if (id != null) {
                if ((id = id.trim()).length() != 0) {
                    Object sid = this.multiPane.getStepProperty("SessionId");
                    Object wsclObj = this.multiPane.getStepProperty("TCWsClient");
                    if (sid instanceof String && wsclObj instanceof TCWsClient) {
                        TCWsClient tcws = (TCWsClient)wsclObj;
                        String sessionId = (String)sid;
                        String result = tcws.downloadText(id, sessionId);
                        if (result == null) {
                            this.showMessage("Failed to download the specified text");
                            return;
                        }
                        this.parseText(result);
                    }
                } else {
                    this.showMessage("No Text ID specified!");
                }
            } else {
                this.showMessage("No Text ID specified!");
            }
        }
    }

    @Override
    public String getStepTitle() {
        return "TypeCraft download text";
    }

    @Override
    public void enterStepForward() {
    }

    @Override
    public boolean leaveStepForward() {
        return true;
    }

    public void valueChanged(ListSelectionEvent lse) {
    }

    private void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private void parseText(String result) {
        TCParser parser = new TCParser(result);
        try {
            parser.parse();
        }
        catch (SAXException se) {
            this.showMessage("A parsing error occurred: " + se.getMessage());
            return;
        }
        catch (IOException ioe) {
            this.showMessage("An input error occurred: " + ioe.getMessage());
            return;
        }
        TCtoTranscription tc2t = new TCtoTranscription();
        TranscriptionImpl trans = tc2t.createTranscription(parser.getPhraseRecords(), parser.getTextRecord());
        if (trans == null) {
            this.showMessage("Could not extract tiers and annotations from the returned content.");
            return;
        }
        TranscriptionImpl oldTrans = null;
        Object oldTransObj = this.multiPane.getStepProperty("transcription");
        if (oldTransObj instanceof TranscriptionImpl) {
            oldTrans = (TranscriptionImpl)oldTransObj;
        }
        if (oldTrans != null) {
            ArrayList props = trans.getDocProperties();
            for (int i = 0; i < props.size(); ++i) {
                Property prop = (Property)props.get(i);
                PropertyImpl np = new PropertyImpl();
                np.setName(prop.getName());
                np.setValue(prop.getValue());
                oldTrans.addDocProperty(np);
            }
            TierImpl oldPhraseTier = (TierImpl)oldTrans.getTierWithId("phrase");
            if (oldPhraseTier != null) {
                DefaultMutableTreeNode node = null;
                AbstractAnnotation aa = null;
                TierImpl phraseTier = (TierImpl)trans.getTierWithId("phrase");
                if (phraseTier != null) {
                    Vector annos = phraseTier.getAnnotations();
                    oldTrans.setNotifying(false);
                    for (int i = 0; i < annos.size(); ++i) {
                        aa = (AbstractAnnotation)annos.get(i);
                        node = AnnotationRecreator.createNodeForAnnotation(aa);
                        AnnotationRecreator.createAnnotationFromTree(oldTrans, node);
                    }
                    oldTrans.setNotifying(true);
                    this.showMessage("The text has been imported.");
                } else {
                    this.showMessage("No phrase tier found, import failed.");
                }
            } else {
                MergeUtil merger = new MergeUtil();
                ArrayList addTiers = merger.getAddableTiers(trans, oldTrans, null);
                merger.addTiersTypesAndCVs(trans, oldTrans, addTiers);
                DefaultMutableTreeNode node = null;
                AbstractAnnotation aa = null;
                TierImpl phraseTier = (TierImpl)trans.getTierWithId("phrase");
                if (phraseTier != null) {
                    Vector annos = phraseTier.getAnnotations();
                    oldTrans.setNotifying(false);
                    for (int i = 0; i < annos.size(); ++i) {
                        aa = (AbstractAnnotation)annos.get(i);
                        node = AnnotationRecreator.createTreeForAnnotation(aa);
                        AnnotationRecreator.createAnnotationFromTree(oldTrans, node, true);
                    }
                    oldTrans.setNotifying(true);
                    this.showMessage("The text has been imported.");
                } else {
                    this.showMessage("No phrase tier found, import failed.");
                }
            }
        } else {
            this.multiPane.putStepProperty("transcription", trans);
            FrameManager.getInstance().createFrame(trans);
        }
    }
}

